/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.text.MessageFormat;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BuildBehaviourTab
extends AbstractCBuildPropertyTab {
    private static final int SPINNER_MAX_VALUE = 10000;
    private static final int SPINNER_MIN_VALUE = 2;
    private static final int TRI_STATES_SIZE = 4;
    private Button b_stopOnError;
    private Button b_parallel;
    private Button b_parallelOptimal;
    private Button b_parallelSpecific;
    private Button b_parallelUnlimited;
    private Spinner s_parallelNumber;
    private Label title2;
    private Button b_autoBuild;
    private Text t_autoBuild;
    private Button b_cmdBuild;
    private Text t_cmdBuild;
    private Button b_cmdClean;
    private Text t_cmdClean;
    private Builder bldr;
    private IConfiguration icfg;
    private boolean canModify = true;
    protected final int cpuNumber = Runtime.getRuntime().availableProcessors();

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Group g3 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_9, 2, 768);
        GridLayout gl = new GridLayout(2, true);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        g3.setLayout((Layout)gl);
        Composite c1 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c1, 1, 1808);
        GridData gd = (GridData)c1.getLayoutData();
        gd.verticalSpan = 2;
        gd.verticalIndent = 0;
        c1.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c1.setLayout((Layout)gl);
        this.b_stopOnError = this.setupCheck(c1, Messages.BuilderSettingsTab_10, 1, 1);
        Composite c2 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c2, 1, 1808);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c2.setLayout((Layout)gl);
        this.b_parallel = this.setupCheck(c2, Messages.BuilderSettingsTab_EnableParallelBuild, 1, 1);
        Composite c3 = new Composite((Composite)g3, 0);
        this.setupControl((Control)c3, 1, 1808);
        gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c3.setLayout((Layout)gl);
        this.b_parallelOptimal = new Button(c3, 16);
        this.b_parallelOptimal.setText(MessageFormat.format(Messages.BuilderSettingsTab_UseOptimalJobs, 1));
        this.setupControl((Control)this.b_parallelOptimal, 2, 1);
        ((GridData)this.b_parallelOptimal.getLayoutData()).horizontalIndent = 15;
        this.b_parallelOptimal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BuildBehaviourTab.this.b_parallelOptimal.getSelection()) {
                    BuildBehaviourTab.this.setParallelDef(true);
                    BuildBehaviourTab.this.setParallelNumber(-1);
                    BuildBehaviourTab.this.updateButtons();
                }
            }
        });
        this.b_parallelSpecific = new Button(c3, 16);
        this.b_parallelSpecific.setText(Messages.BuilderSettingsTab_UseParallelJobs);
        this.setupControl((Control)this.b_parallelSpecific, 1, 1);
        ((GridData)this.b_parallelSpecific.getLayoutData()).horizontalIndent = 15;
        this.b_parallelSpecific.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BuildBehaviourTab.this.b_parallelSpecific.getSelection()) {
                    BuildBehaviourTab.this.setParallelDef(true);
                    BuildBehaviourTab.this.setParallelNumber(BuildBehaviourTab.this.s_parallelNumber.getSelection());
                    BuildBehaviourTab.this.updateButtons();
                }
            }
        });
        this.s_parallelNumber = new Spinner(c3, 2048);
        this.setupControl((Control)this.s_parallelNumber, 1, 1);
        this.s_parallelNumber.setValues(this.cpuNumber, 2, 10000, 0, 1, 10);
        this.s_parallelNumber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildBehaviourTab.this.setParallelDef(true);
                BuildBehaviourTab.this.setParallelNumber(BuildBehaviourTab.this.s_parallelNumber.getSelection());
                BuildBehaviourTab.this.updateButtons();
            }
        });
        this.s_parallelNumber.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.BuilderSettingsTab_UseParallelJobs;
            }
        });
        this.s_parallelNumber.setToolTipText(Messages.BuilderSettingsTab_UseParallelJobs);
        this.b_parallelUnlimited = new Button(c3, 16);
        this.b_parallelUnlimited.setText(Messages.BuilderSettingsTab_UseUnlimitedJobs);
        this.setupControl((Control)this.b_parallelUnlimited, 2, 1);
        ((GridData)this.b_parallelUnlimited.getLayoutData()).horizontalIndent = 15;
        this.b_parallelUnlimited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BuildBehaviourTab.this.b_parallelUnlimited.getSelection()) {
                    BuildBehaviourTab.this.setParallelDef(true);
                    BuildBehaviourTab.this.setParallelNumber(Integer.MAX_VALUE);
                    BuildBehaviourTab.this.updateButtons();
                }
            }
        });
        AccessibleAdapter makeTargetLabelAccessibleListener = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.BuilderSettingsTab_16;
            }
        };
        Group g4 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_14, 3, 768);
        this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_15, 1, 1);
        this.title2 = this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_16, 2, 1);
        this.b_autoBuild = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_17, 1, 1);
        this.t_autoBuild = this.setupBlock((Composite)g4, (Control)this.b_autoBuild);
        this.t_autoBuild.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", BuildBehaviourTab.this.t_autoBuild.getText());
                }
            }
        });
        this.t_autoBuild.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
        this.setupLabel((Composite)g4, Messages.BuilderSettingsTab_18, 3, 1);
        this.b_cmdBuild = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_19, 1, 1);
        this.t_cmdBuild = this.setupBlock((Composite)g4, (Control)this.b_cmdBuild);
        this.t_cmdBuild.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", BuildBehaviourTab.this.t_cmdBuild.getText());
                }
            }
        });
        this.t_cmdBuild.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
        this.b_cmdClean = this.setupCheck((Composite)g4, Messages.BuilderSettingsTab_20, 1, 1);
        this.t_cmdClean = this.setupBlock((Composite)g4, (Control)this.b_cmdClean);
        this.t_cmdClean.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildBehaviourTab.this.canModify) {
                    BuildBehaviourTab.this.setBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", BuildBehaviourTab.this.t_cmdClean.getText());
                }
            }
        });
        this.t_cmdClean.getAccessible().addAccessibleListener((AccessibleListener)makeTargetLabelAccessibleListener);
    }

    static int[] calc3states(ICPropertyProvider p, IConfiguration mcfg, int mode) {
        if (p.isMultiCfg() && mcfg instanceof ICMultiItemsHolder) {
            boolean m0 = mode == 0;
            boolean m1 = mode == 1;
            IConfiguration[] cfgs = (IConfiguration[])((ICMultiItemsHolder)mcfg).getItems();
            IBuilder bldr0 = cfgs[0].getBuilder();
            int[] res = new int[4];
            boolean[] b = new boolean[4];
            boolean bl = m0 ? bldr0.isManagedBuildOn() : (b[0] = m1 ? bldr0.isStopOnError() : bldr0.isAutoBuildEnable());
            boolean bl2 = m0 ? bldr0.isDefaultBuildCmd() : (b[1] = m1 ? bldr0.supportsStopOnError(true) : bldr0.isIncrementalBuildEnabled());
            b[2] = m0 ? bldr0.canKeepEnvironmentVariablesInBuildfile() : (m1 ? bldr0.supportsStopOnError(false) : bldr0.isCleanBuildEnabled());
            b[3] = m0 ? bldr0.keepEnvironmentVariablesInBuildfile() : false;
            int i = 1;
            while (i < cfgs.length) {
                IBuilder bldr = cfgs[i].getBuilder();
                if (b[0] != (m0 ? bldr.isManagedBuildOn() : (m1 ? bldr.isStopOnError() : bldr.isAutoBuildEnable()))) {
                    res[0] = 2;
                }
                if (b[1] != (m0 ? bldr.isDefaultBuildCmd() : (m1 ? bldr.supportsStopOnError(true) : bldr.isIncrementalBuildEnabled()))) {
                    res[1] = 2;
                }
                if (b[2] != (m0 ? bldr.canKeepEnvironmentVariablesInBuildfile() : (m1 ? bldr.supportsStopOnError(false) : bldr.isCleanBuildEnabled()))) {
                    res[2] = 2;
                }
                if (b[3] != (m0 ? bldr.keepEnvironmentVariablesInBuildfile() : false)) {
                    res[3] = 2;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (res[i] != 2) {
                    res[i] = b[i] ? 1 : 0;
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    protected void updateButtons() {
        this.bldr = (Builder)this.icfg.getEditableBuilder();
        this.canModify = false;
        int[] extStates = BuildBehaviourTab.calc3states(this.page, this.icfg, 1);
        if (extStates != null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_stopOnError, (int)extStates[0]);
            this.b_stopOnError.setEnabled(extStates[1] == 1 && extStates[2] == 1);
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_stopOnError, (boolean)this.bldr.isStopOnError());
            this.b_stopOnError.setEnabled(this.bldr.supportsStopOnError(true) && this.bldr.supportsStopOnError(false));
        }
        this.updateParallelBlock();
        extStates = BuildBehaviourTab.calc3states(this.page, this.icfg, 2);
        if (extStates != null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_autoBuild, (int)extStates[0]);
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdBuild, (int)extStates[1]);
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdClean, (int)extStates[2]);
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_autoBuild, (boolean)this.bldr.isAutoBuildEnable());
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdBuild, (boolean)this.bldr.isIncrementalBuildEnabled());
            BuildBehaviourTab.setTriSelection((Button)this.b_cmdClean, (boolean)this.bldr.isCleanBuildEnabled());
        }
        if (this.page.isMultiCfg()) {
            MultiConfiguration mc = (MultiConfiguration)this.icfg;
            this.t_autoBuild.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            this.t_cmdBuild.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            this.t_cmdClean.setText(mc.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
        } else {
            this.t_autoBuild.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            this.t_cmdBuild.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            this.t_cmdClean.setText(this.bldr.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
        }
        boolean external = !this.isInternalBuilderEnabled();
        this.title2.setVisible(external);
        this.t_autoBuild.setVisible(external);
        ((Control)this.t_autoBuild.getData()).setVisible(external);
        this.t_cmdBuild.setVisible(external);
        ((Control)this.t_cmdBuild.getData()).setVisible(external);
        this.t_cmdClean.setVisible(external);
        ((Control)this.t_cmdClean.getData()).setVisible(external);
        if (external) {
            this.checkPressed((Control)this.b_autoBuild, false);
            this.checkPressed((Control)this.b_cmdBuild, false);
            this.checkPressed((Control)this.b_cmdClean, false);
        }
        this.canModify = true;
    }

    private void updateParallelBlock() {
        boolean isParallelSupported = this.bldr.supportsParallelBuild();
        boolean isParallelOn = this.bldr.isParallelBuildOn();
        int triSelection = isParallelOn ? 1 : 0;
        int parallelizationNumInternal = this.bldr.getParallelizationNumAttribute();
        int optimalParallelNumber = this.bldr.getOptimalParallelJobNum();
        int parallelNumber = this.bldr.getParallelizationNum();
        if (this.icfg instanceof ICMultiItemsHolder) {
            IConfiguration[] cfgs = (IConfiguration[])((ICMultiItemsHolder)this.icfg).getItems();
            boolean isAnyParallelOn = isParallelOn;
            boolean isAnyParallelSupported = isParallelSupported;
            boolean isParallelDiffers = false;
            IConfiguration[] iConfigurationArray = cfgs;
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                Builder builder = (Builder)cfg.getBuilder();
                isParallelDiffers = isParallelDiffers || builder.isParallelBuildOn() != isParallelOn || builder.getParallelizationNumAttribute() != parallelizationNumInternal;
                isAnyParallelOn = isAnyParallelOn || builder.isParallelBuildOn();
                isAnyParallelSupported = isAnyParallelSupported || builder.supportsParallelBuild();
                ++n2;
            }
            if (!isParallelSupported && isAnyParallelSupported || !isParallelOn && isAnyParallelOn) {
                isParallelSupported = true;
                parallelizationNumInternal = -optimalParallelNumber;
                parallelNumber = optimalParallelNumber;
            }
            if (isParallelSupported && isParallelDiffers) {
                triSelection = 2;
            }
        }
        this.b_parallel.setVisible(isParallelSupported);
        this.b_parallelOptimal.setVisible(isParallelSupported);
        this.b_parallelSpecific.setVisible(isParallelSupported);
        this.b_parallelUnlimited.setVisible(isParallelSupported);
        this.s_parallelNumber.setVisible(isParallelSupported);
        if (isParallelSupported) {
            BuildBehaviourTab.setTriSelection((Button)this.b_parallel, (int)triSelection);
            boolean isParallelSelected = this.b_parallel.getSelection();
            this.b_parallelOptimal.setText(MessageFormat.format(Messages.BuilderSettingsTab_UseOptimalJobs, optimalParallelNumber));
            this.b_parallelOptimal.setEnabled(isParallelSelected);
            this.b_parallelSpecific.setEnabled(isParallelSelected);
            this.b_parallelUnlimited.setEnabled(isParallelSelected);
            if (isParallelSelected) {
                boolean isOptimal = parallelizationNumInternal <= 0;
                boolean isUnlimited = parallelizationNumInternal == Integer.MAX_VALUE;
                this.b_parallelOptimal.setSelection(isOptimal);
                this.b_parallelSpecific.setSelection(!isOptimal && !isUnlimited);
                this.b_parallelUnlimited.setSelection(isUnlimited);
                this.s_parallelNumber.setEnabled(this.b_parallelSpecific.getEnabled() && this.b_parallelSpecific.getSelection());
                this.s_parallelNumber.setSelection(this.s_parallelNumber.isEnabled() ? parallelNumber : optimalParallelNumber);
            } else {
                this.b_parallelOptimal.setSelection(true);
                this.b_parallelSpecific.setSelection(false);
                this.b_parallelUnlimited.setSelection(false);
                this.s_parallelNumber.setEnabled(false);
                this.s_parallelNumber.setSelection(optimalParallelNumber);
            }
        }
    }

    private Text setupBlock(Composite c, Control check) {
        Text t = this.setupText(c, 1, 768);
        Button b = this.setupButton(c, VARIABLESBUTTON_NAME, 1, 3);
        b.setData((Object)t);
        t.setData((Object)b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildBehaviourTab.this.buttonVarPressed(event);
            }
        });
        if (check != null) {
            check.setData((Object)t);
        }
        return t;
    }

    private void buttonVarPressed(SelectionEvent e) {
        String x;
        Widget b = e.widget;
        if (b == null || b.getData() == null) {
            return;
        }
        if (b.getData() instanceof Text && (x = AbstractCPropertyTab.getVariableDialog((Shell)this.usercomp.getShell(), (ICConfigurationDescription)this.getResDesc().getConfiguration())) != null) {
            ((Text)b.getData()).insert(x);
        }
    }

    public void checkPressed(SelectionEvent e) {
        this.checkPressed((Control)e.widget, true);
        this.updateButtons();
    }

    private void checkPressed(Control b, boolean needsUpdate) {
        if (b == null) {
            return;
        }
        boolean val = false;
        if (b instanceof Button) {
            val = ((Button)b).getSelection();
        }
        if (b.getData() instanceof Text) {
            Text t = (Text)b.getData();
            t.setEnabled(val);
            if (t.getData() != null && t.getData() instanceof Control) {
                Control c = (Control)t.getData();
                c.setEnabled(val);
            }
        }
        if (needsUpdate) {
            this.setValue(b, val);
        }
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.icfg = BuildBehaviourTab.getCfg(cfgd.getConfiguration());
        this.updateButtons();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        BuildBehaviourTab.apply(src, dst, this.page.isMultiCfg());
    }

    static void apply(ICResourceDescription src, ICResourceDescription dst, boolean multi) {
        if (multi) {
            ICMultiConfigDescription mc1 = (ICMultiConfigDescription)src.getConfiguration();
            ICMultiConfigDescription mc2 = (ICMultiConfigDescription)dst.getConfiguration();
            ICConfigurationDescription[] cds1 = (ICConfigurationDescription[])mc1.getItems();
            ICConfigurationDescription[] cds2 = (ICConfigurationDescription[])mc2.getItems();
            int i = 0;
            while (i < cds1.length) {
                BuildBehaviourTab.applyToCfg(cds1[i], cds2[i]);
                ++i;
            }
        } else {
            BuildBehaviourTab.applyToCfg(src.getConfiguration(), dst.getConfiguration());
        }
    }

    private static void applyToCfg(ICConfigurationDescription c1, ICConfigurationDescription c2) {
        Configuration cfg01 = (Configuration)BuildBehaviourTab.getCfg(c1);
        Configuration cfg02 = (Configuration)BuildBehaviourTab.getCfg(c2);
        cfg02.enableInternalBuilder(cfg01.isInternalBuilderEnabled());
        BuildBehaviourTab.copyBuilders(cfg01.getBuilder(), cfg02.getEditableBuilder());
    }

    static void copyBuilders(IBuilder b1, IBuilder b2) {
        try {
            b2.setUseDefaultBuildCmd(b1.isDefaultBuildCmd());
            if (!b1.isDefaultBuildCmd()) {
                b2.setCommand(b1.getCommand());
                b2.setArguments(b1.getArguments());
            } else {
                b2.setCommand(null);
                b2.setArguments(null);
            }
            b2.setStopOnError(b1.isStopOnError());
            b2.setParallelBuildOn(b1.isParallelBuildOn());
            b2.setParallelizationNum(((Builder)b1).getParallelizationNumAttribute());
            if (b2.canKeepEnvironmentVariablesInBuildfile()) {
                b2.setKeepEnvironmentVariablesInBuildfile(b1.keepEnvironmentVariablesInBuildfile());
            }
            ((Builder)b2).setBuildPath(((Builder)b1).getBuildPathAttribute());
            b2.setAutoBuildEnable(b1.isAutoBuildEnable());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            b2.setCleanBuildEnable(b1.isCleanBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
            b2.setIncrementalBuildEnable(b1.isIncrementalBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            b2.setManagedBuildOn(b1.isManagedBuildOn());
        }
        catch (CoreException ex) {
            ManagedBuilderUIPlugin.log(ex);
        }
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    protected void performDefaults() {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                BuildBehaviourTab.copyBuilders(b.getSuperClass(), b);
                ++i;
            }
        } else {
            BuildBehaviourTab.copyBuilders(this.bldr.getSuperClass(), (IBuilder)this.bldr);
        }
        this.updateData(this.getResDesc());
    }

    private void setParallelDef(boolean def) {
        if (this.icfg instanceof Configuration) {
            ((Configuration)this.icfg).setParallelDef(def);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.icfg).setParallelDef(def);
        }
    }

    private void setParallelNumber(int num) {
        if (this.icfg instanceof Configuration) {
            ((Configuration)this.icfg).setParallelNumber(num);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.icfg).setParallelNumber(num);
        }
    }

    private boolean isInternalBuilderEnabled() {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).isInternalBuilderEnabled();
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)this.icfg).isInternalBuilderEnabled();
        }
        return false;
    }

    private void setBuildAttribute(String name, String value) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder b = cfs[i].getEditableBuilder();
                    b.setBuildAttribute(name, value);
                    ++i;
                }
            } else {
                this.icfg.getEditableBuilder().setBuildAttribute(name, value);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    private void setValue(Control b, boolean val) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder bld = cfs[i].getEditableBuilder();
                    if (b == this.b_autoBuild) {
                        bld.setAutoBuildEnable(val);
                    } else if (b == this.b_cmdBuild) {
                        bld.setIncrementalBuildEnable(val);
                    } else if (b == this.b_cmdClean) {
                        bld.setCleanBuildEnable(val);
                    } else if (b == this.b_stopOnError) {
                        bld.setStopOnError(val);
                    } else if (b == this.b_parallel) {
                        bld.setParallelBuildOn(val);
                    }
                    ++i;
                }
            } else if (b == this.b_autoBuild) {
                this.bldr.setAutoBuildEnable(val);
            } else if (b == this.b_cmdBuild) {
                this.bldr.setIncrementalBuildEnable(val);
            } else if (b == this.b_cmdClean) {
                this.bldr.setCleanBuildEnable(val);
            } else if (b == this.b_stopOnError) {
                this.bldr.setStopOnError(val);
            } else if (b == this.b_parallel) {
                this.bldr.setParallelBuildOn(val);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }
}

