/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.scratchpad;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.internal.ui.view.scratchpad.SystemScratchpadView;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SystemScratchpadViewProvider
implements ILabelProvider,
ITreeContentProvider {
    private ListenerList listeners = new ListenerList(1);
    private Map imageTable = new Hashtable(40);
    private SystemScratchpadView _view;

    public SystemScratchpadViewProvider(SystemScratchpadView view) {
        this._view = view;
    }

    public void inputChanged(Viewer visualPart, Object oldInput, Object newInput) {
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public Object[] getChildren(Object object) {
        return this.getElements(object);
    }

    public Object getParent(Object object) {
        return this.getAdapterFor(object).getParent(object);
    }

    public boolean hasChildren(Object object) {
        IWorkbenchAdapter wa;
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            if (object instanceof IContextObject) {
                return adapter.hasChildren((IContextObject)object);
            }
            return adapter.hasChildren((IAdaptable)object);
        }
        if (object instanceof IAdaptable && (wa = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wa.getChildren(object).length > 0;
        }
        return false;
    }

    public Object getElementAt(Object object, int i) {
        return null;
    }

    protected ISystemViewElementAdapter getAdapterFor(Object object) {
        IAdaptable adapt;
        ISystemViewElementAdapter result;
        if (object instanceof IContextObject) {
            object = ((IContextObject)object).getModelObject();
        }
        if (object instanceof IAdaptable && (result = (ISystemViewElementAdapter)(adapt = (IAdaptable)object).getAdapter(ISystemViewElementAdapter.class)) != null) {
            result.setPropertySourceInput(object);
            result.setViewer((Viewer)this._view);
            return result;
        }
        return null;
    }

    public Object[] getElements(Object object) {
        Object[] results = null;
        Object element = object;
        if (object instanceof IContextObject) {
            element = ((IContextObject)object).getModelObject();
        }
        if (element instanceof IAdaptable) {
            ISystemViewElementAdapter adapter = this.getAdapterFor(element);
            if (adapter != null && adapter.hasChildren((IAdaptable)element)) {
                results = object instanceof IContextObject ? adapter.getChildren((IContextObject)object, (IProgressMonitor)new NullProgressMonitor()) : adapter.getChildren((IAdaptable)object, (IProgressMonitor)new NullProgressMonitor());
            } else {
                IWorkbenchAdapter wa = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class);
                if (wa != null) {
                    return wa.getChildren(object);
                }
            }
        }
        if (results == null) {
            return new Object[0];
        }
        return results;
    }

    public String getText(Object object) {
        IWorkbenchAdapter wa;
        if (object instanceof String) {
            return (String)object;
        }
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            return adapter.getText(object);
        }
        if (object instanceof IAdaptable && (wa = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wa.getLabel(object);
        }
        return object.toString();
    }

    public Image getImage(Object object) {
        IWorkbenchAdapter wa;
        Image image = null;
        if (object instanceof String) {
            return null;
        }
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            ImageDescriptor descriptor = adapter.getImageDescriptor(object);
            if (descriptor != null) {
                Object iobj = this.imageTable.get(descriptor);
                if (iobj == null) {
                    image = descriptor.createImage();
                    this.imageTable.put(descriptor, image);
                } else {
                    image = (Image)iobj;
                }
            }
            return image;
        }
        if (object instanceof IAdaptable && (wa = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
            ImageDescriptor descriptor = wa.getImageDescriptor(object);
            if (descriptor != null) {
                Object iobj = this.imageTable.get(descriptor);
                if (iobj == null) {
                    image = descriptor.createImage();
                    this.imageTable.put(descriptor, image);
                } else {
                    image = (Image)iobj;
                }
            }
            return image;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void dispose() {
    }
}

