/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalize
extends AbstractTool {
    FileArgument destfile = null;
    int pagecount;
    float width;
    float height;
    PdfDictionary lastpage = null;
    float tolerancex = 60.0f;
    float tolerancey = 60.0f;
    int pagecountinsertedpages;
    int pagecountrotatedpages;

    public Normalize() {
        this.menuoptions = 3;
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to normalize", false, new PdfFilter());
        this.arguments.add(fileArgument);
        this.destfile = new FileArgument(this, "destfile", "The resulting PDF", true, new PdfFilter());
        this.arguments.add(this.destfile);
        fileArgument.addPropertyChangeListener(this.destfile);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Normalize", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Normalize OPENED ===");
    }

    protected void iteratePages(PdfDictionary pdfDictionary, PdfReader pdfReader, ArrayList<PdfDictionary> arrayList, int n, PdfWriter pdfWriter) throws IOException {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.KIDS);
        if (pdfArray == null) {
            PdfArray pdfArray2 = pdfDictionary.getAsArray(PdfName.MEDIABOX);
            float f = Float.parseFloat(pdfArray2.getPdfObject(2).toString());
            float f2 = Float.parseFloat(pdfArray2.getPdfObject(3).toString());
            PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.ROTATE);
            if (pdfNumber == null) {
                System.out.println("optional rotation missing");
                pdfNumber = new PdfNumber(0);
            }
            Ausrichtung ausrichtung = new Ausrichtung(pdfNumber.floatValue(), new Rectangle(f, f2));
            switch (ausrichtung.type) {
                case 2: 
                case 3: {
                    ausrichtung.rotate();
                    pdfDictionary.put(PdfName.ROTATE, new PdfNumber(ausrichtung.getRotation()));
                    System.out.println("rotate page:" + (this.pagecount + 1) + " targetformat: " + ausrichtung);
                    ++this.pagecountrotatedpages;
                }
            }
            f = ausrichtung.getM5();
            f2 = ausrichtung.getM6();
            if ((this.pagecount + 1) % 2 == 0 && (Math.abs(f - this.width) > this.tolerancex || Math.abs(f2 - this.height) > this.tolerancey)) {
                this.Seitehinzufuegen(pdfDictionary, n, pdfWriter, pdfArray2);
                ++this.pagecountinsertedpages;
            }
            if ((this.pagecount + 1) % 2 == 1) {
                this.width = f;
                this.height = f2;
                this.lastpage = pdfDictionary;
            }
            arrayList.add(this.pagecount, pdfDictionary);
            ++this.pagecount;
        } else {
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfDictionary pdfDictionary2 = pdfArray.getAsDict(i);
                this.iteratePages(pdfDictionary2, pdfReader, arrayList, i, pdfWriter);
            }
        }
    }

    private void Seitehinzufuegen(PdfDictionary pdfDictionary, int n, PdfWriter pdfWriter, PdfArray pdfArray) throws IOException {
        PdfDictionary pdfDictionary2;
        System.out.print("change!");
        PdfArray pdfArray2 = pdfDictionary2.getAsArray(PdfName.KIDS);
        PdfIndirectReference pdfIndirectReference = pdfWriter.getPdfIndirectReference();
        pdfArray2.add(n, pdfIndirectReference);
        PdfDictionary pdfDictionary3 = new PdfDictionary(PdfName.PAGE);
        pdfDictionary3.merge(this.lastpage);
        pdfDictionary3.remove(PdfName.CONTENTS);
        pdfDictionary3.remove(PdfName.ANNOTS);
        pdfDictionary3.put(PdfName.RESOURCES, new PdfDictionary());
        pdfWriter.addToBody((PdfObject)pdfDictionary3, pdfIndirectReference);
        PdfNumber pdfNumber = null;
        for (pdfDictionary2 = pdfDictionary.getAsDict(PdfName.PARENT); pdfDictionary2 != null; pdfDictionary2 = pdfDictionary2.getAsDict(PdfName.PARENT)) {
            pdfNumber = pdfDictionary2.getAsNumber(PdfName.COUNT);
            pdfDictionary2.put(PdfName.COUNT, new PdfNumber(pdfNumber.intValue() + 1));
        }
        System.out.println("page:" + (this.pagecount + 1) + " nr in leaf:" + n + " arl x:" + pdfArray.getPdfObject(0) + " y:" + pdfArray.getPdfObject(1) + " width:" + pdfArray.getPdfObject(2) + " height:" + pdfArray.getPdfObject(3));
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            this.pagecountinsertedpages = 0;
            this.pagecountrotatedpages = 0;
            this.pagecount = 0;
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(file2));
            PdfWriter pdfWriter = pdfStamper.getWriter();
            ArrayList<PdfDictionary> arrayList = new ArrayList<PdfDictionary>();
            PdfDictionary pdfDictionary = pdfReader.getCatalog();
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.PAGES);
            this.iteratePages(pdfDictionary2, pdfReader, arrayList, 0, pdfWriter);
            if (this.pagecount % 2 == 1) {
                this.appendemptypageatend(pdfReader, pdfWriter);
                ++this.pagecountinsertedpages;
            }
            pdfStamper.close();
            System.out.println("In " + file2.getAbsolutePath() + " pages= " + this.pagecount + " inserted pages=" + this.getPagecountinsertedpages() + " rotated pages=" + this.getPagecountrotatedpages());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void appendemptypageatend(PdfReader pdfReader, PdfWriter pdfWriter) throws IOException {
        PdfDictionary pdfDictionary;
        System.out.println("last page odd. add page!");
        PdfDictionary pdfDictionary2 = pdfReader.getPageN(pdfReader.getNumberOfPages());
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.KIDS);
        PdfIndirectReference pdfIndirectReference = pdfWriter.getPdfIndirectReference();
        pdfArray.add(pdfIndirectReference);
        PdfDictionary pdfDictionary3 = new PdfDictionary(PdfName.PAGE);
        pdfDictionary3.merge(this.lastpage);
        pdfDictionary3.remove(PdfName.CONTENTS);
        pdfDictionary3.remove(PdfName.ANNOTS);
        pdfDictionary3.put(PdfName.RESOURCES, new PdfDictionary());
        pdfWriter.addToBody((PdfObject)pdfDictionary3, pdfIndirectReference);
        PdfNumber pdfNumber = null;
        for (pdfDictionary = pdfDictionary2.getAsDict(PdfName.PARENT); pdfDictionary != null; pdfDictionary = pdfDictionary.getAsDict(PdfName.PARENT)) {
            pdfNumber = pdfDictionary.getAsNumber(PdfName.COUNT);
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(pdfNumber.intValue() + 1));
        }
    }

    public int getPagecountinsertedpages() {
        return this.pagecountinsertedpages;
    }

    public int getPagecountrotatedpages() {
        return this.pagecountrotatedpages;
    }

    @Override
    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && abstractArgument.getName().equalsIgnoreCase("srcfile")) {
            String string = abstractArgument.getValue().toString();
            String string2 = string.substring(0, string.indexOf(".", string.length() - 4)) + "_out.pdf";
            this.destfile.setValue(string2);
        }
    }

    public static void main(String[] stringArray) {
        Normalize normalize = new Normalize();
        if (stringArray.length < 2) {
            System.err.println(normalize.getUsage());
        }
        normalize.setMainArguments(stringArray);
        normalize.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Normalize.addVersion("$Id: Normalize.java 3736 2009-02-26 08:52:21Z xlv $");
    }

    public class Ausrichtung {
        static final float tolerance = 60.0f;
        static final int UNKNOWN = 0;
        static final int A4Portrait = 1;
        static final int A4Landscape = 2;
        static final int A3Portrait = 3;
        static final int A3Landscape = 4;
        float rotation;
        Rectangle rect;
        float m5;
        float m6;
        int type;

        public Ausrichtung() {
            this(0.0f, new Rectangle(1.0f, 1.0f));
        }

        public Ausrichtung(float f, Rectangle rectangle) {
            this.rotation = f;
            this.rect = f == 90.0f || f == 270.0f ? rectangle.rotate() : rectangle;
            this.m5 = this.rect.getWidth();
            this.m6 = this.rect.getHeight();
            this.klassifiziere();
        }

        private void klassifiziere() {
            this.type = Math.abs(this.rect.getWidth() - 595.0f) < 60.0f && Math.abs(this.rect.getHeight() - 842.0f) < 60.0f ? 1 : (Math.abs(this.rect.getWidth() - 842.0f) < 60.0f && Math.abs(this.rect.getHeight() - 595.0f) < 60.0f ? 2 : (Math.abs(this.rect.getWidth() - 1190.0f) < 60.0f && Math.abs(this.rect.getHeight() - 842.0f) < 60.0f ? 4 : (Math.abs(this.rect.getWidth() - 842.0f) < 60.0f && Math.abs(this.rect.getHeight() - 1190.0f) < 60.0f ? 3 : 0)));
        }

        public float getM5() {
            return this.m5;
        }

        public float getM6() {
            return this.m6;
        }

        public String toString() {
            String string;
            switch (this.type) {
                case 0: {
                    string = this.rect.getWidth() + "*" + this.rect.getHeight();
                    break;
                }
                case 4: {
                    string = "A3 Landscape";
                    break;
                }
                case 3: {
                    string = "A3 Portrait";
                    break;
                }
                case 2: {
                    string = "A4 Landscape";
                    break;
                }
                case 1: {
                    string = "A4 Portrait";
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }

        public void rotate() {
            this.rect = this.rect.rotate();
            this.m5 = this.rect.getWidth();
            this.m6 = this.rect.getHeight();
            this.rotation += 90.0f;
            this.rotation %= 360.0f;
            this.klassifiziere();
        }

        public float getRotation() {
            return this.rotation;
        }
    }
}

