/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.launch;

import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.ui.launch.AbstractRemoteTab;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RemoteConnectTab
extends AbstractRemoteTab {
    @Override
    protected void apply(ILaunchConfigurationWorkingCopy config) {
    }

    private boolean isDownloading() {
        return this.getSelectedMode() == ICudaRemoteDebugConstants.ExecutableTransferMode.Download;
    }

    @Override
    protected void connectionSelected(IStructuredSelection selection) {
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 0);
        this.setControl((Control)pane);
        pane.setLayout((Layout)new GridLayout(3, false));
        this.createConnectionsCombo(pane);
        this.createButtons(pane);
        this.createPortEntry(pane);
        this.createRemoteExecutableEntry(pane);
        this.selectConnection((IStructuredSelection)StructuredSelection.EMPTY);
    }

    @Override
    protected String getPageId() {
        return "com.nvidia.cuda.ide.remote.connect.remote";
    }

    @Override
    protected boolean ignoreExecutable() {
        return !this.isDownloading();
    }

    @Override
    protected void modeChanged() {
        this.updateRemotePathControls(this.isDownloading());
    }

    @Override
    protected void initialize(ILaunchConfiguration config, IRemoteConnection connection) throws CoreException {
        ICudaRemoteDebugConstants.ExecutableTransferMode mode = ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration(config);
        boolean downloading = mode == ICudaRemoteDebugConstants.ExecutableTransferMode.Download;
        this.updateRemotePathControls(downloading);
    }

    private void updateRemotePathControls(boolean downloading) {
        this.lblExecutable.setEnabled(downloading);
        this.executable.setEnabled(downloading);
        this.btnBrowseExecutable.setEnabled(downloading);
        if (!downloading) {
            this.executable.setText("");
        }
    }

    @Override
    protected String validateChild() {
        return null;
    }

    @Override
    protected Button[] createTransferButtons(Composite composite) {
        return new Button[]{this.createButton(composite, Messages.RemoteDebug_mode_downloadExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Download), this.createButton(composite, Messages.RemoteDebug_mode_noTransferExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer)};
    }
}

