/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class Copy
extends ProcessRunner {
    @Override
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        ProcessArgument[][] files = args[0].getComplexArrayValue();
        int i = 0;
        while (i < files.length) {
            URL sourceURL;
            ProcessArgument[] file = files[i];
            String sourcePath = file[0].getSimpleValue();
            try {
                sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, sourcePath);
                if (sourceURL == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("Copy.0")) + sourcePath));
                }
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(String.valueOf(Messages.getString("Copy.1")) + sourcePath);
            }
            File targetFile = new File(file[1].getSimpleValue());
            boolean replaceable = file[2].getSimpleValue().equals("true");
            if (replaceable) {
                String fileContents;
                try {
                    fileContents = ProcessHelper.readFromFile(sourceURL);
                }
                catch (IOException iOException) {
                    throw new ProcessFailureException(String.valueOf(Messages.getString("Copy.3")) + sourcePath);
                }
                fileContents = ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                FileWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(targetFile);
                        writer.write(fileContents);
                    }
                    catch (IOException e) {
                        throw new ProcessFailureException(Messages.getString("Copy.4"), e);
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                try {
                    ProcessHelper.copyBinaryFile(sourceURL, targetFile);
                }
                catch (IOException e) {
                    throw new ProcessFailureException(Messages.getString("Copy.5"), e);
                }
            }
            ++i;
        }
    }
}

