/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostOutput;
import org.eclipse.rse.services.shells.AbstractHostShellOutputReader;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;
import org.eclipse.rse.services.shells.SimpleHostOutput;

public class DStoreShellOutputReader
extends AbstractHostShellOutputReader
implements IHostShellOutputReader,
IDomainListener {
    protected DataElement _status;
    protected int _statusOffset = 0;

    public DStoreShellOutputReader(IHostShell hostShell, DataElement status, boolean isErrorReader) {
        super(hostShell, isErrorReader);
        this.setName("DStoreShellOutputReader" + this.getName());
        this._status = status;
        if (status != null) {
            this._status.getDataStore().getDomainNotifier().addDomainListener((IDomainListener)this);
        }
    }

    public String getWorkingDirectory() {
        String pwd = this._status.getSource();
        return pwd;
    }

    protected IHostOutput internalReadLine() {
        if (this._status != null && this._keepRunning) {
            int newSize = this._status.getNestedSize();
            if (newSize > this._statusOffset) {
                DataElement line = this._status.get(this._statusOffset++);
                return new DStoreHostOutput(line);
            }
            try {
                if (this._hostShell.isActive()) {
                    this.waitForResponse();
                    return this.internalReadLine();
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._status == null) {
            return null;
        }
        if (this._status.getValue().equals("done")) {
            if (!this._isErrorReader) {
                DataElement dummyLine = this._status.getDataStore().createObject(this._status, "stdout", "");
                return new DStoreHostOutput(dummyLine);
            }
            return null;
        }
        return new SimpleHostOutput("");
    }

    public boolean listeningTo(DomainEvent e) {
        return e.getParent() == this._status;
    }

    public void domainChanged(DomainEvent event) {
        if (this._status.getValue().equals("done")) {
            if (this._status == event.getParent()) {
                this.finish();
            }
        } else {
            this.notifyResponse();
        }
    }

    public synchronized void waitForResponse() {
        try {
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void notifyResponse() {
        try {
            ((Object)((Object)this)).notifyAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        super.finish();
        this.notifyResponse();
    }
}

