/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.datamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.trace.internal.Messages;
import org.eclipse.ui.trace.internal.TracingUIActivator;
import org.eclipse.ui.trace.internal.datamodel.AbstractTracingNode;
import org.eclipse.ui.trace.internal.datamodel.TracingCollections;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;
import org.eclipse.ui.trace.internal.datamodel.TracingNode;
import org.eclipse.ui.trace.internal.utils.DebugOptionsHandler;
import org.osgi.framework.Bundle;

public class TracingComponent
extends AbstractTracingNode {
    private String id = null;
    private List<Bundle> bundles = null;

    public TracingComponent(IConfigurationElement element) {
        assert (element != null);
        this.id = element.getAttribute("id");
        this.setLabel(element.getAttribute("label"));
        this.bundles = new ArrayList<Bundle>();
        this.addBundles(element);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracingComponent)) {
            return false;
        }
        TracingComponent other = (TracingComponent)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TracingComponent (id=");
        builder.append(this.id);
        builder.append(", label=");
        builder.append(this.getLabel());
        builder.append(", bundle count=");
        builder.append(this.bundles.size());
        builder.append(")");
        return builder.toString();
    }

    public boolean isEnabled() {
        boolean isEnabled = true;
        TracingComponentDebugOption[] componentChildren = this.getChildren();
        if (componentChildren.length > 0) {
            int i = 0;
            while (i < componentChildren.length) {
                if (!componentChildren[i].isEnabled()) {
                    isEnabled = false;
                    break;
                }
                ++i;
            }
        } else {
            isEnabled = false;
        }
        return isEnabled;
    }

    protected void populateChildren() {
        if (this.bundles.size() > 0) {
            Map currentDebugOptions = DebugOptionsHandler.getDebugOptions().getOptions();
            for (Bundle bundle : this.bundles) {
                Properties options = TracingCollections.getInstance().getDebugOptions(bundle);
                if (options.size() <= 0) continue;
                for (Map.Entry<Object, Object> option : options.entrySet()) {
                    TracingComponentDebugOption[] debugOptions;
                    String key = (String)option.getKey();
                    String value = (String)option.getValue();
                    String debugOptionValue = (String)currentDebugOptions.get(key);
                    String finalValue = null;
                    finalValue = debugOptionValue != null ? debugOptionValue : ((debugOptions = TracingCollections.getInstance().getTracingDebugOptions(key)).length > 0 ? debugOptions[0].getOptionPathValue() : value);
                    TracingComponentDebugOption newDebugOption = new TracingComponentDebugOption(key, finalValue);
                    newDebugOption.setParent(this);
                    TracingCollections.getInstance().storeTracingDebugOption(newDebugOption);
                }
            }
        }
    }

    public TracingComponentDebugOption[] getChildren() {
        TracingNode[] componentChildren = super.getChildren();
        TracingComponentDebugOption[] debugOptions = new TracingComponentDebugOption[componentChildren.length];
        int i = 0;
        while (i < componentChildren.length) {
            debugOptions[i] = (TracingComponentDebugOption)componentChildren[i];
            ++i;
        }
        return debugOptions;
    }

    private void addBundle(String name, boolean consumed, Bundle[] allBundles) {
        if (name != null) {
            int bundleIndex = 0;
            while (bundleIndex < allBundles.length) {
                String symbolicName = allBundles[bundleIndex].getSymbolicName();
                if (symbolicName != null && symbolicName.matches(name) && !TracingCollections.getInstance().isBundleConsumed(allBundles[bundleIndex])) {
                    this.bundles.add(allBundles[bundleIndex]);
                    TracingCollections.getInstance().storeBundleInComponent(this, allBundles[bundleIndex]);
                    if (consumed) {
                        TracingCollections.getInstance().setBundleIsConsumed(allBundles[bundleIndex], consumed);
                        TracingComponent[] components = TracingCollections.getInstance().getComponentsContainingBundle(allBundles[bundleIndex]);
                        int componentIndex = 0;
                        while (componentIndex < components.length) {
                            if (!components[componentIndex].equals(this)) {
                                components[componentIndex].removeBundle(allBundles[bundleIndex]);
                            }
                            ++componentIndex;
                        }
                    }
                }
                ++bundleIndex;
            }
        }
    }

    public void addBundles(IConfigurationElement element) {
        assert (element != null);
        IConfigurationElement[] componentChildren = element.getChildren();
        Bundle[] installedBundles = TracingUIActivator.getDefault().getBundle().getBundleContext().getBundles();
        int i = 0;
        while (i < componentChildren.length) {
            if (componentChildren[i].getName().equals("bundle")) {
                String name = componentChildren[i].getAttribute("name");
                boolean consumed = Boolean.valueOf(componentChildren[i].getAttribute("consumed"));
                this.addBundle(name, consumed, installedBundles);
            }
            ++i;
        }
    }

    public void addBundle(String name, boolean isConsumed) {
        if (name != null) {
            Bundle[] installedBundles = TracingUIActivator.getDefault().getBundle().getBundleContext().getBundles();
            this.addBundle(name, isConsumed, installedBundles);
        }
    }

    public void removeBundle(Bundle bundle) {
        if (bundle != null) {
            this.bundles.remove(bundle);
        }
    }

    public boolean isConsumed() {
        return this.bundles.size() <= 0;
    }

    public String getId() {
        return this.id;
    }

    public Bundle[] getBundles() {
        return this.bundles.toArray(new Bundle[this.bundles.size()]);
    }

    public String getLabel() {
        String componentLabel = this.label;
        if (componentLabel == null) {
            componentLabel = Messages.missingLabelValue;
        }
        return componentLabel;
    }
}

