/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSettingsPrefStore;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.ui.controls.FileListControl;
import org.eclipse.cdt.utils.ui.controls.IFileListChangeListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;

public class FileListControlFieldEditor
extends FieldEditor {
    private FileListControl list;
    private int browseType;
    private Composite topLayout;
    private static final String DEFAULT_SEPARATOR = ";";

    public FileListControlFieldEditor(String name, String labelText, Composite parent, int type) {
        super(name, labelText, parent);
        this.browseType = type;
        this.list.setType(type);
    }

    public FileListControlFieldEditor(String name, String labelText, String tooltip, String contextId, Composite parent, int type) {
        this(name, labelText, parent, type);
        this.getLabelControl(parent).setToolTipText(tooltip);
        if (!contextId.equals("")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.list.getListControl(), contextId);
        }
    }

    public void setToolTip(String tooltip) {
        this.getLabelControl().setToolTipText(tooltip);
    }

    public String getToolTipText() {
        return this.getLabelControl().getToolTipText();
    }

    public FileListControlFieldEditor(String name, String labelText, Composite parent, String value, int type) {
        this(name, labelText, parent, type);
        this.browseType = type;
    }

    public void setFilterPath(String filterPath) {
        this.list.setFilterPath(filterPath);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.list.setFilterExtensions(filterExtensions);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.topLayout = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = false;
        this.topLayout.setLayout((Layout)layout);
        GridData gddata = new GridData(1808);
        gddata.horizontalSpan = 2;
        this.topLayout.setLayoutData((Object)gddata);
        this.list = new FileListControl(this.topLayout, this.getLabelText(), this.getType(), false);
        this.list.addChangeListener(new IFileListChangeListener(){

            public void fileListChanged(FileListControl fileList, String[] oldValue, String[] newValue) {
                FileListControlFieldEditor.this.handleFileListChange(fileList, oldValue, newValue);
            }
        });
        this.topLayout.setLayout((Layout)layout);
    }

    private void handleFileListChange(FileListControl fileList, String[] oldValue, String[] newValue) {
        this.fireValueChanged("field_editor_value", this.createList(oldValue), this.createList(newValue));
    }

    private int getType() {
        return this.browseType;
    }

    protected List getListControl() {
        return this.list.getListControl();
    }

    protected void doLoad() {
        IPreferenceStore store;
        if (this.list != null && (store = this.getPreferenceStore()) != null) {
            IResource project;
            IConfiguration config;
            String s = store.getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            this.list.setList(array);
            this.list.setSelection(0);
            if (store instanceof ToolSettingsPrefStore && (config = ((ToolSettingsPrefStore)store).getSelectedConfig()) != null && (project = config.getOwner()) != null) {
                ToolSettingsPrefStore btsStore;
                Object[] option;
                this.list.setWorkspaceSupport(true);
                if (store instanceof ToolSettingsPrefStore && (option = (btsStore = (ToolSettingsPrefStore)store).getOption(this.getPreferenceName())) != null) {
                    this.list.setContext((IVariableContextInfo)btsStore.obtainMacroProvider().getMacroContextInfo(2, (Object)new OptionContextData((IOption)option[1], (IBuildObject)((IHoldsOptions)option[0]))));
                }
            }
        }
        this.list.selectionChanged();
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            this.list.setList(array);
            this.list.selectionChanged();
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public String[] getStringListValue() {
        return this.list.getItems();
    }

    public int getNumberOfControls() {
        return 1;
    }

    private String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(DEFAULT_SEPARATOR);
            }
            ++i;
        }
        return path.toString();
    }

    private String[] parseString(String stringList) {
        StringTokenizer tokenizer = new StringTokenizer(stringList, DEFAULT_SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            list.add((String)tokenizer.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void setStyle() {
        ((GridLayout)this.topLayout.getLayout()).marginWidth = 0;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.topLayout.getLayoutData()).horizontalSpan = numColumns;
    }

    public Label getLabelControl(Composite parent) {
        return this.list.getLabelControl();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.list.setEnabled(enabled);
    }
}

