/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexIterator
implements Iterable<String[]> {
    private final Pattern pattern;
    private final String string;

    public RegexIterator(Pattern pattern, String string) {
        this.pattern = pattern;
        this.string = string;
    }

    @Override
    public Iterator<String[]> iterator() {
        return new GroupsIterator(this.pattern, this.string);
    }

    private final class GroupsIterator
    implements Iterator<String[]> {
        private final Matcher matcher;
        private final String string;
        private int start = 0;

        public GroupsIterator(Pattern pattern, String string) {
            this.string = string;
            this.matcher = pattern.matcher(string);
        }

        @Override
        public boolean hasNext() {
            return this.start < this.string.length();
        }

        @Override
        public String[] next() {
            if (this.matcher.find(this.start)) {
                if (this.matcher.start() > this.start) {
                    throw new IllegalArgumentException(String.format("Unmatched string: %s", this.string.substring(this.start, this.matcher.start())));
                }
                this.start = this.matcher.end();
                String[] groups = new String[this.matcher.groupCount()];
                int i = 0;
                while (i < groups.length) {
                    groups[i] = this.matcher.group(i + 1);
                    ++i;
                }
                return groups;
            }
            throw new IllegalArgumentException(String.format("Unmatched string: %s", this.string.substring(this.start)));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

