/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SharedDefaults
extends HashMap<String, String> {
    private static final long serialVersionUID = 0L;
    public Document document;
    private File parsedXML;
    private File backUpSharedXML;
    private HashMap<String, String> sharedDefaultsMap = new HashMap();
    private HashMap<String, String> persistDataMap = new HashMap();
    private HashMap<String, String> tableDataMap = new HashMap();
    private static final String SHARED_DEFAULTS_DOT_XML = "shareddefaults.xml";
    private static final String SHARED_DEFAULTS_DOT_BACKUP_DOT_XML = "shareddefaults.backup.xml";
    public static final String SET = "SET";
    public static final String GET = "GET";
    public static final String ResourceFolder = "resources";
    private static SharedDefaults SHAREDDEFAULTS = new SharedDefaults();

    public static SharedDefaults getInstance() {
        return SHAREDDEFAULTS;
    }

    public SharedDefaults() {
        this.parsedXML = TemplateEngineHelper.getSharedDefaultLocation(SHARED_DEFAULTS_DOT_XML);
        this.backUpSharedXML = TemplateEngineHelper.getSharedDefaultLocation(SHARED_DEFAULTS_DOT_BACKUP_DOT_XML);
        if (this.backUpSharedXML.exists()) {
            this.swapXML();
        }
        this.initSharedDefaults();
    }

    private void initSharedDefaults() {
        String key = null;
        String value = null;
        try {
            long length = this.parsedXML.length();
            if (length == 0L) {
                this.parsedXML = this.createDefaultXMLFormat(this.parsedXML);
            }
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURI().toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int listSize = sharedElementList.size();
        int i = 0;
        while (i < listSize) {
            Element xmlElement = sharedElementList.get(i);
            key = xmlElement.getAttribute("id");
            value = xmlElement.getAttribute("value");
            if (key != null && !key.trim().equals("")) {
                this.sharedDefaultsMap.put(key, value);
            }
            ++i;
        }
    }

    public void updateShareDefaultsMap(Map<String, String> sharedMap) {
        this.sharedDefaultsMap.putAll(sharedMap);
        this.persistSharedValueMap();
    }

    public void persistSharedValueMap() {
        this.generateSharedXML(this.backUpSharedXML);
        this.generateSharedXML(this.parsedXML);
        this.swapXML();
    }

    public Map<String, String> getSharedDefaultsMap() {
        return this.sharedDefaultsMap;
    }

    public void addToBackEndStorage(String name, String value) {
        if (this.sharedDefaultsMap != null) {
            this.tableDataMap.putAll(this.sharedDefaultsMap);
        }
        this.tableDataMap.put(name, value);
        this.updateShareDefaultsMap(this.tableDataMap);
    }

    public void updateToBackEndStorage(String updateName, String updateValue) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURI().toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        this.persistDataMap.putAll(this.sharedDefaultsMap);
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("id");
            if (updateName.equals(name)) {
                this.persistDataMap.put(updateName, updateValue);
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.persistDataMap);
    }

    public void deleteBackEndStorage(String[] deleteName) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURI().toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log(exp);
        }
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("id");
            int k = 0;
            while (k < deleteName.length) {
                if (deleteName[k].equals(name)) {
                    xmlElement.removeAttribute(name);
                    this.sharedDefaultsMap.remove(name);
                }
                ++k;
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.sharedDefaultsMap);
    }

    private File createDefaultXMLFormat(File xmlFile) {
        Document d;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            TemplateEngineUtil.log(e);
            return xmlFile;
        }
        Node rootElement = d.appendChild(d.createElement("SharedRoot"));
        Element element = (Element)rootElement.appendChild(d.createElement("SharedProperty"));
        element.setAttribute("id", "");
        element.setAttribute("value", "");
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(xmlFile);
            StreamResult fileResult = new StreamResult(fos);
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (IOException ioe) {
            TemplateEngineUtil.log(ioe);
        }
        catch (TransformerConfigurationException tce) {
            TemplateEngineUtil.log(tce);
        }
        catch (TransformerException te) {
            TemplateEngineUtil.log(te);
        }
        return xmlFile;
    }

    private void generateSharedXML(File xmlFile) {
        Document d;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            TemplateEngineUtil.log(e);
            return;
        }
        Node rootElement = d.appendChild(d.createElement("SharedRoot"));
        for (String key : this.sharedDefaultsMap.keySet()) {
            Element element = (Element)rootElement.appendChild(d.createElement("SharedProperty"));
            element.setAttribute("id", key);
            element.setAttribute("value", this.sharedDefaultsMap.get(key));
        }
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamResult fileResult = new StreamResult(xmlFile);
        try {
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (Throwable t) {
            TemplateEngineUtil.log(t);
        }
    }

    private void swapXML() {
        if (this.parsedXML.exists()) {
            this.parsedXML.delete();
        }
        this.backUpSharedXML.renameTo(this.parsedXML);
    }
}

