/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.IMIHelpContextIds;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private IWorkbench fWorkbench;
    private MIIntegerFieldEditor fDebugTimeoutText;
    private MIIntegerFieldEditor fLaunchTimeoutText;
    private BooleanFieldEditor fRefreshSolibsButton;
    private MIPreferenceStore fMICorePreferenceStore = new MIPreferenceStore(MIPlugin.getDefault().getPluginPreferences());

    public MIPreferencePage() {
        this.setPreferenceStore(MIUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("MIPreferencePage.0"));
    }

    protected Control createContents(Composite parent) {
        this.getWorkbench().getHelpSystem().setHelp(this.getControl(), IMIHelpContextIds.MI_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createCommunicationPreferences(composite);
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        return ControlFactory.createGroup((Composite)parent, (String)labelText, (int)numColumns);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.storeValues();
        MIUIPlugin.getDefault().savePluginPreferences();
        MIPlugin.getDefault().savePluginPreferences();
        return result;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fDebugTimeoutText.loadDefault();
        this.fLaunchTimeoutText.loadDefault();
        this.fRefreshSolibsButton.loadDefault();
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void createCommunicationPreferences(Composite composite) {
        Composite comp = this.createGroupComposite(composite, 1, PreferenceMessages.getString("MIPreferencePage.1"));
        Composite spacingComposite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        spacingComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)data);
        this.fDebugTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_TIMEOUT, PreferenceMessages.getString("MIPreferencePage.2"), spacingComposite);
        this.fDebugTimeoutText.setPropertyChangeListener(this);
        this.fLaunchTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, PreferenceMessages.getString("MIPreferencePage.3"), spacingComposite);
        this.fLaunchTimeoutText.setPropertyChangeListener(this);
        this.fRefreshSolibsButton = this.createCheckbox(IMIConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH, PreferenceMessages.getString("MIPreferencePage.6"), spacingComposite);
    }

    private void storeValues() {
        this.fDebugTimeoutText.store();
        this.fLaunchTimeoutText.store();
        this.fRefreshSolibsButton.store();
    }

    private MIIntegerFieldEditor createTimeoutField(String preference, String label, Composite parent) {
        MIIntegerFieldEditor toText = new MIIntegerFieldEditor(preference, label, parent);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(10);
        toText.getTextControl(parent).setLayoutData((Object)data);
        toText.setPreferenceStore(this.getMICorePreferenceStore());
        toText.setPage((DialogPage)this);
        toText.setValidateStrategy(0);
        toText.setValidRange(100, Integer.MAX_VALUE);
        String minValue = Integer.toString(100);
        String maxValue = Integer.toString(Integer.MAX_VALUE);
        toText.setErrorMessage(MessageFormat.format((String)PreferenceMessages.getString("MIPreferencePage.4"), (Object[])new String[]{minValue, maxValue}));
        toText.load();
        return toText;
    }

    private BooleanFieldEditor createCheckbox(String preference, String label, Composite parent) {
        BooleanFieldEditor field = new BooleanFieldEditor(preference, label, parent);
        field.setPage((DialogPage)this);
        field.setPreferenceStore((IPreferenceStore)new MIPreferenceStore(MIPlugin.getDefault().getPluginPreferences()));
        field.load();
        return field;
    }

    protected MIPreferenceStore getMICorePreferenceStore() {
        return this.fMICorePreferenceStore;
    }

    public void dispose() {
        this.fDebugTimeoutText.dispose();
        this.fLaunchTimeoutText.dispose();
        this.fRefreshSolibsButton.dispose();
        super.dispose();
    }

    protected MIIntegerFieldEditor getLaunchTimeoutText() {
        return this.fLaunchTimeoutText;
    }

    protected MIIntegerFieldEditor getDebugTimeoutText() {
        return this.fDebugTimeoutText;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            MIIntegerFieldEditor launchTimeout = this.getLaunchTimeoutText();
            MIIntegerFieldEditor debugTimeout = this.getDebugTimeoutText();
            if (newValue) {
                if (launchTimeout != null && event.getSource() != launchTimeout) {
                    launchTimeout.refreshValidState();
                }
                if (debugTimeout != null && event.getSource() != debugTimeout) {
                    debugTimeout.refreshValidState();
                }
            }
            this.setValid(launchTimeout.isValid() && debugTimeout.isValid());
            this.getContainer().updateButtons();
            this.updateApplyButton();
        }
    }

    protected boolean canClearErrorMessage() {
        MIIntegerFieldEditor launchTimeout = this.getLaunchTimeoutText();
        MIIntegerFieldEditor debugTimeout = this.getDebugTimeoutText();
        boolean validLaunch = false;
        boolean validDebug = false;
        if (launchTimeout != null) {
            validLaunch = launchTimeout.isValid();
        }
        if (debugTimeout != null) {
            validDebug = debugTimeout.isValid();
        }
        return validLaunch && validDebug;
    }

    private IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected class MIIntegerFieldEditor
    extends IntegerFieldEditor {
        public MIIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (MIPreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }

    public class MIPreferenceStore
    implements IPreferenceStore {
        private Preferences fPreferences;
        private HashMap fListeners = new HashMap();

        public MIPreferenceStore(Preferences pref) {
            this.fPreferences = pref;
        }

        public void addPropertyChangeListener(final IPropertyChangeListener listener) {
            Preferences.IPropertyChangeListener l = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    listener.propertyChange(new PropertyChangeEvent((Object)MIPreferenceStore.this, event.getProperty(), event.getNewValue(), event.getOldValue()));
                }
            };
            this.fListeners.put(listener, l);
        }

        public boolean contains(String name) {
            return this.getPreferences().contains(name);
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            Iterator it = this.fListeners.keySet().iterator();
            while (it.hasNext()) {
                ((IPropertyChangeListener)it.next()).propertyChange(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
            }
        }

        public boolean getBoolean(String name) {
            return this.fPreferences.getBoolean(name);
        }

        public boolean getDefaultBoolean(String name) {
            return this.fPreferences.getDefaultBoolean(name);
        }

        public double getDefaultDouble(String name) {
            return this.fPreferences.getDefaultDouble(name);
        }

        public float getDefaultFloat(String name) {
            return this.fPreferences.getDefaultFloat(name);
        }

        public int getDefaultInt(String name) {
            return this.fPreferences.getDefaultInt(name);
        }

        public long getDefaultLong(String name) {
            return this.fPreferences.getDefaultLong(name);
        }

        public String getDefaultString(String name) {
            return this.fPreferences.getDefaultString(name);
        }

        public double getDouble(String name) {
            return this.fPreferences.getDouble(name);
        }

        public float getFloat(String name) {
            return this.fPreferences.getFloat(name);
        }

        public int getInt(String name) {
            return this.fPreferences.getInt(name);
        }

        public long getLong(String name) {
            return this.fPreferences.getLong(name);
        }

        public String getString(String name) {
            return this.fPreferences.getString(name);
        }

        public boolean isDefault(String name) {
            return this.fPreferences.isDefault(name);
        }

        public boolean needsSaving() {
            return this.getPreferences().needsSaving();
        }

        public void putValue(String name, String value) {
            this.getPreferences().setValue(name, value);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.fListeners.remove(listener);
        }

        public void setDefault(String name, double value) {
            this.getPreferences().setDefault(name, value);
        }

        public void setDefault(String name, float value) {
            this.getPreferences().setDefault(name, value);
        }

        public void setDefault(String name, int value) {
            this.getPreferences().setDefault(name, value);
        }

        public void setDefault(String name, long value) {
            this.getPreferences().setDefault(name, value);
        }

        public void setDefault(String name, String defaultObject) {
            this.getPreferences().setDefault(name, defaultObject);
        }

        public void setDefault(String name, boolean value) {
            this.getPreferences().setDefault(name, value);
        }

        public void setToDefault(String name) {
            this.getPreferences().setToDefault(name);
        }

        public void setValue(String name, double value) {
            this.getPreferences().setValue(name, value);
        }

        public void setValue(String name, float value) {
            this.getPreferences().setValue(name, value);
        }

        public void setValue(String name, int value) {
            this.getPreferences().setValue(name, value);
        }

        public void setValue(String name, long value) {
            this.getPreferences().setValue(name, value);
        }

        public void setValue(String name, String value) {
            this.getPreferences().setValue(name, value);
        }

        public void setValue(String name, boolean value) {
            this.getPreferences().setValue(name, value);
        }

        protected Preferences getPreferences() {
            return this.fPreferences;
        }
    }
}

