/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.FileNamesComparator;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import com.nvidia.cuda.ide.build.project.MultiCubin;
import com.nvidia.cuda.ide.build.project.MultiExecutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public final class ExecutableFilesContentProvider
implements IStructuredContentProvider {
    private final Map<ICConfigurationDescription, IFile[]> files = new HashMap<ICConfigurationDescription, IFile[]>();

    public void dispose() {
    }

    private IFile[] getAllCUFiles(ICConfigurationDescription description) {
        if (description == null) {
            return new IFile[0];
        }
        Collection<IFile> files = null;
        if (description instanceof ICMultiConfigDescription) {
            Object[] items;
            Object[] objectArray = items = ((ICMultiConfigDescription)description).getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Collection<IFile> collection = this.getConfigurationFiles((ICConfigurationDescription)object);
                if (files == null) {
                    files = collection;
                } else {
                    files.retainAll(collection);
                }
                ++n2;
            }
        } else {
            files = this.getConfigurationFiles(description);
        }
        return files == null ? new IFile[]{} : files.toArray(new IFile[files.size()]);
    }

    private Collection<IFile> getConfigurationFiles(ICConfigurationDescription description) {
        ICSourceEntry[] sourceEntries = description.getSourceEntries();
        HashSet<IFile> set = new HashSet<IFile>();
        ICSourceEntry[] iCSourceEntryArray = sourceEntries;
        int n = sourceEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry entry = iCSourceEntryArray[n2];
            IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getFullPath());
            if (member.getType() == 2 || member.getType() == 4) {
                try {
                    FileSearchVisitor visitor = new FileSearchVisitor(description);
                    member.accept((IResourceVisitor)visitor);
                    set.addAll(visitor.getFiles());
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            ++n2;
        }
        return set;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MultiExecutable) {
            return this.getExecutableFiles(((MultiExecutable)inputElement).getParentConfiguration());
        }
        if (inputElement instanceof MultiCubin) {
            MultiCubin cubin = (MultiCubin)inputElement;
            Collection<IFile> common = cubin.getFilesInAllConfigurations();
            Collection<IFile> uncommon = cubin.getFilesInAnyConfiguration();
            ArrayList<IFile> list = new ArrayList<IFile>(common.size() + uncommon.size());
            list.addAll(common);
            list.addAll(uncommon);
            return list.toArray();
        }
        return new Object[0];
    }

    private Object[] getExecutableFiles(MultiConfiguration projectConfiguration) {
        ICConfigurationDescription description = projectConfiguration.getConfigurationDescription();
        IFile[] array = this.files.get(description);
        if (array == null) {
            array = this.getAllCUFiles(description);
            this.files.put(description, array);
        }
        TreeSet<IFile> files = new TreeSet<IFile>(new FileNamesComparator());
        files.addAll(Arrays.asList(array));
        files.removeAll(projectConfiguration.getExecutable().getExcludedFromAllConfigurations());
        return files.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static class FileSearchVisitor
    implements IResourceVisitor {
        private final ICConfigurationDescription configuration;
        private final Collection<IFile> files = new LinkedList<IFile>();

        public FileSearchVisitor(ICConfigurationDescription configuration) {
            this.configuration = configuration;
        }

        public Collection<IFile> getFiles() {
            return this.files;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                ILanguage language = LanguageManager.getInstance().getLanguageForFile(file, this.configuration);
                if (language != null && "com.nvidia.cuda.ide.editor.cudac".equals(language.getId())) {
                    this.files.add(file);
                }
            }
            return true;
        }
    }
}

