/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;

public class CASTEnumerationSpecifier
extends CASTBaseDeclSpecifier
implements IASTInternalEnumerationSpecifier,
ICASTEnumerationSpecifier {
    private IASTName name;
    private boolean valuesComputed = false;
    private IASTEnumerationSpecifier.IASTEnumerator[] enumerators = null;
    private int enumeratorsPos = -1;

    public CASTEnumerationSpecifier() {
    }

    public CASTEnumerationSpecifier(IASTName name) {
        this.setName(name);
    }

    @Override
    public CASTEnumerationSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTEnumerationSpecifier copy(IASTNode.CopyStyle style) {
        CASTEnumerationSpecifier copy = new CASTEnumerationSpecifier();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CASTEnumerationSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setName(this.name == null ? null : this.name.copy(style));
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = this.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
            copy.addEnumerator(enumerator == null ? null : enumerator.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public boolean startValueComputation() {
        if (this.valuesComputed) {
            return false;
        }
        this.valuesComputed = true;
        return true;
    }

    @Override
    public void addEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.assertNotFrozen();
        if (enumerator != null) {
            enumerator.setParent(this);
            enumerator.setPropertyInParent(ENUMERATOR);
            this.enumerators = ArrayUtil.appendAt(IASTEnumerationSpecifier.IASTEnumerator.class, this.enumerators, ++this.enumeratorsPos, enumerator);
        }
    }

    @Override
    public IASTEnumerationSpecifier.IASTEnumerator[] getEnumerators() {
        if (this.enumerators == null) {
            return IASTEnumerationSpecifier.IASTEnumerator.EMPTY_ENUMERATOR_ARRAY;
        }
        this.enumerators = ArrayUtil.trimAt(IASTEnumerationSpecifier.IASTEnumerator.class, this.enumerators, this.enumeratorsPos);
        return this.enumerators;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATION_NAME);
        }
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] etors = this.getEnumerators();
        int i = 0;
        while (i < etors.length) {
            if (!etors[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 2;
        }
        return 3;
    }
}

