/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.Messages;
import org.eclipse.cdt.dsf.debug.internal.ui.sourcelookup.DsfSourceSelectionResolver;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.IDsfStepIntoSelection;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class DsfStepIntoSelectionHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (editor == null || region == null || !(editor instanceof CEditor)) {
            return null;
        }
        ITextSelection selection = this.resolveSelection(editor, region);
        if (selection == null) {
            return null;
        }
        IRunControl.IExecutionDMContext dmc = this.resolveDebugContext();
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null || !session.isActive()) {
            return null;
        }
        IDsfStepIntoSelection stepIntoSelectionCommand = (IDsfStepIntoSelection)session.getModelAdapter(IDsfStepIntoSelection.class);
        if (stepIntoSelectionCommand == null) {
            return null;
        }
        if (!stepIntoSelectionCommand.isExecutable(dmc)) {
            return null;
        }
        DsfSourceSelectionResolver functionResolver = new DsfSourceSelectionResolver(editor, selection);
        functionResolver.run();
        if (!functionResolver.isSuccessful()) {
            return null;
        }
        return new IHyperlink[]{new DsfStepIntoSelectionHyperlink(functionResolver, stepIntoSelectionCommand)};
    }

    private ITextSelection resolveSelection(ITextEditor editor, IRegion region) {
        TextSelection selection = null;
        if (editor != null) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
            if (document != null && workingCopy != null) {
                try {
                    IRegion wregion;
                    String partitionType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)region.getOffset(), (boolean)false);
                    if ("__dftl_partition_content_type".equals(partitionType) && (wregion = DsfStepIntoSelectionHyperlinkDetector.getIdentifier(document, region.getOffset(), workingCopy.getLanguage())) != null) {
                        selection = new TextSelection(document, wregion.getOffset(), wregion.getLength());
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (CoreException coreException) {}
            }
        }
        return selection;
    }

    private static IRegion getIdentifier(IDocument document, int offset, ILanguage language) throws BadLocationException {
        String word;
        IRegion wordRegion = CWordFinder.findWord((IDocument)document, (int)offset);
        if (wordRegion != null && wordRegion.getLength() > 0 && !Character.isDigit((word = document.get(wordRegion.getOffset(), wordRegion.getLength())).charAt(0)) && !DsfStepIntoSelectionHyperlinkDetector.isLanguageKeyword(language, word)) {
            return wordRegion;
        }
        return null;
    }

    private static boolean isLanguageKeyword(ILanguage lang, String word) {
        ICLanguageKeywords keywords = (ICLanguageKeywords)lang.getAdapter(ICLanguageKeywords.class);
        if (keywords != null) {
            String keyword;
            String[] stringArray = keywords.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                if (keyword.equals(word)) {
                    return true;
                }
                ++n2;
            }
            stringArray = keywords.getBuiltinTypes();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (type.equals(word)) {
                    return true;
                }
                ++n2;
            }
            stringArray = keywords.getPreprocessorKeywords();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                if (keyword.charAt(0) == '#' && keyword.length() == word.length() + 1 && keyword.regionMatches(1, word, 0, word.length())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IRunControl.IExecutionDMContext resolveDebugContext() {
        IRunControl.IExecutionDMContext execContext = null;
        IAdaptable adaptableContext = DebugUITools.getDebugContext();
        IDMContext debugContext = null;
        if (adaptableContext instanceof IDMVMContext) {
            debugContext = ((IDMVMContext)adaptableContext).getDMContext();
        }
        if (debugContext != null) {
            execContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)debugContext, IRunControl.IExecutionDMContext.class);
        }
        return execContext;
    }

    private class DsfStepIntoSelectionHyperlink
    implements IHyperlink {
        private ITextSelection fSelection = null;
        private IDsfStepIntoSelection fStepIntoSelectionCommand = null;
        private DsfSourceSelectionResolver fSelectionResolver = null;

        public DsfStepIntoSelectionHyperlink(DsfSourceSelectionResolver selectionResolver, IDsfStepIntoSelection stepIntoSelectionCommand) {
            this.fSelection = selectionResolver.resolveSelection();
            this.fStepIntoSelectionCommand = stepIntoSelectionCommand;
            this.fSelectionResolver = selectionResolver;
        }

        public IRegion getHyperlinkRegion() {
            return new Region(this.fSelection.getOffset(), this.fSelection.getLength());
        }

        public String getHyperlinkText() {
            return Messages.DsfUIStepIntoEditorSelection;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            IRunControl.IExecutionDMContext dmc = DsfStepIntoSelectionHyperlinkDetector.this.resolveDebugContext();
            if (this.fSelectionResolver.isSuccessful() && dmc != null) {
                DsfSourceSelectionResolver.LineLocation location = this.fSelectionResolver.getLineLocation();
                this.fStepIntoSelectionCommand.runToSelection(location.getFileName(), location.getLineNumber(), this.fSelectionResolver.getFunction(), dmc);
            } else {
                String message = null;
                message = dmc == null ? "DSfStepIntoSelection: Unable to resolve the debug context" : "DSfStepIntoSelection: Unable to resolve a selected function";
                DsfUIPlugin.debug(message);
            }
        }
    }
}

