/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaFinalLaunchSequence;
import com.nvidia.cuda.ide.debug.launch.CudaLaunch;
import com.nvidia.cuda.ide.debug.launch.CudaMIParser;
import com.nvidia.cuda.ide.debug.launch.CudaRunControlEventProcessor;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.command.GDBBackendCLIProcess;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControlDMContext;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.mi.service.command.AbstractMIControl;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor_7_0;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIParser;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public final class CudaControl
extends AbstractMIControl
implements IGDBControl {
    private final ILaunchConfiguration config;
    private CLIEventProcessor_7_0 fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private GDBControlDMContext fControlDmc;
    private CudaRunControlEventProcessor fCudaMIEventProcessor;
    private IGDBBackend fMIBackend;
    private boolean fTerminated;
    private boolean hadSuccess = false;

    public CudaControl(DsfSession session, ILaunchConfiguration config, CudaCommandFactory factory) {
        super(session, false, false, (CommandFactory)factory);
        this.config = config;
    }

    public void completeInitialization(final RequestMonitor rm) {
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            attributes.putAll(launch.getLaunchConfiguration().getAttributes());
        }
        catch (CoreException coreException) {}
        if (launch instanceof CudaLaunch) {
            attributes.put(CudaFinalLaunchSequence.ATTR_PREEMPTION, ((CudaLaunch)launch).isPreemptionOn());
        }
        RequestMonitorWithProgress progressRm = rm instanceof RequestMonitorWithProgress ? (RequestMonitorWithProgress)rm : new RequestMonitorWithProgress((Executor)this.getExecutor(), (IProgressMonitor)new NullProgressMonitor()){

            protected void handleCompleted() {
                rm.setStatus(this.getStatus());
                rm.done();
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)this.getCompleteInitializationSequence(attributes, progressRm));
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fMIBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fControlDmc = new GDBControlDMContext(this.getSession().getId(), this.getId());
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void enablePrettyPrintingForMIVariableObjects(RequestMonitor rm) {
        this.queueCommand(this.getCommandFactory().createMIEnablePrettyPrinting((ICommandControlService.ICommandControlDMContext)this.fControlDmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (e.getState() == IMIBackend.State.TERMINATED && e.getBackendId().equals(this.fMIBackend.getId())) {
            this.getSession().dispatchEvent((Object)new GDBControlShutdownDMEvent((ICommandControlService.ICommandControlDMContext)this.fControlDmc), this.getProperties());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.stopCommandProcessing();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        if (e.isVisualizationModeEnabled()) {
            this.setUseThreadAndFrameOptions(false);
        } else {
            this.setUseThreadAndFrameOptions(true);
        }
    }

    protected BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        return new CudaFinalLaunchSequence(this.getSession(), attributes, rm);
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fControlDmc;
    }

    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public List<String> getFeatures() {
        return Arrays.asList("frozen-varobjs", "pending-breakpoints", "thread-info");
    }

    public String getId() {
        return this.fMIBackend.getId();
    }

    public String getLaunchName() {
        return this.config.getName();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                CudaControl.this.doInitialize(requestMonitor);
            }
        });
    }

    public void setEnvironment(Properties props, boolean clear, RequestMonitor rm) {
        int count = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        if (clear) {
            ++count;
            this.queueCommand(this.getCommandFactory().createCLIUnsetEnv(this.getContext()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            ++count;
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            this.queueCommand(this.getCommandFactory().createMIGDBSetEnv(this.getContext(), name, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
        countingRm.setDoneCount(count);
    }

    public void setPrintPythonErrors(boolean enabled, RequestMonitor rm) {
        String errorOption = enabled ? "full" : "none";
        this.queueCommand(this.getCommandFactory().createMIGDBSetPythonPrintStack(this.getContext(), errorOption), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public void setTracingStream(OutputStream tracingStream) {
        this.setMITracingStream(tracingStream);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                CudaControl.super.shutdown(requestMonitor);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    public void terminate(final RequestMonitor rm) {
        if (this.fTerminated) {
            rm.done();
            return;
        }
        this.fTerminated = true;
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
            this.fMIBackend.interrupt();
        }
        final ScheduledFuture forceQuitTask = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            protected boolean isExecutionRequired() {
                return false;
            }

            public void run() {
                CudaControl.this.fMIBackend.destroy();
                rm.done();
            }
        }, 2L, TimeUnit.SECONDS);
        this.queueCommand(this.getCommandFactory().createMIGDBExit((IDMContext)this.fControlDmc), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess()) {
                    forceQuitTask.cancel(false);
                    rm.done();
                }
            }
        });
    }

    public <V extends ICommandResult> ICommandToken queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        if (!this.hadSuccess) {
            IMIBackend.State state = this.fMIBackend.getState();
            if (state == IMIBackend.State.TERMINATED) {
                this.getSession().getExecutor().schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        CudaControl.this.stopCommandProcessing();
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            } else {
                this.hadSuccess = true;
            }
        }
        return super.queueCommand(command, rm);
    }

    protected MIParser createMIParser() {
        return new CudaMIParser();
    }

    public CudaCommandFactory getCommandFactory() {
        return (CudaCommandFactory)super.getCommandFactory();
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        protected void initialize(RequestMonitor requestMonitor) {
            CudaControl.this.startCommandProcessing(CudaControl.this.fMIBackend.getMIInputStream(), CudaControl.this.fMIBackend.getMIOutputStream());
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            CudaControl.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            try {
                CudaControl.this.fCLIProcess = (AbstractCLIProcess)new GDBBackendCLIProcess((ICommandControlService)CudaControl.this, (IMIBackend)CudaControl.this.fMIBackend);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            CudaControl.this.fCLICommandProcessor = new CLIEventProcessor_7_0((ICommandControlService)CudaControl.this, (ICommandControlService.ICommandControlDMContext)CudaControl.this.fControlDmc);
            CudaControl.this.fCudaMIEventProcessor = new CudaRunControlEventProcessor(CudaControl.this, (ICommandControlService.ICommandControlDMContext)CudaControl.this.getControlDMContext());
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            CudaControl.this.fCLICommandProcessor.dispose();
            CudaControl.this.fCLIProcess.dispose();
            CudaControl.this.fCudaMIEventProcessor.dispose();
            requestMonitor.done();
        }
    }

    private static class GDBControlInitializedDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlInitializedDMEvent {
        public GDBControlInitializedDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    private static class GDBControlShutdownDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlShutdownDMEvent {
        public GDBControlShutdownDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private final Direction fDirection;

        public InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        @Override
        public void initialize(RequestMonitor requestMonitor) {
            CudaControl.this.getSession().addServiceEventListener((Object)CudaControl.this, null);
            CudaControl.this.register(new String[]{ICommandControl.class.getName(), ICommandControlService.class.getName(), IMICommandControl.class.getName(), AbstractMIControl.class.getName(), IGDBControl.class.getName()}, new Hashtable());
            CudaControl.this.getSession().dispatchEvent((Object)new GDBControlInitializedDMEvent((ICommandControlService.ICommandControlDMContext)CudaControl.this.fControlDmc), CudaControl.this.getProperties());
            requestMonitor.done();
        }

        @Override
        protected void shutdown(RequestMonitor requestMonitor) {
            CudaControl.this.unregister();
            CudaControl.this.getSession().removeServiceEventListener((Object)CudaControl.this);
            requestMonitor.done();
        }
    }
}

