/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.memory;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.memory.DeviceMemoryType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CudaGdbMemoryBlockRetrieval
extends GdbMemoryBlockRetrieval {
    public CudaGdbMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        super(modelId, config, session);
    }

    public IMemorySpaceAwareMemoryBlock getMemoryBlock(final String expression, final Object context, String memorySpaceID) throws DebugException {
        ICudaRuntimeObject cro = DebugUtil.getObject(context, ICudaRuntimeObject.class, null);
        if (memorySpaceID == null && cro != null) {
            DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), this.getSession().getId());
            try {
                final IExpressions expressionService = (IExpressions)tracker.getService(IExpressions.class);
                if (expressionService != null) {
                    Query<String> query = new Query<String>(){

                        protected void execute(DataRequestMonitor<String> rm) {
                            IDMContext dmc = DebugUtil.getObject(context, IDMContext.class, null);
                            CudaGdbMemoryBlockRetrieval.this.getMemorySpace(dmc, expression, expressionService, (DataRequestMonitor<String>)rm);
                        }
                    };
                    this.getSession().getExecutor().execute((Runnable)query);
                    IMemorySpaceAwareMemoryBlock iMemorySpaceAwareMemoryBlock = super.getMemoryBlock(expression, context, (String)query.get());
                    return iMemorySpaceAwareMemoryBlock;
                }
                try {
                    throw new DebugException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Unable to obtain expression information"));
                }
                catch (InterruptedException e) {
                    throw new DebugException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Unable to obtain address memory space", (Throwable)e));
                }
                catch (ExecutionException e) {
                    throw new DebugException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Unable to obtain address memory space", (Throwable)e));
                }
            }
            finally {
                tracker.dispose();
            }
        }
        return super.getMemoryBlock(expression, context, memorySpaceID);
    }

    private void getMemorySpace(IDMContext dmc, String expression, IExpressions expressionService, final DataRequestMonitor<String> rm) {
        IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(dmc, expression);
        expressionService.getExpressionData(expressionDMC, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)this.getExecutor(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                rm.done((Object)DeviceMemoryType.fromCudaGdbType(((IExpressions.IExpressionDMData)this.getData()).getTypeName()));
            }
        });
    }
}

