/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.RGB;

public class ExpressionLabelProvider
extends VariableLabelProvider {
    @Override
    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IErrorReportingExpression expression;
        Object element = elementPath.getLastSegment();
        if (element instanceof IErrorReportingExpression && (expression = (IErrorReportingExpression)element).hasErrors() && (columnId == null || columnId.equals("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE"))) {
            return new RGB(255, 0, 0);
        }
        return super.getForeground(elementPath, presentationContext, columnId);
    }

    @Override
    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        if (columnId == null) {
            return super.getLabel(elementPath, context, columnId);
        }
        IExpression expression = (IExpression)elementPath.getLastSegment();
        IValue value = expression.getValue();
        return this.getColumnText(expression, value, context, columnId);
    }

    private String getColumnText(IExpression expression, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return this.getExpressionName(expression, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(columnId)) {
            return this.getExpressionValueText(expression, value, context);
        }
        if (("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_TYPE".equals(columnId) || "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VALUE_TYPE".equals(columnId)) && value != null) {
            return this.getValueTypeName(null, value, context);
        }
        return null;
    }

    protected String getExpressionName(IExpression expression, IPresentationContext context) throws CoreException {
        if (expression instanceof IWatchExpression) {
            return this.getWatchExpressionName((IWatchExpression)expression, context);
        }
        return expression.getExpressionText();
    }

    private String getWatchExpressionName(IWatchExpression expression, IPresentationContext context) {
        StringBuffer result = new StringBuffer();
        String snippet = expression.getExpressionText().trim();
        StringBuffer snippetBuffer = new StringBuffer();
        if (snippet.length() > 30) {
            snippetBuffer.append(snippet.substring(0, 15));
            snippetBuffer.append(DebugUIMessages.DefaultLabelProvider_0);
            snippetBuffer.append(snippet.substring(snippet.length() - 15));
        } else {
            snippetBuffer.append(snippet);
        }
        snippet = snippetBuffer.toString().replaceAll("[\n\r\t]+", " ");
        result.append('\"');
        result.append(snippet);
        result.append('\"');
        return result.toString();
    }

    protected String getExpressionValueText(IExpression expression, IValue value, IPresentationContext context) throws CoreException {
        if (expression instanceof IWatchExpression) {
            IWatchExpression watchExpression = (IWatchExpression)expression;
            StringBuffer result = new StringBuffer();
            if (watchExpression.isPending()) {
                result.append(DebugUIMessages.DefaultLabelProvider_12);
            } else if (watchExpression.hasErrors()) {
                result.append(DebugUIMessages.DefaultLabelProvider_13);
            } else if (value != null) {
                result.append(this.getValueText(null, value, context));
            }
            if (!watchExpression.isEnabled()) {
                result.append(DebugUIMessages.DefaultLabelProvider_15);
            }
            return result.toString();
        }
        if (value != null) {
            return this.getValueText(null, value, context);
        }
        return null;
    }
}

