/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKind;

public class TimelineThread
extends Timeline
implements IModel {
    private final int processId;
    private final int threadId;

    public TimelineThread(int processId, int threadId) {
        super(String.valueOf((long)threadId & 0xFFFFFFFFL), TimelineKind.THREAD);
        this.processId = processId;
        this.threadId = threadId;
    }

    @Override
    public String getDisplayName(boolean verbose) {
        return "Thread " + super.getDisplayName(verbose);
    }

    public int getId() {
        return this.threadId;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            if (this.getCustomName() != null) {
                CuptiActivityName nameActivity = new CuptiActivityName(CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_THREAD.getCode(), this.processId, this.threadId, 0, 0, 0, this.getCustomName());
                nameActivity.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

