/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.RemoteFileSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.ui.ConnectionControl;
import com.nvidia.viper.ui.ImportMultipleFilesScopeControl;
import com.nvidia.viper.ui.TimelineOptionsControl;
import com.nvidia.viper.ui.UVMSegmentComposite;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImportNvprofSingleProcessPage
extends WizardPage
implements Listener {
    private Text timelinePath;
    private ImportMultipleFilesScopeControl multipleFilesScopeControl;
    private ConnectionControl connectionControl;
    private UVMSegmentComposite segmentControl;
    private TimelineOptionsControl timelineOptionControl;
    private Session session = new Session();

    public ImportNvprofSingleProcessPage(String pageName) {
        super(pageName);
        this.setTitle(ViperMessages.ImportNvprof_WizardPageSingle_Title);
        this.setDescription(ViperMessages.ImportNvprof_WizardPageSingle_Message);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        final TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int index = tabFolder.getSelectionIndex();
                if (index == 0) {
                    ImportNvprofSingleProcessPage.this.setTitle(ViperMessages.ImportNvprof_WizardPageSingle_Title);
                    ImportNvprofSingleProcessPage.this.setDescription(ViperMessages.ImportNvprof_WizardPageSingle_Message);
                } else if (index == 1) {
                    ImportNvprofSingleProcessPage.this.setTitle(ViperMessages.TimelineOptionsPage_Title);
                    ImportNvprofSingleProcessPage.this.setDescription(ViperMessages.TimelineOptionsPage_Message);
                }
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Profile Files");
        Composite mainComposite = new Composite((Composite)tabFolder, 0);
        tabItem.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(3, false);
        mainComposite.setLayout((Layout)mainLayout);
        Label labelConnection = new Label(mainComposite, 0);
        labelConnection.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelConnection.setText(ViperMessages.Connection_Label);
        this.connectionControl = new ConnectionControl(mainComposite);
        this.connectionControl.setLayoutData(new GridData(4, 4, false, false, 2, 1));
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Timeline data file: ");
        this.timelinePath = new Text(mainComposite, 2052);
        this.timelinePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timelinePath.setMessage(ViperMessages.ImportNvprof_Timeline_Message);
        this.timelinePath.addListener(24, (Listener)this);
        Button browseButton = new Button(mainComposite, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path path = new Path(ImportNvprofSingleProcessPage.this.timelinePath.getText());
                String prefPath = null;
                prefPath = path.toFile().exists() ? (path.toFile().isDirectory() ? path.toOSString() : path.toFile().getParent().toString()) : Activator.getDefault().getPreferenceStore().getString("ImportPath");
                FileSystem fileSystem = ImportNvprofSingleProcessPage.this.connectionControl.getFileSystem();
                String[] filename = new String[1];
                try {
                    filename[0] = fileSystem.browseForFile(ImportNvprofSingleProcessPage.this.getShell(), "Select a file", "Select " + Viper.COMMANDLINE_PRODUCT_NAME + " profile file containing timeline data", prefPath);
                }
                catch (CoreException e1) {
                    ViperExceptionHandler.logError(e1.getMessage());
                }
                if (filename[0] != null) {
                    ImportNvprofSingleProcessPage.this.timelinePath.setText(filename[0]);
                    path = new Path(filename[0]);
                    prefPath = path.removeLastSegments(1).toOSString();
                    Activator.getDefault().getPreferenceStore().setValue("ImportPath", prefPath);
                }
            }
        });
        Label multipleFilesLable = new Label(mainComposite, 0);
        multipleFilesLable.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        multipleFilesLable.setText("Event/Metric data files:");
        this.multipleFilesScopeControl = new ImportMultipleFilesScopeControl(mainComposite, this.connectionControl);
        this.multipleFilesScopeControl.setLayoutData(new GridData(4, 4, false, true, 3, 1));
        this.segmentControl = new UVMSegmentComposite(mainComposite, 0);
        this.segmentControl.setLayoutData(new GridData(1, 0x1000000, false, false, 3, 1));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ViperMessages.TimelineOptionsPage_Title);
        this.timelineOptionControl = new TimelineOptionsControl((Composite)tabFolder, 0);
        this.timelineOptionControl.setInput(this.session);
        this.timelineOptionControl.addListener(new TimelineOptionsControl.ITimelineOptionListener(){

            @Override
            public void firePageComplete(boolean complete, String message) {
                ImportNvprofSingleProcessPage.this.setPageComplete(complete);
                ImportNvprofSingleProcessPage.this.setErrorMessage(message);
            }
        });
        tabItem.setControl((Control)this.timelineOptionControl);
        this.setControl((Control)tabFolder);
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.timelinePath) {
            File file = new File(this.timelinePath.getText());
            if (this.connectionControl.isLocalConnection() && file != null && file.isFile()) {
                this.setComplete(true, null);
            } else if (!this.connectionControl.isLocalConnection() && file != null) {
                this.setComplete(true, null);
            } else {
                this.setComplete(false, ViperMessages.ImportNvprof_FileError_Message);
            }
        }
    }

    private void setComplete(boolean complete, String message) {
        this.setErrorMessage(message);
        this.setPageComplete(complete);
    }

    public String getTimelineFilePath() throws ViperException, CoreException {
        FileSystem fileSystem = this.connectionControl.getFileSystem();
        if (fileSystem.isLocal()) {
            return this.timelinePath.getText();
        }
        RemoteFileSystem remote = (RemoteFileSystem)fileSystem;
        NullProgressMonitor monitor = new NullProgressMonitor();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
        File[] result = remote.dowloadProfilingResultFile((IPath)new Path(this.timelinePath.getText()), m, null);
        if (result != null && result.length == 1) {
            return result[0].getAbsolutePath();
        }
        return null;
    }

    public String[] getAdditionalFilePaths() throws ViperException, CoreException {
        return this.multipleFilesScopeControl.getFiles();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    public Session getUpdatedSession() {
        this.session.setNumSegmentsUVM(this.segmentControl.getNumSegments());
        this.session.setIsUVMSegmentEnabled(this.segmentControl.isSegmentEnabled());
        return this.session;
    }

    public List<SessionFilter> getScopes(String filename) {
        return this.multipleFilesScopeControl.getScopes(filename);
    }
}

