/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.DataGridCanvas;
import com.nvidia.viper.ui.analysis.KernelOccupancyDataGrid;
import com.nvidia.viper.ui.analysis.OccupancyDataTablePainter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class KernelOccupancyDataControl
extends Composite {
    private final DataGridCanvas headerTable;
    private final DataGridCanvas tableRegisters;
    private final DataGridCanvas tableSharedMemory;
    private final DataGridCanvas tableSM;
    private final DataGridCanvas tableWarps;

    public KernelOccupancyDataControl(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GC gc = new GC((Drawable)this);
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        this.headerTable = this.setupTable(charWidth);
        this.headerTable.setHeader(true);
        this.tableSM = this.createDataTable(parent, "Occupancy Per SM", charWidth);
        this.tableWarps = this.createDataTable(parent, "Warps", charWidth);
        this.tableRegisters = this.createDataTable(parent, "Registers", charWidth);
        this.tableSharedMemory = this.createDataTable(parent, "Shared Memory", charWidth);
        this.layout();
    }

    private DataGridCanvas createDataTable(Composite parent, String label, int charWidth) {
        CLabel lblNewLabel = new CLabel((Composite)this, 0);
        lblNewLabel.setBackground(parent.getBackground());
        lblNewLabel.setText(label);
        return this.setupTable(charWidth);
    }

    public void fillData(TimelineIntervalKernel kernel, double achievedOccupancy, OccupancyCalculator calculator) {
        this.headerTable.setBackground(this.getDisplay().getSystemColor(5));
        this.headerTable.setForeground(this.getDisplay().getSystemColor(3));
        this.headerTable.clear();
        this.headerTable.addRow("Variable", "Achieved", "Theoretical", "Device Limit", KernelOccupancyDataGrid.kernelInfoString(kernel));
        KernelOccupancyDataGrid.fillSMTable(this.tableSM.getDataGrid(), kernel, achievedOccupancy, calculator);
        KernelOccupancyDataGrid.fillWarpsTable(this.tableWarps.getDataGrid(), kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.BLOCK);
        KernelOccupancyDataGrid.fillRegistersTable(this.tableRegisters.getDataGrid(), kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.REGISTER);
        KernelOccupancyDataGrid.fillSharedMemoryTable(this.tableSharedMemory.getDataGrid(), kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.SHARED_MEMORY);
        this.layout();
    }

    private DataGridCanvas setupTable(int charWidth) {
        DataGridCanvas table = new DataGridCanvas(this, 2048, new OccupancyDataTablePainter());
        table.setLayoutData(new GridData(768));
        table.addColumn(charWidth * 25, 16384);
        table.addColumn(charWidth * 15, 0x1000000);
        table.addColumn(charWidth * 15, 0x1000000);
        table.addColumn(charWidth * 15, 0x1000000);
        return table;
    }
}

