/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

final class RebaseInteractiveDropTargetListener
extends ViewerDropAdapter {
    private final RebaseInteractiveView rebaseInteractiveView;

    RebaseInteractiveDropTargetListener(RebaseInteractiveView rebaseInteractiveView, Viewer viewer) {
        super(viewer);
        this.rebaseInteractiveView = rebaseInteractiveView;
    }

    public boolean performDrop(Object data) {
        if (!this.rebaseInteractiveView.isDragAndDropEnabled()) {
            return false;
        }
        DropTargetEvent event = this.getCurrentEvent();
        RebaseInteractivePlan.PlanElement sourceElement = null;
        if (event.data instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)data;
            if (structuredSelection.size() > 1) {
                return false;
            }
            if (structuredSelection.getFirstElement() instanceof RebaseInteractivePlan.PlanElement) {
                sourceElement = (RebaseInteractivePlan.PlanElement)structuredSelection.getFirstElement();
            }
        }
        if (sourceElement == null) {
            return false;
        }
        Object targetObj = this.getCurrentTarget();
        if (!(targetObj instanceof RebaseInteractivePlan.PlanElement)) {
            return false;
        }
        RebaseInteractivePlan.PlanElement targetElement = (RebaseInteractivePlan.PlanElement)targetObj;
        boolean before = false;
        switch (this.getCurrentLocation()) {
            case 1: {
                before = true;
                break;
            }
            case 4: {
                return false;
            }
        }
        this.rebaseInteractiveView.getCurrentPlan().moveTodoEntry(sourceElement, targetElement, before);
        return true;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (!this.rebaseInteractiveView.isDragAndDropEnabled()) {
            return false;
        }
        if (this.getCurrentTarget() instanceof RebaseInteractivePlan.PlanElement) {
            switch (this.getCurrentLocation()) {
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
        }
        return false;
    }
}

