/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.ProfileRunner;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.run.TimelineRunner;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.Disposable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Analysis
extends ModelWithProperties
implements IModel,
ISessionSerializable,
Disposable {
    public static final String PROPERTY_GUIDED = "analysis:guided";
    public static final String PROPERTY_PCIE_GENERATION = "analysis:pciegen";
    public static final String PROPERTY_PCIE_LINKWIDTH = "analysis:pcielinkwidth";
    public static final String PROPERTY_PCIE_LINKRATE = "analysis:pcielinkrate";
    public static final String PROPERTY_SCOPE_INTERVAL = "analysis:scopeinterval";
    public static final String PROPERTY_SELECTED_STAGE = "analysis:sstage";
    public static final String PROPERTY_RESULT = "analysis:result";
    public static final String PROPERTY_SELECTED_RESULT = "analysis:sresult";
    public static final String PROPERTY_VISITED = "analysis:visited";
    private AnalysisViewMode currentAnalysisMode;
    private ITimelineInterval activeScopeInterval = null;
    private AnalysisStage selectedStage = AnalysisStage.NONE;
    private AnalysisStage prevSelectedStage = AnalysisStage.NONE;
    private Map<AnalysisScope, Map<Integer, Map<AnalysisStage, List<AnalysisResult>>>> visitedStages = new HashMap<AnalysisScope, Map<Integer, Map<AnalysisStage, List<AnalysisResult>>>>(AnalysisScope.values().length);
    private AnalysisResult selectedResult = null;
    private Map<Integer, Long> pcieGenerationMap = new HashMap<Integer, Long>();
    private Map<Integer, Long> pcieLinkWidthMap = new HashMap<Integer, Long>();
    private Map<Integer, Long> pcieLinkRateMap = new HashMap<Integer, Long>();

    public Analysis() {
    }

    public Analysis(Element el) throws ViperException {
        this();
        this.read(el);
    }

    public void dispose() {
        this.activeScopeInterval = null;
    }

    public boolean isGuidedMode() {
        return AnalysisViewMode.guided.equals((Object)this.currentAnalysisMode);
    }

    public void setCurrentAnalysisMode(AnalysisViewMode mode) {
        if (!mode.equals((Object)this.currentAnalysisMode)) {
            this.currentAnalysisMode = mode;
            this.firePropertyChange(PROPERTY_GUIDED);
        }
    }

    public AnalysisViewMode getCurrentAnalysisMode() {
        return this.currentAnalysisMode;
    }

    public Long getPCIeGeneration(int deviceId) {
        return this.pcieGenerationMap.get(deviceId);
    }

    public boolean setPCIeGeneration(int deviceId, Long gen) {
        Long current = this.pcieGenerationMap.get(deviceId);
        if (gen == null) {
            if (current != null) {
                this.pcieGenerationMap.remove(deviceId);
                this.firePropertyChange(PROPERTY_PCIE_GENERATION);
            }
        } else if (gen != current) {
            this.pcieGenerationMap.put(deviceId, gen);
            this.firePropertyChange(PROPERTY_PCIE_GENERATION);
        }
        return true;
    }

    public Long getPCIeLinkWidth(int deviceId) {
        return this.pcieLinkWidthMap.get(deviceId);
    }

    public boolean setPCIeLinkWidth(int deviceId, Long width) {
        Long current = this.pcieLinkWidthMap.get(deviceId);
        if (width == null) {
            if (current != null) {
                this.pcieLinkWidthMap.remove(deviceId);
                this.firePropertyChange(PROPERTY_PCIE_LINKWIDTH);
            }
        } else if (width != current) {
            this.pcieLinkWidthMap.put(deviceId, width);
            this.firePropertyChange(PROPERTY_PCIE_LINKWIDTH);
        }
        return true;
    }

    public Long getPCIeLinkRate(int deviceId) {
        return this.pcieLinkRateMap.get(deviceId);
    }

    public boolean setPCIeLinkRate(int deviceId, Long rate) {
        Long current = this.pcieLinkRateMap.get(deviceId);
        if (rate == null) {
            if (current != null) {
                this.pcieLinkRateMap.remove(deviceId);
                this.firePropertyChange(PROPERTY_PCIE_LINKRATE);
            }
        } else if (rate != current) {
            this.pcieLinkRateMap.put(deviceId, rate);
            this.firePropertyChange(PROPERTY_PCIE_LINKRATE);
        }
        return true;
    }

    public AnalysisScope[] getActiveScopes() {
        if (AnalysisScope.APPLICATION.isEnabled(this.activeScopeInterval)) {
            if (AnalysisScope.KERNEL_INSTANCE.isEnabled(this.activeScopeInterval)) {
                return new AnalysisScope[]{AnalysisScope.KERNEL_INSTANCE, AnalysisScope.APPLICATION};
            }
            return new AnalysisScope[]{AnalysisScope.APPLICATION};
        }
        return new AnalysisScope[0];
    }

    public ITimelineInterval getActiveScopeInterval() {
        return this.activeScopeInterval;
    }

    public void setActiveScopeInterval(ITimelineInterval interval) {
        if (this.activeScopeInterval != interval) {
            this.activeScopeInterval = interval;
            this.firePropertyChange(PROPERTY_SCOPE_INTERVAL);
            if (interval != null) {
                if (!AnalysisStage.NONE.equals((Object)this.getSelectedStage())) {
                    Set<AnalysisStage> vstages = this.getVisitedStages();
                    if (!vstages.contains((Object)this.getSelectedStage())) {
                        this.setSelectedStage(AnalysisStage.NONE);
                    }
                } else {
                    Set<AnalysisStage> vstages = this.getVisitedStages();
                    if (vstages.contains((Object)this.prevSelectedStage)) {
                        this.setSelectedStage(this.prevSelectedStage);
                    }
                }
            } else {
                Set<AnalysisStage> vstages = this.getVisitedStages();
                if (!vstages.contains((Object)this.getSelectedStage())) {
                    if (vstages.contains((Object)AnalysisStage.TIMELINE)) {
                        this.setSelectedStage(AnalysisStage.TIMELINE);
                    } else {
                        this.setSelectedStage(AnalysisStage.NONE);
                    }
                }
            }
        }
    }

    public AnalysisStage getSelectedStage() {
        return this.selectedStage;
    }

    public void setSelectedStage(AnalysisStage stage) {
        if (!this.selectedStage.equals((Object)stage)) {
            if (stage == AnalysisStage.NONE) {
                this.prevSelectedStage = this.selectedStage;
            }
            this.selectedStage = stage;
            this.firePropertyChange(PROPERTY_SELECTED_STAGE);
        }
    }

    private void discardAnalysisResult(AnalysisResult result) {
        if (result != null) {
            result.discard();
        }
    }

    private void discardAnalysisResults(Collection<AnalysisResult> results) {
        if (results != null) {
            for (AnalysisResult result : results) {
                this.discardAnalysisResult(result);
            }
        }
    }

    private void discardStageAnalysisResults(Map<AnalysisStage, List<AnalysisResult>> results) {
        if (results != null) {
            for (AnalysisStage stage : results.keySet()) {
                this.discardAnalysisResults((Collection<AnalysisResult>)results.get((Object)stage));
            }
        }
    }

    private void discardAllAnalysisResults(Map<AnalysisScope, Map<Integer, Map<AnalysisStage, List<AnalysisResult>>>> results) {
        if (results != null) {
            for (Map<Integer, Map<AnalysisStage, List<AnalysisResult>>> idm : results.values()) {
                for (Map<AnalysisStage, List<AnalysisResult>> sr : idm.values()) {
                    this.discardStageAnalysisResults(sr);
                }
            }
        }
    }

    private Map<AnalysisStage, List<AnalysisResult>> getVisitedStages(AnalysisScope scope, Integer id) {
        Map<Integer, Map<AnalysisStage, List<AnalysisResult>>> scopeStages;
        if (scope != null && id != null && (scopeStages = this.visitedStages.get((Object)scope)) != null) {
            return scopeStages.get(id);
        }
        return null;
    }

    private Map<AnalysisStage, List<AnalysisResult>> createVisitedStages(AnalysisScope scope, Integer id) {
        HashMap vs = null;
        if (scope != null && id != null) {
            Map<Integer, Map<AnalysisStage, List<AnalysisResult>>> scopeStages = this.visitedStages.get((Object)scope);
            if (scopeStages == null) {
                scopeStages = new HashMap<Integer, Map<AnalysisStage, List<AnalysisResult>>>();
                this.visitedStages.put(scope, scopeStages);
            }
            this.discardStageAnalysisResults(scopeStages.get(id));
            vs = new HashMap();
            scopeStages.put(id, vs);
        }
        return vs;
    }

    public Set<AnalysisStage> getVisitedStages() {
        HashSet<AnalysisStage> stages = new HashSet<AnalysisStage>();
        AnalysisScope[] analysisScopeArray = this.getActiveScopes();
        int n = analysisScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisScope scope = analysisScopeArray[n2];
            Integer id = scope.getAnalysisId(this.activeScopeInterval);
            Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id);
            if (vs != null) {
                stages.addAll(vs.keySet());
            }
            ++n2;
        }
        return Collections.unmodifiableSet(stages);
    }

    public void setVisitedStage(AnalysisStage stage, ITimelineInterval scopeInterval, boolean visited) {
        Integer id;
        AnalysisScope scope = stage.getScope(scopeInterval);
        Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id = scope.getAnalysisId(scopeInterval));
        if (vs == null && visited) {
            vs = this.createVisitedStages(scope, id);
        }
        if (vs != null) {
            if (visited) {
                if (!vs.keySet().contains((Object)stage)) {
                    vs.put(stage, null);
                    this.firePropertyChange(PROPERTY_VISITED);
                }
            } else if (vs.keySet().contains((Object)stage)) {
                this.discardAnalysisResults((Collection<AnalysisResult>)vs.get((Object)stage));
                vs.remove((Object)stage);
                this.firePropertyChange(PROPERTY_VISITED);
            }
        }
    }

    public void setVisitedStage(AnalysisStage stage, boolean visited) {
        this.setVisitedStage(stage, this.activeScopeInterval, visited);
    }

    public void setVisitedStages(AnalysisStage[] stages, boolean visited) {
        AnalysisStage[] analysisStageArray = stages;
        int n = stages.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisStage stage = analysisStageArray[n2];
            this.setVisitedStage(stage, visited);
            ++n2;
        }
    }

    public void clearAllVisitedStages() {
        if (!this.visitedStages.isEmpty()) {
            this.discardAllAnalysisResults(this.visitedStages);
            this.visitedStages.clear();
            this.firePropertyChange(PROPERTY_VISITED);
        }
    }

    public void clearVisitedStages(Integer analysisId) {
        if (!this.visitedStages.isEmpty() && analysisId != null && this.visitedStages.get((Object)AnalysisScope.KERNEL_INSTANCE) != null) {
            this.discardStageAnalysisResults(this.visitedStages.get((Object)AnalysisScope.KERNEL_INSTANCE).get(analysisId));
            this.visitedStages.get((Object)AnalysisScope.KERNEL_INSTANCE).remove(analysisId);
            this.firePropertyChange(PROPERTY_VISITED);
        }
    }

    public void clearVisitedStagesExceptTimeline() {
        if (this.visitedStages != null) {
            List<AnalysisResult> timelineResult = this.visitedStages.get((Object)AnalysisScope.APPLICATION).get(AnalysisScope.APPLICATION_ANALYSIS_ID).remove((Object)AnalysisStage.TIMELINE);
            this.clearAllVisitedStages();
            this.visitedStages.put(AnalysisScope.APPLICATION, new HashMap());
            this.visitedStages.get((Object)AnalysisScope.APPLICATION).put(AnalysisScope.APPLICATION_ANALYSIS_ID, new HashMap());
            this.visitedStages.get((Object)AnalysisScope.APPLICATION).get(AnalysisScope.APPLICATION_ANALYSIS_ID).put(AnalysisStage.TIMELINE, timelineResult);
            this.firePropertyChange(PROPERTY_VISITED);
        }
    }

    public AnalysisResult getSelectedResult() {
        return this.selectedResult;
    }

    public void setSelectedResult(AnalysisResult result) {
        if (this.selectedResult == null ? result != null : !this.selectedResult.equals(result)) {
            this.selectedResult = result;
            this.firePropertyChange(PROPERTY_SELECTED_RESULT);
        }
    }

    public List<AnalysisResult> getAnalysisResults(AnalysisStage stage) {
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>();
        if (stage.getScope(this.activeScopeInterval) != AnalysisScope.NONE) {
            List<AnalysisResult> r;
            Integer id = stage.getScope(this.activeScopeInterval).getAnalysisId(this.activeScopeInterval);
            Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(stage.getScope(this.activeScopeInterval), id);
            if (vs != null && (r = vs.get((Object)stage)) != null) {
                results.addAll(r);
            }
        }
        return results;
    }

    public List<AnalysisResult> getAnalysisResults(AnalysisStage stage, Class<? extends AnalysisResult> analysisClass) {
        AnalysisScope[] analysisScopeArray = this.getActiveScopes();
        int n = analysisScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<AnalysisResult> results;
            AnalysisScope scope = analysisScopeArray[n2];
            Integer id = scope.getAnalysisId(this.activeScopeInterval);
            Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id);
            if (vs != null && (results = vs.get((Object)stage)) != null) {
                ArrayList<AnalysisResult> kresults = new ArrayList<AnalysisResult>();
                for (AnalysisResult result : results) {
                    if (!result.getClass().equals(analysisClass)) continue;
                    kresults.add(result);
                }
                return kresults;
            }
            ++n2;
        }
        return new ArrayList<AnalysisResult>();
    }

    public void setAnalysisResults(AnalysisStage stage, List<AnalysisResult> results) {
        List<AnalysisResult> currentResults = this.getAnalysisResults(stage);
        if (!currentResults.equals(results)) {
            Integer id;
            AnalysisScope scope = stage.getScope(this.activeScopeInterval);
            Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id = scope.getAnalysisId(this.activeScopeInterval));
            if (vs == null) {
                vs = this.createVisitedStages(scope, id);
            }
            if (vs != null) {
                vs.put(stage, results);
                this.firePropertyChange(PROPERTY_RESULT);
            }
        }
    }

    public void clearAnalysisResults(AnalysisStage stage) {
        Integer id = stage.getScope(this.activeScopeInterval).getAnalysisId(this.activeScopeInterval);
        Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(stage.getScope(this.activeScopeInterval), id);
        if (vs != null) {
            this.discardAnalysisResults((Collection<AnalysisResult>)vs.get((Object)stage));
            vs.put(stage, null);
            this.firePropertyChange(PROPERTY_RESULT);
        }
    }

    public void clearAnalysisResults() {
        AnalysisScope[] analysisScopeArray = this.getActiveScopes();
        int n = analysisScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisScope scope = analysisScopeArray[n2];
            Integer id = scope.getAnalysisId(this.activeScopeInterval);
            Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id);
            if (vs != null) {
                for (AnalysisStage stage : vs.keySet()) {
                    this.discardAnalysisResults((Collection<AnalysisResult>)vs.get((Object)stage));
                    vs.put(stage, null);
                }
                this.firePropertyChange(PROPERTY_RESULT);
            }
            ++n2;
        }
    }

    public void resetForNewTimeline() {
        this.setActiveScopeInterval(null);
        this.setSelectedResult(null);
        this.setSelectedStage(AnalysisStage.NONE);
        this.clearAllVisitedStages();
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<analysis guided=\"" + (this.isGuidedMode() ? "true" : "false") + "\">");
            HashSet<Integer> deviceIds = new HashSet<Integer>(this.pcieGenerationMap.keySet());
            deviceIds.addAll(this.pcieLinkRateMap.keySet());
            deviceIds.addAll(this.pcieLinkWidthMap.keySet());
            if (!deviceIds.isEmpty()) {
                Iterator<Object> iterator = deviceIds.iterator();
                while (iterator.hasNext()) {
                    Long rate;
                    Long width;
                    int id = (Integer)iterator.next();
                    w.write("<pcie device=\"" + id + "\"");
                    Long gen = this.pcieGenerationMap.get(id);
                    if (gen != null) {
                        w.write(" gen=\"" + gen + "\"");
                    }
                    if ((width = this.pcieLinkWidthMap.get(id)) != null) {
                        w.write(" width=\"" + width + "\"");
                    }
                    if ((rate = this.pcieLinkRateMap.get(id)) != null) {
                        w.write(" rate=\"" + rate + "\"");
                    }
                    w.write("/>");
                }
            }
            for (AnalysisScope as : this.visitedStages.keySet()) {
                Map<Integer, Map<AnalysisStage, List<AnalysisResult>>> scopeStages = this.visitedStages.get((Object)as);
                for (Integer id : scopeStages.keySet()) {
                    Map<AnalysisStage, List<AnalysisResult>> vs;
                    if (id == null || (vs = scopeStages.get(id)) == null || vs.isEmpty()) continue;
                    w.write("<visitedstages");
                    if (!AnalysisScope.APPLICATION.equals((Object)as)) {
                        w.write(" scope=\"" + (Object)((Object)as) + "\" id=\"" + id + "\"");
                    }
                    w.write(">");
                    for (AnalysisStage stage : vs.keySet()) {
                        if (stage.equals((Object)AnalysisStage.DEPENDENCY_ANALYSIS)) continue;
                        w.write("<stage name=\"" + stage.name() + "\"/>");
                    }
                    w.write("</visitedstages>");
                }
            }
            w.write("</analysis>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"analysis".equals(el.getTagName())) {
            throw new ViperException("expected \"analysis\" tag, got " + el.getTagName());
        }
        String guidedStr = StringUtils.emptyToNull(el.getAttribute("guided"));
        this.currentAnalysisMode = guidedStr == null || !"false".equals(guidedStr) ? AnalysisViewMode.guided : AnalysisViewMode.unguided;
        NodeList pcieList = el.getElementsByTagName("pcie");
        int p = 0;
        while (p < pcieList.getLength()) {
            Element psElement = (Element)pcieList.item(p);
            if (!"pcie".equals(psElement.getTagName())) {
                throw new ViperException("expected \"pcie\" tag, got " + psElement.getTagName());
            }
            String idStr = StringUtils.emptyToNull(psElement.getAttribute("device"));
            if (idStr != null) {
                try {
                    String rateStr;
                    Long rate;
                    String widthStr;
                    Long width;
                    Long gen;
                    int id = Integer.parseInt(idStr);
                    String genStr = StringUtils.emptyToNull(psElement.getAttribute("gen"));
                    Long l = gen = genStr == null ? null : Long.valueOf(Long.parseLong(genStr));
                    if (gen != null) {
                        this.pcieGenerationMap.put(id, gen);
                    }
                    Long l2 = width = (widthStr = StringUtils.emptyToNull(psElement.getAttribute("width"))) == null ? null : Long.valueOf(Long.parseLong(widthStr));
                    if (width != null) {
                        this.pcieLinkWidthMap.put(id, width);
                    }
                    Long l3 = rate = (rateStr = StringUtils.emptyToNull(psElement.getAttribute("rate"))) == null ? null : Long.valueOf(Long.parseLong(rateStr));
                    if (rate != null) {
                        this.pcieLinkRateMap.put(id, rate);
                    }
                }
                catch (IllegalArgumentException e) {
                    ViperExceptionHandler.logError("unknown pcie attribute", e);
                }
            }
            ++p;
        }
        NodeList vsList = el.getElementsByTagName("visitedstages");
        int v = 0;
        while (v < vsList.getLength()) {
            Element vsElement = (Element)vsList.item(v);
            if (!"visitedstages".equals(vsElement.getTagName())) {
                throw new ViperException("expected \"visitedstages\" tag, got " + vsElement.getTagName());
            }
            AnalysisScope scope = AnalysisScope.APPLICATION;
            Integer id = AnalysisScope.APPLICATION_ANALYSIS_ID;
            String scopeStr = StringUtils.emptyToNull(vsElement.getAttribute("scope"));
            String idStr = StringUtils.emptyToNull(vsElement.getAttribute("id"));
            if (scopeStr != null && idStr != null) {
                try {
                    scope = AnalysisScope.valueOf(scopeStr);
                    id = Integer.parseInt(idStr);
                }
                catch (IllegalArgumentException e) {
                    scope = AnalysisScope.NONE;
                    ViperExceptionHandler.logError("unknown visited scope or id", e);
                }
            }
            if (!AnalysisScope.NONE.equals((Object)scope)) {
                Map<AnalysisStage, List<AnalysisResult>> vs = this.getVisitedStages(scope, id);
                if (vs == null) {
                    vs = this.createVisitedStages(scope, id);
                }
                if (vs == null) {
                    ViperExceptionHandler.logError("failed to create visited stages");
                } else {
                    NodeList stageList = vsElement.getElementsByTagName("stage");
                    int d = 0;
                    while (d < stageList.getLength()) {
                        Element stageElement = (Element)stageList.item(d);
                        if (!"stage".equals(stageElement.getTagName())) {
                            throw new ViperException("expected \"stage\" tag, got " + stageElement.getTagName());
                        }
                        String stageStr = StringUtils.emptyToNull(stageElement.getAttribute("name"));
                        if (stageStr != null) {
                            try {
                                if ("MULTIPROCESSOR".equals(stageStr)) {
                                    stageStr = AnalysisStage.KERNELS.name();
                                } else if ("KERNEL_INSTRUCTION".equals(stageStr) || "KERNEL_MEMORY".equals(stageStr)) {
                                    stageStr = AnalysisStage.KERNELS_PERFORMANCE.name();
                                }
                                AnalysisStage stage = AnalysisStage.valueOf(stageStr);
                                vs.put(stage, null);
                            }
                            catch (IllegalArgumentException e) {
                                ViperExceptionHandler.logError("unknown analysis stage", e);
                            }
                        }
                        ++d;
                    }
                }
            }
            ++v;
        }
    }

    private boolean isDependencyAnalysis(Collection<AnalysisStage> stages) {
        AnalysisStage stage;
        return stages.size() == 1 && (stage = stages.iterator().next()).equals((Object)AnalysisStage.DEPENDENCY_ANALYSIS);
    }

    public Runner collectData(IDevicesData deviceData, Session session, Collection<AnalysisStage> stages) throws ViperException {
        if (stages.size() == 0) {
            return null;
        }
        if (!this.isDependencyAnalysis(stages)) {
            this.checkExecutable(session);
        }
        AnalysisStage timelineStage = this.findTimelineStage(stages);
        if (stages.size() == 1 && timelineStage != null) {
            return new TimelineRunner(session);
        }
        if (stages.size() >= 2 && timelineStage != null) {
            session.setTimelines(null);
        }
        Expert expert = new Expert();
        boolean needCollection = false;
        for (AnalysisStage stage : stages) {
            needCollection |= stage.updateExpert(deviceData, session, expert);
        }
        if (needCollection) {
            try {
                return new ProfileRunner(session, expert, FileSystem.getFilesystem(session).getDeviceData(true), ViperMessages.Analysis_Progress_Message, false, false);
            }
            catch (DeviceListNotReadyException deviceListNotReadyException) {
                return null;
            }
        }
        return null;
    }

    private void checkExecutable(Session session) throws ViperException {
        Executable exec = session.getExecutable();
        if (exec == null) {
            throw new ViperException(ViperMessages.NonRunnable_Exec_Message);
        }
        FileSystem fs = FileSystem.getFilesystem(exec.getConnectionName());
        if (!fs.isCustomScript() && !exec.isProfileAllProcesses()) {
            if (exec.getFilename() == null) {
                throw new ViperException(ViperMessages.NoRunnable_Exec_Message);
            }
            if (!exec.isRunnable()) {
                throw new ViperException(ViperMessages.MissingRunnable_Exec_Message);
            }
        }
    }

    private AnalysisStage findTimelineStage(Collection<AnalysisStage> stages) {
        for (AnalysisStage stage : stages) {
            if (!AnalysisStage.TIMELINE.equals((Object)stage)) continue;
            return stage;
        }
        return null;
    }

    public AnalysisStage[] getOrderedStages() {
        LinkedHashSet<AnalysisStage> allStages = new LinkedHashSet<AnalysisStage>();
        AnalysisScope[] analysisScopeArray = this.getActiveScopes();
        int n = analysisScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisScope scope = analysisScopeArray[n2];
            allStages.addAll(Arrays.asList(scope.getOrderedStages(this.activeScopeInterval)));
            ++n2;
        }
        return allStages.toArray(new AnalysisStage[allStages.size()]);
    }

    public boolean isActive(AnalysisScope scope) {
        return scope.isEnabled(this.activeScopeInterval);
    }
}

