/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNS2IPACCESS_H_
#define OPENDRIM_DNS2IPACCESS_H_

#include "DNS_Common.h"

#include "OpenDRIM_DNS2IP.h"
#include "assocOpenDRIM_DNS2IP.h"

int DNS_OpenDRIM_DNS2IP_load(const CMPIBroker* broker, string& errorMessage);

int DNS_OpenDRIM_DNS2IP_unload(string& errorMessage);

int DNS_OpenDRIM_DNS2IP_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNS2IP>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNS2IP_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNS2IP& instance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNS2IP_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNS2IP& newInstance, const OpenDRIM_DNS2IP& oldInstance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNS2IP_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNS2IP& instance, string& errorMessage);

int DNS_OpenDRIM_DNS2IP_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNS2IP& instance, string& errorMessage);

int DNS_OpenDRIM_DNS2IP_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNS2IP_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNS2IP_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_DNS2IP>& OpenDRIM_DNS2IP_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNS2IP_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_DNS2IP>& OpenDRIM_DNS2IP_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNS2IP_populate(OpenDRIM_DNS2IP& instance, string& errorMessage);

#endif /*OPENDRIM_DNS2IPACCESS_H_*/
