/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMOPERATINGSYSTEMCURRENTRUNLEVEL_H_
#define OPENDRIM_OPERATINGSYSTEMOPERATINGSYSTEMCURRENTRUNLEVEL_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiOpenDRIM_OperatingSystemCurrentRunLevel.h"
#include "OpenDRIM_OperatingSystemCurrentRunLevelAccess.h"
#include "cmpiOpenDRIM_OperatingSystem.h"
#include "OpenDRIM_OperatingSystemAccess.h"
*/

const static char* OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel_classnames[] = {"OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel"};
static string OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel_NAMESPACE = _NAMESPACE;
const static string SettingData_role = "SettingData";
const static char* SettingData_classnames[] = {"OpenDRIM_OperatingSystemCurrentRunLevel"};
const static string SettingData_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_OperatingSystem"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel {

public:
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	Objectpath SettingData;
	bool SettingData_isNULL;
	
	unsigned short IsDefault;
	bool IsDefault_isNULL;
	
	unsigned short IsCurrent;
	bool IsCurrent_isNULL;
	
	unsigned short IsNext;
	bool IsNext_isNULL;
	
	unsigned short IsMinimum;
	bool IsMinimum_isNULL;
	
	unsigned short IsMaximum;
	bool IsMaximum_isNULL;
	
	unsigned short IsPending;
	bool IsPending_isNULL;
	
	OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel() {
		ManagedElement_isNULL = true;
		SettingData_isNULL = true;
		IsDefault_isNULL = true;
		IsCurrent_isNULL = true;
		IsNext_isNULL = true;
		IsMinimum_isNULL = true;
		IsMaximum_isNULL = true;
		IsPending_isNULL = true;
	}
	
	~OpenDRIM_OperatingSystemOperatingSystemCurrentRunLevel() {}
	
	string getKeys() const {
		return CF_toLowCase(".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\""".SettingData=\"" + CF_quoteString(SettingData.toString()) + "\"");
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

	int getSettingData(Objectpath& value) const {
		if (SettingData_isNULL==true)
			return NOT_FOUND;
		value = SettingData;
		return OK;
	}
	
	int setSettingData(const Objectpath& newValue) {
		SettingData = newValue;
		SettingData.setNamespace(SettingData_NAMESPACE);
		SettingData_isNULL = false;
		return OK;
	}

	int getIsDefault(unsigned short& value) const {
		if (IsDefault_isNULL==true)
			return NOT_FOUND;
		value = IsDefault;
		return OK;
	}
	
	int setIsDefault(const unsigned short& newValue) {
		IsDefault = newValue;
		IsDefault_isNULL = false;
		return OK;
	}

	int getIsCurrent(unsigned short& value) const {
		if (IsCurrent_isNULL==true)
			return NOT_FOUND;
		value = IsCurrent;
		return OK;
	}
	
	int setIsCurrent(const unsigned short& newValue) {
		IsCurrent = newValue;
		IsCurrent_isNULL = false;
		return OK;
	}

	int getIsNext(unsigned short& value) const {
		if (IsNext_isNULL==true)
			return NOT_FOUND;
		value = IsNext;
		return OK;
	}
	
	int setIsNext(const unsigned short& newValue) {
		IsNext = newValue;
		IsNext_isNULL = false;
		return OK;
	}

	int getIsMinimum(unsigned short& value) const {
		if (IsMinimum_isNULL==true)
			return NOT_FOUND;
		value = IsMinimum;
		return OK;
	}
	
	int setIsMinimum(const unsigned short& newValue) {
		IsMinimum = newValue;
		IsMinimum_isNULL = false;
		return OK;
	}

	int getIsMaximum(unsigned short& value) const {
		if (IsMaximum_isNULL==true)
			return NOT_FOUND;
		value = IsMaximum;
		return OK;
	}
	
	int setIsMaximum(const unsigned short& newValue) {
		IsMaximum = newValue;
		IsMaximum_isNULL = false;
		return OK;
	}

	int getIsPending(unsigned short& value) const {
		if (IsPending_isNULL==true)
			return NOT_FOUND;
		value = IsPending;
		return OK;
	}
	
	int setIsPending(const unsigned short& newValue) {
		IsPending = newValue;
		IsPending_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_OPERATINGSYSTEMOPERATINGSYSTEMCURRENTRUNLEVEL_H_*/
