# компиляция на Linux

## Необходимые инструменты

Для компиляции RHVoice в вашей системе должны быть установлены
следующие программы:

* [GCC](https://gcc.gnu.org)
* [Pkg-config](http://www.freedesktop.org/wiki/Software/pkg-config/)
* [SCons](http://www.scons.org)

## Дополнительные зависимости

Перед началом компиляции RHVoice убедитесь, что на вашей машине
установлен по крайней мере один из следующих компонентов,
обеспечивающих вывод звука:

* [PulseAudio](http://www.freedesktop.org/wiki/Software/PulseAudio/)
* [Libao](https://www.xiph.org/ao/)
* [PortAudio](http://www.portaudio.com) V19

Обратите внимание, что многие дистрибутивы выделяют в отдельные пакеты
те файлы, которые необходимы только при компиляции, а не при
выполнении, программ, использующих ту или иную библиотеку. В вашей
системе должны быть установлены пакеты обоих типов.

## Компиляция

Для запуска компиляции выполните команду:

```bash
scons
```

Вы можете изменить параметры сборки, например, передать дополнительные
опции компилятору. Для получения более подробной информации
воспользуйтесь командой:

```bash
scons -h
```

## Установка

Для установки RHVoice выполните следующие команды:

```bash
# scons install
```

Теперь вы можете проверить работоспособность синтезатора:

```bash
echo test|RHVoice-test
```

## Подключение к Speech Dispatcher

Чтобы Speech Dispatcher обнаружил модуль, реализующий поддержку
RHVoice, вы можете создать ссылку на него в директории, куда
установлены встроенные модули, обеспечивающие взаимодействие с
речевыми синтезаторами. Любые дополнительные модули, найденные в этой
директории, будут загружаться и использоваться наравне со встроенными.
Пример команды:

```bash
# ln -s /usr/local/bin/sd_rhvoice /usr/lib/speech-dispatcher-modules
```
