/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

/**
 * Tests {@link org.apache.logging.log4j.core.lookup.MainMapLookup#MAIN_SINGLETON} from the command line, not a real JUnit
 * test.
 * 
 * From an IDE or CLI: --file foo.txt
 * 
 * @since 2.4
 */
public class MainInputArgumentsLookupTest {

    public static void main(final String[] args) {
        MainMapLookup.setMainArguments(args);
        final LoggerContext ctx = Configurator.initialize(MainInputArgumentsLookupTest.class.getName(),
                "target/test-classes/log4j-lookup-main.xml");
        try {
            LogManager.getLogger().error("this is an error message");
        } finally {
            Configurator.shutdown(ctx);
        }
    }

}
