//Copyright 2013 GoGraphviz Authors
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

package parser

import "github.com/awalterschulze/gographviz/ast"

var ProductionsTable = ProdTab{
	/* [0]  */
	ProdTabEntry{
		"S! : DotGraph ;",
		"S!",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [1]  */
	ProdTabEntry{
		"DotGraph : Graph { } << ast.NewGraph(ast.GRAPH, ast.FALSE, nil, nil) >> ;",
		"DotGraph",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.FALSE, nil, nil)
		},
	},
	/* [2]  */
	ProdTabEntry{
		"DotGraph : Strict Graph { } << ast.NewGraph(ast.GRAPH, ast.TRUE, nil, nil) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.TRUE, nil, nil)
		},
	},
	/* [3]  */
	ProdTabEntry{
		"DotGraph : Graph Id { } << ast.NewGraph(ast.GRAPH, ast.FALSE, X[1], nil) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.FALSE, X[1], nil)
		},
	},
	/* [4]  */
	ProdTabEntry{
		"DotGraph : Strict Graph Id { } << ast.NewGraph(ast.GRAPH, ast.TRUE, X[2], nil) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.TRUE, X[2], nil)
		},
	},
	/* [5]  */
	ProdTabEntry{
		"DotGraph : Graph { StmtList } << ast.NewGraph(ast.GRAPH, ast.FALSE, nil, X[2]) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.FALSE, nil, X[2])
		},
	},
	/* [6]  */
	ProdTabEntry{
		"DotGraph : Graph Id { StmtList } << ast.NewGraph(ast.GRAPH, ast.FALSE, X[1], X[3]) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.FALSE, X[1], X[3])
		},
	},
	/* [7]  */
	ProdTabEntry{
		"DotGraph : Strict Graph { StmtList } << ast.NewGraph(ast.GRAPH, ast.TRUE, nil, X[3]) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.TRUE, nil, X[3])
		},
	},
	/* [8]  */
	ProdTabEntry{
		"DotGraph : Strict Graph Id { StmtList } << ast.NewGraph(ast.GRAPH, ast.TRUE, X[2], X[4]) >> ;",
		"DotGraph",
		6,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.GRAPH, ast.TRUE, X[2], X[4])
		},
	},
	/* [9]  */
	ProdTabEntry{
		"DotGraph : Digraph { } << ast.NewGraph(ast.DIGRAPH, ast.FALSE, nil, nil) >> ;",
		"DotGraph",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.FALSE, nil, nil)
		},
	},
	/* [10]  */
	ProdTabEntry{
		"DotGraph : Strict Digraph { } << ast.NewGraph(ast.DIGRAPH, ast.TRUE, nil, nil) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.TRUE, nil, nil)
		},
	},
	/* [11]  */
	ProdTabEntry{
		"DotGraph : Digraph Id { } << ast.NewGraph(ast.DIGRAPH, ast.FALSE, X[1], nil) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.FALSE, X[1], nil)
		},
	},
	/* [12]  */
	ProdTabEntry{
		"DotGraph : Strict Digraph Id { } << ast.NewGraph(ast.DIGRAPH, ast.TRUE, X[2], nil) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.TRUE, X[2], nil)
		},
	},
	/* [13]  */
	ProdTabEntry{
		"DotGraph : Digraph { StmtList } << ast.NewGraph(ast.DIGRAPH, ast.FALSE, nil, X[2]) >> ;",
		"DotGraph",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.FALSE, nil, X[2])
		},
	},
	/* [14]  */
	ProdTabEntry{
		"DotGraph : Digraph Id { StmtList } << ast.NewGraph(ast.DIGRAPH, ast.FALSE, X[1], X[3]) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.FALSE, X[1], X[3])
		},
	},
	/* [15]  */
	ProdTabEntry{
		"DotGraph : Strict Digraph { StmtList } << ast.NewGraph(ast.DIGRAPH, ast.TRUE, nil, X[3]) >> ;",
		"DotGraph",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.TRUE, nil, X[3])
		},
	},
	/* [16]  */
	ProdTabEntry{
		"DotGraph : Strict Digraph Id { StmtList } << ast.NewGraph(ast.DIGRAPH, ast.TRUE, X[2], X[4]) >> ;",
		"DotGraph",
		6,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraph(ast.DIGRAPH, ast.TRUE, X[2], X[4])
		},
	},
	/* [17]  */
	ProdTabEntry{
		"StmtList : Stmt1 << ast.NewStmtList(X[0]) >> ;",
		"StmtList",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewStmtList(X[0])
		},
	},
	/* [18]  */
	ProdTabEntry{
		"StmtList : StmtList Stmt1 << ast.AppendStmtList(X[0], X[1]) >> ;",
		"StmtList",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendStmtList(X[0], X[1])
		},
	},
	/* [19]  */
	ProdTabEntry{
		"Stmt1 : Stmt << X[0], nil >> ;",
		"Stmt1",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [20]  */
	ProdTabEntry{
		"Stmt1 : Stmt ; << X[0], nil >> ;",
		"Stmt1",
		2,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [21]  */
	ProdTabEntry{
		"Stmt : Id = Id << ast.NewAttr(X[0], X[2]) >> ;",
		"Stmt",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAttr(X[0], X[2])
		},
	},
	/* [22]  */
	ProdTabEntry{
		"Stmt : NodeStmt << X[0], nil >> ;",
		"Stmt",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [23]  */
	ProdTabEntry{
		"Stmt : EdgeStmt << X[0], nil >> ;",
		"Stmt",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [24]  */
	ProdTabEntry{
		"Stmt : AttrStmt << X[0], nil >> ;",
		"Stmt",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [25]  */
	ProdTabEntry{
		"Stmt : SubGraphStmt << X[0], nil >> ;",
		"Stmt",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [26]  */
	ProdTabEntry{
		"AttrStmt : Graph AttrList << ast.NewGraphAttrs(X[1]) >> ;",
		"AttrStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewGraphAttrs(X[1])
		},
	},
	/* [27]  */
	ProdTabEntry{
		"AttrStmt : Node AttrList << ast.NewNodeAttrs(X[1]) >> ;",
		"AttrStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewNodeAttrs(X[1])
		},
	},
	/* [28]  */
	ProdTabEntry{
		"AttrStmt : Edge AttrList << ast.NewEdgeAttrs(X[1]) >> ;",
		"AttrStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeAttrs(X[1])
		},
	},
	/* [29]  */
	ProdTabEntry{
		"AttrList : [ ] << ast.NewAttrList(nil) >> ;",
		"AttrList",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAttrList(nil)
		},
	},
	/* [30]  */
	ProdTabEntry{
		"AttrList : [ AList ] << ast.NewAttrList(X[1]) >> ;",
		"AttrList",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAttrList(X[1])
		},
	},
	/* [31]  */
	ProdTabEntry{
		"AttrList : AttrList [ ] << ast.AppendAttrList(X[0], nil) >> ;",
		"AttrList",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendAttrList(X[0], nil)
		},
	},
	/* [32]  */
	ProdTabEntry{
		"AttrList : AttrList [ AList ] << ast.AppendAttrList(X[0], X[2]) >> ;",
		"AttrList",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendAttrList(X[0], X[2])
		},
	},
	/* [33]  */
	ProdTabEntry{
		"AList : Attr << ast.NewAList(X[0]) >> ;",
		"AList",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAList(X[0])
		},
	},
	/* [34]  */
	ProdTabEntry{
		"AList : AList Attr << ast.AppendAList(X[0], X[1]) >> ;",
		"AList",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendAList(X[0], X[1])
		},
	},
	/* [35]  */
	ProdTabEntry{
		"AList : AList , Attr << ast.AppendAList(X[0], X[2]) >> ;",
		"AList",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendAList(X[0], X[2])
		},
	},
	/* [36]  */
	ProdTabEntry{
		"Attr : Id << ast.NewAttr(X[0], nil) >> ;",
		"Attr",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAttr(X[0], nil)
		},
	},
	/* [37]  */
	ProdTabEntry{
		"Attr : Id = Id << ast.NewAttr(X[0], X[2]) >> ;",
		"Attr",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewAttr(X[0], X[2])
		},
	},
	/* [38]  */
	ProdTabEntry{
		"EdgeStmt : NodeId EdgeRHS << ast.NewEdgeStmt(X[0], X[1], nil) >> ;",
		"EdgeStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeStmt(X[0], X[1], nil)
		},
	},
	/* [39]  */
	ProdTabEntry{
		"EdgeStmt : NodeId EdgeRHS AttrList << ast.NewEdgeStmt(X[0], X[1], X[2]) >> ;",
		"EdgeStmt",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeStmt(X[0], X[1], X[2])
		},
	},
	/* [40]  */
	ProdTabEntry{
		"EdgeStmt : SubGraphStmt EdgeRHS << ast.NewEdgeStmt(X[0], X[1], nil) >> ;",
		"EdgeStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeStmt(X[0], X[1], nil)
		},
	},
	/* [41]  */
	ProdTabEntry{
		"EdgeStmt : SubGraphStmt EdgeRHS AttrList << ast.NewEdgeStmt(X[0], X[1], X[2]) >> ;",
		"EdgeStmt",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeStmt(X[0], X[1], X[2])
		},
	},
	/* [42]  */
	ProdTabEntry{
		"EdgeRHS : EdgeOp NodeId << ast.NewEdgeRHS(X[0], X[1]) >> ;",
		"EdgeRHS",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeRHS(X[0], X[1])
		},
	},
	/* [43]  */
	ProdTabEntry{
		"EdgeRHS : EdgeOp SubGraphStmt << ast.NewEdgeRHS(X[0], X[1]) >> ;",
		"EdgeRHS",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewEdgeRHS(X[0], X[1])
		},
	},
	/* [44]  */
	ProdTabEntry{
		"EdgeRHS : EdgeRHS EdgeOp NodeId << ast.AppendEdgeRHS(X[0], X[1], X[2]) >> ;",
		"EdgeRHS",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendEdgeRHS(X[0], X[1], X[2])
		},
	},
	/* [45]  */
	ProdTabEntry{
		"EdgeRHS : EdgeRHS EdgeOp SubGraphStmt << ast.AppendEdgeRHS(X[0], X[1], X[2]) >> ;",
		"EdgeRHS",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.AppendEdgeRHS(X[0], X[1], X[2])
		},
	},
	/* [46]  */
	ProdTabEntry{
		"NodeStmt : NodeId << ast.NewNodeStmt(X[0], nil) >> ;",
		"NodeStmt",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewNodeStmt(X[0], nil)
		},
	},
	/* [47]  */
	ProdTabEntry{
		"NodeStmt : NodeId AttrList << ast.NewNodeStmt(X[0], X[1]) >> ;",
		"NodeStmt",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewNodeStmt(X[0], X[1])
		},
	},
	/* [48]  */
	ProdTabEntry{
		"NodeId : Id << ast.NewNodeId(X[0], nil) >> ;",
		"NodeId",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewNodeId(X[0], nil)
		},
	},
	/* [49]  */
	ProdTabEntry{
		"NodeId : Id Port << ast.NewNodeId(X[0], X[1]) >> ;",
		"NodeId",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewNodeId(X[0], X[1])
		},
	},
	/* [50]  */
	ProdTabEntry{
		"Port : : Id << ast.NewPort(X[1], nil) >> ;",
		"Port",
		2,
		func(X []Attrib) (Attrib, error) {
			return ast.NewPort(X[1], nil)
		},
	},
	/* [51]  */
	ProdTabEntry{
		"Port : : Id : Id << ast.NewPort(X[1], X[3]) >> ;",
		"Port",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewPort(X[1], X[3])
		},
	},
	/* [52]  */
	ProdTabEntry{
		"SubGraphStmt : { StmtList } << ast.NewSubGraph(nil, X[1]) >> ;",
		"SubGraphStmt",
		3,
		func(X []Attrib) (Attrib, error) {
			return ast.NewSubGraph(nil, X[1])
		},
	},
	/* [53]  */
	ProdTabEntry{
		"SubGraphStmt : Subgraph { StmtList } << ast.NewSubGraph(nil, X[2]) >> ;",
		"SubGraphStmt",
		4,
		func(X []Attrib) (Attrib, error) {
			return ast.NewSubGraph(nil, X[2])
		},
	},
	/* [54]  */
	ProdTabEntry{
		"SubGraphStmt : Subgraph Id { StmtList } << ast.NewSubGraph(X[1], X[3]) >> ;",
		"SubGraphStmt",
		5,
		func(X []Attrib) (Attrib, error) {
			return ast.NewSubGraph(X[1], X[3])
		},
	},
	/* [55]  */
	ProdTabEntry{
		"EdgeOp : -> << ast.DIRECTED, nil >> ;",
		"EdgeOp",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.DIRECTED, nil
		},
	},
	/* [56]  */
	ProdTabEntry{
		"EdgeOp : -- << ast.UNDIRECTED, nil >> ;",
		"EdgeOp",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.UNDIRECTED, nil
		},
	},
	/* [57]  */
	ProdTabEntry{
		"Graph : graph << X[0], nil >> ;",
		"Graph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [58]  */
	ProdTabEntry{
		"Graph : Graph << X[0], nil >> ;",
		"Graph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [59]  */
	ProdTabEntry{
		"Graph : GRAPH << X[0], nil >> ;",
		"Graph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [60]  */
	ProdTabEntry{
		"Strict : strict << X[0], nil >> ;",
		"Strict",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [61]  */
	ProdTabEntry{
		"Strict : Strict << X[0], nil >> ;",
		"Strict",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [62]  */
	ProdTabEntry{
		"Strict : STRICT << X[0], nil >> ;",
		"Strict",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [63]  */
	ProdTabEntry{
		"Digraph : digraph << X[0], nil >> ;",
		"Digraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [64]  */
	ProdTabEntry{
		"Digraph : Digraph << X[0], nil >> ;",
		"Digraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [65]  */
	ProdTabEntry{
		"Digraph : DiGraph << X[0], nil >> ;",
		"Digraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [66]  */
	ProdTabEntry{
		"Digraph : DIGRAPH << X[0], nil >> ;",
		"Digraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [67]  */
	ProdTabEntry{
		"Node : node << X[0], nil >> ;",
		"Node",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [68]  */
	ProdTabEntry{
		"Node : Node << X[0], nil >> ;",
		"Node",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [69]  */
	ProdTabEntry{
		"Node : NODE << X[0], nil >> ;",
		"Node",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [70]  */
	ProdTabEntry{
		"Edge : edge << X[0], nil >> ;",
		"Edge",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [71]  */
	ProdTabEntry{
		"Edge : Edge << X[0], nil >> ;",
		"Edge",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [72]  */
	ProdTabEntry{
		"Edge : EDGE << X[0], nil >> ;",
		"Edge",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [73]  */
	ProdTabEntry{
		"Subgraph : subgraph << X[0], nil >> ;",
		"Subgraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [74]  */
	ProdTabEntry{
		"Subgraph : Subgraph << X[0], nil >> ;",
		"Subgraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [75]  */
	ProdTabEntry{
		"Subgraph : SubGraph << X[0], nil >> ;",
		"Subgraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [76]  */
	ProdTabEntry{
		"Subgraph : SUBGRAPH << X[0], nil >> ;",
		"Subgraph",
		1,
		func(X []Attrib) (Attrib, error) {
			return X[0], nil
		},
	},
	/* [77]  */
	ProdTabEntry{
		"Id : id << ast.NewId(X[0]) >> ;",
		"Id",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewId(X[0])
		},
	},
	/* [78]  */
	ProdTabEntry{
		"Id : string_lit << ast.NewId(X[0]) >> ;",
		"Id",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewId(X[0])
		},
	},
	/* [79]  */
	ProdTabEntry{
		"Id : int_lit << ast.NewId(X[0]) >> ;",
		"Id",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewId(X[0])
		},
	},
	/* [80]  */
	ProdTabEntry{
		"Id : float_lit << ast.NewId(X[0]) >> ;",
		"Id",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewId(X[0])
		},
	},
	/* [81]  */
	ProdTabEntry{
		"Id : html_lit << ast.NewId(X[0]) >> ;",
		"Id",
		1,
		func(X []Attrib) (Attrib, error) {
			return ast.NewId(X[0])
		},
	},
}

var ActionTable ActionTab = ActionTab{
	/* state 0*/ ActionRow{
		/* GRAPH */ 15: Shift(7),
		/* digraph */ 19: Shift(11),
		/* strict */ 16: Shift(8),
		/* Digraph */ 20: Shift(12),
		/* graph */ 13: Shift(5),
		/* Strict */ 17: Shift(9),
		/* DiGraph */ 21: Shift(13),
		/* Graph */ 14: Shift(6),
		/* STRICT */ 18: Shift(10),
		/* DIGRAPH */ 22: Shift(14),
	},
	/* state 1*/ ActionRow{
		/* $ */ 0: Accept(0),
	},
	/* state 2*/ ActionRow{
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(15),
		/* html_lit */ 36: Shift(21),
		/* string_lit */ 33: Shift(18),
		/* int_lit */ 34: Shift(19),
	},
	/* state 3*/ ActionRow{
		/* graph */ 13: Shift(5),
		/* DiGraph */ 21: Shift(13),
		/* Graph */ 14: Shift(6),
		/* DIGRAPH */ 22: Shift(14),
		/* GRAPH */ 15: Shift(7),
		/* digraph */ 19: Shift(11),
		/* Digraph */ 20: Shift(12),
	},
	/* state 4*/ ActionRow{
		/* string_lit */ 33: Shift(18),
		/* int_lit */ 34: Shift(19),
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(24),
		/* html_lit */ 36: Shift(21),
	},
	/* state 5*/ ActionRow{
		/* id */ 2: Reduce(57),
		/* float_lit */ 35: Reduce(57),
		/* { */ 3: Reduce(57),
		/* html_lit */ 36: Reduce(57),
		/* string_lit */ 33: Reduce(57),
		/* int_lit */ 34: Reduce(57),
	},
	/* state 6*/ ActionRow{
		/* int_lit */ 34: Reduce(58),
		/* id */ 2: Reduce(58),
		/* float_lit */ 35: Reduce(58),
		/* { */ 3: Reduce(58),
		/* html_lit */ 36: Reduce(58),
		/* string_lit */ 33: Reduce(58),
	},
	/* state 7*/ ActionRow{
		/* id */ 2: Reduce(59),
		/* float_lit */ 35: Reduce(59),
		/* { */ 3: Reduce(59),
		/* html_lit */ 36: Reduce(59),
		/* string_lit */ 33: Reduce(59),
		/* int_lit */ 34: Reduce(59),
	},
	/* state 8*/ ActionRow{
		/* Digraph */ 20: Reduce(60),
		/* graph */ 13: Reduce(60),
		/* DiGraph */ 21: Reduce(60),
		/* Graph */ 14: Reduce(60),
		/* DIGRAPH */ 22: Reduce(60),
		/* GRAPH */ 15: Reduce(60),
		/* digraph */ 19: Reduce(60),
	},
	/* state 9*/ ActionRow{
		/* graph */ 13: Reduce(61),
		/* DiGraph */ 21: Reduce(61),
		/* Graph */ 14: Reduce(61),
		/* DIGRAPH */ 22: Reduce(61),
		/* GRAPH */ 15: Reduce(61),
		/* digraph */ 19: Reduce(61),
		/* Digraph */ 20: Reduce(61),
	},
	/* state 10*/ ActionRow{
		/* graph */ 13: Reduce(62),
		/* DiGraph */ 21: Reduce(62),
		/* Graph */ 14: Reduce(62),
		/* DIGRAPH */ 22: Reduce(62),
		/* GRAPH */ 15: Reduce(62),
		/* digraph */ 19: Reduce(62),
		/* Digraph */ 20: Reduce(62),
	},
	/* state 11*/ ActionRow{
		/* id */ 2: Reduce(63),
		/* float_lit */ 35: Reduce(63),
		/* { */ 3: Reduce(63),
		/* html_lit */ 36: Reduce(63),
		/* string_lit */ 33: Reduce(63),
		/* int_lit */ 34: Reduce(63),
	},
	/* state 12*/ ActionRow{
		/* { */ 3: Reduce(64),
		/* html_lit */ 36: Reduce(64),
		/* string_lit */ 33: Reduce(64),
		/* int_lit */ 34: Reduce(64),
		/* id */ 2: Reduce(64),
		/* float_lit */ 35: Reduce(64),
	},
	/* state 13*/ ActionRow{
		/* id */ 2: Reduce(65),
		/* float_lit */ 35: Reduce(65),
		/* { */ 3: Reduce(65),
		/* html_lit */ 36: Reduce(65),
		/* string_lit */ 33: Reduce(65),
		/* int_lit */ 34: Reduce(65),
	},
	/* state 14*/ ActionRow{
		/* int_lit */ 34: Reduce(66),
		/* id */ 2: Reduce(66),
		/* float_lit */ 35: Reduce(66),
		/* { */ 3: Reduce(66),
		/* html_lit */ 36: Reduce(66),
		/* string_lit */ 33: Reduce(66),
	},
	/* state 15*/ ActionRow{
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(28),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
	},
	/* state 16*/ ActionRow{
		/* { */ 3: Shift(59),
	},
	/* state 17*/ ActionRow{
		/* { */ 3: Reduce(77),
	},
	/* state 18*/ ActionRow{
		/* { */ 3: Reduce(78),
	},
	/* state 19*/ ActionRow{
		/* { */ 3: Reduce(79),
	},
	/* state 20*/ ActionRow{
		/* { */ 3: Reduce(80),
	},
	/* state 21*/ ActionRow{
		/* { */ 3: Reduce(81),
	},
	/* state 22*/ ActionRow{
		/* string_lit */ 33: Shift(18),
		/* int_lit */ 34: Shift(19),
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(60),
		/* html_lit */ 36: Shift(21),
	},
	/* state 23*/ ActionRow{
		/* string_lit */ 33: Shift(18),
		/* int_lit */ 34: Shift(19),
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(62),
		/* html_lit */ 36: Shift(21),
	},
	/* state 24*/ ActionRow{
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(64),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
	},
	/* state 25*/ ActionRow{
		/* { */ 3: Shift(66),
	},
	/* state 26*/ ActionRow{
		/* [ */ 7: Shift(68),
	},
	/* state 27*/ ActionRow{
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
	},
	/* state 28*/ ActionRow{
		/* $ */ 0: Reduce(1),
	},
	/* state 29*/ ActionRow{
		/* edge */ 26: Reduce(48),
		/* Subgraph */ 30: Reduce(48),
		/* { */ 3: Reduce(48),
		/* SUBGRAPH */ 32: Reduce(48),
		/* [ */ 7: Reduce(48),
		/* html_lit */ 36: Reduce(48),
		/* -> */ 11: Reduce(48),
		/* GRAPH */ 15: Reduce(48),
		/* node */ 23: Reduce(48),
		/* Edge */ 27: Reduce(48),
		/* SubGraph */ 31: Reduce(48),
		/* string_lit */ 33: Reduce(48),
		/* } */ 4: Reduce(48),
		/* -- */ 12: Reduce(48),
		/* Node */ 24: Reduce(48),
		/* EDGE */ 28: Reduce(48),
		/* ; */ 5: Reduce(48),
		/* int_lit */ 34: Reduce(48),
		/* graph */ 13: Reduce(48),
		/* NODE */ 25: Reduce(48),
		/* subgraph */ 29: Reduce(48),
		/* id */ 2: Reduce(48),
		/* float_lit */ 35: Reduce(48),
		/* = */ 6: Shift(70),
		/* : */ 10: Shift(72),
		/* Graph */ 14: Reduce(48),
	},
	/* state 30*/ ActionRow{
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(73),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
	},
	/* state 31*/ ActionRow{
		/* subgraph */ 29: Reduce(17),
		/* id */ 2: Reduce(17),
		/* float_lit */ 35: Reduce(17),
		/* Graph */ 14: Reduce(17),
		/* edge */ 26: Reduce(17),
		/* Subgraph */ 30: Reduce(17),
		/* { */ 3: Reduce(17),
		/* SUBGRAPH */ 32: Reduce(17),
		/* html_lit */ 36: Reduce(17),
		/* GRAPH */ 15: Reduce(17),
		/* node */ 23: Reduce(17),
		/* Edge */ 27: Reduce(17),
		/* SubGraph */ 31: Reduce(17),
		/* string_lit */ 33: Reduce(17),
		/* } */ 4: Reduce(17),
		/* Node */ 24: Reduce(17),
		/* EDGE */ 28: Reduce(17),
		/* int_lit */ 34: Reduce(17),
		/* graph */ 13: Reduce(17),
		/* NODE */ 25: Reduce(17),
	},
	/* state 32*/ ActionRow{
		/* ; */ 5: Shift(75),
		/* int_lit */ 34: Reduce(19),
		/* graph */ 13: Reduce(19),
		/* NODE */ 25: Reduce(19),
		/* subgraph */ 29: Reduce(19),
		/* id */ 2: Reduce(19),
		/* float_lit */ 35: Reduce(19),
		/* Graph */ 14: Reduce(19),
		/* edge */ 26: Reduce(19),
		/* Subgraph */ 30: Reduce(19),
		/* { */ 3: Reduce(19),
		/* SUBGRAPH */ 32: Reduce(19),
		/* html_lit */ 36: Reduce(19),
		/* GRAPH */ 15: Reduce(19),
		/* node */ 23: Reduce(19),
		/* Edge */ 27: Reduce(19),
		/* SubGraph */ 31: Reduce(19),
		/* string_lit */ 33: Reduce(19),
		/* } */ 4: Reduce(19),
		/* Node */ 24: Reduce(19),
		/* EDGE */ 28: Reduce(19),
	},
	/* state 33*/ ActionRow{
		/* NODE */ 25: Reduce(22),
		/* subgraph */ 29: Reduce(22),
		/* id */ 2: Reduce(22),
		/* float_lit */ 35: Reduce(22),
		/* Graph */ 14: Reduce(22),
		/* edge */ 26: Reduce(22),
		/* Subgraph */ 30: Reduce(22),
		/* { */ 3: Reduce(22),
		/* SUBGRAPH */ 32: Reduce(22),
		/* html_lit */ 36: Reduce(22),
		/* GRAPH */ 15: Reduce(22),
		/* node */ 23: Reduce(22),
		/* Edge */ 27: Reduce(22),
		/* SubGraph */ 31: Reduce(22),
		/* string_lit */ 33: Reduce(22),
		/* } */ 4: Reduce(22),
		/* Node */ 24: Reduce(22),
		/* EDGE */ 28: Reduce(22),
		/* ; */ 5: Reduce(22),
		/* int_lit */ 34: Reduce(22),
		/* graph */ 13: Reduce(22),
	},
	/* state 34*/ ActionRow{
		/* Node */ 24: Reduce(23),
		/* EDGE */ 28: Reduce(23),
		/* ; */ 5: Reduce(23),
		/* int_lit */ 34: Reduce(23),
		/* graph */ 13: Reduce(23),
		/* NODE */ 25: Reduce(23),
		/* subgraph */ 29: Reduce(23),
		/* id */ 2: Reduce(23),
		/* float_lit */ 35: Reduce(23),
		/* Graph */ 14: Reduce(23),
		/* edge */ 26: Reduce(23),
		/* Subgraph */ 30: Reduce(23),
		/* { */ 3: Reduce(23),
		/* SUBGRAPH */ 32: Reduce(23),
		/* html_lit */ 36: Reduce(23),
		/* GRAPH */ 15: Reduce(23),
		/* node */ 23: Reduce(23),
		/* Edge */ 27: Reduce(23),
		/* SubGraph */ 31: Reduce(23),
		/* string_lit */ 33: Reduce(23),
		/* } */ 4: Reduce(23),
	},
	/* state 35*/ ActionRow{
		/* GRAPH */ 15: Reduce(24),
		/* node */ 23: Reduce(24),
		/* Edge */ 27: Reduce(24),
		/* SubGraph */ 31: Reduce(24),
		/* string_lit */ 33: Reduce(24),
		/* } */ 4: Reduce(24),
		/* Node */ 24: Reduce(24),
		/* EDGE */ 28: Reduce(24),
		/* ; */ 5: Reduce(24),
		/* int_lit */ 34: Reduce(24),
		/* graph */ 13: Reduce(24),
		/* NODE */ 25: Reduce(24),
		/* subgraph */ 29: Reduce(24),
		/* id */ 2: Reduce(24),
		/* float_lit */ 35: Reduce(24),
		/* Graph */ 14: Reduce(24),
		/* edge */ 26: Reduce(24),
		/* Subgraph */ 30: Reduce(24),
		/* { */ 3: Reduce(24),
		/* SUBGRAPH */ 32: Reduce(24),
		/* html_lit */ 36: Reduce(24),
	},
	/* state 36*/ ActionRow{
		/* { */ 3: Reduce(25),
		/* SUBGRAPH */ 32: Reduce(25),
		/* html_lit */ 36: Reduce(25),
		/* -> */ 11: Shift(78),
		/* GRAPH */ 15: Reduce(25),
		/* node */ 23: Reduce(25),
		/* Edge */ 27: Reduce(25),
		/* SubGraph */ 31: Reduce(25),
		/* string_lit */ 33: Reduce(25),
		/* } */ 4: Reduce(25),
		/* -- */ 12: Shift(79),
		/* Node */ 24: Reduce(25),
		/* EDGE */ 28: Reduce(25),
		/* ; */ 5: Reduce(25),
		/* int_lit */ 34: Reduce(25),
		/* graph */ 13: Reduce(25),
		/* NODE */ 25: Reduce(25),
		/* subgraph */ 29: Reduce(25),
		/* id */ 2: Reduce(25),
		/* float_lit */ 35: Reduce(25),
		/* Graph */ 14: Reduce(25),
		/* edge */ 26: Reduce(25),
		/* Subgraph */ 30: Reduce(25),
	},
	/* state 37*/ ActionRow{
		/* [ */ 7: Shift(68),
	},
	/* state 38*/ ActionRow{
		/* [ */ 7: Shift(68),
	},
	/* state 39*/ ActionRow{
		/* html_lit */ 36: Reduce(46),
		/* -> */ 11: Shift(78),
		/* GRAPH */ 15: Reduce(46),
		/* node */ 23: Reduce(46),
		/* Edge */ 27: Reduce(46),
		/* SubGraph */ 31: Reduce(46),
		/* string_lit */ 33: Reduce(46),
		/* } */ 4: Reduce(46),
		/* -- */ 12: Shift(79),
		/* Node */ 24: Reduce(46),
		/* EDGE */ 28: Reduce(46),
		/* ; */ 5: Reduce(46),
		/* int_lit */ 34: Reduce(46),
		/* graph */ 13: Reduce(46),
		/* NODE */ 25: Reduce(46),
		/* subgraph */ 29: Reduce(46),
		/* id */ 2: Reduce(46),
		/* float_lit */ 35: Reduce(46),
		/* Graph */ 14: Reduce(46),
		/* edge */ 26: Reduce(46),
		/* Subgraph */ 30: Reduce(46),
		/* { */ 3: Reduce(46),
		/* SUBGRAPH */ 32: Reduce(46),
		/* [ */ 7: Shift(68),
	},
	/* state 40*/ ActionRow{
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(84),
		/* html_lit */ 36: Shift(21),
		/* string_lit */ 33: Shift(18),
		/* int_lit */ 34: Shift(19),
	},
	/* state 41*/ ActionRow{
		/* [ */ 7: Reduce(57),
	},
	/* state 42*/ ActionRow{
		/* [ */ 7: Reduce(58),
	},
	/* state 43*/ ActionRow{
		/* [ */ 7: Reduce(59),
	},
	/* state 44*/ ActionRow{
		/* [ */ 7: Reduce(67),
	},
	/* state 45*/ ActionRow{
		/* [ */ 7: Reduce(68),
	},
	/* state 46*/ ActionRow{
		/* [ */ 7: Reduce(69),
	},
	/* state 47*/ ActionRow{
		/* [ */ 7: Reduce(70),
	},
	/* state 48*/ ActionRow{
		/* [ */ 7: Reduce(71),
	},
	/* state 49*/ ActionRow{
		/* [ */ 7: Reduce(72),
	},
	/* state 50*/ ActionRow{
		/* id */ 2: Reduce(73),
		/* float_lit */ 35: Reduce(73),
		/* { */ 3: Reduce(73),
		/* html_lit */ 36: Reduce(73),
		/* string_lit */ 33: Reduce(73),
		/* int_lit */ 34: Reduce(73),
	},
	/* state 51*/ ActionRow{
		/* float_lit */ 35: Reduce(74),
		/* { */ 3: Reduce(74),
		/* html_lit */ 36: Reduce(74),
		/* string_lit */ 33: Reduce(74),
		/* int_lit */ 34: Reduce(74),
		/* id */ 2: Reduce(74),
	},
	/* state 52*/ ActionRow{
		/* { */ 3: Reduce(75),
		/* html_lit */ 36: Reduce(75),
		/* string_lit */ 33: Reduce(75),
		/* int_lit */ 34: Reduce(75),
		/* id */ 2: Reduce(75),
		/* float_lit */ 35: Reduce(75),
	},
	/* state 53*/ ActionRow{
		/* { */ 3: Reduce(76),
		/* html_lit */ 36: Reduce(76),
		/* string_lit */ 33: Reduce(76),
		/* int_lit */ 34: Reduce(76),
		/* id */ 2: Reduce(76),
		/* float_lit */ 35: Reduce(76),
	},
	/* state 54*/ ActionRow{
		/* Node */ 24: Reduce(77),
		/* EDGE */ 28: Reduce(77),
		/* ; */ 5: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* graph */ 13: Reduce(77),
		/* NODE */ 25: Reduce(77),
		/* subgraph */ 29: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
		/* = */ 6: Reduce(77),
		/* : */ 10: Reduce(77),
		/* Graph */ 14: Reduce(77),
		/* edge */ 26: Reduce(77),
		/* Subgraph */ 30: Reduce(77),
		/* { */ 3: Reduce(77),
		/* SUBGRAPH */ 32: Reduce(77),
		/* [ */ 7: Reduce(77),
		/* html_lit */ 36: Reduce(77),
		/* -> */ 11: Reduce(77),
		/* GRAPH */ 15: Reduce(77),
		/* node */ 23: Reduce(77),
		/* Edge */ 27: Reduce(77),
		/* SubGraph */ 31: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* } */ 4: Reduce(77),
		/* -- */ 12: Reduce(77),
	},
	/* state 55*/ ActionRow{
		/* Edge */ 27: Reduce(78),
		/* SubGraph */ 31: Reduce(78),
		/* string_lit */ 33: Reduce(78),
		/* } */ 4: Reduce(78),
		/* -- */ 12: Reduce(78),
		/* Node */ 24: Reduce(78),
		/* EDGE */ 28: Reduce(78),
		/* ; */ 5: Reduce(78),
		/* int_lit */ 34: Reduce(78),
		/* graph */ 13: Reduce(78),
		/* NODE */ 25: Reduce(78),
		/* subgraph */ 29: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* = */ 6: Reduce(78),
		/* : */ 10: Reduce(78),
		/* Graph */ 14: Reduce(78),
		/* edge */ 26: Reduce(78),
		/* Subgraph */ 30: Reduce(78),
		/* { */ 3: Reduce(78),
		/* SUBGRAPH */ 32: Reduce(78),
		/* [ */ 7: Reduce(78),
		/* html_lit */ 36: Reduce(78),
		/* -> */ 11: Reduce(78),
		/* GRAPH */ 15: Reduce(78),
		/* node */ 23: Reduce(78),
	},
	/* state 56*/ ActionRow{
		/* -- */ 12: Reduce(79),
		/* Node */ 24: Reduce(79),
		/* EDGE */ 28: Reduce(79),
		/* ; */ 5: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* graph */ 13: Reduce(79),
		/* NODE */ 25: Reduce(79),
		/* subgraph */ 29: Reduce(79),
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
		/* = */ 6: Reduce(79),
		/* : */ 10: Reduce(79),
		/* Graph */ 14: Reduce(79),
		/* edge */ 26: Reduce(79),
		/* Subgraph */ 30: Reduce(79),
		/* { */ 3: Reduce(79),
		/* SUBGRAPH */ 32: Reduce(79),
		/* [ */ 7: Reduce(79),
		/* html_lit */ 36: Reduce(79),
		/* -> */ 11: Reduce(79),
		/* GRAPH */ 15: Reduce(79),
		/* node */ 23: Reduce(79),
		/* Edge */ 27: Reduce(79),
		/* SubGraph */ 31: Reduce(79),
		/* string_lit */ 33: Reduce(79),
		/* } */ 4: Reduce(79),
	},
	/* state 57*/ ActionRow{
		/* { */ 3: Reduce(80),
		/* SUBGRAPH */ 32: Reduce(80),
		/* [ */ 7: Reduce(80),
		/* html_lit */ 36: Reduce(80),
		/* -> */ 11: Reduce(80),
		/* GRAPH */ 15: Reduce(80),
		/* node */ 23: Reduce(80),
		/* Edge */ 27: Reduce(80),
		/* SubGraph */ 31: Reduce(80),
		/* string_lit */ 33: Reduce(80),
		/* } */ 4: Reduce(80),
		/* -- */ 12: Reduce(80),
		/* Node */ 24: Reduce(80),
		/* EDGE */ 28: Reduce(80),
		/* ; */ 5: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* graph */ 13: Reduce(80),
		/* NODE */ 25: Reduce(80),
		/* subgraph */ 29: Reduce(80),
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* = */ 6: Reduce(80),
		/* : */ 10: Reduce(80),
		/* Graph */ 14: Reduce(80),
		/* edge */ 26: Reduce(80),
		/* Subgraph */ 30: Reduce(80),
	},
	/* state 58*/ ActionRow{
		/* Node */ 24: Reduce(81),
		/* EDGE */ 28: Reduce(81),
		/* ; */ 5: Reduce(81),
		/* int_lit */ 34: Reduce(81),
		/* graph */ 13: Reduce(81),
		/* NODE */ 25: Reduce(81),
		/* subgraph */ 29: Reduce(81),
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
		/* = */ 6: Reduce(81),
		/* : */ 10: Reduce(81),
		/* Graph */ 14: Reduce(81),
		/* edge */ 26: Reduce(81),
		/* Subgraph */ 30: Reduce(81),
		/* { */ 3: Reduce(81),
		/* SUBGRAPH */ 32: Reduce(81),
		/* [ */ 7: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* -> */ 11: Reduce(81),
		/* GRAPH */ 15: Reduce(81),
		/* node */ 23: Reduce(81),
		/* Edge */ 27: Reduce(81),
		/* SubGraph */ 31: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* } */ 4: Reduce(81),
		/* -- */ 12: Reduce(81),
	},
	/* state 59*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(86),
	},
	/* state 60*/ ActionRow{
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(88),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
	},
	/* state 61*/ ActionRow{
		/* { */ 3: Shift(90),
	},
	/* state 62*/ ActionRow{
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(91),
		/* Node */ 24: Shift(45),
	},
	/* state 63*/ ActionRow{
		/* { */ 3: Shift(93),
	},
	/* state 64*/ ActionRow{
		/* $ */ 0: Reduce(9),
	},
	/* state 65*/ ActionRow{
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(94),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
	},
	/* state 66*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(95),
	},
	/* state 67*/ ActionRow{
		/* float_lit */ 35: Reduce(26),
		/* Graph */ 14: Reduce(26),
		/* edge */ 26: Reduce(26),
		/* Subgraph */ 30: Reduce(26),
		/* { */ 3: Reduce(26),
		/* SUBGRAPH */ 32: Reduce(26),
		/* [ */ 7: Shift(97),
		/* html_lit */ 36: Reduce(26),
		/* GRAPH */ 15: Reduce(26),
		/* node */ 23: Reduce(26),
		/* Edge */ 27: Reduce(26),
		/* SubGraph */ 31: Reduce(26),
		/* string_lit */ 33: Reduce(26),
		/* } */ 4: Reduce(26),
		/* Node */ 24: Reduce(26),
		/* EDGE */ 28: Reduce(26),
		/* ; */ 5: Reduce(26),
		/* int_lit */ 34: Reduce(26),
		/* graph */ 13: Reduce(26),
		/* NODE */ 25: Reduce(26),
		/* subgraph */ 29: Reduce(26),
		/* id */ 2: Reduce(26),
	},
	/* state 68*/ ActionRow{
		/* id */ 2: Shift(102),
		/* float_lit */ 35: Shift(105),
		/* html_lit */ 36: Shift(106),
		/* string_lit */ 33: Shift(103),
		/* ] */ 8: Shift(99),
		/* int_lit */ 34: Shift(104),
	},
	/* state 69*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(107),
	},
	/* state 70*/ ActionRow{
		/* string_lit */ 33: Shift(110),
		/* int_lit */ 34: Shift(111),
		/* id */ 2: Shift(109),
		/* float_lit */ 35: Shift(112),
		/* html_lit */ 36: Shift(113),
	},
	/* state 71*/ ActionRow{
		/* id */ 2: Reduce(49),
		/* float_lit */ 35: Reduce(49),
		/* Graph */ 14: Reduce(49),
		/* edge */ 26: Reduce(49),
		/* Subgraph */ 30: Reduce(49),
		/* { */ 3: Reduce(49),
		/* SUBGRAPH */ 32: Reduce(49),
		/* [ */ 7: Reduce(49),
		/* html_lit */ 36: Reduce(49),
		/* -> */ 11: Reduce(49),
		/* GRAPH */ 15: Reduce(49),
		/* node */ 23: Reduce(49),
		/* Edge */ 27: Reduce(49),
		/* SubGraph */ 31: Reduce(49),
		/* string_lit */ 33: Reduce(49),
		/* } */ 4: Reduce(49),
		/* -- */ 12: Reduce(49),
		/* Node */ 24: Reduce(49),
		/* EDGE */ 28: Reduce(49),
		/* ; */ 5: Reduce(49),
		/* int_lit */ 34: Reduce(49),
		/* graph */ 13: Reduce(49),
		/* NODE */ 25: Reduce(49),
		/* subgraph */ 29: Reduce(49),
	},
	/* state 72*/ ActionRow{
		/* id */ 2: Shift(115),
		/* float_lit */ 35: Shift(118),
		/* html_lit */ 36: Shift(119),
		/* string_lit */ 33: Shift(116),
		/* int_lit */ 34: Shift(117),
	},
	/* state 73*/ ActionRow{
		/* $ */ 0: Reduce(5),
	},
	/* state 74*/ ActionRow{
		/* graph */ 13: Reduce(18),
		/* NODE */ 25: Reduce(18),
		/* subgraph */ 29: Reduce(18),
		/* id */ 2: Reduce(18),
		/* float_lit */ 35: Reduce(18),
		/* Graph */ 14: Reduce(18),
		/* edge */ 26: Reduce(18),
		/* Subgraph */ 30: Reduce(18),
		/* { */ 3: Reduce(18),
		/* SUBGRAPH */ 32: Reduce(18),
		/* html_lit */ 36: Reduce(18),
		/* GRAPH */ 15: Reduce(18),
		/* node */ 23: Reduce(18),
		/* Edge */ 27: Reduce(18),
		/* SubGraph */ 31: Reduce(18),
		/* string_lit */ 33: Reduce(18),
		/* } */ 4: Reduce(18),
		/* Node */ 24: Reduce(18),
		/* EDGE */ 28: Reduce(18),
		/* int_lit */ 34: Reduce(18),
	},
	/* state 75*/ ActionRow{
		/* edge */ 26: Reduce(20),
		/* Subgraph */ 30: Reduce(20),
		/* { */ 3: Reduce(20),
		/* SUBGRAPH */ 32: Reduce(20),
		/* html_lit */ 36: Reduce(20),
		/* GRAPH */ 15: Reduce(20),
		/* node */ 23: Reduce(20),
		/* Edge */ 27: Reduce(20),
		/* SubGraph */ 31: Reduce(20),
		/* string_lit */ 33: Reduce(20),
		/* } */ 4: Reduce(20),
		/* Node */ 24: Reduce(20),
		/* EDGE */ 28: Reduce(20),
		/* int_lit */ 34: Reduce(20),
		/* graph */ 13: Reduce(20),
		/* NODE */ 25: Reduce(20),
		/* subgraph */ 29: Reduce(20),
		/* id */ 2: Reduce(20),
		/* float_lit */ 35: Reduce(20),
		/* Graph */ 14: Reduce(20),
	},
	/* state 76*/ ActionRow{
		/* -- */ 12: Shift(79),
		/* Node */ 24: Reduce(40),
		/* EDGE */ 28: Reduce(40),
		/* ; */ 5: Reduce(40),
		/* int_lit */ 34: Reduce(40),
		/* graph */ 13: Reduce(40),
		/* NODE */ 25: Reduce(40),
		/* subgraph */ 29: Reduce(40),
		/* id */ 2: Reduce(40),
		/* float_lit */ 35: Reduce(40),
		/* Graph */ 14: Reduce(40),
		/* edge */ 26: Reduce(40),
		/* Subgraph */ 30: Reduce(40),
		/* { */ 3: Reduce(40),
		/* SUBGRAPH */ 32: Reduce(40),
		/* [ */ 7: Shift(68),
		/* html_lit */ 36: Reduce(40),
		/* -> */ 11: Shift(78),
		/* GRAPH */ 15: Reduce(40),
		/* node */ 23: Reduce(40),
		/* Edge */ 27: Reduce(40),
		/* SubGraph */ 31: Reduce(40),
		/* string_lit */ 33: Reduce(40),
		/* } */ 4: Reduce(40),
	},
	/* state 77*/ ActionRow{
		/* { */ 3: Shift(122),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(119),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(116),
		/* int_lit */ 34: Shift(117),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(115),
		/* float_lit */ 35: Shift(118),
		/* Subgraph */ 30: Shift(51),
	},
	/* state 78*/ ActionRow{
		/* int_lit */ 34: Reduce(55),
		/* subgraph */ 29: Reduce(55),
		/* id */ 2: Reduce(55),
		/* float_lit */ 35: Reduce(55),
		/* Subgraph */ 30: Reduce(55),
		/* { */ 3: Reduce(55),
		/* SUBGRAPH */ 32: Reduce(55),
		/* html_lit */ 36: Reduce(55),
		/* SubGraph */ 31: Reduce(55),
		/* string_lit */ 33: Reduce(55),
	},
	/* state 79*/ ActionRow{
		/* int_lit */ 34: Reduce(56),
		/* subgraph */ 29: Reduce(56),
		/* id */ 2: Reduce(56),
		/* float_lit */ 35: Reduce(56),
		/* Subgraph */ 30: Reduce(56),
		/* { */ 3: Reduce(56),
		/* SUBGRAPH */ 32: Reduce(56),
		/* html_lit */ 36: Reduce(56),
		/* SubGraph */ 31: Reduce(56),
		/* string_lit */ 33: Reduce(56),
	},
	/* state 80*/ ActionRow{
		/* html_lit */ 36: Reduce(27),
		/* GRAPH */ 15: Reduce(27),
		/* node */ 23: Reduce(27),
		/* Edge */ 27: Reduce(27),
		/* SubGraph */ 31: Reduce(27),
		/* string_lit */ 33: Reduce(27),
		/* } */ 4: Reduce(27),
		/* Node */ 24: Reduce(27),
		/* EDGE */ 28: Reduce(27),
		/* ; */ 5: Reduce(27),
		/* int_lit */ 34: Reduce(27),
		/* graph */ 13: Reduce(27),
		/* NODE */ 25: Reduce(27),
		/* subgraph */ 29: Reduce(27),
		/* id */ 2: Reduce(27),
		/* float_lit */ 35: Reduce(27),
		/* Graph */ 14: Reduce(27),
		/* edge */ 26: Reduce(27),
		/* Subgraph */ 30: Reduce(27),
		/* { */ 3: Reduce(27),
		/* SUBGRAPH */ 32: Reduce(27),
		/* [ */ 7: Shift(97),
	},
	/* state 81*/ ActionRow{
		/* NODE */ 25: Reduce(28),
		/* subgraph */ 29: Reduce(28),
		/* id */ 2: Reduce(28),
		/* float_lit */ 35: Reduce(28),
		/* Graph */ 14: Reduce(28),
		/* edge */ 26: Reduce(28),
		/* Subgraph */ 30: Reduce(28),
		/* { */ 3: Reduce(28),
		/* SUBGRAPH */ 32: Reduce(28),
		/* [ */ 7: Shift(97),
		/* html_lit */ 36: Reduce(28),
		/* GRAPH */ 15: Reduce(28),
		/* node */ 23: Reduce(28),
		/* Edge */ 27: Reduce(28),
		/* SubGraph */ 31: Reduce(28),
		/* string_lit */ 33: Reduce(28),
		/* } */ 4: Reduce(28),
		/* Node */ 24: Reduce(28),
		/* EDGE */ 28: Reduce(28),
		/* ; */ 5: Reduce(28),
		/* int_lit */ 34: Reduce(28),
		/* graph */ 13: Reduce(28),
	},
	/* state 82*/ ActionRow{
		/* string_lit */ 33: Reduce(47),
		/* } */ 4: Reduce(47),
		/* Node */ 24: Reduce(47),
		/* EDGE */ 28: Reduce(47),
		/* ; */ 5: Reduce(47),
		/* int_lit */ 34: Reduce(47),
		/* graph */ 13: Reduce(47),
		/* NODE */ 25: Reduce(47),
		/* subgraph */ 29: Reduce(47),
		/* id */ 2: Reduce(47),
		/* float_lit */ 35: Reduce(47),
		/* Graph */ 14: Reduce(47),
		/* edge */ 26: Reduce(47),
		/* Subgraph */ 30: Reduce(47),
		/* { */ 3: Reduce(47),
		/* SUBGRAPH */ 32: Reduce(47),
		/* [ */ 7: Shift(97),
		/* html_lit */ 36: Reduce(47),
		/* GRAPH */ 15: Reduce(47),
		/* node */ 23: Reduce(47),
		/* Edge */ 27: Reduce(47),
		/* SubGraph */ 31: Reduce(47),
	},
	/* state 83*/ ActionRow{
		/* string_lit */ 33: Reduce(38),
		/* } */ 4: Reduce(38),
		/* -- */ 12: Shift(79),
		/* Node */ 24: Reduce(38),
		/* EDGE */ 28: Reduce(38),
		/* ; */ 5: Reduce(38),
		/* int_lit */ 34: Reduce(38),
		/* graph */ 13: Reduce(38),
		/* NODE */ 25: Reduce(38),
		/* subgraph */ 29: Reduce(38),
		/* id */ 2: Reduce(38),
		/* float_lit */ 35: Reduce(38),
		/* Graph */ 14: Reduce(38),
		/* edge */ 26: Reduce(38),
		/* Subgraph */ 30: Reduce(38),
		/* { */ 3: Reduce(38),
		/* SUBGRAPH */ 32: Reduce(38),
		/* [ */ 7: Shift(68),
		/* html_lit */ 36: Reduce(38),
		/* -> */ 11: Shift(78),
		/* GRAPH */ 15: Reduce(38),
		/* node */ 23: Reduce(38),
		/* Edge */ 27: Reduce(38),
		/* SubGraph */ 31: Reduce(38),
	},
	/* state 84*/ ActionRow{
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
	},
	/* state 85*/ ActionRow{
		/* { */ 3: Shift(129),
	},
	/* state 86*/ ActionRow{
		/* $ */ 0: Reduce(3),
	},
	/* state 87*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(130),
	},
	/* state 88*/ ActionRow{
		/* $ */ 0: Reduce(2),
	},
	/* state 89*/ ActionRow{
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(131),
		/* Node */ 24: Shift(45),
	},
	/* state 90*/ ActionRow{
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(132),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
	},
	/* state 91*/ ActionRow{
		/* $ */ 0: Reduce(10),
	},
	/* state 92*/ ActionRow{
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(134),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
	},
	/* state 93*/ ActionRow{
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(135),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
	},
	/* state 94*/ ActionRow{
		/* $ */ 0: Reduce(13),
	},
	/* state 95*/ ActionRow{
		/* $ */ 0: Reduce(11),
	},
	/* state 96*/ ActionRow{
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(137),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
	},
	/* state 97*/ ActionRow{
		/* int_lit */ 34: Shift(104),
		/* id */ 2: Shift(102),
		/* float_lit */ 35: Shift(105),
		/* html_lit */ 36: Shift(106),
		/* string_lit */ 33: Shift(103),
		/* ] */ 8: Shift(138),
	},
	/* state 98*/ ActionRow{
		/* int_lit */ 34: Reduce(36),
		/* , */ 9: Reduce(36),
		/* id */ 2: Reduce(36),
		/* float_lit */ 35: Reduce(36),
		/* = */ 6: Shift(140),
		/* html_lit */ 36: Reduce(36),
		/* string_lit */ 33: Reduce(36),
		/* ] */ 8: Reduce(36),
	},
	/* state 99*/ ActionRow{
		/* id */ 2: Reduce(29),
		/* float_lit */ 35: Reduce(29),
		/* Graph */ 14: Reduce(29),
		/* edge */ 26: Reduce(29),
		/* Subgraph */ 30: Reduce(29),
		/* { */ 3: Reduce(29),
		/* SUBGRAPH */ 32: Reduce(29),
		/* [ */ 7: Reduce(29),
		/* html_lit */ 36: Reduce(29),
		/* GRAPH */ 15: Reduce(29),
		/* node */ 23: Reduce(29),
		/* Edge */ 27: Reduce(29),
		/* SubGraph */ 31: Reduce(29),
		/* string_lit */ 33: Reduce(29),
		/* } */ 4: Reduce(29),
		/* Node */ 24: Reduce(29),
		/* EDGE */ 28: Reduce(29),
		/* ; */ 5: Reduce(29),
		/* int_lit */ 34: Reduce(29),
		/* graph */ 13: Reduce(29),
		/* NODE */ 25: Reduce(29),
		/* subgraph */ 29: Reduce(29),
	},
	/* state 100*/ ActionRow{
		/* int_lit */ 34: Shift(104),
		/* , */ 9: Shift(143),
		/* id */ 2: Shift(102),
		/* float_lit */ 35: Shift(105),
		/* html_lit */ 36: Shift(106),
		/* string_lit */ 33: Shift(103),
		/* ] */ 8: Shift(141),
	},
	/* state 101*/ ActionRow{
		/* int_lit */ 34: Reduce(33),
		/* , */ 9: Reduce(33),
		/* id */ 2: Reduce(33),
		/* float_lit */ 35: Reduce(33),
		/* html_lit */ 36: Reduce(33),
		/* string_lit */ 33: Reduce(33),
		/* ] */ 8: Reduce(33),
	},
	/* state 102*/ ActionRow{
		/* html_lit */ 36: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* ] */ 8: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* , */ 9: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
		/* = */ 6: Reduce(77),
	},
	/* state 103*/ ActionRow{
		/* string_lit */ 33: Reduce(78),
		/* ] */ 8: Reduce(78),
		/* int_lit */ 34: Reduce(78),
		/* , */ 9: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* = */ 6: Reduce(78),
		/* html_lit */ 36: Reduce(78),
	},
	/* state 104*/ ActionRow{
		/* string_lit */ 33: Reduce(79),
		/* ] */ 8: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* , */ 9: Reduce(79),
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
		/* = */ 6: Reduce(79),
		/* html_lit */ 36: Reduce(79),
	},
	/* state 105*/ ActionRow{
		/* string_lit */ 33: Reduce(80),
		/* ] */ 8: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* , */ 9: Reduce(80),
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* = */ 6: Reduce(80),
		/* html_lit */ 36: Reduce(80),
	},
	/* state 106*/ ActionRow{
		/* int_lit */ 34: Reduce(81),
		/* , */ 9: Reduce(81),
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
		/* = */ 6: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* ] */ 8: Reduce(81),
	},
	/* state 107*/ ActionRow{
		/* int_lit */ 34: Reduce(52),
		/* graph */ 13: Reduce(52),
		/* NODE */ 25: Reduce(52),
		/* subgraph */ 29: Reduce(52),
		/* id */ 2: Reduce(52),
		/* float_lit */ 35: Reduce(52),
		/* Graph */ 14: Reduce(52),
		/* edge */ 26: Reduce(52),
		/* Subgraph */ 30: Reduce(52),
		/* { */ 3: Reduce(52),
		/* SUBGRAPH */ 32: Reduce(52),
		/* html_lit */ 36: Reduce(52),
		/* -> */ 11: Reduce(52),
		/* GRAPH */ 15: Reduce(52),
		/* node */ 23: Reduce(52),
		/* Edge */ 27: Reduce(52),
		/* SubGraph */ 31: Reduce(52),
		/* string_lit */ 33: Reduce(52),
		/* } */ 4: Reduce(52),
		/* -- */ 12: Reduce(52),
		/* Node */ 24: Reduce(52),
		/* EDGE */ 28: Reduce(52),
		/* ; */ 5: Reduce(52),
	},
	/* state 108*/ ActionRow{
		/* Graph */ 14: Reduce(21),
		/* edge */ 26: Reduce(21),
		/* Subgraph */ 30: Reduce(21),
		/* { */ 3: Reduce(21),
		/* SUBGRAPH */ 32: Reduce(21),
		/* html_lit */ 36: Reduce(21),
		/* GRAPH */ 15: Reduce(21),
		/* node */ 23: Reduce(21),
		/* Edge */ 27: Reduce(21),
		/* SubGraph */ 31: Reduce(21),
		/* string_lit */ 33: Reduce(21),
		/* } */ 4: Reduce(21),
		/* Node */ 24: Reduce(21),
		/* EDGE */ 28: Reduce(21),
		/* ; */ 5: Reduce(21),
		/* int_lit */ 34: Reduce(21),
		/* graph */ 13: Reduce(21),
		/* NODE */ 25: Reduce(21),
		/* subgraph */ 29: Reduce(21),
		/* id */ 2: Reduce(21),
		/* float_lit */ 35: Reduce(21),
	},
	/* state 109*/ ActionRow{
		/* edge */ 26: Reduce(77),
		/* Subgraph */ 30: Reduce(77),
		/* { */ 3: Reduce(77),
		/* SUBGRAPH */ 32: Reduce(77),
		/* html_lit */ 36: Reduce(77),
		/* GRAPH */ 15: Reduce(77),
		/* node */ 23: Reduce(77),
		/* Edge */ 27: Reduce(77),
		/* SubGraph */ 31: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* } */ 4: Reduce(77),
		/* Node */ 24: Reduce(77),
		/* EDGE */ 28: Reduce(77),
		/* ; */ 5: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* graph */ 13: Reduce(77),
		/* NODE */ 25: Reduce(77),
		/* subgraph */ 29: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
		/* Graph */ 14: Reduce(77),
	},
	/* state 110*/ ActionRow{
		/* Node */ 24: Reduce(78),
		/* EDGE */ 28: Reduce(78),
		/* ; */ 5: Reduce(78),
		/* int_lit */ 34: Reduce(78),
		/* graph */ 13: Reduce(78),
		/* NODE */ 25: Reduce(78),
		/* subgraph */ 29: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* Graph */ 14: Reduce(78),
		/* edge */ 26: Reduce(78),
		/* Subgraph */ 30: Reduce(78),
		/* { */ 3: Reduce(78),
		/* SUBGRAPH */ 32: Reduce(78),
		/* html_lit */ 36: Reduce(78),
		/* GRAPH */ 15: Reduce(78),
		/* node */ 23: Reduce(78),
		/* Edge */ 27: Reduce(78),
		/* SubGraph */ 31: Reduce(78),
		/* string_lit */ 33: Reduce(78),
		/* } */ 4: Reduce(78),
	},
	/* state 111*/ ActionRow{
		/* NODE */ 25: Reduce(79),
		/* subgraph */ 29: Reduce(79),
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
		/* Graph */ 14: Reduce(79),
		/* edge */ 26: Reduce(79),
		/* Subgraph */ 30: Reduce(79),
		/* { */ 3: Reduce(79),
		/* SUBGRAPH */ 32: Reduce(79),
		/* html_lit */ 36: Reduce(79),
		/* GRAPH */ 15: Reduce(79),
		/* node */ 23: Reduce(79),
		/* Edge */ 27: Reduce(79),
		/* SubGraph */ 31: Reduce(79),
		/* string_lit */ 33: Reduce(79),
		/* } */ 4: Reduce(79),
		/* Node */ 24: Reduce(79),
		/* EDGE */ 28: Reduce(79),
		/* ; */ 5: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* graph */ 13: Reduce(79),
	},
	/* state 112*/ ActionRow{
		/* Node */ 24: Reduce(80),
		/* EDGE */ 28: Reduce(80),
		/* ; */ 5: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* graph */ 13: Reduce(80),
		/* NODE */ 25: Reduce(80),
		/* subgraph */ 29: Reduce(80),
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* Graph */ 14: Reduce(80),
		/* edge */ 26: Reduce(80),
		/* Subgraph */ 30: Reduce(80),
		/* { */ 3: Reduce(80),
		/* SUBGRAPH */ 32: Reduce(80),
		/* html_lit */ 36: Reduce(80),
		/* GRAPH */ 15: Reduce(80),
		/* node */ 23: Reduce(80),
		/* Edge */ 27: Reduce(80),
		/* SubGraph */ 31: Reduce(80),
		/* string_lit */ 33: Reduce(80),
		/* } */ 4: Reduce(80),
	},
	/* state 113*/ ActionRow{
		/* edge */ 26: Reduce(81),
		/* Subgraph */ 30: Reduce(81),
		/* { */ 3: Reduce(81),
		/* SUBGRAPH */ 32: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* GRAPH */ 15: Reduce(81),
		/* node */ 23: Reduce(81),
		/* Edge */ 27: Reduce(81),
		/* SubGraph */ 31: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* } */ 4: Reduce(81),
		/* Node */ 24: Reduce(81),
		/* EDGE */ 28: Reduce(81),
		/* ; */ 5: Reduce(81),
		/* int_lit */ 34: Reduce(81),
		/* graph */ 13: Reduce(81),
		/* NODE */ 25: Reduce(81),
		/* subgraph */ 29: Reduce(81),
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
		/* Graph */ 14: Reduce(81),
	},
	/* state 114*/ ActionRow{
		/* { */ 3: Reduce(50),
		/* SUBGRAPH */ 32: Reduce(50),
		/* [ */ 7: Reduce(50),
		/* html_lit */ 36: Reduce(50),
		/* -> */ 11: Reduce(50),
		/* GRAPH */ 15: Reduce(50),
		/* node */ 23: Reduce(50),
		/* Edge */ 27: Reduce(50),
		/* SubGraph */ 31: Reduce(50),
		/* string_lit */ 33: Reduce(50),
		/* } */ 4: Reduce(50),
		/* -- */ 12: Reduce(50),
		/* Node */ 24: Reduce(50),
		/* EDGE */ 28: Reduce(50),
		/* ; */ 5: Reduce(50),
		/* int_lit */ 34: Reduce(50),
		/* graph */ 13: Reduce(50),
		/* NODE */ 25: Reduce(50),
		/* subgraph */ 29: Reduce(50),
		/* id */ 2: Reduce(50),
		/* float_lit */ 35: Reduce(50),
		/* : */ 10: Shift(144),
		/* Graph */ 14: Reduce(50),
		/* edge */ 26: Reduce(50),
		/* Subgraph */ 30: Reduce(50),
	},
	/* state 115*/ ActionRow{
		/* Node */ 24: Reduce(77),
		/* EDGE */ 28: Reduce(77),
		/* ; */ 5: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* graph */ 13: Reduce(77),
		/* NODE */ 25: Reduce(77),
		/* subgraph */ 29: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
		/* : */ 10: Reduce(77),
		/* Graph */ 14: Reduce(77),
		/* edge */ 26: Reduce(77),
		/* Subgraph */ 30: Reduce(77),
		/* { */ 3: Reduce(77),
		/* SUBGRAPH */ 32: Reduce(77),
		/* [ */ 7: Reduce(77),
		/* html_lit */ 36: Reduce(77),
		/* -> */ 11: Reduce(77),
		/* GRAPH */ 15: Reduce(77),
		/* node */ 23: Reduce(77),
		/* Edge */ 27: Reduce(77),
		/* SubGraph */ 31: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* } */ 4: Reduce(77),
		/* -- */ 12: Reduce(77),
	},
	/* state 116*/ ActionRow{
		/* string_lit */ 33: Reduce(78),
		/* } */ 4: Reduce(78),
		/* -- */ 12: Reduce(78),
		/* Node */ 24: Reduce(78),
		/* EDGE */ 28: Reduce(78),
		/* ; */ 5: Reduce(78),
		/* int_lit */ 34: Reduce(78),
		/* graph */ 13: Reduce(78),
		/* NODE */ 25: Reduce(78),
		/* subgraph */ 29: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* : */ 10: Reduce(78),
		/* Graph */ 14: Reduce(78),
		/* edge */ 26: Reduce(78),
		/* Subgraph */ 30: Reduce(78),
		/* { */ 3: Reduce(78),
		/* SUBGRAPH */ 32: Reduce(78),
		/* [ */ 7: Reduce(78),
		/* html_lit */ 36: Reduce(78),
		/* -> */ 11: Reduce(78),
		/* GRAPH */ 15: Reduce(78),
		/* node */ 23: Reduce(78),
		/* Edge */ 27: Reduce(78),
		/* SubGraph */ 31: Reduce(78),
	},
	/* state 117*/ ActionRow{
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
		/* : */ 10: Reduce(79),
		/* Graph */ 14: Reduce(79),
		/* edge */ 26: Reduce(79),
		/* Subgraph */ 30: Reduce(79),
		/* { */ 3: Reduce(79),
		/* SUBGRAPH */ 32: Reduce(79),
		/* [ */ 7: Reduce(79),
		/* html_lit */ 36: Reduce(79),
		/* -> */ 11: Reduce(79),
		/* GRAPH */ 15: Reduce(79),
		/* node */ 23: Reduce(79),
		/* Edge */ 27: Reduce(79),
		/* SubGraph */ 31: Reduce(79),
		/* string_lit */ 33: Reduce(79),
		/* } */ 4: Reduce(79),
		/* -- */ 12: Reduce(79),
		/* Node */ 24: Reduce(79),
		/* EDGE */ 28: Reduce(79),
		/* ; */ 5: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* graph */ 13: Reduce(79),
		/* NODE */ 25: Reduce(79),
		/* subgraph */ 29: Reduce(79),
	},
	/* state 118*/ ActionRow{
		/* NODE */ 25: Reduce(80),
		/* subgraph */ 29: Reduce(80),
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* : */ 10: Reduce(80),
		/* Graph */ 14: Reduce(80),
		/* edge */ 26: Reduce(80),
		/* Subgraph */ 30: Reduce(80),
		/* { */ 3: Reduce(80),
		/* SUBGRAPH */ 32: Reduce(80),
		/* [ */ 7: Reduce(80),
		/* html_lit */ 36: Reduce(80),
		/* -> */ 11: Reduce(80),
		/* GRAPH */ 15: Reduce(80),
		/* node */ 23: Reduce(80),
		/* Edge */ 27: Reduce(80),
		/* SubGraph */ 31: Reduce(80),
		/* string_lit */ 33: Reduce(80),
		/* } */ 4: Reduce(80),
		/* -- */ 12: Reduce(80),
		/* Node */ 24: Reduce(80),
		/* EDGE */ 28: Reduce(80),
		/* ; */ 5: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* graph */ 13: Reduce(80),
	},
	/* state 119*/ ActionRow{
		/* { */ 3: Reduce(81),
		/* SUBGRAPH */ 32: Reduce(81),
		/* [ */ 7: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* -> */ 11: Reduce(81),
		/* GRAPH */ 15: Reduce(81),
		/* node */ 23: Reduce(81),
		/* Edge */ 27: Reduce(81),
		/* SubGraph */ 31: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* } */ 4: Reduce(81),
		/* -- */ 12: Reduce(81),
		/* Node */ 24: Reduce(81),
		/* EDGE */ 28: Reduce(81),
		/* ; */ 5: Reduce(81),
		/* int_lit */ 34: Reduce(81),
		/* graph */ 13: Reduce(81),
		/* NODE */ 25: Reduce(81),
		/* subgraph */ 29: Reduce(81),
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
		/* : */ 10: Reduce(81),
		/* Graph */ 14: Reduce(81),
		/* edge */ 26: Reduce(81),
		/* Subgraph */ 30: Reduce(81),
	},
	/* state 120*/ ActionRow{
		/* Graph */ 14: Reduce(41),
		/* edge */ 26: Reduce(41),
		/* Subgraph */ 30: Reduce(41),
		/* { */ 3: Reduce(41),
		/* SUBGRAPH */ 32: Reduce(41),
		/* [ */ 7: Shift(97),
		/* html_lit */ 36: Reduce(41),
		/* GRAPH */ 15: Reduce(41),
		/* node */ 23: Reduce(41),
		/* Edge */ 27: Reduce(41),
		/* SubGraph */ 31: Reduce(41),
		/* string_lit */ 33: Reduce(41),
		/* } */ 4: Reduce(41),
		/* Node */ 24: Reduce(41),
		/* EDGE */ 28: Reduce(41),
		/* ; */ 5: Reduce(41),
		/* int_lit */ 34: Reduce(41),
		/* graph */ 13: Reduce(41),
		/* NODE */ 25: Reduce(41),
		/* subgraph */ 29: Reduce(41),
		/* id */ 2: Reduce(41),
		/* float_lit */ 35: Reduce(41),
	},
	/* state 121*/ ActionRow{
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(122),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(119),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(116),
		/* int_lit */ 34: Shift(117),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(115),
		/* float_lit */ 35: Shift(118),
	},
	/* state 122*/ ActionRow{
		/* string_lit */ 33: Shift(55),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
	},
	/* state 123*/ ActionRow{
		/* id */ 2: Reduce(48),
		/* float_lit */ 35: Reduce(48),
		/* : */ 10: Shift(72),
		/* Graph */ 14: Reduce(48),
		/* edge */ 26: Reduce(48),
		/* Subgraph */ 30: Reduce(48),
		/* { */ 3: Reduce(48),
		/* SUBGRAPH */ 32: Reduce(48),
		/* [ */ 7: Reduce(48),
		/* html_lit */ 36: Reduce(48),
		/* -> */ 11: Reduce(48),
		/* GRAPH */ 15: Reduce(48),
		/* node */ 23: Reduce(48),
		/* Edge */ 27: Reduce(48),
		/* SubGraph */ 31: Reduce(48),
		/* string_lit */ 33: Reduce(48),
		/* } */ 4: Reduce(48),
		/* -- */ 12: Reduce(48),
		/* Node */ 24: Reduce(48),
		/* EDGE */ 28: Reduce(48),
		/* ; */ 5: Reduce(48),
		/* int_lit */ 34: Reduce(48),
		/* graph */ 13: Reduce(48),
		/* NODE */ 25: Reduce(48),
		/* subgraph */ 29: Reduce(48),
	},
	/* state 124*/ ActionRow{
		/* NODE */ 25: Reduce(43),
		/* subgraph */ 29: Reduce(43),
		/* id */ 2: Reduce(43),
		/* float_lit */ 35: Reduce(43),
		/* Graph */ 14: Reduce(43),
		/* edge */ 26: Reduce(43),
		/* Subgraph */ 30: Reduce(43),
		/* { */ 3: Reduce(43),
		/* SUBGRAPH */ 32: Reduce(43),
		/* [ */ 7: Reduce(43),
		/* html_lit */ 36: Reduce(43),
		/* -> */ 11: Reduce(43),
		/* GRAPH */ 15: Reduce(43),
		/* node */ 23: Reduce(43),
		/* Edge */ 27: Reduce(43),
		/* SubGraph */ 31: Reduce(43),
		/* string_lit */ 33: Reduce(43),
		/* } */ 4: Reduce(43),
		/* -- */ 12: Reduce(43),
		/* Node */ 24: Reduce(43),
		/* EDGE */ 28: Reduce(43),
		/* ; */ 5: Reduce(43),
		/* int_lit */ 34: Reduce(43),
		/* graph */ 13: Reduce(43),
	},
	/* state 125*/ ActionRow{
		/* NODE */ 25: Reduce(42),
		/* subgraph */ 29: Reduce(42),
		/* id */ 2: Reduce(42),
		/* float_lit */ 35: Reduce(42),
		/* Graph */ 14: Reduce(42),
		/* edge */ 26: Reduce(42),
		/* Subgraph */ 30: Reduce(42),
		/* { */ 3: Reduce(42),
		/* SUBGRAPH */ 32: Reduce(42),
		/* [ */ 7: Reduce(42),
		/* html_lit */ 36: Reduce(42),
		/* -> */ 11: Reduce(42),
		/* GRAPH */ 15: Reduce(42),
		/* node */ 23: Reduce(42),
		/* Edge */ 27: Reduce(42),
		/* SubGraph */ 31: Reduce(42),
		/* string_lit */ 33: Reduce(42),
		/* } */ 4: Reduce(42),
		/* -- */ 12: Reduce(42),
		/* Node */ 24: Reduce(42),
		/* EDGE */ 28: Reduce(42),
		/* ; */ 5: Reduce(42),
		/* int_lit */ 34: Reduce(42),
		/* graph */ 13: Reduce(42),
	},
	/* state 126*/ ActionRow{
		/* int_lit */ 34: Shift(19),
		/* id */ 2: Shift(17),
		/* float_lit */ 35: Shift(20),
		/* { */ 3: Shift(148),
		/* html_lit */ 36: Shift(21),
		/* string_lit */ 33: Shift(18),
	},
	/* state 127*/ ActionRow{
		/* edge */ 26: Reduce(39),
		/* Subgraph */ 30: Reduce(39),
		/* { */ 3: Reduce(39),
		/* SUBGRAPH */ 32: Reduce(39),
		/* [ */ 7: Shift(97),
		/* html_lit */ 36: Reduce(39),
		/* GRAPH */ 15: Reduce(39),
		/* node */ 23: Reduce(39),
		/* Edge */ 27: Reduce(39),
		/* SubGraph */ 31: Reduce(39),
		/* string_lit */ 33: Reduce(39),
		/* } */ 4: Reduce(39),
		/* Node */ 24: Reduce(39),
		/* EDGE */ 28: Reduce(39),
		/* ; */ 5: Reduce(39),
		/* int_lit */ 34: Reduce(39),
		/* graph */ 13: Reduce(39),
		/* NODE */ 25: Reduce(39),
		/* subgraph */ 29: Reduce(39),
		/* id */ 2: Reduce(39),
		/* float_lit */ 35: Reduce(39),
		/* Graph */ 14: Reduce(39),
	},
	/* state 128*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(150),
	},
	/* state 129*/ ActionRow{
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
	},
	/* state 130*/ ActionRow{
		/* $ */ 0: Reduce(6),
	},
	/* state 131*/ ActionRow{
		/* $ */ 0: Reduce(7),
	},
	/* state 132*/ ActionRow{
		/* $ */ 0: Reduce(4),
	},
	/* state 133*/ ActionRow{
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(152),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
	},
	/* state 134*/ ActionRow{
		/* $ */ 0: Reduce(15),
	},
	/* state 135*/ ActionRow{
		/* $ */ 0: Reduce(12),
	},
	/* state 136*/ ActionRow{
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(153),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
	},
	/* state 137*/ ActionRow{
		/* $ */ 0: Reduce(14),
	},
	/* state 138*/ ActionRow{
		/* EDGE */ 28: Reduce(31),
		/* ; */ 5: Reduce(31),
		/* int_lit */ 34: Reduce(31),
		/* graph */ 13: Reduce(31),
		/* NODE */ 25: Reduce(31),
		/* subgraph */ 29: Reduce(31),
		/* id */ 2: Reduce(31),
		/* float_lit */ 35: Reduce(31),
		/* Graph */ 14: Reduce(31),
		/* edge */ 26: Reduce(31),
		/* Subgraph */ 30: Reduce(31),
		/* { */ 3: Reduce(31),
		/* SUBGRAPH */ 32: Reduce(31),
		/* [ */ 7: Reduce(31),
		/* html_lit */ 36: Reduce(31),
		/* GRAPH */ 15: Reduce(31),
		/* node */ 23: Reduce(31),
		/* Edge */ 27: Reduce(31),
		/* SubGraph */ 31: Reduce(31),
		/* string_lit */ 33: Reduce(31),
		/* } */ 4: Reduce(31),
		/* Node */ 24: Reduce(31),
	},
	/* state 139*/ ActionRow{
		/* int_lit */ 34: Shift(104),
		/* , */ 9: Shift(143),
		/* id */ 2: Shift(102),
		/* float_lit */ 35: Shift(105),
		/* html_lit */ 36: Shift(106),
		/* string_lit */ 33: Shift(103),
		/* ] */ 8: Shift(154),
	},
	/* state 140*/ ActionRow{
		/* id */ 2: Shift(156),
		/* float_lit */ 35: Shift(159),
		/* html_lit */ 36: Shift(160),
		/* string_lit */ 33: Shift(157),
		/* int_lit */ 34: Shift(158),
	},
	/* state 141*/ ActionRow{
		/* id */ 2: Reduce(30),
		/* float_lit */ 35: Reduce(30),
		/* Graph */ 14: Reduce(30),
		/* edge */ 26: Reduce(30),
		/* Subgraph */ 30: Reduce(30),
		/* { */ 3: Reduce(30),
		/* SUBGRAPH */ 32: Reduce(30),
		/* [ */ 7: Reduce(30),
		/* html_lit */ 36: Reduce(30),
		/* GRAPH */ 15: Reduce(30),
		/* node */ 23: Reduce(30),
		/* Edge */ 27: Reduce(30),
		/* SubGraph */ 31: Reduce(30),
		/* string_lit */ 33: Reduce(30),
		/* } */ 4: Reduce(30),
		/* Node */ 24: Reduce(30),
		/* EDGE */ 28: Reduce(30),
		/* ; */ 5: Reduce(30),
		/* int_lit */ 34: Reduce(30),
		/* graph */ 13: Reduce(30),
		/* NODE */ 25: Reduce(30),
		/* subgraph */ 29: Reduce(30),
	},
	/* state 142*/ ActionRow{
		/* html_lit */ 36: Reduce(34),
		/* string_lit */ 33: Reduce(34),
		/* ] */ 8: Reduce(34),
		/* int_lit */ 34: Reduce(34),
		/* , */ 9: Reduce(34),
		/* id */ 2: Reduce(34),
		/* float_lit */ 35: Reduce(34),
	},
	/* state 143*/ ActionRow{
		/* id */ 2: Shift(102),
		/* float_lit */ 35: Shift(105),
		/* html_lit */ 36: Shift(106),
		/* string_lit */ 33: Shift(103),
		/* int_lit */ 34: Shift(104),
	},
	/* state 144*/ ActionRow{
		/* id */ 2: Shift(163),
		/* float_lit */ 35: Shift(166),
		/* html_lit */ 36: Shift(167),
		/* string_lit */ 33: Shift(164),
		/* int_lit */ 34: Shift(165),
	},
	/* state 145*/ ActionRow{
		/* GRAPH */ 15: Reduce(45),
		/* node */ 23: Reduce(45),
		/* Edge */ 27: Reduce(45),
		/* SubGraph */ 31: Reduce(45),
		/* string_lit */ 33: Reduce(45),
		/* } */ 4: Reduce(45),
		/* -- */ 12: Reduce(45),
		/* Node */ 24: Reduce(45),
		/* EDGE */ 28: Reduce(45),
		/* ; */ 5: Reduce(45),
		/* int_lit */ 34: Reduce(45),
		/* graph */ 13: Reduce(45),
		/* NODE */ 25: Reduce(45),
		/* subgraph */ 29: Reduce(45),
		/* id */ 2: Reduce(45),
		/* float_lit */ 35: Reduce(45),
		/* Graph */ 14: Reduce(45),
		/* edge */ 26: Reduce(45),
		/* Subgraph */ 30: Reduce(45),
		/* { */ 3: Reduce(45),
		/* SUBGRAPH */ 32: Reduce(45),
		/* [ */ 7: Reduce(45),
		/* html_lit */ 36: Reduce(45),
		/* -> */ 11: Reduce(45),
	},
	/* state 146*/ ActionRow{
		/* edge */ 26: Reduce(44),
		/* Subgraph */ 30: Reduce(44),
		/* { */ 3: Reduce(44),
		/* SUBGRAPH */ 32: Reduce(44),
		/* [ */ 7: Reduce(44),
		/* html_lit */ 36: Reduce(44),
		/* -> */ 11: Reduce(44),
		/* GRAPH */ 15: Reduce(44),
		/* node */ 23: Reduce(44),
		/* Edge */ 27: Reduce(44),
		/* SubGraph */ 31: Reduce(44),
		/* string_lit */ 33: Reduce(44),
		/* } */ 4: Reduce(44),
		/* -- */ 12: Reduce(44),
		/* Node */ 24: Reduce(44),
		/* EDGE */ 28: Reduce(44),
		/* ; */ 5: Reduce(44),
		/* int_lit */ 34: Reduce(44),
		/* graph */ 13: Reduce(44),
		/* NODE */ 25: Reduce(44),
		/* subgraph */ 29: Reduce(44),
		/* id */ 2: Reduce(44),
		/* float_lit */ 35: Reduce(44),
		/* Graph */ 14: Reduce(44),
	},
	/* state 147*/ ActionRow{
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(168),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
	},
	/* state 148*/ ActionRow{
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
	},
	/* state 149*/ ActionRow{
		/* { */ 3: Shift(170),
	},
	/* state 150*/ ActionRow{
		/* id */ 2: Reduce(53),
		/* float_lit */ 35: Reduce(53),
		/* Graph */ 14: Reduce(53),
		/* edge */ 26: Reduce(53),
		/* Subgraph */ 30: Reduce(53),
		/* { */ 3: Reduce(53),
		/* SUBGRAPH */ 32: Reduce(53),
		/* html_lit */ 36: Reduce(53),
		/* -> */ 11: Reduce(53),
		/* GRAPH */ 15: Reduce(53),
		/* node */ 23: Reduce(53),
		/* Edge */ 27: Reduce(53),
		/* SubGraph */ 31: Reduce(53),
		/* string_lit */ 33: Reduce(53),
		/* } */ 4: Reduce(53),
		/* -- */ 12: Reduce(53),
		/* Node */ 24: Reduce(53),
		/* EDGE */ 28: Reduce(53),
		/* ; */ 5: Reduce(53),
		/* int_lit */ 34: Reduce(53),
		/* graph */ 13: Reduce(53),
		/* NODE */ 25: Reduce(53),
		/* subgraph */ 29: Reduce(53),
	},
	/* state 151*/ ActionRow{
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(171),
		/* Node */ 24: Shift(45),
	},
	/* state 152*/ ActionRow{
		/* $ */ 0: Reduce(8),
	},
	/* state 153*/ ActionRow{
		/* $ */ 0: Reduce(16),
	},
	/* state 154*/ ActionRow{
		/* ; */ 5: Reduce(32),
		/* int_lit */ 34: Reduce(32),
		/* graph */ 13: Reduce(32),
		/* NODE */ 25: Reduce(32),
		/* subgraph */ 29: Reduce(32),
		/* id */ 2: Reduce(32),
		/* float_lit */ 35: Reduce(32),
		/* Graph */ 14: Reduce(32),
		/* edge */ 26: Reduce(32),
		/* Subgraph */ 30: Reduce(32),
		/* { */ 3: Reduce(32),
		/* SUBGRAPH */ 32: Reduce(32),
		/* [ */ 7: Reduce(32),
		/* html_lit */ 36: Reduce(32),
		/* GRAPH */ 15: Reduce(32),
		/* node */ 23: Reduce(32),
		/* Edge */ 27: Reduce(32),
		/* SubGraph */ 31: Reduce(32),
		/* string_lit */ 33: Reduce(32),
		/* } */ 4: Reduce(32),
		/* Node */ 24: Reduce(32),
		/* EDGE */ 28: Reduce(32),
	},
	/* state 155*/ ActionRow{
		/* id */ 2: Reduce(37),
		/* float_lit */ 35: Reduce(37),
		/* html_lit */ 36: Reduce(37),
		/* string_lit */ 33: Reduce(37),
		/* ] */ 8: Reduce(37),
		/* int_lit */ 34: Reduce(37),
		/* , */ 9: Reduce(37),
	},
	/* state 156*/ ActionRow{
		/* html_lit */ 36: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* ] */ 8: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* , */ 9: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
	},
	/* state 157*/ ActionRow{
		/* int_lit */ 34: Reduce(78),
		/* , */ 9: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* html_lit */ 36: Reduce(78),
		/* string_lit */ 33: Reduce(78),
		/* ] */ 8: Reduce(78),
	},
	/* state 158*/ ActionRow{
		/* html_lit */ 36: Reduce(79),
		/* string_lit */ 33: Reduce(79),
		/* ] */ 8: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* , */ 9: Reduce(79),
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
	},
	/* state 159*/ ActionRow{
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* html_lit */ 36: Reduce(80),
		/* string_lit */ 33: Reduce(80),
		/* ] */ 8: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* , */ 9: Reduce(80),
	},
	/* state 160*/ ActionRow{
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* ] */ 8: Reduce(81),
		/* int_lit */ 34: Reduce(81),
		/* , */ 9: Reduce(81),
	},
	/* state 161*/ ActionRow{
		/* string_lit */ 33: Reduce(35),
		/* ] */ 8: Reduce(35),
		/* int_lit */ 34: Reduce(35),
		/* , */ 9: Reduce(35),
		/* id */ 2: Reduce(35),
		/* float_lit */ 35: Reduce(35),
		/* html_lit */ 36: Reduce(35),
	},
	/* state 162*/ ActionRow{
		/* { */ 3: Reduce(51),
		/* SUBGRAPH */ 32: Reduce(51),
		/* [ */ 7: Reduce(51),
		/* html_lit */ 36: Reduce(51),
		/* -> */ 11: Reduce(51),
		/* GRAPH */ 15: Reduce(51),
		/* node */ 23: Reduce(51),
		/* Edge */ 27: Reduce(51),
		/* SubGraph */ 31: Reduce(51),
		/* string_lit */ 33: Reduce(51),
		/* } */ 4: Reduce(51),
		/* -- */ 12: Reduce(51),
		/* Node */ 24: Reduce(51),
		/* EDGE */ 28: Reduce(51),
		/* ; */ 5: Reduce(51),
		/* int_lit */ 34: Reduce(51),
		/* graph */ 13: Reduce(51),
		/* NODE */ 25: Reduce(51),
		/* subgraph */ 29: Reduce(51),
		/* id */ 2: Reduce(51),
		/* float_lit */ 35: Reduce(51),
		/* Graph */ 14: Reduce(51),
		/* edge */ 26: Reduce(51),
		/* Subgraph */ 30: Reduce(51),
	},
	/* state 163*/ ActionRow{
		/* Node */ 24: Reduce(77),
		/* EDGE */ 28: Reduce(77),
		/* ; */ 5: Reduce(77),
		/* int_lit */ 34: Reduce(77),
		/* graph */ 13: Reduce(77),
		/* NODE */ 25: Reduce(77),
		/* subgraph */ 29: Reduce(77),
		/* id */ 2: Reduce(77),
		/* float_lit */ 35: Reduce(77),
		/* Graph */ 14: Reduce(77),
		/* edge */ 26: Reduce(77),
		/* Subgraph */ 30: Reduce(77),
		/* { */ 3: Reduce(77),
		/* SUBGRAPH */ 32: Reduce(77),
		/* [ */ 7: Reduce(77),
		/* html_lit */ 36: Reduce(77),
		/* -> */ 11: Reduce(77),
		/* GRAPH */ 15: Reduce(77),
		/* node */ 23: Reduce(77),
		/* Edge */ 27: Reduce(77),
		/* SubGraph */ 31: Reduce(77),
		/* string_lit */ 33: Reduce(77),
		/* } */ 4: Reduce(77),
		/* -- */ 12: Reduce(77),
	},
	/* state 164*/ ActionRow{
		/* node */ 23: Reduce(78),
		/* Edge */ 27: Reduce(78),
		/* SubGraph */ 31: Reduce(78),
		/* string_lit */ 33: Reduce(78),
		/* } */ 4: Reduce(78),
		/* -- */ 12: Reduce(78),
		/* Node */ 24: Reduce(78),
		/* EDGE */ 28: Reduce(78),
		/* ; */ 5: Reduce(78),
		/* int_lit */ 34: Reduce(78),
		/* graph */ 13: Reduce(78),
		/* NODE */ 25: Reduce(78),
		/* subgraph */ 29: Reduce(78),
		/* id */ 2: Reduce(78),
		/* float_lit */ 35: Reduce(78),
		/* Graph */ 14: Reduce(78),
		/* edge */ 26: Reduce(78),
		/* Subgraph */ 30: Reduce(78),
		/* { */ 3: Reduce(78),
		/* SUBGRAPH */ 32: Reduce(78),
		/* [ */ 7: Reduce(78),
		/* html_lit */ 36: Reduce(78),
		/* -> */ 11: Reduce(78),
		/* GRAPH */ 15: Reduce(78),
	},
	/* state 165*/ ActionRow{
		/* SubGraph */ 31: Reduce(79),
		/* string_lit */ 33: Reduce(79),
		/* } */ 4: Reduce(79),
		/* -- */ 12: Reduce(79),
		/* Node */ 24: Reduce(79),
		/* EDGE */ 28: Reduce(79),
		/* ; */ 5: Reduce(79),
		/* int_lit */ 34: Reduce(79),
		/* graph */ 13: Reduce(79),
		/* NODE */ 25: Reduce(79),
		/* subgraph */ 29: Reduce(79),
		/* id */ 2: Reduce(79),
		/* float_lit */ 35: Reduce(79),
		/* Graph */ 14: Reduce(79),
		/* edge */ 26: Reduce(79),
		/* Subgraph */ 30: Reduce(79),
		/* { */ 3: Reduce(79),
		/* SUBGRAPH */ 32: Reduce(79),
		/* [ */ 7: Reduce(79),
		/* html_lit */ 36: Reduce(79),
		/* -> */ 11: Reduce(79),
		/* GRAPH */ 15: Reduce(79),
		/* node */ 23: Reduce(79),
		/* Edge */ 27: Reduce(79),
	},
	/* state 166*/ ActionRow{
		/* EDGE */ 28: Reduce(80),
		/* ; */ 5: Reduce(80),
		/* int_lit */ 34: Reduce(80),
		/* graph */ 13: Reduce(80),
		/* NODE */ 25: Reduce(80),
		/* subgraph */ 29: Reduce(80),
		/* id */ 2: Reduce(80),
		/* float_lit */ 35: Reduce(80),
		/* Graph */ 14: Reduce(80),
		/* edge */ 26: Reduce(80),
		/* Subgraph */ 30: Reduce(80),
		/* { */ 3: Reduce(80),
		/* SUBGRAPH */ 32: Reduce(80),
		/* [ */ 7: Reduce(80),
		/* html_lit */ 36: Reduce(80),
		/* -> */ 11: Reduce(80),
		/* GRAPH */ 15: Reduce(80),
		/* node */ 23: Reduce(80),
		/* Edge */ 27: Reduce(80),
		/* SubGraph */ 31: Reduce(80),
		/* string_lit */ 33: Reduce(80),
		/* } */ 4: Reduce(80),
		/* -- */ 12: Reduce(80),
		/* Node */ 24: Reduce(80),
	},
	/* state 167*/ ActionRow{
		/* Graph */ 14: Reduce(81),
		/* edge */ 26: Reduce(81),
		/* Subgraph */ 30: Reduce(81),
		/* { */ 3: Reduce(81),
		/* SUBGRAPH */ 32: Reduce(81),
		/* [ */ 7: Reduce(81),
		/* html_lit */ 36: Reduce(81),
		/* -> */ 11: Reduce(81),
		/* GRAPH */ 15: Reduce(81),
		/* node */ 23: Reduce(81),
		/* Edge */ 27: Reduce(81),
		/* SubGraph */ 31: Reduce(81),
		/* string_lit */ 33: Reduce(81),
		/* } */ 4: Reduce(81),
		/* -- */ 12: Reduce(81),
		/* Node */ 24: Reduce(81),
		/* EDGE */ 28: Reduce(81),
		/* ; */ 5: Reduce(81),
		/* int_lit */ 34: Reduce(81),
		/* graph */ 13: Reduce(81),
		/* NODE */ 25: Reduce(81),
		/* subgraph */ 29: Reduce(81),
		/* id */ 2: Reduce(81),
		/* float_lit */ 35: Reduce(81),
	},
	/* state 168*/ ActionRow{
		/* html_lit */ 36: Reduce(52),
		/* -> */ 11: Reduce(52),
		/* GRAPH */ 15: Reduce(52),
		/* node */ 23: Reduce(52),
		/* Edge */ 27: Reduce(52),
		/* SubGraph */ 31: Reduce(52),
		/* string_lit */ 33: Reduce(52),
		/* } */ 4: Reduce(52),
		/* -- */ 12: Reduce(52),
		/* Node */ 24: Reduce(52),
		/* EDGE */ 28: Reduce(52),
		/* ; */ 5: Reduce(52),
		/* int_lit */ 34: Reduce(52),
		/* graph */ 13: Reduce(52),
		/* NODE */ 25: Reduce(52),
		/* subgraph */ 29: Reduce(52),
		/* id */ 2: Reduce(52),
		/* float_lit */ 35: Reduce(52),
		/* Graph */ 14: Reduce(52),
		/* edge */ 26: Reduce(52),
		/* Subgraph */ 30: Reduce(52),
		/* { */ 3: Reduce(52),
		/* SUBGRAPH */ 32: Reduce(52),
		/* [ */ 7: Reduce(52),
	},
	/* state 169*/ ActionRow{
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(172),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
	},
	/* state 170*/ ActionRow{
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
		/* string_lit */ 33: Shift(55),
	},
	/* state 171*/ ActionRow{
		/* html_lit */ 36: Reduce(54),
		/* -> */ 11: Reduce(54),
		/* GRAPH */ 15: Reduce(54),
		/* node */ 23: Reduce(54),
		/* Edge */ 27: Reduce(54),
		/* SubGraph */ 31: Reduce(54),
		/* string_lit */ 33: Reduce(54),
		/* } */ 4: Reduce(54),
		/* -- */ 12: Reduce(54),
		/* Node */ 24: Reduce(54),
		/* EDGE */ 28: Reduce(54),
		/* ; */ 5: Reduce(54),
		/* int_lit */ 34: Reduce(54),
		/* graph */ 13: Reduce(54),
		/* NODE */ 25: Reduce(54),
		/* subgraph */ 29: Reduce(54),
		/* id */ 2: Reduce(54),
		/* float_lit */ 35: Reduce(54),
		/* Graph */ 14: Reduce(54),
		/* edge */ 26: Reduce(54),
		/* Subgraph */ 30: Reduce(54),
		/* { */ 3: Reduce(54),
		/* SUBGRAPH */ 32: Reduce(54),
	},
	/* state 172*/ ActionRow{
		/* NODE */ 25: Reduce(53),
		/* subgraph */ 29: Reduce(53),
		/* id */ 2: Reduce(53),
		/* float_lit */ 35: Reduce(53),
		/* Graph */ 14: Reduce(53),
		/* edge */ 26: Reduce(53),
		/* Subgraph */ 30: Reduce(53),
		/* { */ 3: Reduce(53),
		/* SUBGRAPH */ 32: Reduce(53),
		/* [ */ 7: Reduce(53),
		/* html_lit */ 36: Reduce(53),
		/* -> */ 11: Reduce(53),
		/* GRAPH */ 15: Reduce(53),
		/* node */ 23: Reduce(53),
		/* Edge */ 27: Reduce(53),
		/* SubGraph */ 31: Reduce(53),
		/* string_lit */ 33: Reduce(53),
		/* } */ 4: Reduce(53),
		/* -- */ 12: Reduce(53),
		/* Node */ 24: Reduce(53),
		/* EDGE */ 28: Reduce(53),
		/* ; */ 5: Reduce(53),
		/* int_lit */ 34: Reduce(53),
		/* graph */ 13: Reduce(53),
	},
	/* state 173*/ ActionRow{
		/* string_lit */ 33: Shift(55),
		/* } */ 4: Shift(174),
		/* Node */ 24: Shift(45),
		/* EDGE */ 28: Shift(49),
		/* int_lit */ 34: Shift(56),
		/* graph */ 13: Shift(41),
		/* NODE */ 25: Shift(46),
		/* subgraph */ 29: Shift(50),
		/* id */ 2: Shift(54),
		/* float_lit */ 35: Shift(57),
		/* Graph */ 14: Shift(42),
		/* edge */ 26: Shift(47),
		/* Subgraph */ 30: Shift(51),
		/* { */ 3: Shift(27),
		/* SUBGRAPH */ 32: Shift(53),
		/* html_lit */ 36: Shift(58),
		/* GRAPH */ 15: Shift(43),
		/* node */ 23: Shift(44),
		/* Edge */ 27: Shift(48),
		/* SubGraph */ 31: Shift(52),
	},
	/* state 174*/ ActionRow{
		/* NODE */ 25: Reduce(54),
		/* subgraph */ 29: Reduce(54),
		/* id */ 2: Reduce(54),
		/* float_lit */ 35: Reduce(54),
		/* Graph */ 14: Reduce(54),
		/* edge */ 26: Reduce(54),
		/* Subgraph */ 30: Reduce(54),
		/* { */ 3: Reduce(54),
		/* SUBGRAPH */ 32: Reduce(54),
		/* [ */ 7: Reduce(54),
		/* html_lit */ 36: Reduce(54),
		/* -> */ 11: Reduce(54),
		/* GRAPH */ 15: Reduce(54),
		/* node */ 23: Reduce(54),
		/* Edge */ 27: Reduce(54),
		/* SubGraph */ 31: Reduce(54),
		/* string_lit */ 33: Reduce(54),
		/* } */ 4: Reduce(54),
		/* -- */ 12: Reduce(54),
		/* Node */ 24: Reduce(54),
		/* EDGE */ 28: Reduce(54),
		/* ; */ 5: Reduce(54),
		/* int_lit */ 34: Reduce(54),
		/* graph */ 13: Reduce(54),
	},
}

var GotoTable GotoTab = GotoTab{
	/* state 0*/ GotoRow{
		"Strict":   State(3),
		"Digraph":  State(4),
		"Graph":    State(2),
		"DotGraph": State(1),
	},
	/* state 1*/ GotoRow{},
	/* state 2*/ GotoRow{
		"Id": State(16),
	},
	/* state 3*/ GotoRow{
		"Graph":   State(22),
		"Digraph": State(23),
	},
	/* state 4*/ GotoRow{
		"Id": State(25),
	},
	/* state 5*/ GotoRow{},
	/* state 6*/ GotoRow{},
	/* state 7*/ GotoRow{},
	/* state 8*/ GotoRow{},
	/* state 9*/ GotoRow{},
	/* state 10*/ GotoRow{},
	/* state 11*/ GotoRow{},
	/* state 12*/ GotoRow{},
	/* state 13*/ GotoRow{},
	/* state 14*/ GotoRow{},
	/* state 15*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(30),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 16*/ GotoRow{},
	/* state 17*/ GotoRow{},
	/* state 18*/ GotoRow{},
	/* state 19*/ GotoRow{},
	/* state 20*/ GotoRow{},
	/* state 21*/ GotoRow{},
	/* state 22*/ GotoRow{
		"Id": State(61),
	},
	/* state 23*/ GotoRow{
		"Id": State(63),
	},
	/* state 24*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(65),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 25*/ GotoRow{},
	/* state 26*/ GotoRow{
		"AttrList": State(67),
	},
	/* state 27*/ GotoRow{
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(69),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
	},
	/* state 28*/ GotoRow{},
	/* state 29*/ GotoRow{
		"Port": State(71),
	},
	/* state 30*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 31*/ GotoRow{},
	/* state 32*/ GotoRow{},
	/* state 33*/ GotoRow{},
	/* state 34*/ GotoRow{},
	/* state 35*/ GotoRow{},
	/* state 36*/ GotoRow{
		"EdgeRHS": State(76),
		"EdgeOp":  State(77),
	},
	/* state 37*/ GotoRow{
		"AttrList": State(80),
	},
	/* state 38*/ GotoRow{
		"AttrList": State(81),
	},
	/* state 39*/ GotoRow{
		"AttrList": State(82),
		"EdgeRHS":  State(83),
		"EdgeOp":   State(77),
	},
	/* state 40*/ GotoRow{
		"Id": State(85),
	},
	/* state 41*/ GotoRow{},
	/* state 42*/ GotoRow{},
	/* state 43*/ GotoRow{},
	/* state 44*/ GotoRow{},
	/* state 45*/ GotoRow{},
	/* state 46*/ GotoRow{},
	/* state 47*/ GotoRow{},
	/* state 48*/ GotoRow{},
	/* state 49*/ GotoRow{},
	/* state 50*/ GotoRow{},
	/* state 51*/ GotoRow{},
	/* state 52*/ GotoRow{},
	/* state 53*/ GotoRow{},
	/* state 54*/ GotoRow{},
	/* state 55*/ GotoRow{},
	/* state 56*/ GotoRow{},
	/* state 57*/ GotoRow{},
	/* state 58*/ GotoRow{},
	/* state 59*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(87),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 60*/ GotoRow{
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(89),
		"SubGraphStmt": State(36),
		"Id":           State(29),
	},
	/* state 61*/ GotoRow{},
	/* state 62*/ GotoRow{
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(92),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
	},
	/* state 63*/ GotoRow{},
	/* state 64*/ GotoRow{},
	/* state 65*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 66*/ GotoRow{
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(96),
		"SubGraphStmt": State(36),
		"Id":           State(29),
	},
	/* state 67*/ GotoRow{},
	/* state 68*/ GotoRow{
		"Attr":  State(101),
		"Id":    State(98),
		"AList": State(100),
	},
	/* state 69*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 70*/ GotoRow{
		"Id": State(108),
	},
	/* state 71*/ GotoRow{},
	/* state 72*/ GotoRow{
		"Id": State(114),
	},
	/* state 73*/ GotoRow{},
	/* state 74*/ GotoRow{},
	/* state 75*/ GotoRow{},
	/* state 76*/ GotoRow{
		"AttrList": State(120),
		"EdgeOp":   State(121),
	},
	/* state 77*/ GotoRow{
		"Subgraph":     State(126),
		"SubGraphStmt": State(124),
		"Id":           State(123),
		"NodeId":       State(125),
	},
	/* state 78*/ GotoRow{},
	/* state 79*/ GotoRow{},
	/* state 80*/ GotoRow{},
	/* state 81*/ GotoRow{},
	/* state 82*/ GotoRow{},
	/* state 83*/ GotoRow{
		"EdgeOp":   State(121),
		"AttrList": State(127),
	},
	/* state 84*/ GotoRow{
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(128),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
	},
	/* state 85*/ GotoRow{},
	/* state 86*/ GotoRow{},
	/* state 87*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 88*/ GotoRow{},
	/* state 89*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 90*/ GotoRow{
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(133),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
	},
	/* state 91*/ GotoRow{},
	/* state 92*/ GotoRow{
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
	},
	/* state 93*/ GotoRow{
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(136),
		"SubGraphStmt": State(36),
		"Id":           State(29),
	},
	/* state 94*/ GotoRow{},
	/* state 95*/ GotoRow{},
	/* state 96*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 97*/ GotoRow{
		"Id":    State(98),
		"AList": State(139),
		"Attr":  State(101),
	},
	/* state 98*/ GotoRow{},
	/* state 99*/ GotoRow{},
	/* state 100*/ GotoRow{
		"Attr": State(142),
		"Id":   State(98),
	},
	/* state 101*/ GotoRow{},
	/* state 102*/ GotoRow{},
	/* state 103*/ GotoRow{},
	/* state 104*/ GotoRow{},
	/* state 105*/ GotoRow{},
	/* state 106*/ GotoRow{},
	/* state 107*/ GotoRow{},
	/* state 108*/ GotoRow{},
	/* state 109*/ GotoRow{},
	/* state 110*/ GotoRow{},
	/* state 111*/ GotoRow{},
	/* state 112*/ GotoRow{},
	/* state 113*/ GotoRow{},
	/* state 114*/ GotoRow{},
	/* state 115*/ GotoRow{},
	/* state 116*/ GotoRow{},
	/* state 117*/ GotoRow{},
	/* state 118*/ GotoRow{},
	/* state 119*/ GotoRow{},
	/* state 120*/ GotoRow{},
	/* state 121*/ GotoRow{
		"Subgraph":     State(126),
		"SubGraphStmt": State(145),
		"Id":           State(123),
		"NodeId":       State(146),
	},
	/* state 122*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(147),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 123*/ GotoRow{
		"Port": State(71),
	},
	/* state 124*/ GotoRow{},
	/* state 125*/ GotoRow{},
	/* state 126*/ GotoRow{
		"Id": State(149),
	},
	/* state 127*/ GotoRow{},
	/* state 128*/ GotoRow{
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
	},
	/* state 129*/ GotoRow{
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(151),
		"SubGraphStmt": State(36),
	},
	/* state 130*/ GotoRow{},
	/* state 131*/ GotoRow{},
	/* state 132*/ GotoRow{},
	/* state 133*/ GotoRow{
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
	},
	/* state 134*/ GotoRow{},
	/* state 135*/ GotoRow{},
	/* state 136*/ GotoRow{
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
	},
	/* state 137*/ GotoRow{},
	/* state 138*/ GotoRow{},
	/* state 139*/ GotoRow{
		"Id":   State(98),
		"Attr": State(142),
	},
	/* state 140*/ GotoRow{
		"Id": State(155),
	},
	/* state 141*/ GotoRow{},
	/* state 142*/ GotoRow{},
	/* state 143*/ GotoRow{
		"Id":   State(98),
		"Attr": State(161),
	},
	/* state 144*/ GotoRow{
		"Id": State(162),
	},
	/* state 145*/ GotoRow{},
	/* state 146*/ GotoRow{},
	/* state 147*/ GotoRow{
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
	},
	/* state 148*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(169),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 149*/ GotoRow{},
	/* state 150*/ GotoRow{},
	/* state 151*/ GotoRow{
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
	},
	/* state 152*/ GotoRow{},
	/* state 153*/ GotoRow{},
	/* state 154*/ GotoRow{},
	/* state 155*/ GotoRow{},
	/* state 156*/ GotoRow{},
	/* state 157*/ GotoRow{},
	/* state 158*/ GotoRow{},
	/* state 159*/ GotoRow{},
	/* state 160*/ GotoRow{},
	/* state 161*/ GotoRow{},
	/* state 162*/ GotoRow{},
	/* state 163*/ GotoRow{},
	/* state 164*/ GotoRow{},
	/* state 165*/ GotoRow{},
	/* state 166*/ GotoRow{},
	/* state 167*/ GotoRow{},
	/* state 168*/ GotoRow{},
	/* state 169*/ GotoRow{
		"Stmt1":        State(74),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
	},
	/* state 170*/ GotoRow{
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(31),
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"StmtList":     State(173),
	},
	/* state 171*/ GotoRow{},
	/* state 172*/ GotoRow{},
	/* state 173*/ GotoRow{
		"NodeStmt":     State(33),
		"Node":         State(37),
		"Stmt":         State(32),
		"NodeId":       State(39),
		"Graph":        State(26),
		"Edge":         State(38),
		"AttrStmt":     State(35),
		"EdgeStmt":     State(34),
		"Subgraph":     State(40),
		"SubGraphStmt": State(36),
		"Id":           State(29),
		"Stmt1":        State(74),
	},
	/* state 174*/ GotoRow{},
}
