type file = {
  name : string;
  fd : Unix.file_descr;
  mtime : float;
  mutable mtime_counter : int;
  range_low : int;
  range_high : int;
}
and pool = {
  mutable count : int;
  mutable files : file array;
  mutable high : int;
}
and virtual_string = { beginning : int; length : int; }
and t = Real of string | Virtual of virtual_string
exception Error of string
exception Not_real
exception File_out_of_date of string
val sf : ('a, unit, string) format -> 'a
val create : unit -> pool
val add_file : pool -> string -> Unix.file_descr -> int
val find_file : pool -> int -> int
val make_virtual_string : pool -> int -> int -> int -> t
val empty_string : t
val is_empty : t -> bool
val make_real_string : string -> t
val get_real_string : 'a -> t -> string
val check_mtime_every : int ref
val mtime_counter : int ref
val get_string : pool -> t -> string
