/*
 *   This file is part of Auralquiz
 *   Copyright 2011-2012  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QtGui/QApplication>
#include <QTranslator>
#include <iostream>

#include "auralwindow.h"

int main(int argc, char *argv[])
{
    QApplication auralApp(argc, argv);

    auralApp.setApplicationName("Auralquiz");
    auralApp.setApplicationVersion("0.8.1");
    auralApp.setOrganizationName("JanCoding");
    auralApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("%1 v%2 - JanKusanagi 2011-2012\n")
                  .arg(auralApp.applicationName())
                  .arg(auralApp.applicationVersion()).toStdString();
    std::cout.flush();

    // Enable localization
    QTranslator translator;
    QString languageFile;
    // get LANG environment variable, and generate the resource filename
    languageFile = QString(":/translations/auralquiz_%1").arg(qgetenv("LANG").constData());
    qDebug() << "Language file:" << languageFile;

    translator.load(languageFile);
    auralApp.installTranslator(&translator);

    AuralWindow auralWindow;
    auralWindow.show();

    return auralApp.exec();
}
