//
// BAGEL - Parallel electron correlation program.
// Filename: _breitroot_5.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot5(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[5] = {4.313988071478515e-01,1.759753698423697e+00,4.104465362828315e+00,7.746703779542557e+00,1.345767835205758e+01
    };
  constexpr double aw[5] = {1.852252850037293e-01,2.062921868847264e-01,4.888991002659035e-02,2.686707670585993e-03,1.937314074696786e-05
    };
  constexpr double x[1920] = {  1.345015754586262e-01, -5.256134243437009e-03,  1.434259022232678e-04, -3.112703161984571e-06,  5.186105352634832e-08,
 -4.887037473709479e-10, -6.643392396540148e-12,  4.842321961203824e-13, -1.456146255045210e-14,  2.828748746290356e-16, -2.663936376533926e-18, -6.277879455500483e-20,
  5.062362055756694e-01, -1.608417761939236e-02,  2.584901742387758e-04, -1.304659737936685e-07, -1.073762051090822e-07,  2.326154731143053e-09,  1.068839018942707e-11,
 -1.695319480247359e-12,  3.198758129048375e-14,  4.090069527627482e-16, -3.297045308980945e-17,  4.928596961452547e-19,  1.022808726793804e+00, -2.173085537145793e-02,
 -6.442862959830311e-06,  6.829921655467744e-06,  1.385630099097278e-09, -3.876769706836079e-09,  3.266211928104183e-13,  2.664686529413005e-12, -1.734972695430386e-15,
 -2.047982696033401e-15,  1.789872028792495e-18,  1.654802855005481e-18,  1.542933210042146e+00, -1.569195498468502e-02, -2.792858172469525e-04, -6.712947162121623e-07,
  1.133055936227211e-07,  2.879087786771281e-09, -4.405353572641798e-12, -2.051517879645309e-12, -4.681028826133213e-14,  3.644298469035821e-16,  4.461679365920613e-17,
  8.182128258743323e-19,  1.905996636593092e+00, -4.054360262755481e-03, -1.244456057751349e-04, -3.139248077225449e-06, -6.561831398053234e-08, -1.042485401603335e-09,
 -7.275397626582572e-12,  2.795178035538437e-13,  1.553522082263864e-14,  4.697675156719942e-16,  9.725597716092394e-18,  9.931356048795261e-20,  1.155541756529709e-01,
 -4.244810249401094e-03,  1.107120817664990e-04, -2.366006700408232e-06,  4.135566512157959e-08, -5.295007778333553e-10,  1.759190780556056e-12,  1.581147992794712e-13,
 -6.543117120605034e-15,  1.637999093446078e-16, -2.622475254795796e-18,  3.190464822319083e-20,  4.459888784686309e-01, -1.404816993133068e-02,  2.481580051823940e-04,
 -1.476327050389526e-06, -6.150668126288638e-08,  2.134417515146045e-09, -2.176848984963923e-11, -6.412161119018377e-13,  2.915572363800207e-14, -3.894150198088652e-16,
 -6.992874182862338e-18,  5.077931200754615e-19,  9.362942096458250e-01, -2.145995252388842e-02,  7.315912825678858e-05,  6.256648885376707e-06, -7.033663526961125e-08,
 -3.044128315484229e-09,  6.395529763922508e-11,  1.575546415481369e-12, -5.841063939976981e-14, -7.533813436764239e-16,  5.278992222315517e-17,  3.150125915878174e-19,
  1.475694898808227e+00, -1.792341404412958e-02, -2.746425169524583e-04,  1.574216303564378e-06,  1.644033691933054e-07,  1.940622117837967e-09, -7.807729191174774e-11,
 -2.944812529487291e-12,  3.835919097849360e-15,  2.474377973858486e-15,  4.676438839829151e-17, -1.094096385104217e-18,  1.887522140680482e+00, -5.220085316905125e-03,
 -1.691245162222228e-04, -4.361526399383914e-06, -8.721323156253061e-08, -1.048532875096920e-09,  1.062314956852395e-11,  1.127632574900114e-12,  3.996668202367273e-14,
  8.792828791101085e-16,  7.978651411973311e-18, -2.944813047557610e-19,  1.001813569989482e-01, -3.462217146792249e-03,  8.595133266450906e-05, -1.785599402790786e-06,
  3.144488582386991e-08, -4.530211207914449e-10,  4.012941097126101e-12,  2.551901318422006e-14, -2.211372328169082e-15,  8.449523944375476e-17, -1.493096216502879e-18,
  1.317892431334009e-20,  3.936349239621018e-01, -1.214746272986261e-02,  2.258417055333264e-04, -2.151698129549062e-06, -2.501112825960043e-08,  1.488001707432353e-09,
 -2.893992951086990e-11,  4.902086506275187e-14,  1.423695564794720e-14, -3.603266337217938e-16,  5.024297467810360e-18,  5.020747115286087e-20,  8.520680953873863e-01,
 -2.059751880170118e-02,  1.397790463583031e-04,  4.738622165635382e-06, -1.134412112328203e-07, -1.201507241740255e-09,  8.071389455408126e-11, -3.279374645761097e-13,
 -4.942513092326516e-14,  1.076840334448972e-15,  2.740167659322205e-17, -1.198865162992505e-18,  1.399792625609254e+00, -1.999811999036137e-02, -2.390916752687790e-04,
  4.386728115374596e-06,  1.782562074515518e-07, -8.168505091081101e-10, -1.436358141996079e-10, -1.178757922149344e-12,  1.076842723467807e-13,  2.606777321858042e-15,
 -5.511713073673660e-17, -3.026466817979097e-18,  1.863568932498206e+00, -6.807595277754282e-03, -2.304460237346778e-04, -5.897126521380897e-06, -1.022007819086068e-07,
 -2.396746644928589e-10,  6.506474314546409e-11,  2.930798421094874e-12,  7.130986751580768e-14,  5.962743461594257e-16, -3.333340180019574e-17, -1.838277769986735e-18,
  8.758321489545780e-02, -2.852416107340180e-03,  6.726119378482324e-05, -1.349600540723524e-06,  2.337461229779770e-08, -3.537141977609928e-10,  4.116265440195612e-12,
 -7.403791843126132e-15, -1.687616160301658e-16,  2.976436237134875e-17, -1.350562757749992e-18, -1.170836246374134e-21,  3.484880868351498e-01, -1.044879145166830e-02,
  1.984832961196626e-04, -2.350280426615823e-06, -1.865205351396595e-09,  8.508012604152841e-10, -2.286430173703833e-11,  3.349022575328621e-13,  4.647702259315682e-15,
 -1.938476943944805e-16,  2.061012821089861e-18, -1.209699683595036e-19,  7.722294799615497e-01, -1.928385785353604e-02,  1.852849377318396e-04,  2.830747371176356e-06,
 -1.195963503432448e-07,  4.874762604787527e-10,  5.611177257695367e-11, -1.183357511810246e-12, -3.842196388561578e-15,  1.123942535751857e-15, -2.154770607642665e-17,
 -7.491408318664834e-19,  1.316373320460758e+00, -2.165428724493930e-02, -1.704959493483062e-04,  6.917526270569390e-06,  1.270784049098631e-07, -4.205355246027230e-09,
 -1.187224498590691e-10,  3.107675390929132e-12,  1.341127420361238e-13, -1.689792678193275e-15, -1.343402108089451e-16,  3.645232158207996e-19,  1.832164394267260e+00,
 -8.961679361033599e-03, -3.108184613463596e-04, -7.453174818062215e-06, -8.336330998562640e-08,  2.570408671264952e-09,  1.793387294990632e-10,  5.097596483786334e-12,
  4.274388260770705e-14, -3.066941268233842e-15, -1.657265258313656e-16, -3.866276927733517e-18,  7.715547042100844e-02, -2.373252622751191e-03,  5.309368707208877e-05,
 -1.026905851946053e-06,  1.727112967976791e-08, -2.574042547827419e-10,  3.920270525579641e-12, -6.022977358491459e-15, -5.465780248397966e-17, -2.187773719795970e-17,
 -1.099072236645926e-18,  1.663732670942574e-20,  3.096907976523641e-01, -8.973129585933890e-03,  1.705750880078188e-04, -2.270398868432178e-06,  1.048372528417155e-08,
  4.252704065870554e-10, -1.239621062369959e-11,  3.784987255418054e-13, -1.955231502479644e-15, -1.957800695290346e-16, -1.270856575977607e-18, -3.363743715237380e-21,
  6.982293273815059e-01, -1.769707183149709e-02,  2.083009314237374e-04,  1.057266457514030e-06, -9.900271100956396e-08,  1.452877797095483e-09,  2.588040943986919e-11,
 -8.692551534471288e-13,  1.627693754383723e-14, -5.619041102265393e-17, -2.933755398374542e-17,  3.444496192592602e-19,  1.227593288956244e+00, -2.265886746384634e-02,
 -7.846355795467144e-05,  8.160353917662222e-06,  2.366656490129117e-08, -5.616295418417225e-09,  1.248780831887177e-11,  5.514863408585387e-12, -5.455740600503859e-15,
 -5.245535734747479e-15, -1.460366650783755e-17,  4.158155452329200e-18,  1.790753493764477e+00, -1.182298175158516e-02, -4.056700243812226e-04, -8.092373018511207e-06,
  2.282153667405263e-08,  8.586381538254022e-09,  3.137225478917450e-10,  3.122665042165434e-12, -2.211880282295414e-13, -1.211098553791543e-14, -2.286287149243055e-16,
  4.456673136209536e-18,  6.844007177968267e-02, -1.993455241431264e-03,  4.227532678078415e-05, -7.867132719666803e-07,  1.304517778221115e-08, -1.665249050030751e-10,
  3.559182617896716e-12, -2.688297105865187e-14, -1.373231945534099e-15, -4.177338673968650e-17,  3.633120386013119e-19,  5.202253677363348e-20,  2.763596969507145e-01,
 -7.714097990789662e-03,  1.445744070394568e-04, -2.047391049775387e-06,  1.680717928620488e-08,  2.410572863531042e-10, -3.789121906695021e-12,  1.963852400497114e-13,
 -9.444819142905452e-15, -1.930739885785546e-16,  2.872895281552514e-18,  1.971017664926249e-19,  6.308193325998728e-01, -1.600445378499320e-02,  2.125318261940351e-04,
 -2.678807820498142e-07, -6.543548158496653e-08,  1.831807484267337e-09,  7.150475194826118e-12, -5.647606200735400e-13, -1.315157471213928e-15, -7.262176718519098e-16,
 -2.104325181087624e-19,  8.968112932977883e-19,  1.136320862353498e+00, -2.289662108976754e-02,  1.821644495731544e-05,  7.706637009685715e-06, -7.398375259914018e-08,
 -3.653232220248561e-09,  1.372635269856272e-10,  2.545927287103036e-12, -1.639907347548119e-13, -2.612582031664803e-15,  1.262027252048061e-16,  1.606175868132341e-18,
  1.736385232329152e+00, -1.543478958353554e-02, -4.935611454291464e-04, -5.934626908779642e-06,  2.709053020987922e-07,  1.591658164455212e-08,  2.282982688086272e-10,
 -1.186898301227100e-11, -7.053529580251534e-13, -9.494715900756244e-15,  5.748250178970899e-16,  3.249531169249893e-17,  6.108757740310086e-02, -1.689691229964787e-03,
  3.399128275586627e-05, -6.003543518929690e-07,  1.047711126016210e-08, -9.626917673050704e-11,  2.014250701995526e-12, -8.698389052360301e-14, -1.973981868845686e-15,
  2.744763003164801e-17,  3.165970273095168e-18,  5.686693618025886e-20,  2.476677984321574e-01, -6.650865111719298e-03,  1.217657687273328e-04, -1.743663596787800e-06,
  2.096500499541303e-08,  1.768046748474637e-10, -3.293711880192412e-12, -1.746577026604085e-13, -1.176285336781436e-14,  1.429845277232673e-16,  1.442207901261524e-17,
  2.446498623021589e-19,  5.701602535996603e-01, -1.433203905144510e-02,  2.042591041401209e-04, -1.018191294687644e-06, -2.848495573160753e-08,  1.786694538238121e-09,
 -1.272238941339075e-11, -9.448477931570665e-13, -1.743796743172661e-14,  1.158643575882653e-16,  4.205079180113208e-17,  8.099411716828987e-19,  1.045577371485587e+00,
 -2.240541031042475e-02,  1.018011600299152e-04,  6.130189781158096e-06, -1.116293513171154e-07, -1.460672743152028e-10,  1.284407072769424e-10, -3.143279932921472e-12,
 -1.573256230159623e-13,  3.109123569827425e-15,  1.471032340284870e-16, -2.799273909256187e-19,  1.666435510031522e+00, -1.956908230219869e-02, -5.277242938973446e-04,
  1.083411321272069e-06,  6.033957350909539e-07,  1.477128472677844e-08, -4.232024285209281e-10, -3.264480666816431e-11, -2.949980020826935e-13,  3.945661550578876e-14,
  1.543763447954692e-15, -1.439093071866201e-17,  5.483089230675073e-02, -1.443862030719572e-03,  2.773527620501878e-05, -4.464325745915919e-07,  8.808316797066108e-09,
 -8.242218498482918e-11, -9.651673350532768e-13, -1.072958895722737e-13,  1.522229424954307e-15,  1.586681894175140e-16,  1.743640231131784e-18, -1.644275198472395e-19,
  2.228884282116074e-01, -5.754502516958114e-03,  1.029510569212755e-04, -1.386554673185800e-06,  2.313055220916310e-08,  5.628847179985599e-12, -1.181023875701563e-11,
 -3.462028449865321e-13,  4.738872158040360e-15,  7.367953438947816e-16,  7.918237900264115e-18, -7.413321101411565e-19,  5.160153077659193e-01, -1.275202803048294e-02,
  1.904047814528810e-04, -1.214625083685250e-06,  1.789511369762269e-09,  1.117510814206100e-09, -4.378564385793843e-11, -1.071914057275958e-12,  2.067626274589237e-14,
  1.913100359926505e-15,  2.601180639903916e-17, -2.125031129380119e-18,  9.580084317073952e-01, -2.132643331038856e-02,  1.649904234911161e-04,  4.449789809220490e-06,
 -9.321171240218220e-08,  1.453999491588641e-09, -5.523022503532896e-12, -5.330607825853860e-12,  4.828695806865655e-14,  7.581720730708875e-15,  2.857672046616027e-17,
 -6.815729470729184e-18,  1.580052827912724e+00, -2.355743334099553e-02, -4.496871585021331e-04,  1.223976953596050e-05,  7.245913548693268e-07, -5.758663305324149e-09,
 -1.190244378297115e-09, -1.115177681964701e-11,  1.710241516943048e-12,  4.826903796648506e-14, -1.912388197949229e-15, -1.136224274722127e-16,  4.946848122254605e-02,
 -1.241150609926385e-03,  2.316280635061299e-05, -3.207991098802921e-07,  6.736098237445475e-09, -1.308106860355798e-10, -2.437106135073184e-12,  2.776831437728003e-14,
  6.131485512038031e-15,  2.508160755381977e-17, -8.596688078143473e-18, -1.699251215970636e-19,  2.014210071133595e-01, -4.991262671934019e-03,  8.847919886179370e-05,
 -1.033633230072732e-06,  1.981774184748896e-08, -3.522870918522474e-10, -1.542977196621492e-11,  2.071381106820432e-13,  2.626904267200059e-14,  1.298983899520388e-16,
 -3.917672565485602e-17, -7.797665793953830e-19,  4.679637681707037e-01, -1.128531964273088e-02,  1.765308737217844e-04, -1.072305739262944e-06,  1.186453261550400e-08,
 -1.536491894562745e-10, -5.412019403069308e-11,  6.490423799628366e-13,  7.714936932417108e-14,  2.574544348206088e-16, -1.120894589553628e-16, -2.306459070279216e-18,
  8.756475117843404e-01, -1.981633840620713e-02,  2.102517388723734e-04,  3.139405529327956e-06, -7.560159947403188e-08, -5.252261176328433e-11, -9.472942778531331e-11,
  6.224195556683637e-14,  2.479812280268854e-13,  7.061839024371493e-16, -3.711783793538459e-16, -5.762566121100693e-18,  1.479812277681139e+00, -2.638919409743359e-02,
 -2.420685007271946e-04,  2.137856454879636e-05,  3.346479531230136e-07, -3.101265129614237e-08, -6.259801712130023e-10,  4.924349450960559e-11,  1.268425989331479e-12,
 -7.841522483679872e-14, -2.582230481718289e-15,  1.217700492663761e-16,  4.485240494385519e-02, -1.069630883713831e-03,  1.986490872283420e-05, -2.364802219876288e-07,
  3.706827115772648e-09, -1.595086204746635e-10,  7.169007166793678e-13,  1.681372371684225e-13,  7.047097758967572e-16, -2.819958132340777e-16, -2.006085092036688e-18,
  4.334672473836231e-19,  1.827998268647953e-01, -4.328302672139695e-03,  7.768981231095412e-05, -7.894130682620692e-07,  1.000569541824643e-08, -5.652886813276667e-10,
  5.341426820225589e-13,  8.021942086805605e-13,  2.106538524965416e-15, -1.266736246774967e-15, -8.794955931740309e-18,  1.992806547201628e-18,  4.255692197955548e-01,
 -9.921957783324579e-03,  1.645007360781406e-04, -9.666478092746884e-07, -1.368098849682649e-09, -9.801441842193063e-10, -6.600151286503058e-12,  2.349265444156230e-12,
  4.080173076035316e-15, -3.696573535965109e-15, -2.058644241610960e-17,  5.915285128812630e-18,  7.999547126472851e-01, -1.800501275317599e-02,  2.402710461548829e-04,
  1.813827604050615e-06, -9.490012806320587e-08, -1.491149922056852e-09,  9.189840226136274e-13,  5.515502723209772e-12,  1.801787959298614e-14, -1.110366018997092e-14,
 -2.334391990996969e-17,  1.881149576193149e-17,  1.372069935148247e+00, -2.725845756280470e-02,  2.488513245933228e-05,  2.146798833554790e-05, -3.131146166058298e-07,
 -2.791081787208000e-08,  8.289376451754429e-10,  3.773767889298926e-11, -1.794568780859106e-12, -4.812798042098635e-14,  3.550044239810469e-15,  5.333758981534430e-17,
  4.087486829655657e-02, -9.212830677291235e-04,  1.728497880433490e-05, -2.002291821120102e-07,  1.044393296371614e-09, -9.226869905491422e-11,  4.318391347030083e-12,
  4.914939138481908e-14, -6.568003031643009e-15, -3.203785037432195e-17,  1.077088089394655e-17, -3.974931158837475e-20,  1.666724175537640e-01, -3.742772548141451e-03,
  6.882660310697660e-05, -7.118272033838649e-07,  5.129611923307257e-10, -3.156358943312979e-10,  1.758205196087250e-11,  2.385105189241623e-13, -3.007738699887449e-14,
 -1.147790827178686e-16,  4.886447077434874e-17, -2.259528568020894e-19,  3.884375056065834e-01, -8.654162100691060e-03,  1.521532390916785e-04, -1.132867220517441e-06,
 -1.765266888771496e-08, -4.506163357270031e-10,  4.275039921567640e-11,  6.787147283446873e-13, -8.627821306044144e-14, -1.768572357124644e-16,  1.417931583911972e-16,
 -9.969237578084898e-19,  7.318777342363154e-01, -1.602360258797567e-02,  2.520827120781593e-04,  1.072333486803821e-07, -1.131235262227874e-07,  1.115303827477814e-10,
  1.107910865117950e-10,  9.803131133982128e-13, -2.280933626870927e-13,  4.672010849309603e-16,  4.073760713768287e-16, -5.607070777049567e-18,  1.264900073512987e+00,
 -2.614821341563831e-02,  2.381980357056567e-04,  1.330521963415957e-05, -6.234859071836074e-07, -2.432932649481414e-09,  1.016867386617533e-09, -2.065747269478991e-11,
 -1.178124066526030e-12,  6.078178826390728e-14,  6.105632426553037e-16, -1.147628039268989e-16,  3.745134130380530e-02, -7.924332021206435e-04,  1.494010890096089e-05,
 -1.925967312900948e-07,  2.295360312810691e-10,  5.737572444804837e-12,  3.094075846552391e-12, -1.110670750215673e-13, -2.014014389782269e-15,  2.019751030021311e-16,
 -8.807000209532826e-19, -2.862048470155842e-19,  1.527482107482061e-01, -3.226515181114641e-03,  6.020150246196148e-05, -7.308078467865052e-07, -1.572826785828594e-09,
  8.589360026516205e-11,  1.247998474572217e-11, -4.834991132059783e-13, -8.760970631255935e-15,  9.141098340539848e-16, -5.114198524623233e-18, -1.280464709519720e-18,
  3.561619986222445e-01, -7.496427994217481e-03,  1.367520334118187e-04, -1.430541250020895e-06, -1.637576490658379e-08,  5.197106670690838e-10,  2.870738684816514e-11,
 -1.320428643562040e-12, -2.178835098531025e-14,  2.595372380685388e-15, -2.148504353896186e-17, -3.561433386885823e-18,  6.717827524848878e-01, -1.403146539612181e-02,
  2.430434106675447e-04, -1.544777667562305e-06, -8.592821627146513e-08,  2.383505268624658e-09,  5.625104279049875e-11, -3.763682175622377e-12, -2.979491957771587e-14,
  6.902551460619694e-15, -1.049956069608779e-16, -8.903420505911175e-18,  1.164894687553962e+00, -2.376984728187497e-02,  3.400302764207903e-04,  4.018706446281974e-06,
 -4.884567139847951e-07,  1.275243756382051e-08,  2.257768426536025e-10, -2.645814215031923e-11,  5.571312728455833e-13,  2.142868782318763e-14, -1.540810260594019e-15,
  1.705920243518048e-17,  3.450613884019072e-02, -6.820651072618519e-04,  1.266481058756215e-05, -1.850801863600645e-07,  8.233589377413117e-10,  4.138809240285879e-11,
  1.832801351316440e-14, -8.353301868405395e-14,  2.673999840350061e-15,  3.470439239690520e-17, -4.625781667482379e-18,  8.440784710717846e-20,  1.407495048754281e-01,
 -2.780197364172266e-03,  5.137706139612220e-05, -7.307711621073197e-07,  1.996791239633901e-09,  2.181487711494119e-10, -7.936378106991325e-13, -3.538467997767933e-13,
  1.195921584534296e-14,  1.398067415470655e-16, -2.061605856970471e-17,  4.064961179535663e-19,  3.282505787996136e-01, -6.474563382766280e-03,  1.184421785346656e-04,
 -1.584953652526060e-06, -2.167946270599796e-09,  7.609231442107630e-10, -6.437538691215617e-12, -8.931968119812364e-13,  3.389093256239484e-14,  2.851526137245891e-16,
 -5.671219364118866e-17,  1.305723013975622e-18,  6.194003470969610e-01, -1.218071715336681e-02,  2.179707515052888e-04, -2.500139664512263e-06, -3.302541220624329e-08,
  2.548878628366230e-09, -3.374356986810243e-11, -1.996012425031166e-12,  9.688925932972592e-14, -4.901466239910231e-18, -1.395589695501313e-16,  4.413564616678759e-18,
  1.075400276560024e+00, -2.096935414538535e-02,  3.501445095692893e-04, -1.672057830390692e-06, -2.271657218151423e-07,  1.163892407045250e-08, -2.208815923706548e-10,
 -5.781881045092985e-12,  5.277225441998321e-13, -1.343647328835011e-14, -1.735516701431121e-16,  2.470337610399228e-17,  3.196684464136343e-02, -5.893466766986901e-04,
  1.054854043415099e-05, -1.658777802192353e-07,  1.516981185111188e-09,  2.352523671034785e-11, -1.137928918079419e-12, -4.672599403942210e-15,  1.718183418964349e-15,
 -5.644114886198391e-17, -9.809290984004935e-20,  7.151285473358081e-20,  1.303963886985396e-01, -2.403403405965522e-03,  4.293282616209305e-05, -6.675325499181961e-07,
  5.592531590706722e-09,  1.234328974516496e-10, -5.481062245902305e-12, -7.812547090884445e-15,  7.362100381307693e-15, -2.531565334527845e-16, -6.912000686987226e-20,
  3.106317766428294e-19,  3.041275265530317e-01, -5.602624590035426e-03,  9.967170385817545e-05, -1.512593819695766e-06,  1.010630903835084e-08,  4.257988783211958e-10,
 -1.711177666987644e-11,  4.422284412906881e-14,  1.888066379085861e-14, -7.144370452677463e-16,  2.078048247610538e-18,  8.064532103995659e-19,  5.739669803064487e-01,
 -1.056242203267066e-02,  1.863009930546905e-04, -2.677730130173062e-06,  7.027383546677413e-09,  1.389619198298237e-09, -5.170541099663590e-11,  4.048601003674009e-13,
  4.214015443830959e-14, -1.955195774300344e-15,  1.935025364891215e-17,  1.702240871257141e-18,  9.969316401721737e-01, -1.829458027546382e-02,  3.149400537077983e-04,
 -3.759075089397978e-06, -5.258431427712821e-08,  5.849885796049957e-09, -2.192739532189467e-10,  3.555415018276395e-12,  9.178623158893506e-14, -8.141132683078932e-15,
  2.460974638989610e-16, -1.178114360785475e-18,  2.976624556709280e-02, -5.124815984709785e-04,  8.714453696213980e-06, -1.392819475267903e-07,  1.728216386911493e-09,
 -9.297192382510111e-13, -7.835962111114122e-13,  2.131350086693520e-14,  9.315597916368835e-17, -2.723593792885071e-17,  9.661088629854981e-19, -8.542389674604033e-21,
  1.214213056566461e-01, -2.090318795651610e-03,  3.551835429851633e-05, -5.651493768849795e-07,  6.831456424994408e-09,  7.944980892230984e-12, -3.663010451835832e-12,
  9.965451758049847e-14,  2.273555245974910e-16, -1.163996174140727e-16,  4.296273631624026e-18, -4.325046801340311e-20,  2.832013771341432e-01, -4.874598234893778e-03,
  8.270300539474796e-05, -1.303717681275707e-06,  1.487403787593274e-08,  7.631825250305330e-11, -1.088526795823785e-11,  2.983140222878763e-13, -3.499865855471902e-16,
 -2.955342839377782e-16,  1.185702607534152e-17, -1.497398703904016e-19,  5.344995655383463e-01, -9.196931918645828e-03,  1.555570638425344e-04, -2.404540913304043e-06,
  2.386781373447508e-08,  3.798293666916703e-10, -3.047335625923147e-11,  8.604907590366468e-13, -5.439954289198637e-15, -6.333248497689611e-16,  3.049332786595776e-17,
 -5.499764191054894e-19,  9.284960828398636e-01, -1.596258205917317e-02,  2.678183350537545e-04, -3.913395650739587e-06,  2.064915139059201e-08,  1.905899692701635e-09,
 -1.103528459899352e-10,  3.477133419626067e-12, -5.398972120346817e-14, -9.963715388922521e-16,  9.830568868361939e-17, -3.359293565257272e-18,  2.784581963283289e-02,
 -4.489884801746874e-04,  7.205604165737971e-06, -1.126012648952817e-07,  1.568684865805482e-09, -1.290266517773297e-11, -2.454272922519006e-13,  1.497513377860769e-14,
 -3.312832574073427e-16, -6.959648522013081e-19,  3.377954610838562e-19, -1.303658322778210e-20,  1.135879785508876e-01, -1.831455300897216e-03,  2.938469405950454e-05,
 -4.584268236374514e-07,  6.329000771048613e-09, -4.846913158533800e-11, -1.193393725493526e-12,  6.790104347698958e-14, -1.523930429212297e-15, -6.813375356801562e-19,
  1.430672555215665e-18, -5.726525797145786e-20,  2.649329148163339e-01, -4.271469458521540e-03,  6.849818092155261e-05, -1.064996119465730e-06,  1.442695224881290e-08,
 -9.290208065914662e-11, -3.727014184067084e-12,  1.924871828110722e-13, -4.448127998408573e-15,  1.087699470659929e-17,  3.553356022367120e-18, -1.537600054108643e-19,
  5.000276540270613e-01, -8.061043634428833e-03,  1.291369414877999e-04, -1.993979450967788e-06,  2.593799034452365e-08, -9.596779742417520e-11, -1.085615872135349e-11,
  5.069784638231290e-13, -1.241284410433270e-14,  8.778914210310911e-17,  7.160864988773956e-18, -3.707076047904453e-19,  8.686441833691155e-01, -1.400015046532401e-02,
  2.237131751444716e-04, -3.392584578290243e-06,  3.909723284347197e-08,  2.182061046980337e-10, -3.860903872702603e-11,  1.691728089849204e-12, -4.765002541069414e-14,
  7.501016511602138e-16,  7.034761762425646e-18, -9.477767384152506e-19,  2.615717234174385e-02, -3.963428951117754e-04,  5.995768767159700e-06, -8.976533728528362e-08,
  1.279663647106727e-09, -1.491337471896091e-11,  3.472549164722666e-14,  5.649414157398756e-15, -2.224898021967531e-16,  4.487254475105703e-18, -6.284892791765401e-21,
 -3.322974229557111e-21,  1.066997959256016e-01, -1.616741716161300e-03,  2.445565886186291e-05, -3.659240542141585e-07,  5.199719669255234e-09, -5.954009481211521e-11,
  7.590347745479713e-14,  2.572713440174077e-14, -9.943158317812240e-16,  2.039654853033182e-17, -5.442825454838245e-20, -1.388858878942900e-20,  2.488673919109036e-01,
 -3.770844518635373e-03,  5.703049217534324e-05, -8.523341650450494e-07,  1.203204947015457e-08, -1.326975486935098e-10, -1.399501068661384e-13,  7.311606735006210e-14,
 -2.751437381646460e-15,  5.834992663072692e-17, -2.897335350771172e-19, -3.344607702213444e-20,  4.697078056437229e-01, -7.116820970758204e-03,  1.076013940597737e-04,
 -1.604412563423174e-06,  2.234843873817710e-08, -2.268187448085115e-10, -1.502864249069745e-12,  1.906251840257795e-13, -6.995202726539734e-15,  1.579451284401395e-16,
 -1.390700554719459e-18, -6.196691418054153e-20,  8.159802783027922e-01, -1.236258159853643e-02,  1.867736802035618e-04, -2.769130917253630e-06,  3.724938442361250e-08,
 -2.869454601739490e-10, -8.489563482590014e-12,  5.963439824271049e-13, -2.201915580133347e-14,  5.723840256371741e-16, -9.276292727977013e-18, -1.624618668777035e-20,
  2.466137303414151e-02, -3.523595720921094e-04,  5.031852445899523e-06, -7.159041766228349e-08,  9.989950167670387e-10, -1.284397282226625e-11,  1.160032545714116e-13,
  8.764826868294530e-16, -8.655605993091302e-17,  2.777595482712823e-18, -5.362615787339800e-20,  2.661298307803443e-22,  1.005981887628435e-01, -1.437335351526552e-03,
  2.052529926917210e-05, -2.919673789706762e-07,  4.069654722738839e-09, -5.202765170646213e-11,  4.533777321431976e-13,  4.458392695262972e-15, -3.855355759024753e-16,
  1.230247433789734e-17, -2.413531334455104e-19,  1.425350188065649e-21,  2.346360806474616e-01, -3.352439978086587e-03,  4.787091025994936e-05, -6.806947603750087e-07,
  9.466695811491435e-09, -1.196280543512084e-10,  9.632543098041350e-13,  1.463884291102372e-14, -1.057130544491522e-15,  3.351176561272122e-17, -6.783854673252802e-19,
  5.193188429445022e-21,  4.428483289715477e-01, -6.327292961139249e-03,  9.034184580815935e-05, -1.283665821966230e-06,  1.777359592054862e-08, -2.193479745865158e-10,
  1.460169884560831e-12,  4.405658285127026e-14, -2.622770723897965e-15,  8.308619895831586e-17, -1.783525555716479e-18,  1.903203339404850e-20,  7.693215433119375e-01,
 -1.099166355030966e-02,  1.569073518938560e-04, -2.225658687285205e-06,  3.048561391241327e-08, -3.534123705891935e-10,  9.451471517032655e-13,  1.528127285405425e-13,
 -7.636695311571682e-15,  2.493997686592082e-16, -6.089641291059227e-18,  1.012488720403627e-19,  2.332736265352416e-02, -3.152878837470763e-04,  4.260695476200990e-06,
 -5.750650721270644e-08,  7.706675157499463e-10, -9.999930761683066e-12,  1.140561830971348e-13, -6.700044595792585e-16, -2.031054760508185e-17,  1.064723538036892e-18,
 -3.011955802778413e-20,  5.682636008950450e-22,  9.515652610147191e-02, -1.286115561343826e-03,  1.738002016429173e-05, -2.345641414939538e-07,  3.142326373931307e-09,
 -4.069582926432365e-11,  4.598029550389802e-13, -2.474807478655931e-15, -9.313965738156549e-17,  4.688832479818247e-18, -1.325475193927155e-19,  2.536035691778934e-21,
  2.219439288169483e-01, -2.999744320358367e-03,  4.053673307947478e-05, -5.470288996349452e-07,  7.322852987559709e-09, -9.447270441520197e-11,  1.046830341763564e-12,
 -4.549317984724468e-15, -2.664338855606505e-16,  1.260930590515260e-17, -3.568390060108413e-19,  7.017776418214388e-21,  4.188934709698908e-01, -5.661659275962794e-03,
  7.650632264833749e-05, -1.032200200568452e-06,  1.379806033593935e-08, -1.766690903891141e-10,  1.880651646899915e-12, -3.976095213190238e-15, -6.917932329277097e-16,
  3.037853437359949e-17, -8.672431510538081e-19,  1.795675276037220e-20,  7.277072717883124e-01, -9.835467916734222e-03,  1.328997874061992e-04, -1.792153017915947e-06,
  2.387781668800258e-08, -3.001768615228189e-10,  2.865017114799265e-12,  1.322424354618107e-14, -2.060416278511059e-15,  8.424033858996756e-17, -2.499001512219301e-18,
  5.789538561866549e-20,  2.213028882186416e-02, -2.837672800126036e-04,  3.638463523580956e-06, -4.663440537596471e-08,  5.962669293124828e-10, -7.532914755538431e-12,
  9.056247345434346e-14, -8.948593346193246e-16,  1.650846861674993e-18,  2.806744385243655e-19, -1.117523252599229e-20,  2.889824775485436e-22,  9.027344714494030e-02,
 -1.157537863884096e-03,  1.484192150836200e-05, -1.902266100639906e-07,  2.431953945681060e-09, -3.070448618820385e-11,  3.680220900034728e-13, -3.580969924025489e-15,
  3.811928222574068e-18,  1.250545571191872e-18, -4.886299430891281e-20,  1.265281239632703e-21,  2.105545985652406e-01, -2.699851026063060e-03,  3.461729991636062e-05,
 -4.436699450900431e-07,  5.670807146949586e-09, -7.150605308018633e-11,  8.518704651966272e-13, -8.027683657368225e-15, -4.894591922243998e-18,  3.419612021172139e-18,
 -1.297502979723830e-19,  3.374098238463235e-21,  3.973974518922840e-01, -5.095654168295187e-03,  6.533568857267847e-05, -8.373179064212700e-07,  1.069761836134726e-08,
 -1.345650281839185e-10,  1.584094023633760e-12, -1.395409793636856e-14, -6.081573144978066e-17,  8.368430129802289e-18, -3.063087788952701e-19,  8.063659799919718e-21,
  6.903641914320136e-01, -8.852230005581212e-03,  1.135002943382523e-04, -1.454378417784079e-06,  1.856310565783988e-08, -2.322020891868888e-10,  2.655670043382903e-12,
 -1.925722551011859e-14, -3.269510956377476e-16,  2.305936465895817e-17, -8.185360717270933e-19,  2.241559651103213e-20,  2.105010568974701e-02, -2.567465629859879e-04,
  3.131480286019626e-06, -3.818962542028593e-08,  4.653750807121473e-10, -5.647328264765113e-12,  6.727357404231935e-14, -7.458602933356488e-16,  6.162571332542961e-18,
  2.294631755181354e-20, -3.061776262709656e-21,  1.030309827674002e-22,  8.586718527381844e-02, -1.047315597308093e-03,  1.277386771132355e-05, -1.557815873667229e-07,
  1.898274210976577e-09, -2.303091168656596e-11,  2.740818529444780e-13, -3.025078950885663e-15,  2.437221442274331e-17,  1.227674837019373e-19, -1.345668198006853e-20,
  4.482116237035611e-22,  2.002773952674720e-01, -2.442768173294265e-03,  2.979385535084443e-05, -3.633427462120888e-07,  4.427209458614443e-09, -5.369196162222212e-11,
  6.377055747301657e-13, -6.974909214933543e-15,  5.327087328141642e-17,  4.234243681123210e-19, -3.597099987072086e-20,  1.179222972959740e-21,  3.780004243866174e-01,
 -4.610441950840410e-03,  5.623235718964726e-05, -6.857547023188363e-07,  8.354637929370829e-09, -1.012465427577390e-10,  1.197980608700997e-12, -1.287157979057061e-14,
  8.744224540989692e-17,  1.308270931033647e-18, -8.519594490989393e-20,  2.741061318122913e-21,  6.566674334207933e-01, -8.009320066825336e-03,  9.768724111232592e-05,
 -1.191254729268969e-06,  1.450920511884248e-08, -1.755366649212553e-10,  2.059108176151157e-12, -2.118779898884474e-14,  9.816062507260872e-17,  4.420745317613775e-18,
 -2.235305305258236e-19,  7.108205325561875e-21,  2.007048877454624e-02, -2.334092883045914e-04,  2.714419286904115e-06, -3.156616860060764e-08,  3.669984964820516e-10,
 -4.260984034580728e-12,  4.914838379412486e-14, -5.519979843295897e-16,  5.612438180160256e-18, -3.662644514926027e-20, -4.524816186699100e-22,  2.843944330181943e-23,
  8.187115090911595e-02, -9.521186626393651e-04,  1.107260548880561e-05, -1.287639339180031e-07,  1.497036653589646e-09, -1.738006768083788e-11,  2.004065688730999e-13,
 -2.247547590079624e-15,  2.270540904794738e-17, -1.419317021794134e-19, -2.105746418792806e-21,  1.239840254764492e-22,  1.909570090817708e-01, -2.220730105683461e-03,
  2.582583861917184e-05, -3.003293760414741e-07,  3.491626548778748e-09, -4.053169264565222e-11,  4.670700578281815e-13, -5.223090831049845e-15,  5.208527302303870e-17,
 -2.962726825408888e-19, -6.129026189439102e-21,  3.268238589224103e-22,  3.604092742959561e-01, -4.191371186888139e-03,  4.874326326033325e-05, -5.668342578428673e-07,
  6.589778940346820e-09, -7.647874301962970e-11,  8.802666442733186e-13, -9.789789840493827e-15,  9.516015975521121e-17, -4.325743851245526e-19, -1.605750637434886e-20,
  7.577508744128347e-22,  6.261078542016375e-01, -7.281306202612661e-03,  8.467737884713766e-05, -9.847021776494788e-07,  1.144687917815680e-08, -1.327841705638930e-10,
  1.524347880922401e-12, -1.674224535904151e-14,  1.528691084352071e-16, -2.392522473226469e-19, -4.653773476066181e-20,  1.919936763510823e-21,  1.917801618391438e-02,
 -2.131153714853200e-04,  2.368238957294911e-06, -2.631676693361266e-08,  2.924219186449947e-10, -3.247893543371245e-12,  3.599489063087379e-14, -3.951330184332884e-16,
  4.182808615149980e-18, -3.875291490772101e-20,  1.799639498710468e-22,  5.111851429543105e-24,  7.823059393591625e-02, -8.693361138971153e-04,  9.660474425745470e-06,
 -1.073508120620369e-07,  1.192838312364728e-09, -1.324847062536224e-11,  1.468121561735401e-13, -1.610871679966230e-15,  1.701819414424066e-17, -1.562729973757734e-19,
  6.689030311002690e-22,  2.294189833082815e-23,  1.824657413028407e-01, -2.027647369092654e-03,  2.253217623598334e-05, -2.503858362649584e-07,  2.782170793364267e-09,
 -3.089960814977196e-11,  3.423462659588858e-13, -3.752881247610245e-15,  3.949031138269856e-17, -3.561572493181195e-19,  1.257784671759123e-21,  6.326162909353226e-23,
  3.443829884277732e-01, -3.826949933685222e-03,  4.252687300188295e-05, -4.725737510220555e-07,  5.250970318325502e-09, -5.831511423708816e-11,  6.458601224036663e-13,
 -7.067875134452301e-15,  7.381234689536609e-17, -6.423453313808095e-19,  1.279635420174142e-21,  1.551092891462143e-22,  5.982667749396711e-01, -6.648228994468357e-03,
  7.387824242594851e-05, -8.209594702003141e-07,  9.121855111287851e-09, -1.012898930532744e-10,  1.120957492698479e-12, -1.222074009752882e-14,  1.254582564491886e-16,
 -9.991132146917004e-19, -2.145928086358532e-21,  4.155003017349831e-22,  1.836155259085761e-02, -1.953577753534385e-04,  2.078509032904013e-06, -2.211424736968007e-08,
  2.352795650365741e-10, -2.502887359376898e-12,  2.660699832294040e-14, -2.819316600485769e-16,  2.948668893193342e-18, -2.941132055215087e-20,  2.465392667290794e-22,
 -6.384510975059494e-25,  7.490009138843508e-02, -7.968996711965250e-04,  8.478613925057730e-06, -9.020800413676964e-08,  9.597471286830269e-10, -1.020967183300241e-11,
  1.085309806139938e-13, -1.149841872315700e-15,  1.201820502802486e-17, -1.195572710101631e-19,  9.901951253532776e-22, -2.091004101531071e-24,  1.746976472025216e-01,
 -1.858695963392931e-03,  1.977559516812797e-05, -2.104019271713155e-07,  2.238519518197352e-09, -2.381286840819419e-11,  2.531215432496409e-13, -2.680954925439463e-15,
  2.798600005437357e-17, -2.769478483125279e-19,  2.238322779404731e-21, -2.503729056168661e-24,  3.297216090725228e-01, -3.508073708526901e-03,  3.732414840178099e-05,
 -3.971091949269821e-07,  4.224935376290105e-09, -4.494313347523113e-11,  4.776784683912491e-13, -5.056695031851599e-15,  5.266122737301846e-17, -5.159630266846693e-19,
  3.970799082097041e-21,  3.813016295383630e-24,  5.727968290246073e-01, -6.094272974858722e-03,  6.484001130143788e-05, -6.898630481051162e-07,  7.339574067912892e-09,
 -7.807255946061592e-11,  8.296133951258326e-13, -8.772371906377460e-15,  9.088779839756141e-17, -8.706952294625114e-19,  5.916745426753138e-21,  4.028548937868802e-23,
  1.761178255131811e-02, -1.797307824842025e-04,  1.834178487171181e-06, -1.871804481730294e-08,  1.910192713804493e-10, -1.949298254315969e-12,  1.988784984318287e-14,
 -2.026947898333752e-16,  2.056585977373248e-18, -2.051432100092490e-20,  1.927719028730212e-22, -1.451169665538748e-24,  7.184164389641091e-02, -7.331543433418969e-04,
  7.481945517848154e-06, -7.635428611096631e-08,  7.792019797071620e-10, -7.951527895271203e-12,  8.112534322859381e-14, -8.267842939827643e-16,  8.387025755120000e-18,
 -8.358918236585186e-20,  7.828347662178629e-22, -5.799771182260418e-24,  1.675640967508370e-01, -1.710015788067199e-03,  1.745095700850048e-05, -1.780894173689000e-07,
  1.817417037231401e-09, -1.854616142367846e-11,  1.892139179563034e-13, -1.928198503588400e-15,  1.955217950553171e-17, -1.945435389348723e-19,  1.809827695849610e-21,
 -1.297782210179534e-23,  3.162578574452528e-01, -3.227457072733989e-03,  3.293666335890602e-05, -3.361231604320080e-07,  3.430162227117244e-09, -3.500355155982763e-11,
  3.571071686793325e-13, -3.638559710099015e-15,  3.686849425824776e-17, -3.657096284550782e-19,  3.359346282373266e-21, -2.254566992438202e-23,  5.494074180285975e-01,
 -5.606781980256928e-03,  5.721801550290391e-05, -5.839176113322239e-07,  5.958916063744409e-09, -6.080798966245721e-11,  6.203275521571884e-13, -6.318446938194850e-15,
  6.392385654649510e-17, -6.298621727573079e-19,  5.623161904311046e-21, -3.171219576068798e-23,  1.692085335195150e-02, -1.659066670053359e-04,  1.626692300362983e-06,
 -1.594949454185088e-08,  1.563824001513040e-10, -1.533290927856726e-12,  1.503262064154704e-14, -1.473345173006134e-16,  1.441895655499932e-18, -1.402793931138270e-20,
  1.335935844755093e-22, -1.182876475944119e-24,  6.902321882490584e-02, -6.767632780010526e-04,  6.635571873153605e-06, -6.506087039642838e-08,  6.379120424055865e-10,
 -6.254568385546217e-12,  6.132061490450598e-14, -6.009949224562392e-16,  5.881297858866186e-18, -5.720267081412003e-20,  5.441828030183016e-22, -4.798353335526863e-24,
  1.609903767506187e-01, -1.578488759985645e-03,  1.547686754304134e-05, -1.517485583055830e-07,  1.487871655188938e-09, -1.458820079468603e-11,  1.430240296137000e-13,
 -1.401724574798716e-15,  1.371553890602261e-17, -1.333302965952472e-19,  1.265762868416647e-21, -1.106953776699741e-23,  3.038507210553983e-01, -2.979215016170089e-03,
  2.921079788950275e-05, -2.864078529466651e-07,  2.808185259087459e-09, -2.753350561346748e-11,  2.699388528631073e-13, -2.645451526177017e-15,  2.587943722749655e-17,
 -2.513353982571992e-19,  2.376830598132952e-21, -2.046468693949104e-23,  5.278535732567874e-01, -5.175532531769807e-03,  5.074539219908579e-05, -4.975515721639544e-07,
  4.878415767360653e-09, -4.783144947614689e-11,  4.689327138905449e-13, -4.595209838201474e-15,  4.493271495228423e-17, -4.354950860384769e-19,  4.084327659751522e-21,
 -3.395547875678535e-23,  1.628209872964522e-02, -1.536183781757953e-04,  1.449358983051918e-06, -1.367441460425142e-08,  1.290153484105134e-10, -1.217230684509404e-12,
  1.148410061592423e-14, -1.083376920143372e-16,  1.021553656597341e-18, -9.613641074701099e-21,  8.979914831671245e-23, -8.173500704608122e-25,  6.641762328232564e-02,
 -6.266371270868440e-04,  5.912197225235876e-06, -5.578040840718695e-08,  5.262769164963885e-10, -4.965303468888171e-12,  4.684568961929058e-14, -4.419271633500146e-16,
  4.167008588067575e-18, -3.921164659942767e-20,  3.661438012586447e-22, -3.328325727547101e-24,  1.549130622585614e-01, -1.461574074529919e-03,  1.378966201217685e-05,
 -1.301027263032779e-07,  1.227492990256836e-09, -1.158111637297328e-11,  1.092631639355443e-13, -1.030746553418226e-15,  9.718748897258883e-18, -9.143898768411210e-20,
  8.532602764070286e-22, -7.736772217894767e-24,  2.923804926621786e-01, -2.758552066161548e-03,  2.602639256516690e-05, -2.455538514822169e-07,  2.316750999121800e-09,
 -2.185801090565960e-11,  2.062211011126310e-13, -1.945386641974635e-15,  1.834158524634345e-17, -1.725167771673167e-19,  1.607892933528817e-21, -1.451136268523108e-23,
  5.079273376958863e-01, -4.792193877485593e-03,  4.521340038454078e-05, -4.265794618075280e-07,  4.024690803243033e-09, -3.797200685063760e-11,  3.582483848484032e-13,
 -3.379452630777964e-15,  3.185818867114193e-17, -2.994706846548777e-19,  2.784091853241703e-21, -2.487736439766851e-23,  1.568982292434483e-02, -1.426465437990339e-04,
  1.296893951269350e-06, -1.179091945383017e-08,  1.071990277067743e-10, -9.746164389724442e-13,  8.860834359484018e-15, -8.055707416132658e-17,  7.322716962801582e-19,
 -6.652249321545392e-21,  6.028007813518337e-23, -5.412571784860532e-25,  6.400162323412624e-02, -5.818810317931879e-04,  5.290264806860131e-06, -4.809729134211800e-08,
  4.372842063233737e-10, -3.975636498858300e-12,  3.614493840400302e-14, -3.286064954171338e-16,  2.987049860084807e-18, -2.713488722364010e-20,  2.458596794613424e-22,
 -2.206671502086286e-24,  1.492779620037502e-01, -1.357184555098988e-03,  1.233906124407453e-05, -1.121825551224640e-07,  1.019925613142563e-09, -9.272809938352262e-12,
  8.430475150157580e-14, -7.664431019065186e-16,  6.966938212930030e-18, -6.328588930059822e-20,  5.732940625081588e-22, -5.141386939986903e-24,  2.817448925089575e-01,
 -2.561528918654180e-03,  2.328855135103258e-05, -2.117316011443644e-07,  1.924991645910484e-09, -1.750135518813726e-11,  1.591153760782734e-13, -1.446567189263548e-15,
  1.314900695267312e-17, -1.194320037403872e-19,  1.081509893791349e-21, -9.684993523536690e-24,  4.894510295763645e-01, -4.449922606777754e-03,  4.045718569559070e-05,
 -3.678229944114411e-07,  3.344121410072685e-09, -3.040358574392114e-11,  2.764170542748383e-13, -2.512976850051020e-15,  2.284164363425092e-17, -2.074338717940177e-19,
  1.876980384488473e-21, -1.675757255455080e-23,  1.513913024392554e-02, -1.328096081584632e-04,  1.165086219155440e-06, -1.022084105661713e-08,  8.966339849912219e-11,
 -7.865814232713177e-13,  6.900358457051689e-15, -6.053358092687309e-17,  5.310110272362140e-19, -4.657227433455095e-21,  4.081306956869048e-23, -3.565328508014951e-25,
  6.175524826737715e-02, -5.417543935464057e-04,  4.752597246826189e-06, -4.169265781800335e-08,  3.657532065845916e-10, -3.208607762016030e-12,  2.814780799195698e-14,
 -2.469273448376693e-16,  2.166086267590453e-18, -1.899750539454753e-20,  1.664771099288214e-22, -1.454113950799968e-24,  1.440384968154122e-01, -1.263592822940244e-03,
  1.108500058867986e-05, -9.724433029225323e-08,  8.530860696431877e-10, -7.483785541692765e-12,  6.565219528393075e-14, -5.759352427539338e-16,  5.052182710746284e-18,
 -4.430920688873562e-20,  3.882623775273392e-22, -3.390475784374453e-24,  2.718560077970002e-01, -2.384885346072120e-03,  2.092165686994980e-05, -1.835374291899867e-07,
  1.610101312374393e-09, -1.412477961302439e-11,  1.239109093622935e-13, -1.087010109858388e-15,  9.535355610104791e-18, -8.362598942686301e-20,  7.326976025974853e-22,
 -6.395345115172744e-24,  4.722719255985875e-01, -4.143055008596580e-03,  3.634538466360021e-05, -3.188436988335948e-07,  2.797089718709400e-09, -2.453775689155511e-11,
  2.152596428809323e-13, -1.888364984450647e-15,  1.656475871780160e-17, -1.452674696429866e-19,  1.272492811918566e-21, -1.109672430877994e-23,  1.462578933162517e-02,
 -1.239562702027975e-04,  1.050552320550303e-06, -8.903625254264510e-09,  7.545987075061157e-11, -6.395363353034435e-13,  5.420186846682584e-15, -4.593697830150541e-17,
  3.893190688552532e-19, -3.299319654468626e-21,  2.795335299710701e-23, -2.365785395971858e-25,  5.966123791314107e-02, -5.056400280156886e-04,  4.285392775416827e-06,
 -3.631949650950142e-08,  3.078144501533698e-10, -2.608784287899330e-12,  2.210992147514824e-14, -1.873852227232315e-16,  1.588102131645115e-18, -1.345848859231764e-20,
  1.140254427997727e-22, -9.649971289256035e-25,  1.391544082204778e-01, -1.179359351771138e-03,  9.995288675084469e-06, -8.471192050867623e-08,  7.179491934920518e-10,
 -6.084751935887339e-12,  5.156937880695563e-14, -4.370589191914071e-16,  3.704100552974367e-18, -3.139055510140469e-20,  2.659480123238909e-22, -2.250546834641062e-24,
  2.626378553134529e-01, -2.225904409023449e-03,  1.886495163486564e-05, -1.598839548501988e-07,  1.355046086822809e-09, -1.148426566066662e-11,  9.733123624024638e-14,
 -8.248979717334979e-16,  6.991050972699759e-18, -5.924555783417794e-20,  5.019260855902253e-22, -4.246900036181511e-24,  4.562580266998908e-01, -3.866871179218956e-03,
  3.277244857336600e-05, -2.777525640740226e-07,  2.354004347255476e-09, -1.995062113138514e-11,  1.690851257891504e-13, -1.433023205991152e-15,  1.214491227124544e-17,
 -1.029205193746171e-19,  8.718836119521467e-22, -7.375174579217355e-24,  1.414612416269694e-02, -1.159596288141233e-04,  9.505526291152124e-07, -7.791938538308019e-09,
  6.387264025740802e-11, -5.235814059284938e-13,  4.291938875882934e-15, -3.518216949895963e-17,  2.883967552580037e-19, -2.364019936502411e-21,  1.937667462865055e-23,
 -1.587599474102541e-25,  5.770459700213088e-02, -4.730202826072134e-04,  3.877475961722731e-06, -3.178472548708013e-08,  2.605480429143359e-10, -2.135783177837925e-12,
  1.750759428776428e-14, -1.435144250731836e-16,  1.176422350313417e-18, -9.643258324468655e-21,  7.904069923619440e-23, -6.476008399077314e-25,  1.345907213511576e-01,
 -1.103276764024221e-03,  9.043859827851188e-06, -7.413497976737273e-08,  6.077046000225667e-10, -4.981519901947360e-12,  4.083487028463180e-14, -3.347343252107885e-16,
  2.743897481136700e-18, -2.249199486211238e-20,  1.843540900258247e-22, -1.510426941155928e-24,  2.540244240394589e-01, -2.082307321959797e-03,  1.706923969794746e-05,
 -1.399212022002424e-07,  1.146972164522980e-09, -9.402042800869948e-12,  7.707109536727350e-14, -6.317722964081940e-16,  5.178787244703104e-18, -4.245094751892288e-20,
  3.479431903471092e-22, -2.850611663590083e-24,  4.412946576474861e-01, -3.617412381646957e-03,  2.965291356248783e-05, -2.430730007763748e-07,  1.992535522916456e-09,
 -1.633335561033810e-11,  1.338889449109691e-13, -1.097523233352571e-15,  8.996652425658582e-18, -7.374604686063675e-20,  6.044385150714081e-22, -4.951624727339722e-24,
  1.369692582387694e-02, -1.087126085453161e-04,  8.628528334520649e-07, -6.848469760276630e-09,  5.435635861511663e-11, -4.314268469928153e-13,  3.424238223991917e-15,
 -2.717820172995609e-17,  2.157133941276646e-19, -1.712109655021015e-21,  1.358865889789028e-23, -1.078332457754708e-25,  5.587223579721604e-02, -4.434583772211065e-04,
  3.519732645765527e-06, -2.793614583420475e-08,  2.217294102819559e-10, -1.759868077907506e-12,  1.396808654941473e-14, -1.108647961300656e-16,  8.799338940676400e-19,
 -6.984003527728837e-21,  5.543054630289206e-23, -4.398694394123417e-25,  1.303169055867696e-01, -1.034326309863985e-03,  8.209456098259999e-06, -6.515851795056818e-08,
  5.171636719546297e-10, -4.104732142076602e-12,  3.257929073676744e-14, -2.585820461031811e-16,  2.052365622356613e-18, -1.628954748733744e-20,  1.292864873892390e-22,
 -1.025947193711938e-24,  2.459580909586899e-01, -1.952171312363630e-03,  1.549439913912474e-05, -1.229791684558188e-07,  9.760866319834947e-10, -7.747207292922989e-12,
  6.148964406017759e-14, -4.880437056674638e-16,  3.873602433714777e-18, -3.074462014370840e-20,  2.440125723812852e-22, -1.936329206188239e-24,  4.272817149597563e-01,
 -3.391338349516063e-03,  2.691707929033792e-05, -2.136410711156949e-07,  1.695670869872388e-09, -1.345855305702084e-11,  1.068206391229161e-13, -8.478360889285412e-16,
  6.729273200348205e-18, -5.340991130053487e-20,  4.238994927472005e-22, -3.363723890980869e-24  };
  constexpr double w[1920] = {  3.222481016858012e-02, -2.799687087204800e-03,  1.721992594069735e-04, -8.948252983996153e-06,  4.152741280337745e-07,
 -1.768293453780783e-08,  7.020306440856274e-10, -2.626272988628988e-11,  9.326233977529248e-13, -3.160818146966764e-14,  1.026488728131407e-15, -3.201343671211179e-17,
  9.355696169730054e-02, -1.448458419793693e-02,  1.451824639688134e-03, -1.137235542987913e-04,  7.505271333003097e-06, -4.341666556234885e-07,  2.255071657337470e-08,
 -1.068610961092618e-09,  4.672476399643016e-11, -1.900996590163446e-12,  7.242890358512030e-14, -2.594577248886418e-15,  1.259535666664971e-01, -3.130100240634434e-02,
  4.516787793217836e-03, -4.772016174867363e-04,  4.052583508142443e-05, -2.907437983578107e-06,  1.816958054113680e-07, -1.009754641262150e-08,  5.064940955725384e-10,
 -2.318849618893426e-11,  9.774427343011156e-13, -3.815259217359075e-14,  1.084441350422955e-01, -3.677725135930895e-02,  6.830930444163850e-03, -8.886372126228964e-04,
  8.978435074858562e-05, -7.455596121199735e-06,  5.272481464342106e-07, -3.253744433783580e-08,  1.783561416346329e-09, -8.802033446765485e-11,  3.952488038673060e-12,
 -1.626613891094496e-13,  5.338588490114620e-02, -2.128144540844424e-02,  4.549725671855534e-03, -6.655244706911227e-04,  7.413725119850217e-05, -6.678811231534358e-06,
  5.056225660667454e-07, -3.303536507877902e-08,  1.899495359947591e-09, -9.756386063156934e-11,  4.529491006055311e-12, -1.916259825181979e-13,  2.323143692524797e-02,
 -1.760619453740032e-03,  9.541944720281433e-05, -4.418176674736010e-06,  1.843547949214186e-07, -7.110017872156577e-09,  2.572053865852456e-10, -8.814502673699311e-12,
  2.881008354547157e-13, -9.026451499401468e-15,  2.721771117984413e-16, -7.911511356880452e-18,  5.240784234715055e-02, -6.796642794083822e-03,  5.944325243585849e-04,
 -4.148298826736458e-05,  2.473636243747041e-06, -1.307072958020792e-07,  6.256901763497929e-09, -2.753503816845729e-10,  1.125587599120427e-11, -4.306875876117759e-13,
  1.551578884350465e-14, -5.281727732114815e-16,  4.797021944193872e-02, -1.030043702446791e-02,  1.328867869467776e-03, -1.279805780837971e-04,  1.004697849335018e-05,
 -6.735366680747202e-07,  3.967571097024692e-08, -2.093467222185002e-09,  1.003131109003759e-10, -4.410390659552675e-12,  1.793507131350738e-13, -6.781224992574310e-15,
  2.682072147172438e-02, -8.399016841741143e-03,  1.461471438521319e-03, -1.801851976460626e-04,  1.740727198670239e-05, -1.391741992381593e-06,  9.528966548220396e-08,
 -5.719127380627127e-09,  3.060342496411857e-10, -1.478951150331170e-11,  6.520347378113536e-13, -2.640569865361849e-14,  9.515930350271644e-03, -3.705264268091481e-03,
  7.755814937206603e-04, -1.114239832092961e-04,  1.222265740408065e-05, -1.086603823633039e-06,  8.131982914348388e-08, -5.259766143240716e-09,  2.997478394404868e-10,
 -1.527448853233165e-11,  7.041245923852338e-13, -2.960003153407129e-14,  1.743874674528781e-02, -1.168171941783350e-03,  5.630192645026192e-05, -2.339100000522816e-06,
  8.823016351345545e-08, -3.096081642618629e-09,  1.024120036244557e-10, -3.223970383707977e-12,  9.723491805941361e-14, -2.818649571972740e-15,  7.896432759709007e-17,
 -2.142130523273290e-18,  3.232124780300505e-02, -3.515773237805053e-03,  2.685386650444386e-04, -1.669691385902888e-05,  8.988217834585831e-07, -4.330983666680190e-08,
  1.906333006362560e-09, -7.768881096056774e-11,  2.959372965252921e-12, -1.061132488508844e-13,  3.600614144941164e-15, -1.159981714176332e-16,  2.114020906341220e-02,
 -3.845170276164036e-03,  4.386223208844567e-04, -3.814827061723294e-05,  2.745178765463593e-06, -1.706336385703397e-07,  9.406014311526115e-09, -4.680224908009805e-10,
  2.128764755315381e-11, -8.934840315969196e-13,  3.485890987040497e-14, -1.270156475208308e-15,  7.572533984424675e-03, -2.136452115860678e-03,  3.425864903055633e-04,
 -3.952180870821280e-05,  3.613121081546410e-06, -2.757436374574917e-07,  1.814562911638839e-08, -1.052584971106560e-09,  5.468849473822877e-11, -2.576002425057800e-12,
  1.110543986857772e-13, -4.410092170691849e-15,  1.789907892919555e-03, -6.743898026614724e-04,  1.372099706671870e-04, -1.925153875521567e-05,  2.070322059953374e-06,
 -1.809820235966668e-07,  1.335033833468577e-08, -8.527705104772662e-10,  4.807025165277713e-11, -2.426092280999166e-12,  1.108875493708726e-13, -4.626194552802220e-15,
  1.351772753813282e-02, -8.100034252500097e-04,  3.502111434769597e-05, -1.314629588508292e-06,  4.506155915375774e-08, -1.445634189675963e-09,  4.391995060489558e-11,
 -1.272230770965138e-12,  3.555853756987188e-14, -9.567589146987401e-16,  2.484435783089031e-17, -6.306906769690539e-19,  2.156080612415625e-02, -1.977138498856978e-03,
  1.322909610831654e-04, -7.343647735255151e-06,  3.572313993527279e-07, -1.569749012230255e-08,  6.348819211895499e-10, -2.392858166414010e-11,  8.477628400368997e-13,
 -2.842007654852761e-14,  9.058902599708466e-16, -2.753489372087327e-17,  1.066924970575844e-02, -1.617874174456404e-03,  1.619787825881517e-04, -1.263590133566185e-05,
  8.281228014561806e-07, -4.742544954592373e-08,  2.431370491490023e-09, -1.134055636673321e-10,  4.867859310840271e-12, -1.939569938044378e-13,  7.221207088564229e-15,
 -2.522767738821790e-16,  2.485899639538830e-03, -6.137992491941527e-04,  8.912204178164952e-05, -9.488814379090119e-06,  8.116964892801836e-07, -5.856954409744658e-08,
  3.674216727345869e-09, -2.045384668893018e-10,  1.025493220790868e-11, -4.682816626746326e-13,  1.964790936658609e-14, -7.619277074200098e-16,  3.620149533356553e-04,
 -1.300966323407269e-04,  2.546223858371100e-05, -3.461895110306398e-06,  3.627834566345946e-07, -3.103542388938216e-08,  2.247857376476538e-09, -1.413531955325698e-10,
  7.860805309028470e-12, -3.920723758129409e-13,  1.773496109185780e-14, -7.331391856528967e-16,  1.075295153632243e-02, -5.825572319640568e-04,  2.277457249384766e-05,
 -7.778223410697910e-07,  2.435496374438469e-08, -7.165505413117254e-10,  2.015701505709141e-11, -5.371494326059899e-13,  1.390169544361286e-14, -3.524518678005365e-16,
  8.443270267893165e-18, -1.986944606683580e-19,  1.532213066173792e-02, -1.193563039981390e-03,  7.027091589126629e-05, -3.494352248297128e-06,  1.539668348565693e-07,
 -6.178425108729073e-09,  2.297216632530149e-10, -8.008087663260223e-12,  2.637088198591819e-13, -8.253699904097212e-15,  2.467930393512806e-16, -7.064626795590146e-18,
  6.072708632866254e-03, -7.591167591444306e-04,  6.648191449964627e-05, -4.633036140489540e-06,  2.753707873295494e-07, -1.446515058786725e-08,  6.863976703860710e-10,
 -2.986870573881945e-11,  1.204062367195892e-12, -4.531815952365359e-14,  1.602368938298631e-15, -5.341895299223361e-17,  9.598162562160187e-04, -2.009195643763301e-04,
  2.598065588811736e-05, -2.518442212764420e-06,  1.993064906939691e-07, -1.346458804189408e-08,  7.982915279500856e-10, -4.232416445873794e-11,  2.033901121735606e-12,
 -8.949934622947305e-14,  3.635232480358010e-15, -1.370119976710705e-16,  8.080832789451001e-05, -2.708772108845479e-05,  5.025789289646289e-06, -6.550885166441004e-07,
  6.635150033861808e-08, -5.519496171277462e-09,  3.905246198382758e-10, -2.407596054478747e-11,  1.316386679085496e-12, -6.470267023734167e-14,  2.889643474625678e-15,
 -1.181261160832499e-16,  8.736105602551447e-03, -4.320121353432163e-04,  1.537891849539963e-05, -4.808457290622738e-07,  1.386073395480517e-08, -3.727499772144612e-10,
  9.819469239538982e-12, -2.439454451447541e-13,  5.669263097938971e-15, -1.389424484632652e-16,  3.190861125858593e-18, -6.429530471126837e-20,  1.145544485604394e-02,
 -7.650099163989029e-04,  3.983856285077802e-05, -1.781904359121434e-06,  7.133940184716593e-08, -2.621196388342068e-09,  8.969482520570913e-11, -2.894355939772853e-12,
  8.870278346946896e-14, -2.589733670177585e-15,  7.254181727067134e-17, -1.956512201144311e-18,  3.830512765866877e-03, -3.920676585980048e-04,  3.005023062490978e-05,
 -1.868202047923526e-06,  1.004734278595820e-07, -4.831014979971001e-09,  2.114386059852921e-10, -8.553553560194555e-12,  3.227569272703205e-13, -1.142685509427644e-14,
  3.821193882253765e-16, -1.210944226944995e-17,  4.365712367296509e-04, -7.502185936396271e-05,  8.528757683337773e-06, -7.436846663262537e-07,  5.388270386067628e-08,
 -3.376972749840940e-09,  1.876198109180703e-10, -9.401209458436151e-12,  4.300157220768605e-13, -1.811844048980611e-14,  7.083326562843735e-16, -2.581295977353453e-17,
  2.060592988085867e-05, -6.225584822132813e-06,  1.073629295967289e-06, -1.322534345059265e-07,  1.280841731412343e-08, -1.027409631069392e-09,  7.054003796601640e-11,
 -4.240650079716359e-12,  2.269648586397269e-13, -1.095355629137766e-14,  4.815212172099956e-16, -1.941574735392478e-17,  7.222243317462219e-03, -3.287848658770083e-04,
  1.072929147503366e-05, -3.079144238628155e-07,  8.298300399680198e-09, -2.024057199694934e-10,  4.925870705248895e-12, -1.223803815013400e-13,  2.441892914568436e-15,
 -5.131126712496731e-17,  1.492948845521810e-18, -2.238419792934151e-20,  8.920353356912306e-03, -5.157695019261527e-04,  2.388971272147645e-05, -9.656220655482133e-07,
  3.523141800060867e-08, -1.189896513390919e-09,  3.756895128917840e-11, -1.121066654692991e-12,  3.207517198942684e-14, -8.767678430097712e-16,  2.286094867420500e-17,
 -5.816011097512303e-19,  2.631811274503706e-03, -2.198957947845140e-04,  1.480109012414184e-05, -8.223110348680835e-07,  3.993253463250980e-08, -1.759121320191499e-09,
  7.091793897008232e-11, -2.655837724264304e-12,  9.372986435818961e-14, -3.115064118437453e-15,  9.796452572989178e-17, -2.946713220903218e-18,  2.319173876266821e-04,
 -3.172871643528139e-05,  3.150126200047132e-06, -2.449041051517154e-07,  1.609645999946882e-08, -9.290066042818935e-10,  4.800169198761251e-11, -2.256386217224813e-12,
  9.759957800269111e-14, -3.912688452923211e-15,  1.463427923955291e-16, -5.129412578305934e-18,  6.254494428433765e-06, -1.618297408965811e-06,  2.532441087245970e-07,
 -2.895333712979163e-08,  2.644825096890480e-09, -2.024162759491498e-10,  1.337181918779459e-11, -7.785160337822646e-13,  4.055887483936801e-14, -1.913035855063835e-15,
  8.245997146823574e-17, -3.268995376243589e-18,  6.058198156099887e-03, -2.557444169640685e-04,  7.715333171421754e-06, -2.021275705515575e-07,  5.194582580615956e-09,
 -1.178145853399156e-10,  2.387142280869189e-12, -6.408310603169813e-14,  1.445824838509334e-15, -1.038166533337816e-17,  5.083828890237865e-19, -2.755668927853129e-20,
  7.177612878178257e-03, -3.629547151377949e-04,  1.503297929718881e-05, -5.522188568353010e-07,  1.840266854184457e-08, -5.728388906359272e-10,  1.682228187467242e-11,
 -4.632545940762350e-13,  1.227544993560881e-14, -3.204361739821362e-16,  7.826293077899150e-18, -1.786409005708728e-19,  1.938987382011918e-03, -1.322740777105567e-04,
  7.848572502822266e-06, -3.926626196596992e-07,  1.714038103128066e-08, -6.922839091261541e-10,  2.589757917174413e-11, -8.910357033452810e-13,  2.923226516162123e-14,
 -9.230479803367478e-16,  2.708739936326391e-17, -7.588077288298298e-19,  1.415184723856047e-04, -1.499592264027780e-05,  1.299768862091802e-06, -8.988115080509485e-08,
  5.309146829595106e-09, -2.807289212853104e-10,  1.343125567899887e-11, -5.876664294364694e-13,  2.389335942963827e-14, -9.075728590967568e-16,  3.224730026242828e-17,
 -1.080660835789087e-18,  2.350655678353606e-06, -4.854514734251206e-07,  6.728259725395522e-08, -6.995228911885659e-09,  5.928757169508694e-10, -4.275512659076602e-11,
  2.689782885156630e-12, -1.503657802047184e-13,  7.572872142320846e-15, -3.470855099637295e-16,  1.459748180734858e-17, -5.666815768746173e-19,  5.145084965415656e-03,
 -2.024724621118350e-04,  5.719359619767851e-06, -1.352712935366062e-07,  3.291731096291346e-09, -7.709379607606636e-11,  1.197855558246771e-12, -2.237551351910889e-14,
  1.130653431864318e-15, -1.508284534149562e-17, -6.387873665780365e-19, -1.196481176030697e-20,  5.930427911465681e-03, -2.649391252910886e-04,  9.855604990450096e-06,
 -3.312236409411404e-07,  1.012356053472861e-08, -2.891912487288598e-10,  7.973222597612825e-12, -2.069587389038441e-13,  4.921627569447145e-15, -1.187955301742138e-16,
  3.069450176877589e-18, -6.425638891014854e-20,  1.511053290337421e-03, -8.453954915147287e-05,  4.415251161980089e-06, -2.023231695901766e-07,  7.928092987209127e-09,
 -2.889923173921874e-10,  1.023461733851737e-11, -3.290165599908612e-13,  9.577549902510412e-15, -2.875971980424101e-16,  8.588717701134740e-18, -2.083453620248121e-19,
  9.709192238614557e-05, -7.803478135518271e-06,  5.900846440052545e-07, -3.669174534088970e-08,  1.929948528604070e-09, -9.258807765459132e-11,  4.120063471429861e-12,
 -1.671891451398243e-13,  6.295112561549818e-15, -2.266605187939512e-16,  7.689743772147928e-18, -2.413571023711056e-19,  1.117652337783786e-06, -1.694199178895494e-07,
  2.041602609631563e-08, -1.897505787727029e-09,  1.463612167950943e-10, -9.807602584970570e-12,  5.814121764520746e-13, -3.088479330692329e-14,  1.490453534695828e-15,
 -6.596827094717310e-17,  2.691221893170778e-18, -1.016967560051449e-19,  4.417545598429169e-03, -1.624230773901272e-04,  4.365865503411154e-06, -9.352428018559403e-08,
  2.004929475680887e-09, -5.245774334239880e-11,  9.606766851061813e-13,  2.912331461165711e-16,  1.737672892771996e-16, -3.230677014702044e-17,  1.945842341250580e-19,
  4.080413389101817e-20,  5.006570533097685e-03, -1.996200676615151e-04,  6.690887575646141e-06, -2.068135449135405e-07,  5.861814532913267e-09, -1.528042361998539e-10,
  3.880543088073053e-12, -9.907357719801432e-14,  2.269998462427608e-15, -4.240748099603992e-17,  9.604071301449548e-19, -3.365861372755166e-20,  1.230720647876545e-03,
 -5.713855443886904e-05,  2.593681374557071e-06, -1.109780159342430e-07,  4.004118361109081e-09, -1.268575887429241e-10,  4.141195457338784e-12, -1.366807035851975e-13,
  3.654718497498953e-15, -8.057912163170929e-17,  2.556283046073844e-18, -9.240437675681335e-20,  7.312232955319433e-05, -4.431407469526105e-06,  2.878154811109631e-07,
 -1.651536154708121e-08,  7.798156607131168e-10, -3.295673987178805e-11,  1.359687112097744e-12, -5.287154072736028e-14,  1.818855221510180e-15, -5.863101841090007e-17,
  1.965586244849262e-18, -6.246918910776650e-20,  6.637676722459159e-07, -6.848875273536555e-08,  7.060235151831229e-09, -5.860607357261486e-10,  4.038377285416330e-11,
 -2.464661464461137e-12,  1.365283494464541e-13, -6.845040694896491e-15,  3.122694895415223e-16, -1.320263936386750e-17,  5.220091351816214e-19, -1.912810080192911e-20,
  3.831274331084675e-03, -1.315115596195018e-04,  3.405490221653052e-06, -6.858442877381935e-08,  1.186144129078798e-09, -2.961538414174457e-11,  9.010728015480155e-13,
 -8.165033359949692e-15, -4.919893226493255e-16,  1.327600187179456e-18,  1.044518174806130e-18, -1.530014801122479e-20,  4.301407703003354e-03, -1.546291291580369e-04,
  4.685143126473612e-06, -1.332244251823807e-07,  3.549562779852286e-09, -8.595804814646166e-11,  1.932913466946513e-12, -4.575109790974916e-14,  1.168198922140804e-15,
 -2.369051203403145e-17,  2.132263152904413e-19, -2.143772746487983e-21,  1.036551709580323e-03, -4.079026373161154e-05,  1.577060355977865e-06, -6.290146124980794e-08,
  2.209790349431114e-09, -6.232631097961284e-11,  1.616313459630008e-12, -5.306303884759256e-14,  1.814637143511170e-15, -3.727393066313702e-17,  2.018867806567484e-19,
 -1.292399185574652e-20,  5.899193385183391e-05, -2.750177439827367e-06,  1.473493743569793e-07, -7.943926815961363e-09,  3.544180475287882e-10, -1.303149802459568e-11,
  4.595082108919020e-13, -1.751754723335697e-14,  6.269119590355880e-16, -1.755046886463881e-17,  4.271594063276349e-19, -1.495660129084446e-20,  4.699460454404975e-07,
 -3.199999057755576e-08,  2.715288509681702e-09, -2.055597485093187e-10,  1.272258775087431e-11, -6.863782098575701e-13,  3.465122341719465e-14, -1.650215379756215e-15,
  7.164759217845548e-17, -2.815246824805267e-18,  1.044439392514900e-19, -3.788198908167106e-21,  3.354908651842764e-03, -1.072749470064679e-04,  2.680323688864090e-06,
 -5.327630734531939e-08,  7.834611078386151e-10, -1.222986815706303e-11,  5.045681691911128e-13, -1.726926468388299e-14,  2.364185605418136e-17,  1.807216163838485e-17,
 -2.641543117743690e-19, -2.405101207992724e-20,  3.748937512090351e-03, -1.226934430998240e-04,  3.377612370628586e-06, -8.803325861425184e-08,  2.209238739014868e-09,
 -5.144526660911914e-11,  1.058910591164298e-12, -2.031908680365633e-14,  4.785423029897493e-16, -1.400151103096171e-17,  2.858521507181310e-19,  5.600240393616143e-22,
  8.945814659111283e-04, -3.067511290889642e-05,  9.989448240044118e-07, -3.581187788434832e-08,  1.259654168717458e-09, -3.599469864743970e-11,  7.514380205696535e-13,
 -1.504163711239820e-14,  6.209969784296262e-16, -2.667633051478075e-17,  4.867916836386083e-19,  9.562309805424257e-21,  4.985912161510937e-05, -1.872889446412235e-06,
  7.901470993233905e-08, -3.891579759215892e-09,  1.739285787009546e-10, -6.112182926292173e-12,  1.730010383036127e-13, -5.148330763442715e-15,  2.033645898572830e-16,
 -7.538273808090419e-18,  1.712447593230700e-19, -1.280611068965313e-21,  3.735713173038194e-07, -1.749624910563453e-08,  1.129445358831927e-09, -7.865159974089325e-11,
  4.594053936135675e-12, -2.213828583342253e-13,  9.598330997426585e-15, -4.136417729021542e-16,  1.774613208865532e-17, -6.931353238738626e-19,  2.325630153908955e-20,
 -7.114791744833203e-22,  2.964925808592705e-03, -8.819161980686940e-05,  2.109849109271321e-06, -4.219594174493780e-08,  6.233987706701499e-10, -5.345401171530256e-12,
  1.068396130824516e-13, -9.413568919336766e-15,  3.494471050089290e-16, -7.040312497698703e-19, -4.030101870449770e-19,  1.160363368072453e-20,  3.306270520026072e-03,
 -9.936730561635804e-05,  2.503354084979931e-06, -5.970336552429291e-08,  1.395638509935360e-09, -3.151644298921185e-11,  6.439214521105816e-13, -1.095148724232257e-14,
  1.660952881900751e-16, -4.185685156897610e-18,  1.674716722228029e-19, -4.392459468917228e-21,  7.855613092264607e-04, -2.410882625627963e-05,  6.692307286109335e-07,
 -2.054941894876620e-08,  6.943631554004035e-10, -2.150899054584169e-11,  4.936032368520788e-13, -6.375685915695673e-15,  4.837972231897580e-17, -5.776871413189699e-18,
  4.040056286857423e-19, -1.029783229314242e-20,  4.339218093847183e-05, -1.388283268316296e-06,  4.560142993995200e-08, -1.899629115496222e-09,  8.442854004698631e-11,
 -3.160861766184972e-12,  8.793205320284050e-14, -1.775944842311163e-15,  4.047461276503653e-17, -2.013020095722166e-18,  9.484793878627122e-20, -2.351489315136937e-21,
  3.170835577114374e-07, -1.125728768302200e-08,  5.125691667415708e-10, -3.107743059552325e-11,  1.785010052293523e-12, -8.369964597599930e-14,  3.216257717030020e-15,
 -1.118536025207996e-16,  4.145344084588119e-18, -1.694217434657232e-19,  6.468677647490472e-21, -1.956613549654452e-22,  2.642939399628850e-03, -7.317624394614789e-05,
  1.660074810058866e-06, -3.300557506883719e-08,  5.268925608837075e-10, -4.789091375258534e-12, -2.006526852355534e-14, -6.969542999309302e-16,  1.618458101797511e-16,
 -6.561355249637405e-18,  5.816106072032041e-20,  5.550772704421048e-21,  2.944796560549480e-03, -8.186954922654250e-05,  1.902552097715778e-06, -4.167096023899325e-08,
  8.976653344463800e-10, -1.924337354968586e-11,  3.961862828646358e-13, -7.105836503940448e-15,  9.392000926434195e-17, -7.902816632986312e-19,  2.319169476392551e-20,
 -1.721218904055420e-21,  6.985003802959677e-04, -1.958129186228311e-05,  4.770238442588258e-07, -1.229648165693504e-08,  3.686105484950863e-10, -1.173285470005723e-11,
  3.225109101306849e-13, -5.930195862130777e-15,  2.293271853578936e-17,  1.727433355702619e-18,  1.591243243485901e-20, -4.880784074595900e-21,  3.845123121882019e-05,
 -1.095824557212466e-06,  2.915499248674504e-08, -9.547604369370855e-10,  3.883889949247503e-11, -1.546528009847676e-12,  4.952858221457736e-14, -1.101628191379243e-15,
  1.297864745281922e-17, -6.708633665180610e-20,  1.271805499930629e-20, -1.047049369870770e-21,  2.784402796558782e-07, -8.267300134234006e-09,  2.669566670349688e-10,
 -1.256792438140752e-11,  6.881236395853693e-13, -3.330989522662357e-14,  1.298845303298310e-15, -4.053354220138971e-17,  1.097582948667555e-18, -3.323665040791726e-20,
  1.345732300231524e-21, -5.614670293891822e-23,  2.374479712522908e-03, -6.134404691590912e-05,  1.311345607342423e-06, -2.536638818674639e-08,  4.268986267695383e-10,
 -5.113621567269890e-12,  2.427510087779263e-15,  1.438554790325051e-15, -1.791189218866349e-18, -2.290073722585331e-18,  1.025370637949113e-19, -1.698445307139511e-21,
  2.644902190908648e-03, -6.843137907950258e-05,  1.477478530894477e-06, -2.993246206103426e-08,  5.934242959877726e-10, -1.180550594225533e-11,  2.356760481123505e-13,
 -4.477776439309849e-15,  7.082799167847107e-17, -6.564906074839196e-19, -3.504160082299181e-21,  7.465776219073439e-23,  6.269942057912958e-04, -1.627044350133962e-05,
  3.583221848128711e-07, -7.909663716876663e-09,  1.985694122530814e-10, -5.847995187575205e-12,  1.752577010302715e-13, -4.353571869520615e-15,  6.622734196666829e-17,
  3.069283956840796e-19, -4.614288894080030e-20,  7.173000285527583e-22,  3.447413509653482e-05, -8.998287256077369e-07,  2.058825896054278e-08, -5.258486599259076e-10,
  1.753692637597270e-11, -6.814839595189115e-13,  2.445083722648048e-14, -6.892636822283237e-16,  1.269664845170506e-17, -5.290775456784971e-20, -4.158047485076018e-21,
  3.232332553520843e-23,  2.488965333590760e-07, -6.589030752545142e-09,  1.647957310989530e-10, -5.519604497559738e-12,  2.585780316602604e-13, -1.261733575662687e-14,
  5.282371865337105e-16, -1.772494973593659e-17,  4.616366819823588e-19, -9.379082295362101e-21,  1.941794609098702e-22, -7.601149843301017e-24,  2.148310995618878e-03,
 -5.196243950781304e-05,  1.044601992987381e-06, -1.933817440581124e-08,  3.282051135305293e-10, -4.630304350148078e-12,  3.422836083075691e-14,  6.934046941699113e-16,
 -3.015635543784405e-17,  1.903246540560129e-19,  2.551740902232820e-20, -1.278289282330638e-21,  2.392747958858034e-03, -5.790303924285811e-05,  1.168355571071130e-06,
 -2.205754038023046e-08,  4.049491623333504e-10, -7.420221059403015e-12,  1.383521265013611e-13, -2.604087247982682e-15,  4.627658779785574e-17, -6.561430818684653e-19,
  3.738972529116569e-21,  1.320964483333526e-22,  5.671106239892548e-04, -1.373711132835178e-05,  2.792466824322075e-07, -5.476813606254795e-09,  1.150379983431981e-10,
 -2.865794677122471e-12,  8.259043092685270e-14, -2.336387171914717e-15,  5.372609459527555e-17, -7.287602562441781e-19, -6.588755671047852e-21,  6.828685631649673e-22,
  3.116986140723416e-05, -7.564513862890005e-07,  1.559911029451682e-08, -3.281798760988125e-10,  8.438287556764042e-12, -2.831041853289849e-13,  1.036076614056937e-14,
 -3.389031534130995e-16,  8.671797505036123e-18, -1.413155252709795e-19, -3.034889060935458e-23,  8.100175037112727e-23,  2.248364072815167e-07, -5.480704141313211e-09,
  1.168911923323398e-10, -2.854583310175366e-12,  1.002680724174606e-13, -4.495875298446649e-15,  1.960965898832687e-16, -7.274505096920831e-18,  2.169642327009396e-19,
 -4.917587153280915e-21,  7.558172708488497e-23, -6.430088293281409e-25,  1.955822316131997e-03, -4.445130697777848e-05,  8.411537657382678e-07, -1.477833658210725e-08,
  2.448679298945859e-10, -3.673798654440857e-12,  4.204637817492661e-14, -5.174768734778735e-17, -1.500761041185580e-17,  4.579811726894050e-19, -4.342403576559201e-21,
 -2.186297090465984e-22,  2.178295088191205e-03, -4.951502884462048e-05,  9.381661832688987e-07, -1.660722587967941e-08,  2.846198679446356e-10, -4.827980376291619e-12,
  8.287409315030167e-14, -1.464193442028113e-15,  2.625938180936980e-17, -4.428592377986775e-19,  5.801078926027737e-21, -1.936119997489545e-23,  5.162530816619630e-04,
 -1.173848822567184e-05,  2.229729495437275e-07, -4.006100531934994e-09,  7.314336912550405e-11, -1.499235614746084e-12,  3.720738791731667e-14, -1.042558912212732e-15,
  2.795765021030119e-17, -6.086832616713162e-19,  8.017221916880585e-21,  6.284431763315554e-23,  2.837146644292365e-05, -6.454723985867911e-07,  1.232035567945343e-08,
 -2.276748420158065e-10,  4.636697452568555e-12, -1.215288914977087e-13,  4.021769073537844e-15, -1.378002761415211e-16,  4.160914986476648e-18, -9.923708459564720e-20,
  1.536929749496278e-21,  5.545303845926697e-25,  2.045981285940139e-07, -4.660787261223417e-09,  8.996353832715316e-11, -1.770962750903902e-12,  4.434758955601234e-14,
 -1.593213371715496e-15,  6.686597694374586e-17, -2.630598992700180e-18,  8.822283933488419e-20, -2.403412195992568e-21,  4.968528536056284e-23, -6.352943643755664e-25,
  1.790439503645567e-03, -3.837006666448581e-05,  6.850706454984759e-07, -1.139471723100818e-08,  1.811445252192814e-10, -2.722607227752324e-12,  3.604717336058005e-14,
 -3.121396365575392e-16, -2.744334489064573e-18,  2.168660132551682e-19, -5.703031190578725e-21,  6.750658536945587e-23,  1.994083908932286e-03, -4.273612891149504e-05,
  7.633322180971103e-07, -1.273012124005508e-08,  2.050631092765706e-10, -3.249210211600022e-12,  5.154816654889863e-14, -8.369578318202434e-16,  1.413063253631267e-17,
 -2.436020275979762e-19,  3.953533566582183e-21, -4.966792402864631e-23,  4.725876597089579e-04, -1.012910879723804e-05,  1.810659132761149e-07, -3.035509376538557e-09,
  5.016867885284739e-11, -8.734552521495362e-13,  1.769537759322568e-14, -4.358928616427561e-16,  1.180685464849733e-17, -3.014094690632018e-19,  6.314202783583214e-21,
 -8.536642249626758e-23,  2.597097232958732e-05, -5.567329632517309e-07,  9.967142607935036e-09, -1.687672633620026e-10,  2.924079488973520e-12, -5.914844048022052e-14,
  1.572308433765628e-15, -5.047462683351059e-17,  1.618070787016597e-18, -4.558223470192222e-20,  1.032460570907600e-21, -1.595236636855295e-23,  1.872742256876136e-07,
 -4.015982015048802e-09,  7.214368127275784e-11, -1.249325995490056e-12,  2.392001780320658e-14, -6.208745096921853e-16,  2.214708936720092e-17, -8.620990211633209e-19,
  3.089984585274009e-20, -9.514727355189415e-22,  2.415651350248370e-23, -4.729626121869171e-25,  1.647118838367695e-03, -3.339102478909208e-05,  5.640708792255631e-07,
 -8.888088417009788e-09,  1.346098629804899e-10, -1.966481855152604e-12,  2.697422272627087e-14, -3.127134971231609e-16,  1.743200176233678e-18,  5.395276463799217e-20,
 -2.518664986829614e-21,  6.083685422487031e-23,  1.834457958324563e-03, -3.718927805836510e-05,  6.283103180416734e-07, -9.908908750058620e-09,  1.507855750978098e-10,
 -2.249289979548473e-12,  3.331930795986461e-14, -4.986400955088243e-16,  7.713914447803940e-18, -1.252588117882408e-19,  2.089946265177278e-21, -3.301304995684096e-23,
  4.347552617601961e-04, -8.813835677341322e-06,  1.489445209208168e-07, -2.352982906582095e-09,  3.614172243745499e-11, -5.609970480758184e-13,  9.453932114922546e-15,
 -1.901859271365275e-16,  4.619373356443229e-18, -1.204529723425070e-19,  2.937305687523096e-21, -5.975518805283364e-23,  2.389170706919824e-05, -4.843799041722868e-07,
  8.189153767144645e-09, -1.297875872450748e-10,  2.028724220031247e-12, -3.378564969292164e-14,  6.864304775711762e-16, -1.828254863134746e-17,  5.630043057230596e-19,
 -1.691801297031816e-20,  4.482744969525958e-22, -9.751219563874031e-24,  1.722777837561517e-07, -3.493083877174557e-09,  5.911351088307496e-11, -9.436100474966054e-13,
  1.532703568646479e-14, -2.931762333702057e-16,  7.819770689003984e-18, -2.707232706559861e-19,  9.757853729403289e-21, -3.215851769274716e-22,  9.196763526216925e-24,
 -2.204698904892276e-25,  1.521952398385002e-03, -2.927124690130801e-05,  4.691446030317488e-07, -7.016639846548213e-09,  1.010828459499981e-10, -1.416652627894070e-12,
  1.917944709428369e-14, -2.407608621537416e-16,  2.411511688173394e-18, -4.740089653766547e-21, -6.806172869006167e-22,  2.496424962953918e-23,  1.695054457273375e-03,
 -3.260056779624276e-05,  5.225231690503672e-07, -7.817070998060903e-09,  1.127938625119552e-10, -1.592930083300142e-12,  2.223552988457797e-14, -3.103200653577675e-16,
  4.409037939471468e-18, -6.534685569183959e-20,  1.025374179540585e-21, -1.663559805982456e-23,  4.017170500694797e-04, -7.726172687681873e-06,  1.238436853894281e-07,
 -1.853701276954397e-09,  2.683128743218203e-11, -3.846120591486848e-13,  5.681588946134621e-15, -9.352819406431750e-17,  1.867442654004093e-18, -4.441787120066099e-20,
  1.112128232035332e-21, -2.596385436159704e-23,  2.207606780337287e-05, -4.245909410693207e-07,  6.806660242640332e-09, -1.019821631860646e-10,  1.484813375891466e-12,
 -2.187597152965678e-14,  3.555980805322034e-16, -7.268613494297434e-18,  1.914710471470471e-19, -5.620078878909699e-21,  1.587698501523141e-22, -3.979481655159458e-24,
  1.591849185549772e-07, -3.061690123621798e-09,  4.909535123015877e-11, -7.371465683533958e-13,  1.087112227337255e-14, -1.697495017222321e-16,  3.282587024559343e-18,
 -8.853738078123648e-20,  2.932455854674566e-21, -9.806373892010203e-23,  2.995160659459524e-24, -8.019422931718422e-26,  1.411876628193986e-03, -2.582939583309804e-05,
  3.937890088972781e-07, -5.603107388657919e-09,  7.685067611003590e-11, -1.028821825451935e-12,  1.346573239180637e-14, -1.698481883024852e-16,  1.953291220413224e-18,
 -1.657203756489117e-20, -4.156864305879270e-23,  6.879920579393343e-24,  1.572458800705237e-03, -2.876716838639622e-05,  4.385816797103493e-07, -6.240935608295983e-09,
  8.564208139193162e-11, -1.149524286529849e-12,  1.521727330913815e-14, -2.001919916024949e-16,  2.647403727054984e-18, -3.588718469575722e-20,  5.116826773796207e-22,
 -7.781889081939290e-24,  3.726625652035060e-04, -6.817643216287862e-06,  1.039430523776034e-07, -1.479315013687098e-09,  2.032009547312621e-11, -2.741453805784752e-13,
  3.709196823571684e-15, -5.262269579677035e-17,  8.503811409549678e-19, -1.679689740785627e-20,  3.889645489448075e-22, -9.334802023442021e-24,  2.047938971534037e-05,
 -3.746594726921068e-07,  5.712316718519714e-09, -8.132036884685803e-11,  1.119072870616760e-12, -1.524195216199890e-14,  2.145014265388077e-16, -3.434243805079389e-18,
  7.034538292897029e-20, -1.812813641963439e-21,  5.056462576111722e-23, -1.346623792261468e-24,  1.476715255807144e-07, -2.701587146378663e-09,  4.119313028833914e-11,
 -5.867749843057195e-13,  8.106643843073495e-15, -1.126932953704521e-16,  1.718032498579367e-18, -3.364695593246413e-20,  9.028309691265609e-22, -2.838402816213198e-23,
  8.837460872552658e-25, -2.516822263408026e-26,  1.314461416246707e-03, -2.292858679637278e-05,  3.333031143486493e-07, -4.522045705290980e-09,  5.915496039335795e-11,
 -7.562011225127425e-13,  9.495746404110489e-15, -1.167692767777749e-16,  1.377339414830933e-18, -1.451542811365470e-20,  1.013827215920341e-22,  8.532657920917294e-25,
  1.463963857478195e-03, -2.553641237952982e-05,  3.712128603744486e-07, -5.036490486889446e-09,  6.589458080474365e-11, -8.430686005173649e-13,  1.062845229013059e-14,
 -1.327744359845131e-16,  1.654916459973592e-18, -2.083062653339368e-20,  2.704345383060641e-22, -3.719580462020380e-24,  3.469499435582635e-04, -6.051966413108700e-06,
  8.797548367735348e-08, -1.193671839826260e-09,  1.562190306784040e-11, -2.001993157228562e-13,  2.543332256932394e-15, -3.273661011536810e-17,  4.488482749344274e-19,
 -7.133813846250628e-21,  1.387791901554737e-22, -3.113356274771019e-24,  1.906636983379830e-05, -3.325814253871960e-07,  4.834669892047696e-09, -6.560297804986119e-11,
  8.590268938939545e-13, -1.104223439910889e-14,  1.422724003026055e-16, -1.930154141709768e-18,  3.056879332390422e-20, -6.233972050174895e-22,  1.558915443431534e-23,
 -4.126109969284932e-25,  1.374825759327572e-07, -2.398160422276995e-09,  3.486219158994312e-11, -4.731309441695826e-13,  6.202400680606901e-15, -8.024659286816988e-17,
  1.065105749939194e-18, -1.600363323588860e-20,  3.160425895647602e-22, -8.323480187891044e-24,  2.475111849161094e-25, -7.199254961383505e-27,  1.227757538513263e-03,
 -2.046420407963224e-05,  2.842556247521138e-07, -3.685204004263823e-09,  4.606888064266370e-11, -5.630110330926513e-13,  6.770502875921820e-15, -8.023866817802219e-17,
  9.310734690139396e-19, -1.030071186236696e-20,  9.949006499116479e-23, -5.491146867211442e-25,  1.367398560720589e-03, -2.279173500088714e-05,  3.165861110428505e-07,
 -4.104373217336644e-09,  5.131114020446990e-11, -6.272392005868790e-13,  7.552669107014498e-15, -9.000721179016532e-17,  1.066337909780918e-18, -1.264436124010947e-20,
  1.520256941105509e-22, -1.895411527901429e-24,  3.240645895820398e-04, -5.401493828419983e-06,  7.502894856845849e-08, -9.727219372294810e-10,  1.216157193019222e-11,
 -1.487404708096010e-13,  1.795522715132538e-15, -2.162868716391359e-17,  2.663726524892424e-19, -3.544244574368696e-21,  5.538996792171668e-23, -1.055954232247778e-24,
  1.780872217764241e-05, -2.968350167066362e-07,  4.123167895517130e-09, -5.345639777474778e-11,  6.684465131587855e-13, -8.182865928504482e-15,  9.923787232719790e-17,
 -1.218943621352515e-18,  1.604224687280089e-20, -2.515522408280108e-22,  5.071408697366823e-24, -1.223093366092500e-25,  1.284140027965737e-07, -2.140399756585369e-09,
  2.973121360527761e-11, -3.854778637148310e-13,  4.821736162658198e-15, -5.913980939349735e-17,  7.242475853462102e-19, -9.260517491586506e-21,  1.377950541546080e-22,
 -2.724021756320431e-24,  6.972082749119938e-26, -1.957804124665851e-27,  1.150185366769130e-03, -1.835532011619506e-05,  2.441108501589439e-07, -3.030062372217197e-09,
  3.626764119832311e-11, -4.244288495530099e-13,  4.890369835963235e-15, -5.566172056521148e-17,  6.253599294784961e-19, -6.871069818693817e-21,  7.148639793374495e-23,
 -6.330920033928218e-25,  1.281003588349567e-03, -2.044299280410154e-05,  2.718752412454728e-07, -3.374697066768391e-09,  4.039314416776364e-11, -4.727440113656755e-13,
  5.449271966475156e-15, -6.213818419648755e-17,  7.033094163302000e-19, -7.932526831368302e-21,  8.978326922509547e-23, -1.033897585788183e-24,  3.035895405394368e-04,
 -4.844856775848812e-06,  6.443268789272861e-08, -7.997838515181296e-10,  9.573161119464364e-12, -1.120565109182894e-13,  1.292676010320009e-15, -1.479344005135897e-17,
  1.698331670885219e-19, -2.009854976671933e-21,  2.601582432321787e-23, -3.990284650168409e-25,  1.668353138938348e-05, -2.662454141057588e-07,  3.540851072382061e-09,
 -4.395176183332841e-11,  5.261103877682883e-13, -6.159900940507247e-15,  7.116183838350563e-17, -8.197345660028758e-19,  9.653439211401050e-21, -1.237441537540963e-22,
  1.918551918642267e-24, -3.796846765992042e-26,  1.203005471354747e-07, -1.919825634463049e-09,  2.553217134994708e-11, -3.169282312805985e-13,  3.794005864105948e-15,
 -4.444597013077957e-17,  5.149886999367255e-19, -6.013777347835189e-21,  7.453863648410868e-23, -1.099821858719564e-24,  2.159119358792626e-26, -5.330786464511383e-28,
  1.080452700553132e-03, -1.653861768619024e-05,  2.109709731757729e-07, -2.511803646615192e-09,  2.883729666711091e-11, -3.237111405146284e-13,  3.578448406829773e-15,
 -3.910792720300899e-17,  4.231654732583084e-19, -4.522803501886414e-21,  4.719105292458413e-23, -4.628892629211014e-25,  1.203339762386301e-03, -1.841966456490575e-05,
  2.349661118523029e-07, -2.797488904504498e-09,  3.211726720540141e-11, -3.605378597200191e-13,  3.986027682908249e-15, -4.358787478150687e-17,  4.728219485774594e-19,
 -5.101328341537114e-21,  5.494823534513909e-23, -5.951819959598106e-25,  2.851837173952998e-04, -4.365341029200333e-06,  5.568544816069598e-08, -6.629872424765431e-10,
  7.611635468987588e-12, -8.544919055146702e-14,  9.449270705669891e-16, -1.034468068818296e-17,  1.127576235248834e-19, -1.238551786273792e-21,  1.412869273320001e-23,
 -1.780791777975213e-25,  1.567205341320354e-05, -2.398939845976631e-07,  3.060151663839385e-09, -3.643400867910254e-11,  4.182966908073172e-13, -4.696196682140177e-15,
  5.195404643690061e-17, -5.699477706433878e-19,  6.267098190564310e-21, -7.105615692558517e-23,  8.891701875322202e-25, -1.358864912877812e-26,  1.130070457932829e-07,
 -1.729812310071069e-09,  2.206595243329737e-11, -2.627167671416374e-13,  3.016300826635775e-15, -3.386891385576572e-17,  3.750153238729319e-19, -4.131575712676457e-21,
  4.625491165868731e-23, -5.580483614131413e-25,  8.156119258755646e-27, -1.577315676912208e-28,  1.017493329167966e-03, -1.496403619835815e-05,  1.833982209445747e-07,
 -2.097880969986421e-09,  2.314051881671027e-11, -2.495768265433821e-13,  2.650909008502421e-15, -2.784421489142394e-17,  2.898779913110015e-19, -2.992110315872258e-21,
  3.051033292163319e-23, -3.030785168691925e-25,  1.133219603439633e-03, -1.666599543107267e-05,  2.042573204232987e-07, -2.336487137019583e-09,  2.577246679416101e-11,
 -2.779646949833473e-13,  2.952535746195676e-15, -3.101792452785227e-17,  3.231786900582421e-19, -3.346592039987836e-21,  3.452024532710233e-23, -3.559859876549019e-25,
  2.685656945680352e-04, -3.949732804915298e-06,  4.840766065563602e-08, -5.537323984559993e-10,  6.107917892883171e-12, -6.587666403521584e-14,  6.997869895472174e-16,
 -7.354149800335344e-18,  7.674263149061278e-20, -7.996208628542650e-22,  8.429504218498708e-24, -9.288214235474333e-26,  1.475882265498967e-05, -2.170545504484009e-07,
  2.660206100496400e-09, -3.042995127521097e-11,  3.356569872084928e-13, -3.620283806798562e-15,  3.846170635877998e-17, -4.044494222369956e-19,  4.232420712090104e-21,
 -4.459396472736425e-23,  4.882818306487537e-25, -5.968443765004081e-27,  1.064219794815590e-07, -1.565123149039963e-09,  1.918204598322883e-11, -2.194225015468250e-13,
  2.420348714872634e-15, -2.610609621631615e-17,  2.774164705334806e-19, -2.920894779169196e-21,  3.074243898270245e-23, -3.313093085557673e-25,  3.900245353511842e-27,
 -5.629639635346153e-29,  9.604205295353206e-04, -1.359161263814413e-05,  1.602909343346699e-07, -1.764355591244326e-09,  1.872707336387597e-11, -1.943541804895829e-13,
  1.986482239941541e-15, -2.007990015410765e-17,  2.012490166166978e-19, -2.002487573369620e-21,  1.977239303552831e-23, -1.928134607279271e-25,  1.069655535223788e-03,
 -1.513747701707202e-05,  1.785218872444453e-07, -1.965027516583090e-09,  2.085703240547654e-11, -2.164597436976820e-13,  2.212442873580032e-15, -2.236513231515168e-17,
  2.242081484784481e-19, -2.233280297591085e-21,  2.213907714667257e-23, -2.188520779245079e-25,  2.535014227473589e-04, -3.587483853490377e-06,  4.230852931614440e-08,
 -4.656987943748656e-10,  4.942983455930822e-12, -5.129972304221045e-14,  5.243458570373404e-16, -5.301032660339499e-18,  5.316763984964674e-20, -5.306594534289516e-22,
  5.300777311735742e-24, -5.375376998180541e-26,  1.393097710015499e-05, -1.971474356487432e-07,  2.325032934229136e-09, -2.559212360435036e-11,  2.716380835573287e-13,
 -2.819153514376781e-15,  2.881612899858807e-17, -2.913773421096148e-19,  2.924927702770637e-21, -2.929973498411977e-23,  2.966889953450407e-25, -3.143546971718623e-27,
  1.004526034096926e-07, -1.421578187782616e-09,  1.676519977284672e-11, -1.845380847867630e-13,  1.958713478713840e-15, -2.032840673390196e-17,  2.078013437147241e-19,
 -2.101958762853749e-21,  2.113670584790022e-23, -2.133008797737659e-25,  2.219485695957115e-27, -2.551721608179785e-29,  9.084914647201169e-04, -1.238915995545895e-05,
  1.407960908639488e-07, -1.493407584210176e-09,  1.527470118657234e-11, -1.527592742090435e-13,  1.504566385347144e-15, -1.465588611644975e-17,  1.415655301475079e-19,
 -1.358200273509419e-21,  1.295163288794921e-23, -1.226103283517552e-25,  1.011820232964425e-03, -1.379826140304919e-05,  1.568097654733763e-07, -1.663262756423625e-09,
  1.701199530611785e-11, -1.701336746247343e-13,  1.675695685552387e-15, -1.632308378833749e-17,  1.576810583506428e-19, -1.513310934107200e-21,  1.444968948781431e-23,
 -1.374420801836084e-25,  2.397948313012614e-04, -3.270098440155957e-06,  3.716289718513966e-08, -3.941824872753883e-10,  4.031732933257431e-12, -4.032061036266291e-14,
  3.971312530295952e-16, -3.868594608605706e-18,  3.737589319604564e-20, -3.589329348988142e-22,  3.435870210899760e-24, -3.297806981286142e-26,  1.317774183415998e-05,
 -1.797057625721630e-07,  2.042258638055988e-09, -2.166199795295388e-11,  2.215608438411174e-13, -2.215791572509166e-15,  2.182426358299739e-17, -2.126083397226701e-19,
  2.054602300853619e-21, -1.975328457131141e-23,  1.899434446807523e-25, -1.852614199188408e-27,  9.502122247115286e-08, -1.295810880349268e-09,  1.472618870089663e-11,
 -1.561989620793895e-13,  1.597617388679005e-15, -1.597753431220863e-17,  1.573721162645291e-19, -1.533243790042268e-21,  1.482438649224655e-23, -1.428477241157614e-25,
  1.386136704059022e-27, -1.395451658588233e-29,  8.610796379857914e-04, -1.133054017847657e-05,  1.242467450805496e-07, -1.271622754335764e-09,  1.254983817002829e-11,
 -1.211040066496812e-13,  1.150928531261976e-15, -1.081778343597857e-17,  1.008295738071679e-19, -9.336025087171987e-22,  8.596679692962062e-24, -7.873367799162225e-26,
  9.590159442780712e-04, -1.261923776749651e-05,  1.383781526249961e-07, -1.416252857658452e-09,  1.397721479187374e-11, -1.348779839835531e-13,  1.281832254839204e-15,
 -1.204821872678174e-17,  1.123004755659357e-19, -1.039916408590019e-21,  9.579598874461972e-24, -8.787455149511390e-26,  2.272805574359161e-04, -2.990677487011965e-06,
  3.279472448657439e-08, -3.356427404623153e-10,  3.312509310367470e-12, -3.196521365539355e-14,  3.037863690636768e-16, -2.855375363121417e-18,  2.661578813124114e-20,
 -2.465119152715696e-22,  2.272646163097044e-24, -2.091033131466162e-26,  1.249002947042335e-05, -1.643503974615558e-07,  1.802209040898048e-09, -1.844499056020749e-11,
  1.820364270656102e-13, -1.756624527644043e-15,  1.669439056922640e-17, -1.569174689555659e-19,  1.462777496008590e-21, -1.355259900470499e-23,  1.251219052458387e-25,
 -1.157467834210462e-27,  9.006230990949403e-08, -1.185087390338635e-09,  1.299525430566604e-11, -1.330019654941178e-13,  1.312616791821344e-15, -1.266656506406318e-17,
  1.203794480025045e-19, -1.131525757888490e-21,  1.054951098674193e-23, -9.780618564320731e-26,  9.055447830904452e-28, -8.467764078362504e-30,  8.176533699987367e-04,
 -1.039436536744607e-05,  1.101167229457581e-07, -1.088797975282723e-09,  1.038120680275942e-11, -9.678073727711249e-14,  8.885862786518410e-16, -8.068842170951378e-18,
  7.265858675707997e-20, -6.499901028014617e-22,  5.783619997852177e-24, -5.121992164222893e-26,  9.106505184068959e-04, -1.157658557733203e-05,  1.226410292149282e-07,
 -1.212634200838786e-09,  1.156193043471394e-11, -1.077882560609836e-13,  9.896512867903504e-16, -8.986576293646833e-18,  8.092309941305237e-20, -7.239435488299230e-22,
  6.442472102604543e-24, -5.708356986039768e-26,  2.158182652620857e-04, -2.743575681846728e-06,  2.906512832426569e-08, -2.873864391026352e-10,  2.740102522901223e-12,
 -2.554511866801603e-14,  2.345410196963541e-16, -2.129765281140184e-18,  1.917850596722824e-20, -1.715815507338000e-22,  1.527295687914863e-24, -1.354569144726005e-26,
  1.186012795721863e-05, -1.507711064566280e-07,  1.597251931486156e-09, -1.579310231096439e-11,  1.505802430759417e-13, -1.403812606886591e-15,  1.288903080378606e-17,
 -1.170401076770988e-19,  1.053965009558848e-21, -9.430264286623220e-24,  8.397742090743594e-26, -7.460847945151860e-28,  8.552025615134179e-08, -1.087170702624520e-09,
  1.151736261425291e-11, -1.138798975978221e-13,  1.085794456597509e-15, -1.012252427030002e-17,  9.293951696055855e-20, -8.439521142069960e-22,  7.600213372915086e-24,
 -6.801515576794156e-26,  6.061951250269154e-28, -5.404097773524184e-30,  7.777588289245502e-04, -9.563010140145118e-06,  9.798742211523779e-08, -9.370972184399062e-10,
  8.641824205166363e-12, -7.792319157420298e-14,  6.919865504264390e-16, -6.077566799779062e-18,  5.293308066877190e-20, -4.580095211034636e-22,  3.942027635277011e-24,
 -3.377587972090069e-26,  8.662185062072919e-04, -1.065067479837870e-05,  1.091321824394590e-07, -1.043679509104890e-09,  9.624716274922451e-12, -8.678591421439685e-14,
  7.706908127395228e-16, -6.768810970467688e-18,  5.895362177298731e-20, -5.101070282728176e-22,  4.390586989672525e-24, -3.762505882984395e-26,  2.052881666115003e-04,
 -2.524140833827909e-06,  2.586361927265310e-08, -2.473452730940397e-10,  2.280995322159309e-12, -2.056769889978536e-14,  1.826487390645939e-16, -1.604165245786994e-18,
  1.397167545163684e-20, -1.208943255763476e-22,  1.040633669837051e-24, -8.920338607421256e-27,  1.128145442721588e-05, -1.387122319554401e-07,  1.421315446316775e-09,
 -1.359267059943748e-11,  1.253503563039049e-13, -1.130282208574699e-15,  1.003732351862999e-17, -8.815576805508127e-20,  7.678075327602232e-22, -6.643874865803769e-24,
  5.719625923600270e-26, -4.905458372725667e-28,  8.134759387547950e-08, -1.000217337532598e-09,  1.024873099870276e-11, -9.801316444830988e-14,  9.038683782416562e-16,
 -8.150167346140194e-18,  7.237651513486534e-20, -6.356692777806488e-22,  5.536524219811646e-24, -4.791030356547892e-26,  4.125543486412071e-28, -3.541952488080846e-30,
  7.410065370821583e-04, -8.821853708176450e-06,  8.752321405719911e-08, -8.104479911407486e-10,  7.236581529950483e-12, -6.318038572236945e-14,  5.432512071864715e-16,
 -4.619769910408450e-18,  3.895880860627703e-20, -3.263943008323410e-22,  2.720098991495352e-24, -2.256837787277735e-26,  8.252861321146248e-04, -9.825221722834877e-06,
  9.747781049812093e-08, -9.026256239659761e-10,  8.059646011961634e-12, -7.036631071430098e-14,  6.050387818519806e-16, -5.145207428915743e-18,  4.338987369415559e-20,
 -3.635182630316270e-22,  3.029514028937592e-24, -2.513672690291254e-26,  1.955874594893064e-04, -2.328513809828136e-06,  2.310160872700551e-08, -2.139164173437449e-10,
  1.910083820557793e-12, -1.667635919971124e-14,  1.433902692836900e-16, -1.219380962914352e-18,  1.028312800723050e-20, -8.615190559660496e-23,  7.179932004870814e-25,
 -5.957915456451093e-27,  1.074835947528940e-05, -1.279616982426207e-07,  1.269531265983592e-09, -1.175561335767444e-11,  1.049671977659474e-13, -9.164365889591578e-16,
  7.879903035592978e-18, -6.701016690242658e-20,  5.651023511744401e-22, -4.734454095860610e-24,  3.945850842103595e-26, -3.274779878423276e-28,  7.750358671078346e-08,
 -9.226980729671972e-10,  9.154255287226560e-12, -8.476662893216249e-14,  7.568907924592079e-16, -6.608182709072318e-18,  5.681990743090076e-20, -4.831928854860360e-22,
  4.074816556948018e-24, -3.413948156547539e-26,  2.845491668415090e-28, -2.362273104656162e-30  };
  int offset = -5;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 5;
    if (std::isnan(t)) {
      fill_n(rr+offset, 5, 0.5);
      fill_n(ww+offset, 5, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 5; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=5; ++j) {
        const int boxof = it*60+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
