//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/PolarizationAnalysisEditor.h
//! @brief     Defines class PolarizationAnalysisEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_POLARIZATIONANALYSISEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_POLARIZATIONANALYSISEDITOR_H

#include <QFormLayout>
#include <QGroupBox>

class DoubleProperty;
class DoubleSpinBox;
class InstrumentItem;
class VectorProperty;

//! Polarization analysis editor (beam polarization, analyzer properties) for instrument editors.
//! Operates on InstrumentItem.

class PolarizationAnalysisEditor : public QGroupBox {
    Q_OBJECT

public:
    PolarizationAnalysisEditor(QWidget* parent, InstrumentItem* instrument);

signals:
    void dataChanged();

private:
    DoubleSpinBox* createSpinBox(DoubleProperty& d);
    void addBlochRow(QFormLayout* parentLayout, VectorProperty& d);

    InstrumentItem* m_instrument;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_POLARIZATIONANALYSISEDITOR_H
