(*:Name: Image *)

(* :Title: Image *)

(* :Author: Tom Wickham-Jones*)

(* :Summary: *)

(* :Context: ExtendGraphics`Image` *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package installs a MathLink function that generates
	PostScript images.
*)

(* :History:
	Created summer 1993 by Tom Wickham-Jones.
*)

(*:Warnings:
	The package installs the MathLink binary image.
	If this fails the functions cannot possibly work.
	If the installation fails an error message is printed.
	In case of a failure make sure that the binary is built
	properly for your system.	
*)


BeginPackage[ "ExtendGraphics`Image`"]

MandelbrotImage::usage = 
	"MandelbrotImage[ {x0,y0},{x1,y1},n,cont] returns a Graphics object 
	containing a image of the Mandelbrot set generated by GetMandelbrot.
	The image contains n by n samples from {x0,y0} to {x1,y1}.
	The argument cont changes the contrast of the image."

GetMandelbrot::usage = 
	"GetMandelbrot[ {x0,y0},{x1,y1},n,cont] returns a string expression 
	containing a PostScript image of the Mandelbrot set.  It contains 
	n by n samples from {x0,y0} to {x1,y1}.   The argument cont 
	changes the contrast of the image."

Begin[ "`Private`"]

ImportImage::fail = 
	"Installation of the MathLink binary image failed.
	 The binary must be found for the functions to work."


GetFile[ file_String] :=
	Block[{pos, res},
		pos = StringPosition[ file, $PathnameSeparator] ;
		If[ pos === {},
				file1 = file;
				dir1 = $Path,
				file1 = StringDrop[ file, Part[ pos, 1,1]] ;
				dir1  = StringTake[ file, Part[ pos, 1,1]-1] ;
				dir1 = Map[ StringJoin[ #, $PathnameSeparator, dir1]&,
							$Path] ;
				dir1 = Select[ dir1, (FileType[ #] === Directory)&]] ;
		res = FileNames[ file1, dir1] ;
		If[ !ListQ[ res] && Length[ res] < 1,
			file, First[ res]]
		]


If[ 
  Install[ 
    GetFile[ StringJoin[ "ExtendGraphics", $PathnameSeparator, "image"]]]
		=== $Failed,
	Message[ImportImage::fail]]



MandelbrotImage[ {x0_, y0_}, {x1_, y1_}, n_, fact_] :=                             
    Block[{image, str},
        image = GetMandelbrot[ N[{x0,y0}], N[{x1,y1}], n, N[fact]] ;
        str = ToString[ n] ;
        Graphics[
            PostScript[
                "0 0 translate",
                "1 1 scale",
                str <> " string",
                StringReplace[ "xx xx 8 [xx 0 0 xx 0 0]", "xx" -> str],
                "{ currentfile 1 index readhexstring pop } image",
                image,
                "pop"],
            PlotRange -> {{x0,x1}, {y0,y1}},
            AspectRatio -> 1]
        ]

End[]

EndPackage[]

(*:Examples:

<<ExtendGraphics`Image`

tt[n_] :=
(t = MemoryInUse[]; Apply[ StringJoin, Table[ "a", {n}]];
 MemoryInUse[] -t)



(t = MemoryInUse[];
MandelbrotImage[ 500] 
; MemoryInUse[] - t)

(t = MemoryInUse[];
b = DensityPlot[ Sin[ x/Sin[y]], {x,-Pi,Pi},{y,-Pi,Pi}, 
	Mesh -> False, 
	Frame -> False,
	PlotPoints -> 500]; MemoryInUse[] - t)


tt[n_] :=
(t = MemoryInUse[]; Table[ Random[], {n}, {n}];
 MemoryInUse[] -t)



*)

