# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
{
  'targets': [
    {
      # This target contains mocks and test utilities that don't belong in
      # production libraries but are used by more than one test executable.
      'target_name': 'test_support_common',
      'type': 'static_library',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'browser',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:theme_resources',
        'common',
        '../base/base.gyp:base_prefs_test_support',
        '../base/base.gyp:test_support_base',
        '../components/components.gyp:password_manager_core_browser_test_support',
        '../components/components.gyp:sync_driver_test_support',
        '../content/content.gyp:content_app_both',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../sql/sql.gyp:test_support_sql',
        '../sync/sync.gyp:sync',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/message_center/message_center.gyp:message_center_test_support',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:test_support_base',
        '../content/content_shell_and_tests.gyp:test_support_content',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'app/chrome_main_delegate.cc',
        'app/chrome_main_delegate.h',
        'browser/android/bookmarks/partner_bookmarks_shim_unittest.cc',
        'browser/android/mock_google_location_settings_helper.cc',
        'browser/android/mock_google_location_settings_helper.h',
        'browser/bookmarks/bookmark_test_helpers.cc',
        'browser/bookmarks/bookmark_test_helpers.h',
        'browser/browsing_data/mock_browsing_data_appcache_helper.cc',
        'browser/browsing_data/mock_browsing_data_appcache_helper.h',
        'browser/browsing_data/mock_browsing_data_cookie_helper.cc',
        'browser/browsing_data/mock_browsing_data_cookie_helper.h',
        'browser/browsing_data/mock_browsing_data_database_helper.cc',
        'browser/browsing_data/mock_browsing_data_database_helper.h',
        'browser/browsing_data/mock_browsing_data_file_system_helper.cc',
        'browser/browsing_data/mock_browsing_data_file_system_helper.h',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.cc',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.h',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.cc',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.h',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.cc',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.h',
        'browser/browsing_data/mock_browsing_data_quota_helper.cc',
        'browser/browsing_data/mock_browsing_data_quota_helper.h',
        'browser/browsing_data/mock_browsing_data_server_bound_cert_helper.cc',
        'browser/browsing_data/mock_browsing_data_server_bound_cert_helper.h',
        'browser/chromeos/contacts/contact_test_util.cc',
        'browser/chromeos/contacts/contact_test_util.h',
        'browser/chromeos/input_method/mock_candidate_window_controller.cc',
        'browser/chromeos/input_method/mock_candidate_window_controller.h',
        'browser/chromeos/input_method/mock_input_method_engine.cc',
        'browser/chromeos/input_method/mock_input_method_engine.h',
        'browser/chromeos/input_method/mock_input_method_manager.cc',
        'browser/chromeos/input_method/mock_input_method_manager.h',
        'browser/chromeos/login/fake_login_utils.cc',
        'browser/chromeos/login/fake_login_utils.h',
        'browser/chromeos/login/fake_supervised_user_manager.cc',
        'browser/chromeos/login/fake_supervised_user_manager.h',
        'browser/chromeos/login/fake_user_manager.cc',
        'browser/chromeos/login/fake_user_manager.h',
        'browser/chromeos/login/mock_authenticator.cc',
        'browser/chromeos/login/mock_authenticator.h',
        'browser/chromeos/login/mock_login_display.cc',
        'browser/chromeos/login/mock_login_display.h',
        'browser/chromeos/login/mock_login_display_host.cc',
        'browser/chromeos/login/mock_login_display_host.h',
        'browser/chromeos/login/mock_login_status_consumer.cc',
        'browser/chromeos/login/mock_login_status_consumer.h',
        'browser/chromeos/login/mock_login_utils.cc',
        'browser/chromeos/login/mock_login_utils.h',
        'browser/chromeos/login/mock_url_fetchers.cc',
        'browser/chromeos/login/mock_url_fetchers.h',
        'browser/chromeos/login/mock_user_image_manager.cc',
        'browser/chromeos/login/mock_user_image_manager.h',
        'browser/chromeos/login/mock_user_manager.cc',
        'browser/chromeos/login/mock_user_manager.h',
        'browser/chromeos/login/test/oobe_screen_waiter.cc',
        'browser/chromeos/login/test/oobe_screen_waiter.h',
        'browser/chromeos/login/test/js_checker.cc',
        'browser/chromeos/login/test/js_checker.h',
        'browser/chromeos/policy/cloud_external_data_manager_base_test_util.cc',
        'browser/chromeos/policy/cloud_external_data_manager_base_test_util.h',
        'browser/chromeos/policy/device_policy_builder.cc',
        'browser/chromeos/policy/device_policy_builder.h',
        'browser/chromeos/policy/stub_enterprise_install_attributes.cc',
        'browser/chromeos/policy/stub_enterprise_install_attributes.h',
        'browser/chromeos/settings/device_settings_test_helper.cc',
        'browser/chromeos/settings/device_settings_test_helper.h',
        'browser/chromeos/settings/mock_owner_key_util.cc',
        'browser/chromeos/settings/mock_owner_key_util.h',
        'browser/chromeos/system/fake_input_device_settings.cc',
        'browser/chromeos/system/fake_input_device_settings.h',
        # The only thing used from browser is Browser::Type.
        'browser/download/download_test_file_activity_observer.cc',
        'browser/download/download_test_file_activity_observer.h',
        'browser/download/test_download_shelf.cc',
        'browser/download/test_download_shelf.h',
        'browser/drive/dummy_drive_service.cc',
        'browser/drive/dummy_drive_service.h',
        'browser/drive/fake_drive_service.cc',
        'browser/drive/fake_drive_service.h',
        'browser/extensions/api/messaging/native_messaging_test_util.cc',
        'browser/extensions/api/messaging/native_messaging_test_util.h',
        'browser/extensions/extension_notification_observer.cc',
        'browser/extensions/extension_notification_observer.h',
        'browser/extensions/fake_safe_browsing_database_manager.cc',
        'browser/extensions/fake_safe_browsing_database_manager.h',
        'browser/extensions/mock_extension_special_storage_policy.cc',
        'browser/extensions/mock_extension_special_storage_policy.h',
        'browser/extensions/test_blacklist.cc',
        'browser/extensions/test_blacklist.h',
        'browser/extensions/test_blacklist_state_fetcher.cc',
        'browser/extensions/test_blacklist_state_fetcher.h',
        'browser/extensions/test_extension_environment.cc',
        'browser/extensions/test_extension_environment.h',
        'browser/extensions/test_extension_prefs.cc',
        'browser/extensions/test_extension_prefs.h',
        'browser/extensions/test_extension_service.cc',
        'browser/extensions/test_extension_service.h',
        'browser/extensions/test_extension_system.cc',
        'browser/extensions/test_extension_system.h',
        'browser/media/fake_desktop_media_list.cc',
        'browser/media/fake_desktop_media_list.h',
        'browser/media_galleries/media_galleries_test_util.cc',
        'browser/media_galleries/media_galleries_test_util.h',
        'browser/net/dns_probe_test_util.cc',
        'browser/net/dns_probe_test_util.h',
        'browser/net/url_request_mock_util.cc',
        'browser/net/url_request_mock_util.h',
        'browser/notifications/notification_test_util.cc',
        'browser/notifications/notification_test_util.h',
        'browser/password_manager/mock_password_store_service.cc',
        'browser/password_manager/mock_password_store_service.h',
        'browser/password_manager/null_password_store_service.cc',
        'browser/password_manager/null_password_store_service.h',
        'browser/password_manager/test_password_store_service.cc',
        'browser/password_manager/test_password_store_service.h',
        'browser/policy/test/local_policy_test_server.cc',
        'browser/policy/test/local_policy_test_server.h',
        'browser/prefs/pref_service_mock_factory.cc',
        'browser/prefs/pref_service_mock_factory.h',
        'browser/profile_resetter/profile_resetter_test_base.cc',
        'browser/profile_resetter/profile_resetter_test_base.h',
        'browser/search_engines/template_url_service_test_util.cc',
        'browser/search_engines/template_url_service_test_util.h',
        'browser/sessions/session_service_test_helper.cc',
        'browser/sessions/session_service_test_helper.h',
        'browser/signin/fake_profile_oauth2_token_service.cc',
        'browser/signin/fake_profile_oauth2_token_service.h',
        'browser/signin/fake_profile_oauth2_token_service_wrapper.cc',
        'browser/signin/fake_profile_oauth2_token_service_wrapper.h',
        'browser/signin/fake_signin_manager.cc',
        'browser/signin/fake_signin_manager.h',
        'browser/ssl/ssl_client_auth_requestor_mock.cc',
        'browser/ssl/ssl_client_auth_requestor_mock.h',
        'browser/sync/profile_sync_service_mock.cc',
        'browser/sync/profile_sync_service_mock.h',
        'browser/ui/app_list/test/chrome_app_list_test_support.cc',
        'browser/ui/app_list/test/chrome_app_list_test_support.h',
        'browser/ui/browser.h',
        'browser/ui/cocoa/find_bar/find_bar_host_unittest_util_cocoa.mm',
        'browser/ui/cocoa/run_loop_testing.h',
        'browser/ui/cocoa/run_loop_testing.mm',
        'browser/ui/find_bar/find_bar_host_unittest_util.h',
        'browser/ui/fullscreen/fullscreen_controller_state_test.cc',
        'browser/ui/fullscreen/fullscreen_controller_state_test.h',
        'browser/ui/fullscreen/fullscreen_controller_state_tests.h',
        'browser/ui/fullscreen/fullscreen_controller_test.cc',
        'browser/ui/fullscreen/fullscreen_controller_test.h',
        'browser/ui/gtk/find_bar_host_unittest_util_gtk.cc',
        'browser/ui/test/test_confirm_bubble_model.cc',
        'browser/ui/test/test_confirm_bubble_model.h',
        'browser/ui/views/find_bar_host_unittest_util_views.cc',
        'common/extensions/extension_test_util.cc',
        'common/extensions/extension_test_util.h',
        'renderer/chrome_mock_render_thread.cc',
        'renderer/chrome_mock_render_thread.h',
        'renderer/media/mock_webrtc_logging_message_filter.cc',
        'renderer/media/mock_webrtc_logging_message_filter.h',
        'renderer/mock_printer.cc',
        'renderer/mock_printer.h',
        'renderer/safe_browsing/mock_feature_extractor_clock.cc',
        'renderer/safe_browsing/mock_feature_extractor_clock.h',
        'renderer/safe_browsing/test_utils.cc',
        'renderer/safe_browsing/test_utils.h',
        'test/automation/automation_handle_tracker.cc',
        'test/automation/automation_handle_tracker.h',
        'test/automation/automation_proxy.cc',
        'test/automation/automation_proxy.h',
        'test/automation/browser_proxy.cc',
        'test/automation/browser_proxy.h',
        'test/automation/tab_proxy.cc',
        'test/automation/tab_proxy.h',
        'test/automation/window_proxy.cc',
        'test/automation/window_proxy.h',
        'test/base/chrome_process_util.cc',
        'test/base/chrome_process_util.h',
        'test/base/chrome_process_util_mac.cc',
        'test/base/chrome_render_view_host_test_harness.cc',
        'test/base/chrome_render_view_host_test_harness.h',
        'test/base/chrome_test_launcher.cc',
        'test/base/chrome_test_launcher.h',
        'test/base/chrome_test_suite.cc',
        'test/base/chrome_test_suite.h',
        'test/base/chrome_unit_test_suite.cc',
        'test/base/chrome_unit_test_suite.h',
        'test/base/find_in_page_observer.cc',
        'test/base/find_in_page_observer.h',
        'test/base/history_index_restore_observer.cc',
        'test/base/history_index_restore_observer.h',
        'test/base/in_process_browser_test.cc',
        'test/base/in_process_browser_test.h',
        'test/base/javascript_test_observer.cc',
        'test/base/javascript_test_observer.h',
        'test/base/module_system_test.cc',
        'test/base/module_system_test.h',
        'test/base/profile_mock.cc',
        'test/base/profile_mock.h',
        'test/base/scoped_browser_locale.cc',
        'test/base/scoped_browser_locale.h',
        'test/base/scoped_testing_local_state.cc',
        'test/base/scoped_testing_local_state.h',
        'test/base/test_browser_window.cc',
        'test/base/test_browser_window.h',
        'test/base/test_launcher_utils.cc',
        'test/base/test_launcher_utils.h',
        'test/base/test_switches.cc',
        'test/base/test_switches.h',
        'test/base/testing_browser_process.cc',
        'test/base/testing_browser_process.h',
        'test/base/testing_browser_process_platform_part.h',
        'test/base/testing_browser_process_platform_part.cc',
        'test/base/testing_io_thread_state.cc',
        'test/base/testing_io_thread_state.h',
        'test/base/testing_pref_service_syncable.cc',
        'test/base/testing_pref_service_syncable.h',
        'test/base/testing_profile.cc',
        'test/base/testing_profile.h',
        'test/base/testing_profile_manager.cc',
        'test/base/testing_profile_manager.h',
        'test/base/tracing.cc',
        'test/base/tracing.h',
        'test/base/ui_test_utils.cc',
        'test/base/ui_test_utils.h',
        'test/base/uma_histogram_helper.cc',
        'test/base/uma_histogram_helper.h',
        'test/logging/win/file_logger.cc',
        'test/logging/win/file_logger.h',
        'test/logging/win/log_file_printer.cc',
        'test/logging/win/log_file_printer.h',
        'test/logging/win/log_file_reader.cc',
        'test/logging/win/log_file_reader.h',
        'test/logging/win/mof_data_parser.cc',
        'test/logging/win/mof_data_parser.h',
        'test/logging/win/test_log_collector.cc',
        'test/logging/win/test_log_collector.h',
        'test/ppapi/ppapi_test.cc',
        'test/ppapi/ppapi_test.h',
        '../ui/gfx/image/image_unittest_util.cc',
        '../ui/gfx/image/image_unittest_util.h',
        '../webkit/browser/quota/mock_quota_manager.cc',
        '../webkit/browser/quota/mock_quota_manager.h',
        '../webkit/browser/quota/mock_quota_manager_proxy.cc',
        '../webkit/browser/quota/mock_quota_manager_proxy.h',
        '../webkit/browser/quota/mock_special_storage_policy.cc',
        '../webkit/browser/quota/mock_special_storage_policy.h',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            'common/extensions/api/api.gyp:api',
            'plugin',
            'renderer',
            'utility',
            '../content/content.gyp:content_gpu',
            '../content/content.gyp:content_plugin',
            '../content/content.gyp:content_ppapi_plugin',
            '../content/content.gyp:content_renderer',
            '../content/content.gyp:content_utility',
            '../content/content.gyp:content_worker',
            '../components/components.gyp:autofill_core_test_support',
            '../components/components.gyp:sessions_test_support',
            '../components/components.gyp:storage_monitor_test_support',
            '../extensions/extensions.gyp:extensions_test_support',
            '../google_apis/google_apis.gyp:google_apis_test_support',
            '../ipc/ipc.gyp:test_support_ipc',
            '../media/media.gyp:media_test_support',
            '../ppapi/ppapi_internal.gyp:ppapi_shared',
            '../sql/sql.gyp:test_support_sql',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../webkit/child/webkit_child.gyp:webkit_child',
          ],
          'export_dependent_settings': [
            'renderer',
          ],
        }, {  # OS=="ios"
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^test/base/chrome_test_suite\\.cc$'],
            ['include', '^test/base/chrome_unit_test_suite\\.cc$'],
            ['include', '^test/base/testing_browser_process'],
          ],
        }],
        ['chromeos==0', {
          'sources/': [
            ['exclude', '^browser/chromeos'],
          ],
        }, {  # chromeos==1
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../chromeos/chromeos.gyp:chromeos_test_support',
          ],
        }],
        ['configuration_policy==0', {
          'sources/': [
            ['exclude', '^browser/policy'],
            ['exclude', 'browser/net/disk_cache_dir_policy_handler_unittest.cc'],
          ],
        }],
        ['configuration_policy==1', {
          'dependencies': [
            '../components/components.gyp:policy_component_test_support',
            '../components/components.gyp:policy_test_support',
          ],
          'export_dependent_settings': [
            '../components/components.gyp:policy_component_test_support',
            '../components/components.gyp:policy_test_support',
          ],
        }],
        ['safe_browsing!=1', {
          'sources/': [
            ['exclude', '^browser/extensions/blacklist_unittest.cc'],
            ['exclude', '^browser/extensions/fake_safe_browsing_database_manager.cc'],
            ['exclude', '^browser/extensions/fake_safe_browsing_database_manager.h'],
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gtk',
          ],
        }],
        ['toolkit_uses_gtk == 1 or chromeos==1 or (OS=="linux" and use_aura==1)', {
          'dependencies': [
            '../build/linux/system.gyp:ssl',
          ],
        }],
        ['enable_printing==1', {
          'dependencies': [
            'service',
          ],
        }],
        ['enable_printing==0', {
          'sources/': [
            ['exclude', '^renderer/mock_printer.cc'],
            ['exclude', '^renderer/mock_printer.h'],
          ],
        }],
        ['OS=="android"', {
          '!dependencies': [
            '../components/components.gyp:storage_monitor_test_support',
          ],
          'sources/': [
            ['exclude', '^browser/media_galleries/'],
            ['exclude', '^browser/extensions/api/messaging/native_messaging_'],
          ],
        }],
        ['OS=="win"', {
          'dependencies': [
            '../ui/snapshot/snapshot.gyp:snapshot_test_support',
          ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../win8/win8.gyp:test_registrar_constants',
                '../win8/win8.gyp:test_support_win8',
              ],
            }],
          ],
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [
            'common/media_galleries/picasa_test_util.cc',
            'common/media_galleries/picasa_test_util.cc',
            'common/media_galleries/pmp_test_util.cc',
            'common/media_galleries/pmp_test_util.h',
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            '../components/components.gyp:breakpad_stubs',
          ],
        }],
        ['enable_mdns == 1', {
            'sources': [
              'browser/local_discovery/test_service_discovery_client.cc',
              'browser/local_discovery/test_service_discovery_client.h',
            ]
        }],
        ['enable_app_list==0', {
          'sources/': [
            ['exclude', '^browser/ui/app_list/'],
          ],
        }],
        ['enable_webrtc==0', {
          'sources!': [
            'renderer/media/mock_webrtc_logging_message_filter.cc',
            'renderer/media/mock_webrtc_logging_message_filter.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'test_support_unit',
      'type': 'static_library',
      'dependencies': [
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'browser',
        'common',
        'test_support_common',
        '../base/base.gyp:base',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'browser/sync/glue/session_sync_test_helper.cc',
        'browser/sync/glue/session_sync_test_helper.h',
        'test/base/run_all_unittests.cc',
      ],
      'conditions': [
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            # Needed for the following #include chain:
            #   test/base/run_all_unittests.cc
            #   test/base/chrome_test_suite.h
            #   gtk/gtk.h
            '../build/linux/system.gyp:gtk',
          ],
        }],
      ],
    },
    {
      'target_name': 'unit_tests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        # Unit tests should only depend on:
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_browser_dependencies)',
        '<@(chromium_child_dependencies)',
        # 2) test-specific support libraries:
        '../base/base.gyp:test_support_base',
        '../content/content.gyp:content_app_both',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../rlz/rlz.gyp:test_support_rlz',
        '../sync/sync.gyp:test_support_sync_api',
        '../sync/sync.gyp:test_support_sync_core',
        '../sync/sync.gyp:test_support_sync_internal_api',
        '../sync/sync.gyp:test_support_sync_notifier',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
        'test_support_unit',
        # 3) anything tests directly depend on
        '../courgette/courgette.gyp:courgette_lib',
        '../google_apis/google_apis.gyp:google_apis',
        '../skia/skia.gyp:skia',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libxml/libxml.gyp:libxml',
        '../ui/gfx/gfx.gyp:gfx_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/ui_unittests.gyp:ui_test_support',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
      ],
      'include_dirs': [
        '..',
      ],
      'msvs_settings': {
        'VCLinkerTool': {
          'conditions': [
            ['incremental_chrome_dll==1', {
              'UseLibraryDependencyInputs': "true",
            }],
          ],
        },
      },
      'variables': {
        'win_use_external_manifest': 1,
      },
      'sources': [
        '../apps/app_keep_alive_service_unittest.cc',
        '../apps/app_shim/app_shim_host_mac_unittest.cc',
        '../apps/app_shim/extension_app_shim_handler_mac_unittest.cc',
        '../apps/app_window_geometry_cache_unittest.cc',
        '../apps/saved_files_service_unittest.cc',
        '../components/autofill/content/renderer/test_password_autofill_agent.cc',
        '../components/autofill/content/renderer/test_password_autofill_agent.h',
        '../components/autofill/content/renderer/test_password_generation_agent.cc',
        '../components/autofill/content/renderer/test_password_generation_agent.h',
        '../extensions/browser/admin_policy_unittest.cc',
        '../extensions/browser/error_map_unittest.cc',
        '../extensions/browser/event_listener_map_unittest.cc',
        '../extensions/browser/event_router_unittest.cc',
        '../extensions/browser/extension_error_test_util.cc',
        '../extensions/browser/extension_error_test_util.h',
        '../extensions/browser/extension_pref_value_map_unittest.cc',
        '../extensions/browser/extension_registry_unittest.cc',
        '../extensions/browser/file_highlighter_unittest.cc',
        '../extensions/browser/file_reader_unittest.cc',
        '../extensions/browser/info_map_unittest.cc',
        '../extensions/browser/lazy_background_task_queue_unittest.cc',
        '../extensions/browser/management_policy_unittest.cc',
        '../extensions/browser/process_map_unittest.cc',
        '../extensions/browser/quota_service_unittest.cc',
        '../extensions/browser/runtime_data_unittest.cc',
        '../extensions/common/csp_validator_unittest.cc',
        '../extensions/common/event_filter_unittest.cc',
        '../extensions/common/extension_resource_unittest.cc',
        '../extensions/common/extension_set_unittest.cc',
        '../extensions/common/file_util_unittest.cc',
        '../extensions/common/id_util_unittest.cc',
        '../extensions/common/manifest_handler_unittest.cc',
        '../extensions/common/manifest_handlers/shared_module_manifest_unittest.cc',
        '../extensions/common/one_shot_event_unittest.cc',
        '../extensions/common/permissions/api_permission_set_unittest.cc',
        '../extensions/common/permissions/manifest_permission_set_unittest.cc',
        '../extensions/common/permissions/permissions_data_unittest.cc',
        '../extensions/common/url_pattern_set_unittest.cc',
        '../extensions/common/url_pattern_unittest.cc',
        '../extensions/common/user_script_unittest.cc',
        'app/chrome_dll.rc',
        # All unittests in browser, common, renderer and service.
        'browser/about_flags_unittest.cc',
        'browser/app_controller_mac_unittest.mm',
        'browser/apps/ephemeral_app_service_unittest.cc',
        'browser/autocomplete/autocomplete_input_unittest.cc',
        'browser/autocomplete/autocomplete_match_unittest.cc',
        'browser/autocomplete/autocomplete_provider_unittest.cc',
        'browser/autocomplete/autocomplete_result_unittest.cc',
        'browser/autocomplete/bookmark_provider_unittest.cc',
        'browser/autocomplete/builtin_provider_unittest.cc',
        'browser/autocomplete/contact_provider_chromeos_unittest.cc',
        'browser/autocomplete/extension_app_provider_unittest.cc',
        'browser/autocomplete/history_quick_provider_unittest.cc',
        'browser/autocomplete/history_url_provider_unittest.cc',
        'browser/autocomplete/keyword_provider_unittest.cc',
        'browser/autocomplete/search_provider_unittest.cc',
        'browser/autocomplete/shortcuts_provider_unittest.cc',
        'browser/background/background_application_list_model_unittest.cc',
        'browser/background/background_contents_service_unittest.cc',
        'browser/background/background_mode_manager_unittest.cc',
        'browser/bookmarks/bookmark_codec_unittest.cc',
        'browser/bookmarks/bookmark_expanded_state_tracker_unittest.cc',
        'browser/bookmarks/bookmark_html_writer_unittest.cc',
        'browser/bookmarks/bookmark_index_unittest.cc',
        'browser/bookmarks/bookmark_model_unittest.cc',
        'browser/bookmarks/bookmark_node_data_unittest.cc',
        'browser/bookmarks/bookmark_tag_model_unittest.cc',
        'browser/bookmarks/bookmark_utils_unittest.cc',
        'browser/browser_about_handler_unittest.cc',
        'browser/browser_commands_unittest.cc',
        'browser/browsing_data/browsing_data_appcache_helper_unittest.cc',
        'browser/browsing_data/browsing_data_cookie_helper_unittest.cc',
        'browser/browsing_data/browsing_data_database_helper_unittest.cc',
        'browser/browsing_data/browsing_data_file_system_helper_unittest.cc',
        'browser/browsing_data/browsing_data_helper_unittest.cc',
        'browser/browsing_data/browsing_data_indexed_db_helper_unittest.cc',
        'browser/browsing_data/browsing_data_local_storage_helper_unittest.cc',
        'browser/browsing_data/browsing_data_quota_helper_unittest.cc',
        'browser/browsing_data/browsing_data_remover_unittest.cc',
        'browser/browsing_data/browsing_data_server_bound_cert_helper_unittest.cc',
        'browser/browsing_data/cookies_tree_model_unittest.cc',
        'browser/captive_portal/captive_portal_detector_unittest.cc',
        'browser/captive_portal/captive_portal_service_unittest.cc',
        'browser/captive_portal/captive_portal_tab_helper_unittest.cc',
        'browser/captive_portal/captive_portal_tab_reloader_unittest.cc',
        'browser/captive_portal/testing_utils.cc',
        'browser/captive_portal/testing_utils.h',
        'browser/chrome_browser_application_mac_unittest.mm',
        'browser/chrome_elf_init_unittest_win.cc',
        'browser/chrome_page_zoom_unittest.cc',
        'browser/chrome_process_singleton_win_unittest.cc',
        'browser/chromeos/accessibility/magnification_manager_unittest.cc',
        'browser/chromeos/attestation/attestation_ca_client_unittest.cc',
        'browser/chromeos/attestation/attestation_policy_observer_unittest.cc',
        'browser/chromeos/attestation/fake_certificate.cc',
        'browser/chromeos/attestation/fake_certificate.h',
        'browser/chromeos/attestation/platform_verification_flow_unittest.cc',
        'browser/chromeos/contacts/contact_database_unittest.cc',
        'browser/chromeos/contacts/contact_manager_stub.cc',
        'browser/chromeos/contacts/contact_manager_stub.h',
        'browser/chromeos/contacts/contact_manager_unittest.cc',
        'browser/chromeos/contacts/contact_map_unittest.cc',
        'browser/chromeos/contacts/fake_contact_database.cc',
        'browser/chromeos/contacts/fake_contact_database.h',
        'browser/chromeos/contacts/fake_contact_store.cc',
        'browser/chromeos/contacts/fake_contact_store.h',
        'browser/chromeos/contacts/gdata_contacts_service_stub.cc',
        'browser/chromeos/contacts/gdata_contacts_service_stub.h',
        'browser/chromeos/contacts/gdata_contacts_service_unittest.cc',
        'browser/chromeos/contacts/google_contact_store_unittest.cc',
        'browser/chromeos/customization_document_unittest.cc',
        'browser/chromeos/dbus/cros_dbus_service_unittest.cc',
        'browser/chromeos/dbus/printer_service_provider_unittest.cc',
        'browser/chromeos/dbus/proxy_resolution_service_provider_unittest.cc',
        'browser/chromeos/dbus/service_provider_test_helper.cc',
        'browser/chromeos/dbus/service_provider_test_helper.h',
        'browser/chromeos/display/display_preferences_unittest.cc',
        'browser/chromeos/drive/change_list_loader_unittest.cc',
        'browser/chromeos/drive/change_list_processor_unittest.cc',
        'browser/chromeos/drive/download_handler_unittest.cc',
        'browser/chromeos/drive/drive_file_stream_reader_unittest.cc',
        'browser/chromeos/drive/drive_integration_service_unittest.cc',
        'browser/chromeos/drive/drive_url_request_job_unittest.cc',
        'browser/chromeos/drive/dummy_file_system.h',
        'browser/chromeos/drive/fake_file_system.cc',
        'browser/chromeos/drive/fake_file_system.h',
        'browser/chromeos/drive/fake_file_system_unittest.cc',
        'browser/chromeos/drive/fake_free_disk_space_getter.cc',
        'browser/chromeos/drive/fake_free_disk_space_getter.h',
        'browser/chromeos/drive/file_cache_unittest.cc',
        'browser/chromeos/drive/file_change_unittest.cc',
        'browser/chromeos/drive/file_system/copy_operation_unittest.cc',
        'browser/chromeos/drive/file_system/create_directory_operation_unittest.cc',
        'browser/chromeos/drive/file_system/create_file_operation_unittest.cc',
        'browser/chromeos/drive/file_system/download_operation_unittest.cc',
        'browser/chromeos/drive/file_system/get_file_for_saving_operation_unittest.cc',
        'browser/chromeos/drive/file_system/move_operation_unittest.cc',
        'browser/chromeos/drive/file_system/open_file_operation_unittest.cc',
        'browser/chromeos/drive/file_system/operation_test_base.cc',
        'browser/chromeos/drive/file_system/operation_test_base.h',
        'browser/chromeos/drive/file_system/remove_operation_unittest.cc',
        'browser/chromeos/drive/file_system/search_operation_unittest.cc',
        'browser/chromeos/drive/file_system/touch_operation_unittest.cc',
        'browser/chromeos/drive/file_system/truncate_operation_unittest.cc',
        'browser/chromeos/drive/file_system_unittest.cc',
        'browser/chromeos/drive/file_system_util_unittest.cc',
        'browser/chromeos/drive/file_write_watcher_unittest.cc',
        'browser/chromeos/drive/fileapi/fileapi_worker_unittest.cc',
        'browser/chromeos/drive/fileapi/webkit_file_stream_reader_impl_unittest.cc',
        'browser/chromeos/drive/job_queue_unittest.cc',
        'browser/chromeos/drive/job_scheduler_unittest.cc',
        'browser/chromeos/drive/local_file_reader_unittest.cc',
        'browser/chromeos/drive/remove_stale_cache_files_unittest.cc',
        'browser/chromeos/drive/resource_entry_conversion_unittest.cc',
        'browser/chromeos/drive/resource_metadata_storage_unittest.cc',
        'browser/chromeos/drive/resource_metadata_unittest.cc',
        'browser/chromeos/drive/search_metadata_unittest.cc',
        'browser/chromeos/drive/sync/entry_revert_performer_unittest.cc',
        'browser/chromeos/drive/sync/entry_update_performer_unittest.cc',
        'browser/chromeos/drive/sync/remove_performer_unittest.cc',
        'browser/chromeos/drive/sync_client_unittest.cc',
        'browser/chromeos/drive/test_util.cc',
        'browser/chromeos/drive/test_util.h',
        'browser/chromeos/drive/write_on_cache_file_unittest.cc',
        'browser/chromeos/events/event_rewriter_unittest.cc',
        'browser/chromeos/events/keyboard_driven_event_rewriter_unittest.cc',
        'browser/chromeos/extensions/default_app_order_unittest.cc',
        'browser/chromeos/extensions/device_local_account_external_policy_loader_unittest.cc',
        'browser/chromeos/extensions/external_cache_unittest.cc',
        'browser/chromeos/file_manager/fake_disk_mount_manager.cc',
        'browser/chromeos/file_manager/fake_disk_mount_manager.h',
        'browser/chromeos/file_manager/file_tasks_unittest.cc',
        'browser/chromeos/file_manager/file_watcher_unittest.cc',
        'browser/chromeos/file_manager/mime_util_unittest.cc',
        'browser/chromeos/file_manager/mounted_disk_monitor_unittest.cc',
        'browser/chromeos/file_manager/path_util_unittest.cc',
        'browser/chromeos/file_manager/url_util_unittest.cc',
        'browser/chromeos/file_manager/volume_manager_unittest.cc',
        'browser/chromeos/extensions/device_local_account_management_policy_provider_unittest.cc',
        'browser/chromeos/extensions/wallpaper_private_api_unittest.cc',
        'browser/chromeos/external_metrics_unittest.cc',
        'browser/chromeos/fileapi/file_access_permissions_unittest.cc',
        'browser/chromeos/fileapi/file_system_backend_unittest.cc',
        'browser/chromeos/imageburner/burn_device_handler_unittest.cc',
        'browser/chromeos/imageburner/burn_manager_unittest.cc',
        'browser/chromeos/input_method/browser_state_monitor_unittest.cc',
        'browser/chromeos/input_method/input_method_configuration_unittest.cc',
        'browser/chromeos/input_method/input_method_manager_impl_unittest.cc',
        'browser/chromeos/input_method/input_method_persistence_unittest.cc',
        'browser/chromeos/input_method/input_method_util_unittest.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_idle_logout_unittest.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_settings_unittest.cc',
        'browser/chromeos/login/existing_user_controller_auto_login_unittest.cc',
        'browser/chromeos/login/hwid_checker_unittest.cc',
        'browser/chromeos/login/merge_session_load_page_unittest.cc',
        'browser/chromeos/login/mock_auth_attempt_state_resolver.cc',
        'browser/chromeos/login/mock_auth_attempt_state_resolver.h',
        'browser/chromeos/login/multi_profile_user_controller_unittest.cc',
        'browser/chromeos/login/online_attempt_unittest.cc',
        'browser/chromeos/login/parallel_authenticator_unittest.cc',
        'browser/chromeos/login/saml/saml_offline_signin_limiter_unittest.cc',
        'browser/chromeos/login/screens/screen_context_unittest.cc',
        'browser/chromeos/login/user_manager_unittest.cc',
        'browser/chromeos/login/wallpaper_manager_unittest.cc',
        'browser/chromeos/memory/oom_priority_manager_unittest.cc',
        'browser/chromeos/mobile/mobile_activator_unittest.cc',
        'browser/chromeos/mobile_config_unittest.cc',
        'browser/chromeos/net/cert_verify_proc_chromeos_unittest.cc',
        'browser/chromeos/net/network_portal_detector_impl_unittest.cc',
        'browser/chromeos/net/onc_utils_unittest.cc',
        'browser/chromeos/offline/offline_load_page_unittest.cc',
        'browser/chromeos/options/network_property_ui_data_unittest.cc',
        'browser/chromeos/policy/auto_enrollment_client_unittest.cc',
        'browser/chromeos/policy/cloud_external_data_manager_base_unittest.cc',
        'browser/chromeos/policy/cloud_external_data_policy_observer_unittest.cc',
        'browser/chromeos/policy/cloud_external_data_store_unittest.cc',
        'browser/chromeos/policy/configuration_policy_handler_chromeos_unittest.cc',
        'browser/chromeos/policy/device_cloud_policy_manager_chromeos_unittest.cc',
        'browser/chromeos/policy/device_cloud_policy_store_chromeos_unittest.cc',
        'browser/chromeos/policy/device_local_account_policy_service_unittest.cc',
        'browser/chromeos/policy/enterprise_install_attributes_unittest.cc',
        'browser/chromeos/policy/login_screen_power_management_policy_unittest.cc',
        'browser/chromeos/policy/network_configuration_updater_unittest.cc',
        'browser/chromeos/policy/recommendation_restorer_unittest.cc',
        'browser/chromeos/policy/user_cloud_policy_manager_chromeos_unittest.cc',
        'browser/chromeos/policy/user_cloud_policy_store_chromeos_unittest.cc',
        'browser/chromeos/power/power_data_collector_unittest.cc',
        'browser/chromeos/power/power_prefs_unittest.cc',
        'browser/chromeos/preferences_unittest.cc',
        'browser/chromeos/profiles/profile_list_chromeos_unittest.cc',
        'browser/chromeos/session_length_limiter_unittest.cc',
        'browser/chromeos/proxy_config_service_impl_unittest.cc',
        'browser/chromeos/settings/cros_settings_unittest.cc',
        'browser/chromeos/settings/device_oauth2_token_service_factory_unittest.cc',
        'browser/chromeos/settings/device_oauth2_token_service_unittest.cc',
        'browser/chromeos/settings/device_settings_provider_unittest.cc',
        'browser/chromeos/settings/device_settings_service_unittest.cc',
        'browser/chromeos/settings/owner_key_util_unittest.cc',
        'browser/chromeos/settings/session_manager_operation_unittest.cc',
        'browser/chromeos/settings/stub_cros_settings_provider_unittest.cc',
        'browser/chromeos/system/automatic_reboot_manager_unittest.cc',
        'browser/chromeos/ui/idle_app_name_notification_view_unittest.cc',
        'browser/chromeos/version_loader_unittest.cc',
        'browser/command_updater_unittest.cc',
        'browser/component_updater/test/component_installers_unittest.cc',
        'browser/component_updater/test/component_patcher_mock.h',
        'browser/component_updater/test/component_patcher_unittest.cc',
        'browser/component_updater/test/component_updater_ping_manager_unittest.cc',
        'browser/component_updater/test/component_updater_service_unittest.cc',
        'browser/component_updater/test/crx_downloader_unittest.cc',
        'browser/component_updater/test/test_installer.cc',
        'browser/component_updater/test/update_checker_unittest.cc',
        'browser/component_updater/test/update_response_unittest.cc',
        'browser/component_updater/test/url_request_post_interceptor.cc',
        'browser/content_settings/content_settings_default_provider_unittest.cc',
        'browser/content_settings/content_settings_mock_observer.cc',
        'browser/content_settings/content_settings_mock_observer.h',
        'browser/content_settings/content_settings_mock_provider.cc',
        'browser/content_settings/content_settings_mock_provider.h',
        'browser/content_settings/content_settings_origin_identifier_value_map_unittest.cc',
        'browser/content_settings/content_settings_policy_provider_unittest.cc',
        'browser/content_settings/content_settings_pref_provider_unittest.cc',
        'browser/content_settings/content_settings_provider_unittest.cc',
        'browser/content_settings/content_settings_rule_unittest.cc',
        'browser/content_settings/content_settings_usages_state_unittest.cc',
        'browser/content_settings/content_settings_utils_unittest.cc',
        'browser/content_settings/cookie_settings_unittest.cc',
        'browser/content_settings/host_content_settings_map_unittest.cc',
        'browser/content_settings/mock_settings_observer.cc',
        'browser/content_settings/mock_settings_observer.h',
        'browser/content_settings/permission_queue_controller_unittest.cc',
        'browser/content_settings/tab_specific_content_settings_unittest.cc',
        'browser/custom_handlers/protocol_handler_registry_unittest.cc',
        'browser/diagnostics/diagnostics_model_unittest.cc',
        'browser/diagnostics/diagnostics_controller_unittest.cc',
        'browser/devtools/devtools_contents_resizing_strategy_unittest.cc',
        'browser/download/all_download_item_notifier_unittest.cc',
        'browser/download/chrome_download_manager_delegate_unittest.cc',
        'browser/download/download_history_unittest.cc',
        'browser/download/download_item_model_unittest.cc',
        'browser/download/download_path_reservation_tracker_unittest.cc',
        'browser/download/download_query_unittest.cc',
        'browser/download/download_request_infobar_delegate_unittest.cc',
        'browser/download/download_request_limiter_unittest.cc',
        'browser/download/download_shelf_unittest.cc',
        'browser/download/download_status_updater_unittest.cc',
        'browser/download/download_target_determiner_unittest.cc',
        'browser/download/download_ui_controller_unittest.cc',
        'browser/drive/drive_app_registry_unittest.cc',
        'browser/drive/drive_api_util_unittest.cc',
        'browser/drive/drive_uploader_unittest.cc',
        'browser/drive/event_logger_unittest.cc',
        'browser/drive/fake_drive_service_unittest.cc',
        'browser/enumerate_modules_model_unittest_win.cc',
        'browser/extensions/active_tab_unittest.cc',
        'browser/extensions/activity_log/activity_database_unittest.cc',
        'browser/extensions/activity_log/activity_log_enabled_unittest.cc',
        'browser/extensions/activity_log/activity_log_unittest.cc',
        'browser/extensions/activity_log/activity_log_policy_unittest.cc',
        'browser/extensions/activity_log/counting_policy_unittest.cc',
        'browser/extensions/activity_log/database_string_table_unittest.cc',
        'browser/extensions/activity_log/fullstream_ui_policy_unittest.cc',
        'browser/extensions/activity_log/uma_policy_unittest.cc',
        'browser/extensions/api/activity_log_private/activity_log_private_api_unittest.cc',
        'browser/extensions/api/alarms/alarms_api_unittest.cc',
        'browser/extensions/api/api_resource_manager_unittest.cc',
        'browser/extensions/api/bluetooth/bluetooth_event_router_unittest.cc',
        'browser/extensions/api/bookmarks/bookmark_api_helpers_unittest.cc',
        'browser/extensions/api/cast_channel/cast_socket_unittest.cc',
        'browser/extensions/api/content_settings/content_settings_store_unittest.cc',
        'browser/extensions/api/content_settings/content_settings_unittest.cc',
        'browser/extensions/api/cookies/cookies_unittest.cc',
        'browser/extensions/api/declarative/declarative_rule_unittest.cc',
        'browser/extensions/api/declarative/deduping_factory_unittest.cc',
        'browser/extensions/api/declarative/rules_registry_service_unittest.cc',
        'browser/extensions/api/declarative/rules_registry_unittest.cc',
        'browser/extensions/api/declarative/rules_registry_with_cache_unittest.cc',
        'browser/extensions/api/declarative_content/content_action_unittest.cc',
        'browser/extensions/api/declarative_content/content_condition_unittest.cc',
        'browser/extensions/api/declarative_content/content_rules_registry_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_action_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_attribute_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_rules_registry_unittest.cc',
        'browser/extensions/api/dial/dial_device_data_unittest.cc',
        'browser/extensions/api/dial/dial_registry_unittest.cc',
        'browser/extensions/api/dial/dial_service_unittest.cc',
        'browser/extensions/api/enterprise_platform_keys_private/enterprise_platform_keys_private_api_unittest.cc',
        'browser/extensions/api/extension_action/extension_action_prefs_unittest.cc',
        'browser/extensions/api/extension_action/extension_browser_actions_api_unittest.cc',
        'browser/extensions/api/file_system/file_system_api_unittest.cc',
        'browser/extensions/api/identity/account_tracker_unittest.cc',
        'browser/extensions/api/identity/extension_token_key_unittest.cc',
        'browser/extensions/api/identity/gaia_web_auth_flow_unittest.cc',
        'browser/extensions/api/identity/identity_mint_queue_unittest.cc',
        'browser/extensions/api/idle/idle_api_unittest.cc',
        'browser/extensions/api/image_writer_private/destroy_partitions_operation_unittest.cc',
        'browser/extensions/api/image_writer_private/operation_manager_unittest.cc',
        'browser/extensions/api/image_writer_private/operation_unittest.cc',
        'browser/extensions/api/image_writer_private/test_utils.cc',
        'browser/extensions/api/image_writer_private/write_from_file_operation_unittest.cc',
        'browser/extensions/api/image_writer_private/write_from_url_operation_unittest.cc',
        'browser/extensions/api/log_private/syslog_parser_unittest.cc',
        'browser/extensions/api/mdns/dns_sd_registry_unittest.cc',
        'browser/extensions/api/messaging/native_message_process_host_unittest.cc',
        'browser/extensions/api/messaging/native_messaging_host_manifest_unittest.cc',
        'browser/extensions/api/messaging/native_messaging_policy_handler_unittest.cc',
        'browser/extensions/api/omnibox/omnibox_unittest.cc',
        'browser/extensions/api/permissions/permissions_api_helpers_unittest.cc',
        'browser/extensions/api/power/power_api_unittest.cc',
        'browser/extensions/api/preference/preference_api_prefs_unittest.cc',
        'browser/extensions/api/proxy/proxy_api_helpers_unittest.cc',
        'browser/extensions/api/push_messaging/obfuscated_gaia_id_fetcher_unittest.cc',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_handler_unittest.cc',
        'browser/extensions/api/signed_in_devices/id_mapping_helper_unittest.cc',
        'browser/extensions/api/signed_in_devices/signed_in_devices_api_unittest.cc',
        'browser/extensions/api/signed_in_devices/signed_in_devices_manager_unittest.cc',
        'browser/extensions/api/socket/socket_api_unittest.cc',
        'browser/extensions/api/socket/tcp_socket_unittest.cc',
        'browser/extensions/api/socket/udp_socket_unittest.cc',
        'browser/extensions/api/sockets_tcp/sockets_tcp_api_unittest.cc',
        'browser/extensions/api/sockets_tcp_server/sockets_tcp_server_api_unittest.cc',
        'browser/extensions/api/sockets_udp/sockets_udp_api_unittest.cc',
        'browser/extensions/api/storage/policy_value_store_unittest.cc',
        'browser/extensions/api/storage/settings_frontend_unittest.cc',
        'browser/extensions/api/storage/settings_quota_unittest.cc',
        'browser/extensions/api/storage/settings_sync_unittest.cc',
        'browser/extensions/api/storage/settings_test_util.cc',
        'browser/extensions/api/storage/settings_test_util.h',
        'browser/extensions/api/streams_private/streams_private_manifest_unittest.cc',
        'browser/extensions/api/system_display/display_info_provider_chromeos_unittest.cc',
        'browser/extensions/api/web_navigation/frame_navigation_state_unittest.cc',
        'browser/extensions/api/web_request/form_data_parser_unittest.cc',
        'browser/extensions/api/web_request/upload_data_presenter_unittest.cc',
        'browser/extensions/api/web_request/web_request_api_unittest.cc',
        'browser/extensions/api/web_request/web_request_permissions_unittest.cc',
        'browser/extensions/api/web_request/web_request_time_tracker_unittest.cc',
        'browser/extensions/app_sync_data_unittest.cc',
        'browser/extensions/blacklist_unittest.cc',
        'browser/extensions/blacklist_state_fetcher_unittest.cc',
        'browser/extensions/browser_permissions_policy_delegate_unittest.cc',
        'browser/extensions/chrome_app_sorting_unittest.cc',
        'browser/extensions/component_loader_unittest.cc',
        'browser/extensions/convert_user_script_unittest.cc',
        'browser/extensions/convert_web_app_unittest.cc',
        'browser/extensions/default_apps_unittest.cc',
        'browser/extensions/error_console/error_console_unittest.cc',
        'browser/extensions/event_router_forwarder_unittest.cc',
        'browser/extensions/extension_api_unittest.cc',
        'browser/extensions/extension_api_unittest.h',
        'browser/extensions/extension_action_icon_factory_unittest.cc',
        'browser/extensions/extension_action_unittest.cc',
        'browser/extensions/extension_context_menu_model_unittest.cc',
        'browser/extensions/extension_creator_filter_unittest.cc',
        'browser/extensions/extension_function_test_utils.cc',
        'browser/extensions/extension_function_test_utils.h',
        'browser/extensions/extension_icon_image_unittest.cc',
        'browser/extensions/extension_icon_manager_unittest.cc',
        'browser/extensions/extension_message_bubble_controller_unittest.cc',
        'browser/extensions/extension_prefs_unittest.cc',
        'browser/extensions/extension_prefs_unittest.h',
        'browser/extensions/extension_protocols_unittest.cc',
        'browser/extensions/extension_service_unittest.cc',
        'browser/extensions/extension_service_unittest.h',
        'browser/extensions/extension_special_storage_policy_unittest.cc',
        'browser/extensions/extension_sync_data_unittest.cc',
        'browser/extensions/extension_ui_unittest.cc',
        'browser/extensions/extension_warning_badge_service_unittest.cc',
        'browser/extensions/extension_warning_service_unittest.cc',
        'browser/extensions/external_policy_loader_unittest.cc',
        'browser/extensions/external_provider_impl_unittest.cc',
        'browser/extensions/external_provider_impl_chromeos_unittest.cc',
        'browser/extensions/favicon_downloader_unittest.cc',
        'browser/extensions/image_loader_unittest.cc',
        'browser/extensions/menu_manager_unittest.cc',
        'browser/extensions/pack_extension_unittest.cc',
        'browser/extensions/page_action_controller_unittest.cc',
        'browser/extensions/permissions_updater_unittest.cc',
        'browser/extensions/policy_handlers_unittest.cc',
        'browser/extensions/process_manager_unittest.cc',
        'browser/extensions/sandboxed_unpacker_unittest.cc',
        'browser/extensions/standard_management_policy_provider_unittest.cc',
        'browser/extensions/tab_helper_unittest.cc',
        'browser/extensions/token_cache/token_cache_service_unittest.cc',
        'browser/extensions/updater/extension_cache_fake.h',
        'browser/extensions/updater/extension_cache_fake.cc',
        'browser/extensions/updater/extension_updater_unittest.cc',
        'browser/extensions/user_script_listener_unittest.cc',
        'browser/extensions/user_script_master_unittest.cc',
        'browser/extensions/webstore_inline_installer_unittest.cc',
        'browser/extensions/webstore_installer_unittest.cc',
        'browser/external_protocol/external_protocol_handler_unittest.cc',
        'browser/favicon/favicon_handler_unittest.cc',
        'browser/feedback/feedback_uploader_unittest.cc',
        'browser/file_select_helper_unittest.cc',
        'browser/first_run/first_run_unittest.cc',
        'browser/geolocation/chrome_geolocation_permission_context_unittest.cc',
        'browser/global_keyboard_shortcuts_mac_unittest.mm',
        'browser/google/google_search_counter_unittest.cc',
        'browser/google/google_update_settings_unittest.cc',
        'browser/google/google_url_tracker_unittest.cc',
        'browser/google/google_util_unittest.cc',
        'browser/history/android/android_cache_database_unittest.cc',
        'browser/history/android/android_history_provider_service_unittest.cc',
        'browser/history/android/android_history_types_unittest.cc',
        'browser/history/android/android_provider_backend_unittest.cc',
        'browser/history/android/android_urls_database_unittest.cc',
        'browser/history/android/bookmark_model_sql_handler_unittest.cc',
        'browser/history/android/sqlite_cursor_unittest.cc',
        'browser/history/android/urls_sql_handler_unittest.cc',
        'browser/history/android/visit_sql_handler_unittest.cc',
        'browser/history/expire_history_backend_unittest.cc',
        'browser/history/history_backend_unittest.cc',
        'browser/history/history_database_unittest.cc',
        'browser/history/history_querying_unittest.cc',
        'browser/history/history_types_unittest.cc',
        'browser/history/history_unittest.cc',
        'browser/history/history_unittest_base.cc',
        'browser/history/history_unittest_base.h',
        'browser/history/in_memory_url_index_types_unittest.cc',
        'browser/history/in_memory_url_index_unittest.cc',
        'browser/history/most_visited_tiles_experiment_unittest.cc',
        'browser/history/query_parser_unittest.cc',
        'browser/history/scored_history_match_unittest.cc',
        'browser/history/select_favicon_frames_unittest.cc',
        'browser/history/shortcuts_backend_unittest.cc',
        'browser/history/shortcuts_database_unittest.cc',
        'browser/history/snippet_unittest.cc',
        'browser/history/thumbnail_database_unittest.cc',
        'browser/history/top_sites_cache_unittest.cc',
        'browser/history/top_sites_database_unittest.cc',
        'browser/history/top_sites_impl_unittest.cc',
        'browser/history/typed_url_syncable_service_unittest.cc',
        'browser/history/url_database_unittest.cc',
        'browser/history/url_utils_unittest.cc',
        'browser/history/visit_database_unittest.cc',
        'browser/history/visit_filter_unittest.cc',
        'browser/history/visit_tracker_unittest.cc',
        'browser/importer/firefox_profile_lock_unittest.cc',
        'browser/importer/profile_writer_unittest.cc',
        'browser/internal_auth_unittest.cc',
        'browser/install_verification/win/imported_module_verification_unittest.cc',
        'browser/install_verification/win/loaded_module_verification_unittest.cc',
        'browser/install_verification/win/loaded_modules_snapshot_unittest.cc',
        'browser/install_verification/win/module_ids_unittest.cc',
        'browser/install_verification/win/module_info_unittest.cc',
        'browser/install_verification/win/module_list_unittest.cc',
        'browser/install_verification/win/module_verification_test.cc',
        'browser/install_verification/win/module_verification_test.h',
        'browser/invalidation/gcm_network_channel_delegate_impl_unittest.cc',
        'browser/invalidation/invalidation_logger_unittest.cc',
        'browser/invalidation/invalidation_service_android_unittest.cc',
        'browser/invalidation/invalidation_service_test_template.cc',
        'browser/invalidation/invalidation_service_test_template.h',
        'browser/invalidation/invalidator_storage_unittest.cc',
        'browser/invalidation/ticl_invalidation_service_unittest.cc',
        'browser/local_discovery/privet_confirm_api_flow_unittest.cc',
        'browser/local_discovery/privet_http_unittest.cc',
        'browser/local_discovery/privet_url_fetcher_unittest.cc',
        'browser/local_discovery/cloud_print_printer_list_unittest.cc',
        'browser/local_discovery/service_discovery_client_mac_unittest.mm',
        'browser/logging_chrome_unittest.cc',
        'browser/mac/keystone_glue_unittest.mm',
        'browser/managed_mode/managed_mode_url_filter_unittest.cc',
        'browser/managed_mode/managed_user_service_unittest.cc',
        'browser/managed_mode/managed_user_sync_service_unittest.cc',
        'browser/managed_mode/managed_user_refresh_token_fetcher_unittest.cc',
        'browser/managed_mode/managed_user_registration_utility_unittest.cc',
        'browser/managed_mode/managed_user_settings_service_unittest.cc',
        'browser/managed_mode/managed_user_shared_settings_service_unittest.cc',
        'browser/managed_mode/managed_user_shared_settings_update_unittest.cc',
        'browser/managed_mode/supervised_user_pref_mapping_service_unittest.cc',
        'browser/managed_mode/supervised_user_pref_store_unittest.cc',
        'browser/media/cast_transport_host_filter_unittest.cc',
        'browser/media/desktop_media_list_ash_unittest.cc',
        'browser/media/native_desktop_media_list_unittest.cc',
        'browser/media/webrtc_log_uploader_unittest.cc',
        'browser/media_galleries/fileapi/native_media_file_util_unittest.cc',
        'browser/media_galleries/linux/mtp_device_object_enumerator_unittest.cc',
        'browser/media_galleries/mac/mtp_device_delegate_impl_mac_unittest.mm',
        'browser/media_galleries/win/mtp_device_delegate_impl_win_unittest.cc',
        'browser/media_galleries/media_file_system_registry_unittest.cc',
        'browser/media_galleries/media_folder_finder_unittest.cc',
        'browser/media_galleries/media_galleries_dialog_controller_mock.cc',
        'browser/media_galleries/media_galleries_dialog_controller_mock.h',
        'browser/media_galleries/media_galleries_dialog_controller_unittest.cc',
        'browser/media_galleries/media_galleries_permissions_unittest.cc',
        'browser/media_galleries/media_galleries_preferences_unittest.cc',
        'browser/media_galleries/media_galleries_scan_result_dialog_controller_unittest.cc',
        'browser/media_galleries/media_scan_manager_unittest.cc',
        'browser/media_galleries/win/mtp_device_object_enumerator_unittest.cc',
        'browser/metrics/compression_utils_unittest.cc',
        'browser/metrics/metrics_log_unittest.cc',
        'browser/metrics/metrics_log_serializer_unittest.cc',
        'browser/metrics/metrics_reporting_scheduler_unittest.cc',
        'browser/metrics/metrics_service_unittest.cc',
        'browser/metrics/thread_watcher_unittest.cc',
        'browser/metrics/time_ticks_experiment_unittest.cc',
        'browser/metrics/variations/variations_http_header_provider_unittest.cc',
        'browser/metrics/variations/variations_request_scheduler_mobile_unittest.cc',
        'browser/metrics/variations/variations_request_scheduler_unittest.cc',
        'browser/metrics/variations/variations_seed_store_unittest.cc',
        'browser/metrics/variations/variations_service_unittest.cc',
        'browser/net/chrome_fraudulent_certificate_reporter_unittest.cc',
        'browser/net/chrome_network_delegate_unittest.cc',
        'browser/net/client_hints_unittest.cc',
        'browser/net/connection_tester_unittest.cc',
        'browser/net/dns_probe_runner_unittest.cc',
        'browser/net/dns_probe_service_unittest.cc',
        'browser/net/evicted_domain_cookie_counter_unittest.cc',
        'browser/net/firefox_proxy_settings_unittest.cc',
        'browser/net/http_pipelining_compatibility_client_unittest.cc',
        'browser/net/http_server_properties_manager_unittest.cc',
        'browser/net/net_error_tab_helper_unittest.cc',
        'browser/net/net_log_temp_file_unittest.cc',
        'browser/net/network_stats_unittest.cc',
        'browser/net/predictor_unittest.cc',
        'browser/net/pref_proxy_config_tracker_impl_unittest.cc',
        'browser/net/probe_message_unittest.cc',
        'browser/net/proxy_policy_handler_unittest.cc',
        'browser/net/spdyproxy/data_reduction_proxy_settings_unittest.cc',
        'browser/net/spdyproxy/data_reduction_proxy_settings_unittest.h',
        'browser/net/spdyproxy/data_reduction_proxy_settings_unittest_android.cc',
        'browser/net/spdyproxy/data_saving_metrics_unittest.cc',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy_unittest.cc',
        'browser/net/sqlite_server_bound_cert_store_unittest.cc',
        'browser/net/ssl_config_service_manager_pref_unittest.cc',
        'browser/net/url_info_unittest.cc',
        'browser/network_time/navigation_time_helper_unittest.cc',
        'browser/network_time/network_time_tracker_unittest.cc',
        'browser/notifications/desktop_notification_service_unittest.cc',
        'browser/notifications/extension_welcome_notification_unittest.cc',
        'browser/notifications/login_state_notification_blocker_chromeos_unittest.cc',
        'browser/notifications/message_center_notifications_unittest_win.cc',
        'browser/notifications/message_center_settings_controller_unittest.cc',
        'browser/notifications/sync_notifier/chrome_notifier_delegate_unittest.cc',
        'browser/notifications/sync_notifier/chrome_notifier_service_unittest.cc',
        'browser/notifications/sync_notifier/synced_notification_unittest.cc',
        'browser/notifications/sync_notifier/sync_notifier_test_utils.cc',
        'browser/notifications/sync_notifier/sync_notifier_test_utils.h',
        'browser/notifications/sync_notifier/welcome_delegate_unittest.cc',
        'browser/omnibox/omnibox_field_trial_unittest.cc',
        'browser/omaha_query_params/omaha_query_params_unittest.cc',
        'browser/parsers/metadata_parser_filebase_unittest.cc',
        'browser/password_manager/native_backend_gnome_x_unittest.cc',
        'browser/password_manager/native_backend_kwallet_x_unittest.cc',
        'browser/password_manager/password_form_manager_unittest.cc',
        'browser/password_manager/password_generation_manager_unittest.cc',
        'browser/password_manager/password_manager_metrics_util_unittest.cc',
        'browser/password_manager/password_manager_unittest.cc',
        'browser/password_manager/password_store_mac_unittest.cc',
        'browser/password_manager/password_store_win_unittest.cc',
        'browser/password_manager/password_store_x_unittest.cc',
        'browser/performance_monitor/database_unittest.cc',
        'browser/plugins/plugin_finder_unittest.cc',
        'browser/plugins/plugin_metadata_unittest.cc',
        'browser/plugins/plugin_prefs_unittest.cc',
        'browser/policy/cloud/cloud_policy_invalidator_unittest.cc',
        'browser/policy/cloud/user_policy_signin_service_unittest.cc',
        'browser/policy/configuration_policy_handler_unittest.cc',
        'browser/policy/configuration_policy_pref_store_test.cc',
        'browser/policy/configuration_policy_pref_store_test.h',
        'browser/policy/configuration_policy_pref_store_unittest.cc',
        'browser/policy/file_selection_dialogs_policy_handler_unittest.cc',
        'browser/policy/javascript_policy_handler_unittest.cc',
        'browser/policy/policy_path_parser_unittest.cc',
        'browser/policy/url_blacklist_manager_unittest.cc',
        'browser/policy/url_blacklist_policy_handler_unittest.cc',
        'browser/predictors/autocomplete_action_predictor_table_unittest.cc',
        'browser/predictors/autocomplete_action_predictor_unittest.cc',
        'browser/prefs/chrome_pref_service_unittest.cc',
        'browser/prefs/command_line_pref_store_unittest.cc',
        'browser/prefs/incognito_mode_prefs_unittest.cc',
        'browser/prefs/pref_hash_calculator_unittest.cc',
        'browser/prefs/pref_hash_filter_unittest.cc',
        'browser/prefs/pref_hash_store_impl_unittest.cc',
        'browser/prefs/pref_model_associator_unittest.cc',
        'browser/prefs/proxy_config_dictionary_unittest.cc',
        'browser/prefs/proxy_policy_unittest.cc',
        'browser/prefs/proxy_prefs_unittest.cc',
        'browser/prefs/session_startup_pref_unittest.cc',
        'browser/prerender/prerender_history_unittest.cc',
        'browser/prerender/prerender_tracker_unittest.cc',
        'browser/prerender/prerender_unittest.cc',
        'browser/prerender/prerender_util_unittest.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service_unittest.cc',
        'browser/printing/print_dialog_cloud_unittest.cc',
        'browser/printing/print_job_unittest.cc',
        'browser/printing/print_preview_dialog_controller_unittest.cc',
        'browser/printing/print_preview_test.cc',
        'browser/printing/print_preview_test.h',
        'browser/process_info_snapshot_mac_unittest.cc',
        'browser/process_singleton_linux_unittest.cc',
        'browser/process_singleton_mac_unittest.cc',
        'browser/profile_resetter/automatic_profile_resetter_delegate_unittest.cc',
        'browser/profile_resetter/automatic_profile_resetter_unittest.cc',
        'browser/profile_resetter/jtl_interpreter_unittest.cc',
        'browser/profile_resetter/profile_resetter_unittest.cc',
        'browser/profiles/file_path_verifier_win_unittest.cc',
        'browser/profiles/gaia_info_update_service_unittest.cc',
        'browser/profiles/incognito_mode_policy_handler_unittest.cc',
        'browser/profiles/off_the_record_profile_impl_unittest.cc',
        'browser/profiles/profile_downloader_unittest.cc',
        'browser/profiles/profile_info_cache_unittest.cc',
        'browser/profiles/profile_info_cache_unittest.h',
        'browser/profiles/profile_info_util_unittest.cc',
        'browser/profiles/profile_list_desktop_unittest.cc',
        'browser/profiles/profile_manager_unittest.cc',
        'browser/profiles/profile_shortcut_manager_unittest_win.cc',
        'browser/renderer_host/plugin_info_message_filter_unittest.cc',
        'browser/renderer_host/web_cache_manager_unittest.cc',
        'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper_unit_test.mm',
        'browser/resources/google_now/background.js',
        'browser/resources/google_now/background_test_util.js',
        'browser/resources/google_now/background_unittest.gtestjs',
        'browser/resources/google_now/cards.js',
        'browser/resources/google_now/cards_unittest.gtestjs',
        'browser/resources/google_now/common_test_util.js',
        'browser/resources/google_now/utility.js',
        'browser/resources/google_now/utility_test_util.js',
        'browser/resources/google_now/utility_unittest.gtestjs',
        'browser/resources/print_preview/data/measurement_system.js',
        'browser/resources/print_preview/data/measurement_system_unittest.gtestjs',
        'browser/resources/print_preview/print_preview_utils.js',
        'browser/resources/print_preview/print_preview_utils_unittest.gtestjs',
        'browser/resources_util_unittest.cc',
        'browser/rlz/rlz_unittest.cc',
        'browser/safe_browsing/browser_feature_extractor_unittest.cc',
        'browser/safe_browsing/chunk_range_unittest.cc',
        'browser/safe_browsing/client_side_detection_host_unittest.cc',
        'browser/safe_browsing/client_side_detection_service_unittest.cc',
        'browser/safe_browsing/database_manager_unittest.cc',
        'browser/safe_browsing/download_feedback_service_unittest.cc',
        'browser/safe_browsing/download_feedback_unittest.cc',
        'browser/safe_browsing/download_protection_service_unittest.cc',
        'browser/safe_browsing/local_two_phase_testserver.cc',
        'browser/safe_browsing/malware_details_unittest.cc',
        'browser/safe_browsing/ping_manager_unittest.cc',
        'browser/safe_browsing/prefix_set_unittest.cc',
        'browser/safe_browsing/protocol_manager_unittest.cc',
        'browser/safe_browsing/protocol_parser_unittest.cc',
        'browser/safe_browsing/safe_browsing_blocking_page_unittest.cc',
        'browser/safe_browsing/safe_browsing_database_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_file_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_unittest_helper.cc',
        'browser/safe_browsing/safe_browsing_util_unittest.cc',
        'browser/safe_browsing/signature_util_win_unittest.cc',
        'browser/safe_browsing/two_phase_uploader_unittest.cc',
        'browser/search/hotword_service_unittest.cc',
        'browser/search/iframe_source_unittest.cc',
        'browser/search/instant_service_unittest.cc',
        'browser/search/instant_unittest_base.cc',
        'browser/search/instant_unittest_base.h',
        'browser/search/most_visited_iframe_source_unittest.cc',
        'browser/search/search_unittest.cc',
        'browser/search/suggestions/suggestions_service_unittest.cc',
        'browser/search_engines/default_search_policy_handler_unittest.cc',
        'browser/search_engines/search_host_to_urls_map_unittest.cc',
        'browser/search_engines/search_provider_install_data_unittest.cc',
        'browser/search_engines/template_url_fetcher_unittest.cc',
        'browser/search_engines/template_url_service_util_unittest.cc',
        'browser/search_engines/template_url_service_sync_unittest.cc',
        'browser/search_engines/template_url_service_unittest.cc',
        'browser/search_engines/template_url_parser_unittest.cc',
        'browser/search_engines/template_url_prepopulate_data_unittest.cc',
        'browser/search_engines/template_url_scraper_unittest.cc',
        'browser/search_engines/template_url_unittest.cc',
        'browser/services/gcm/gcm_client_mock.cc',
        'browser/services/gcm/gcm_client_mock.h',
        'browser/services/gcm/gcm_profile_service_unittest.cc',
        'browser/sessions/persistent_tab_restore_service_unittest.cc',
        'browser/sessions/restore_on_startup_policy_handler_unittest.cc',
        'browser/sessions/session_backend_unittest.cc',
        'browser/sessions/session_service_unittest.cc',
        'browser/sessions/session_types_unittest.cc',
        'browser/shell_integration_linux_unittest.cc',
        'browser/shell_integration_win_unittest.cc',
        'browser/signin/account_reconcilor_unittest.cc',
        'browser/signin/fake_auth_status_provider.cc',
        'browser/signin/fake_auth_status_provider.h',
        'browser/signin/local_auth_unittest.cc',
        'browser/signin/mutable_profile_oauth2_token_service_unittest.cc',
        'browser/signin/profile_oauth2_token_service_request_unittest.cc',
        'browser/signin/signin_global_error_unittest.cc',
        'browser/signin/signin_manager_unittest.cc',
        'browser/signin/signin_names_io_thread_unittest.cc',
        'browser/signin/signin_tracker_unittest.cc',
        'browser/speech/extension_api/extension_manifests_tts_unittest.cc',
        'browser/speech/speech_recognition_bubble_controller_unittest.cc',
        'browser/speech/tts_controller_unittest.cc',
        'browser/spellchecker/feedback_sender_unittest.cc',
        'browser/spellchecker/feedback_unittest.cc',
        'browser/spellchecker/misspelling_unittest.cc',
        'browser/spellchecker/spellcheck_action_unittest.cc',
        'browser/spellchecker/spellcheck_custom_dictionary_unittest.cc',
        'browser/spellchecker/spellcheck_host_metrics_unittest.cc',
        'browser/spellchecker/spellcheck_message_filter_mac_unittest.cc',
        'browser/spellchecker/spellcheck_message_filter_unittest.cc',
        'browser/spellchecker/spellcheck_platform_mac_unittest.cc',
        'browser/spellchecker/spellcheck_service_unittest.cc',
        'browser/spellchecker/spelling_service_client_unittest.cc',
        'browser/spellchecker/word_trimmer_unittest.cc',
        'browser/status_icons/status_icon_menu_model_unittest.cc',
        'browser/status_icons/status_icon_unittest.cc',
        'browser/status_icons/status_tray_unittest.cc',
        'browser/sync/about_sync_util_unittest.cc',
        'browser/sync/abstract_profile_sync_service_test.cc',
        'browser/sync/abstract_profile_sync_service_test.h',
        'browser/sync/backend_migrator_unittest.cc',
        'browser/sync/glue/autofill_data_type_controller_unittest.cc',
        'browser/sync/glue/bookmark_data_type_controller_unittest.cc',
        'browser/sync/glue/browser_thread_model_worker_unittest.cc',
        'browser/sync/glue/change_processor_mock.cc',
        'browser/sync/glue/change_processor_mock.h',
        'browser/sync/glue/data_type_manager_impl_unittest.cc',
        'browser/sync/glue/extensions_activity_monitor_unittest.cc',
        'browser/sync/glue/fake_generic_change_processor.cc',
        'browser/sync/glue/fake_generic_change_processor.h',
        'browser/sync/glue/favicon_cache_unittest.cc',
        'browser/sync/glue/frontend_data_type_controller_mock.cc',
        'browser/sync/glue/frontend_data_type_controller_mock.h',
        'browser/sync/glue/frontend_data_type_controller_unittest.cc',
        'browser/sync/glue/generic_change_processor_unittest.cc',
        'browser/sync/glue/non_frontend_data_type_controller_mock.cc',
        'browser/sync/glue/non_frontend_data_type_controller_mock.h',
        'browser/sync/glue/non_frontend_data_type_controller_unittest.cc',
        'browser/sync/glue/non_ui_data_type_controller_mock.cc',
        'browser/sync/glue/non_ui_data_type_controller_mock.h',
        'browser/sync/glue/non_ui_data_type_controller_unittest.cc',
        'browser/sync/glue/search_engine_data_type_controller_unittest.cc',
        'browser/sync/glue/session_model_associator_unittest.cc',
        'browser/sync/glue/shared_change_processor_mock.cc',
        'browser/sync/glue/shared_change_processor_mock.h',
        'browser/sync/glue/shared_change_processor_unittest.cc',
        'browser/sync/glue/sync_backend_host_impl_unittest.cc',
        'browser/sync/glue/sync_backend_host_mock.cc',
        'browser/sync/glue/sync_backend_host_mock.h',
        'browser/sync/glue/sync_backend_registrar_unittest.cc',
        'browser/sync/glue/synced_device_tracker_unittest.cc',
        'browser/sync/glue/synced_session_tracker_unittest.cc',
        'browser/sync/glue/tab_node_pool_unittest.cc',
        'browser/sync/glue/typed_url_model_associator_unittest.cc',
        'browser/sync/glue/ui_data_type_controller_unittest.cc',
        'browser/sync/glue/ui_model_worker_unittest.cc',
        'browser/sync/profile_sync_components_factory_impl_unittest.cc',
        'browser/sync/profile_sync_components_factory_mock.cc',
        'browser/sync/profile_sync_components_factory_mock.h',
        'browser/sync/profile_sync_service_autofill_unittest.cc',
        'browser/sync/profile_sync_service_bookmark_unittest.cc',
        'browser/sync/profile_sync_service_password_unittest.cc',
        'browser/sync/profile_sync_service_preference_unittest.cc',
        'browser/sync/profile_sync_service_session_unittest.cc',
        'browser/sync/profile_sync_service_startup_unittest.cc',
        'browser/sync/profile_sync_service_typed_url_unittest.cc',
        'browser/sync/profile_sync_service_unittest.cc',
        'browser/sync/profile_sync_test_util.cc',
        'browser/sync/profile_sync_test_util.h',
        'browser/sync/sessions2/sessions_sync_manager_unittest.cc',
        'browser/sync/sessions2/tab_node_pool2_unittest.cc',
        'browser/sync/sync_global_error_unittest.cc',
        'browser/sync/sync_policy_handler_unittest.cc',
        'browser/sync/sync_prefs_unittest.cc',
        'browser/sync/sync_startup_tracker_unittest.cc',
        'browser/sync/sync_ui_util_unittest.cc',
        'browser/sync/test/test_http_bridge_factory.cc',
        'browser/sync/test/test_http_bridge_factory.h',
        'browser/sync/test_profile_sync_service.cc',
        'browser/sync/test_profile_sync_service.h',
        'browser/sync_file_system/drive_backend/conflict_resolver_unittest.cc',
        'browser/sync_file_system/drive_backend/drive_backend_sync_unittest.cc',
        'browser/sync_file_system/drive_backend/drive_backend_test_util.cc',
        'browser/sync_file_system/drive_backend/drive_backend_test_util.h',
        'browser/sync_file_system/drive_backend/fake_drive_service_helper.cc',
        'browser/sync_file_system/drive_backend/fake_drive_service_helper.h',
        'browser/sync_file_system/drive_backend/fake_drive_uploader.cc',
        'browser/sync_file_system/drive_backend/fake_drive_uploader.h',
        'browser/sync_file_system/drive_backend/list_changes_task_unittest.cc',
        'browser/sync_file_system/drive_backend/local_to_remote_syncer_unittest.cc',
        'browser/sync_file_system/drive_backend/metadata_database_unittest.cc',
        'browser/sync_file_system/drive_backend/metadata_db_migration_util_unittest.cc',
        'browser/sync_file_system/drive_backend/register_app_task_unittest.cc',
        'browser/sync_file_system/drive_backend/remote_to_local_syncer_unittest.cc',
        'browser/sync_file_system/drive_backend/sync_engine_initializer_unittest.cc',
        'browser/sync_file_system/drive_backend/sync_engine_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/api_util_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_service_fake_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_service_sync_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/drive_file_sync_service_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/drive_metadata_store_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/fake_api_util.cc',
        'browser/sync_file_system/drive_backend_v1/fake_api_util.h',
        'browser/sync_file_system/drive_backend_v1/fake_api_util_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/local_sync_operation_resolver_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/origin_operation_queue_unittest.cc',
        'browser/sync_file_system/drive_backend_v1/remote_sync_operation_resolver_unittest.cc',
        'browser/sync_file_system/fake_remote_change_processor.cc',
        'browser/sync_file_system/fake_remote_change_processor.h',
        'browser/sync_file_system/file_change_unittest.cc',
        'browser/sync_file_system/local/canned_syncable_file_system.cc',
        'browser/sync_file_system/local/canned_syncable_file_system.h',
        'browser/sync_file_system/local/local_file_change_tracker_unittest.cc',
        'browser/sync_file_system/local/local_file_sync_context_unittest.cc',
        'browser/sync_file_system/local/local_file_sync_service_unittest.cc',
        'browser/sync_file_system/local/local_file_sync_status_unittest.cc',
        'browser/sync_file_system/local/mock_sync_status_observer.cc',
        'browser/sync_file_system/local/mock_sync_status_observer.h',
        'browser/sync_file_system/local/syncable_file_operation_runner_unittest.cc',
        'browser/sync_file_system/local/syncable_file_system_unittest.cc',
        'browser/sync_file_system/logger_unittest.cc',
        'browser/sync_file_system/mock_local_change_processor.cc',
        'browser/sync_file_system/mock_local_change_processor.h',
        'browser/sync_file_system/mock_remote_change_processor.cc',
        'browser/sync_file_system/mock_remote_change_processor.h',
        'browser/sync_file_system/mock_remote_file_sync_service.cc',
        'browser/sync_file_system/mock_remote_file_sync_service.h',
        'browser/sync_file_system/sync_file_system_service_unittest.cc',
        'browser/sync_file_system/sync_file_system_test_util.cc',
        'browser/sync_file_system/sync_file_system_test_util.h',
        'browser/sync_file_system/sync_task_manager_unittest.cc',
        'browser/sync_file_system/syncable_file_system_util_unittest.cc',
        'browser/tab_contents/render_view_context_menu_test_util.cc',
        'browser/tab_contents/render_view_context_menu_test_util.h',
        'browser/tab_contents/render_view_context_menu_unittest.cc',
        'browser/task_manager/task_manager_unittest.cc',
        'browser/task_manager/task_manager_util_unittest.cc',
        'browser/task_profiler/task_profiler_data_serializer_unittest.cc',
        'browser/themes/browser_theme_pack_unittest.cc',
        'browser/themes/theme_properties_unittest.cc',
        'browser/themes/theme_service_unittest.cc',
        'browser/themes/theme_syncable_service_unittest.cc',
        'browser/thumbnails/content_analysis_unittest.cc',
        'browser/thumbnails/content_based_thumbnailing_algorithm_unittest.cc',
        'browser/thumbnails/simple_thumbnail_crop_unittest.cc',
        'browser/thumbnails/thumbnail_service_unittest.cc',
        'browser/translate/translate_manager_unittest.cc',
        'browser/ui/android/tab_model/tab_model_unittest.cc',
        'browser/ui/ash/ime_controller_chromeos_unittest.cc',
        'browser/ui/ash/launcher/chrome_launcher_controller_unittest.cc',
        'browser/ui/ash/launcher/launcher_context_menu_unittest.cc',
        'browser/ui/ash/multi_user/multi_user_context_menu_chromeos_unittest.cc',
        'browser/ui/ash/multi_user/multi_user_notification_blocker_chromeos_unittest.cc',
        'browser/ui/ash/multi_user/multi_user_window_manager_chromeos_unittest.cc',
        'browser/ui/ash/screenshot_taker_unittest.cc',
        'browser/ui/ash/session_state_delegate_chromeos_unittest.cc',
        'browser/ui/ash/window_positioner_unittest.cc',
        'browser/ui/autofill/account_chooser_model_unittest.cc',
        'browser/ui/autofill/autofill_dialog_controller_unittest.cc',
        'browser/ui/autofill/autofill_dialog_i18n_input_unittest.cc',
        'browser/ui/autofill/autofill_dialog_models_unittest.cc',
        'browser/ui/autofill/autofill_dialog_types_unittest.cc',
        'browser/ui/autofill/autofill_popup_controller_unittest.cc',
        'browser/ui/autofill/country_combobox_model_unittest.cc',
        'browser/ui/autofill/data_model_wrapper_unittest.cc',
        'browser/ui/autofill/generated_credit_card_bubble_controller_unittest.cc',
        'browser/ui/autofill/mock_address_validator.cc',
        'browser/ui/autofill/mock_address_validator.h',
        'browser/ui/autofill/mock_autofill_dialog_view_delegate.cc',
        'browser/ui/autofill/mock_autofill_dialog_view_delegate.h',
        'browser/ui/autofill/mock_new_credit_card_bubble_controller.cc',
        'browser/ui/autofill/mock_new_credit_card_bubble_controller.h',
        'browser/ui/autofill/popup_controller_common_unittest.cc',
        'browser/ui/autofill/test_generated_credit_card_bubble_controller.cc',
        'browser/ui/autofill/test_generated_credit_card_bubble_controller.h',
        'browser/ui/autofill/test_generated_credit_card_bubble_view.cc',
        'browser/ui/autofill/test_generated_credit_card_bubble_view.h',
        'browser/ui/autofill/test_popup_controller_common.cc',
        'browser/ui/autofill/test_popup_controller_common.h',
        'browser/ui/bookmarks/bookmark_context_menu_controller_unittest.cc',
        'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate_unittest.cc',
        'browser/ui/bookmarks/bookmark_editor_unittest.cc',
        'browser/ui/bookmarks/bookmark_prompt_controller_unittest.cc',
        'browser/ui/bookmarks/bookmark_ui_utils_unittest.cc',
        'browser/ui/bookmarks/bookmark_unittest.cc',
        'browser/ui/bookmarks/recently_used_folders_combo_model_unittest.cc',
        'browser/ui/browser_command_controller_unittest.cc',
        'browser/ui/browser_instant_controller_unittest.cc',
        'browser/ui/browser_iterator_unittest.cc',
        'browser/ui/browser_unittest.cc',
        'browser/ui/chrome_select_file_policy_unittest.cc',
        # It is safe to list */cocoa/* files in the "common" file list
        # without an explicit exclusion since gyp is smart enough to
        # exclude them from non-Mac builds.
        'browser/ui/cocoa/about_ipc_controller_unittest.mm',
        'browser/ui/cocoa/accelerators_cocoa_unittest.mm',
        'browser/ui/cocoa/animatable_image_unittest.mm',
        'browser/ui/cocoa/animatable_view_unittest.mm',
        'browser/ui/cocoa/applescript/apple_event_util_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.h',
        'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_item_applescript_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_account_chooser_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_details_container_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_bubble_controller_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_main_container_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_notification_container_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_notification_controller_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_overlay_controller_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_pop_up_button_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_textfield_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_tooltip_controller_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_section_container_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_section_view_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_sign_in_container_unittest.mm',
        'browser/ui/cocoa/autofill/autofill_suggestion_container_unittest.mm',
        'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell_unittest.mm',
        'browser/ui/cocoa/autofill/layout_view_unittest.mm',
        'browser/ui/cocoa/autofill/new_credit_card_bubble_cocoa_unittest.mm',
        'browser/ui/cocoa/autofill/simple_grid_layout_unittest.mm',
        'browser/ui/cocoa/background_gradient_view_unittest.mm',
        'browser/ui/cocoa/base_bubble_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_sync_promo_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell_unittest.mm',
        'browser/ui/cocoa/browser/avatar_button_controller_unittest.mm',
        'browser/ui/cocoa/browser/avatar_icon_controller_unittest.mm',
        'browser/ui/cocoa/browser/avatar_label_button_unittest.mm',
        'browser/ui/cocoa/browser/avatar_menu_bubble_controller_unittest.mm',
        'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/browser/password_generation_bubble_controller_unittest.mm',
        'browser/ui/cocoa/browser/profile_chooser_controller_unittest.mm',
        'browser/ui/cocoa/browser/user_manager_mac_unittest.mm',
        'browser/ui/cocoa/browser/zoom_bubble_controller_unittest.mm',
        'browser/ui/cocoa/browser_window_cocoa_unittest.mm',
        'browser/ui/cocoa/browser_window_controller_unittest.mm',
        'browser/ui/cocoa/bubble_view_unittest.mm',
        'browser/ui/cocoa/chrome_browser_window_unittest.mm',
        'browser/ui/cocoa/chrome_event_processing_window_unittest.mm',
        'browser/ui/cocoa/clickhold_button_cell_unittest.mm',
        'browser/ui/cocoa/cocoa_profile_test.h',
        'browser/ui/cocoa/cocoa_profile_test.mm',
        'browser/ui/cocoa/cocoa_test_helper.h',
        'browser/ui/cocoa/cocoa_test_helper.mm',
        'browser/ui/cocoa/command_observer_bridge_unittest.mm',
        'browser/ui/cocoa/confirm_bubble_controller_unittest.mm',
        'browser/ui/cocoa/confirm_quit_panel_controller_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_alert_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_animation_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_button_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_window_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller_unittest.mm',
        'browser/ui/cocoa/content_settings/collected_cookies_mac_unittest.mm',
        'browser/ui/cocoa/content_settings/cookie_details_unittest.mm',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller_unittest.mm',
        'browser/ui/cocoa/custom_frame_view_unittest.mm',
        'browser/ui/cocoa/download/download_item_button_unittest.mm',
        'browser/ui/cocoa/download/download_item_cell_unittest.mm',
        'browser/ui/cocoa/download/download_shelf_controller_unittest.mm',
        'browser/ui/cocoa/download/download_shelf_mac_unittest.mm',
        'browser/ui/cocoa/download/download_shelf_view_unittest.mm',
        'browser/ui/cocoa/download/download_util_mac_unittest.mm',
        'browser/ui/cocoa/draggable_button_unittest.mm',
        'browser/ui/cocoa/extensions/browser_actions_container_view_unittest.mm',
        'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.h',
        'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.mm',
        'browser/ui/cocoa/extensions/extension_install_view_controller_unittest.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller_unittest.mm',
        'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa_unittest.mm',
        'browser/ui/cocoa/extensions/media_galleries_scan_result_dialog_cocoa_unittest.mm',
        'browser/ui/cocoa/fast_resize_view_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_bridge_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_view_unittest.mm',
        'browser/ui/cocoa/find_pasteboard_unittest.mm',
        'browser/ui/cocoa/first_run_bubble_controller_unittest.mm',
        'browser/ui/cocoa/floating_bar_backing_view_unittest.mm',
        'browser/ui/cocoa/framed_browser_window_unittest.mm',
        'browser/ui/cocoa/fullscreen_window_unittest.mm',
        'browser/ui/cocoa/fullscreen_exit_bubble_controller_unittest.mm',
        'browser/ui/cocoa/gradient_button_cell_unittest.mm',
        'browser/ui/cocoa/history_menu_bridge_unittest.mm',
        'browser/ui/cocoa/history_menu_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/history_overlay_controller_unittest.mm',
        'browser/ui/cocoa/hover_close_button_unittest.mm',
        'browser/ui/cocoa/hung_renderer_controller_unittest.mm',
        'browser/ui/cocoa/hyperlink_text_view_unittest.mm',
        'browser/ui/cocoa/image_button_cell_unittest.mm',
        'browser/ui/cocoa/info_bubble_view_unittest.mm',
        'browser/ui/cocoa/info_bubble_window_unittest.mm',
        'browser/ui/cocoa/infobars/confirm_infobar_controller_unittest.mm',
        'browser/ui/cocoa/infobars/infobar_container_controller_unittest.mm',
        'browser/ui/cocoa/infobars/infobar_gradient_view_unittest.mm',
        'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.cc',
        'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.h',
        'browser/ui/cocoa/infobars/translate_infobar_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest_helper.mm',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/image_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration_unittest.mm',
        'browser/ui/cocoa/media_picker/desktop_media_picker_controller_unittest.mm',
        'browser/ui/cocoa/menu_button_unittest.mm',
        'browser/ui/cocoa/notifications/balloon_controller_unittest.mm',
        'browser/ui/cocoa/notifications/message_center_tray_bridge_unittest.mm',
        'browser/ui/cocoa/nsmenuitem_additions_unittest.mm',
        'browser/ui/cocoa/nsview_additions_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_cell_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_matrix_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_separator_view_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_view_mac_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_view_mac_unittest.mm',
        'browser/ui/cocoa/one_click_signin_bubble_controller_unittest.mm',
        'browser/ui/cocoa/panels/panel_cocoa_unittest.mm',
        'browser/ui/cocoa/profile_menu_controller_unittest.mm',
        'browser/ui/cocoa/run_loop_testing_unittest.mm',
        'browser/ui/cocoa/screen_capture_notification_ui_cocoa_unittest.mm',
        'browser/ui/cocoa/status_bubble_mac_unittest.mm',
        'browser/ui/cocoa/status_icons/status_icon_mac_unittest.mm',
        'browser/ui/cocoa/styled_text_field_cell_unittest.mm',
        'browser/ui/cocoa/styled_text_field_test_helper.h',
        'browser/ui/cocoa/styled_text_field_test_helper.mm',
        'browser/ui/cocoa/styled_text_field_unittest.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_controller_unittest.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_view_unittest.mm',
        'browser/ui/cocoa/table_row_nsimage_cache_unittest.mm',
        'browser/ui/cocoa/tabs/media_indicator_view_unittest.mm',
        'browser/ui/cocoa/tabs/tab_controller_unittest.mm',
        'browser/ui/cocoa/tabs/tab_strip_controller_unittest.mm',
        'browser/ui/cocoa/tabs/tab_strip_view_unittest.mm',
        'browser/ui/cocoa/tabs/tab_view_unittest.mm',
        'browser/ui/cocoa/tabs/throbber_view_unittest.mm',
        'browser/ui/cocoa/task_manager_mac_unittest.mm',
        'browser/ui/cocoa/toolbar/reload_button_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_button_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_controller_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_view_unittest.mm',
        'browser/ui/cocoa/toolbar/wrench_toolbar_button_cell_unittest.mm',
        'browser/ui/cocoa/vertical_gradient_view_unittest.mm',
        'browser/ui/cocoa/validation_message_bubble_controller_unittest.mm',
        'browser/ui/cocoa/view_resizer_pong.h',
        'browser/ui/cocoa/view_resizer_pong.mm',
        'browser/ui/cocoa/website_settings_bubble_controller_unittest.mm',
        'browser/ui/cocoa/web_dialog_window_controller_unittest.mm',
        'browser/ui/cocoa/window_size_autosaver_unittest.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view_unittest.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell_unittest.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller_unittest.mm',
        'browser/ui/content_settings/content_setting_bubble_model_unittest.cc',
        'browser/ui/content_settings/content_setting_image_model_unittest.cc',
        'browser/ui/find_bar/find_backend_unittest.cc',
        'browser/ui/fullscreen/fullscreen_controller_state_unittest.cc',
        'browser/ui/global_error/global_error_service_unittest.cc',
        'browser/ui/gtk/accelerators_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk_unittest.cc',
        'browser/ui/gtk/event_utils_unittest.cc',
        'browser/ui/gtk/extensions/media_galleries_dialog_gtk_unittest.cc',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox_unittest.cc',
        'browser/ui/gtk/gtk_theme_service_unittest.cc',
        'browser/ui/gtk/omnibox/omnibox_popup_view_gtk_unittest.cc',
        'browser/ui/gtk/omnibox/omnibox_view_gtk_unittest.cc',
        'browser/ui/gtk/reload_button_gtk_unittest.cc',
        'browser/ui/gtk/status_icons/status_tray_gtk_unittest.cc',
        'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
        'browser/ui/libgtk2ui/x11_input_method_context_impl_gtk2_unittest.cc',
        'browser/ui/login/login_prompt_unittest.cc',
        'browser/ui/omnibox/omnibox_controller_unittest.cc',
        'browser/ui/omnibox/omnibox_edit_unittest.cc',
        'browser/ui/omnibox/omnibox_view_unittest.cc',
        'browser/ui/panels/panel_mouse_watcher_unittest.cc',
        'browser/ui/passwords/password_manager_presenter_unittest.cc',
        'browser/ui/search_engines/keyword_editor_controller_unittest.cc',
        'browser/ui/search/instant_page_unittest.cc',
        'browser/ui/search/instant_search_prerenderer_unittest.cc',
        'browser/ui/search/search_delegate_unittest.cc',
        'browser/ui/search/search_ipc_router_policy_unittest.cc',
        'browser/ui/search/search_ipc_router_unittest.cc',
        'browser/ui/search/search_model_unittest.cc',
        'browser/ui/search/search_tab_helper_unittest.cc',
        'browser/ui/startup/session_crashed_infobar_delegate_unittest.cc',
        'browser/ui/sync/one_click_signin_helper_unittest.cc',
        'browser/ui/sync/one_click_signin_sync_starter_unittest.cc',
        'browser/ui/sync/profile_signin_confirmation_helper_unittest.cc',
        'browser/ui/sync/sync_promo_ui_unittest.cc',
        'browser/ui/tab_contents/tab_contents_iterator_unittest.cc',
        'browser/ui/tabs/dock_info_unittest.cc',
        'browser/ui/tabs/pinned_tab_codec_unittest.cc',
        'browser/ui/tabs/pinned_tab_service_unittest.cc',
        'browser/ui/tabs/pinned_tab_test_utils.cc',
        'browser/ui/tabs/tab_menu_model_unittest.cc',
        'browser/ui/tabs/tab_strip_model_unittest.cc',
        'browser/ui/tabs/test_tab_strip_model_delegate.cc',
        'browser/ui/tabs/test_tab_strip_model_delegate.h',
        'browser/ui/tests/elide_url_unittest.cc',
        'browser/ui/tests/ui_gfx_image_unittest.cc',
        'browser/ui/tests/ui_gfx_image_unittest.mm',
        'browser/ui/toolbar/back_forward_menu_model_unittest.cc',
        'browser/ui/toolbar/encoding_menu_controller_unittest.cc',
        'browser/ui/toolbar/recent_tabs_builder_test_helper.cc',
        'browser/ui/toolbar/recent_tabs_builder_test_helper.h',
        'browser/ui/toolbar/recent_tabs_sub_menu_model_unittest.cc',
        'browser/ui/toolbar/toolbar_model_unittest.cc',
        'browser/ui/toolbar/test_toolbar_model.cc',
        'browser/ui/toolbar/test_toolbar_model.h',
        'browser/ui/toolbar/wrench_icon_painter_unittest.cc',
        'browser/ui/toolbar/wrench_menu_model_unittest.cc',
        'browser/ui/views/accelerator_table_unittest.cc',
        'browser/ui/views/accessibility/accessibility_event_router_views_unittest.cc',
        'browser/ui/views/apps/shaped_app_window_targeter_unittest.cc',
        'browser/ui/views/autofill/autofill_dialog_views_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_bar_view_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_bubble_view_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_context_menu_test.cc',
        'browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_menu_delegate_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_bubble_view_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_sync_promo_view_unittest.cc',
        'browser/ui/views/confirm_bubble_views_unittest.cc',
        'browser/ui/views/constrained_window_views_unittest.cc',
        'browser/ui/views/crypto_module_password_dialog_view_unittest.cc',
        'browser/ui/views/extensions/browser_action_drag_data_unittest.cc',
        'browser/ui/views/extensions/media_galleries_dialog_views_unittest.cc',
        'browser/ui/views/first_run_bubble_unittest.cc',
        'browser/ui/views/frame/browser_view_layout_unittest.cc',
        'browser/ui/views/frame/browser_view_unittest.cc',
        'browser/ui/views/frame/immersive_mode_controller_ash_unittest.cc',
        'browser/ui/views/frame/opaque_browser_frame_view_layout_unittest.cc',
        'browser/ui/views/frame/test_with_browser_view.cc',
        'browser/ui/views/frame/test_with_browser_view.h',
        'browser/ui/views/toolbar/reload_button_unittest.cc',
        'browser/ui/views/select_file_dialog_extension_unittest.cc',
        'browser/ui/views/status_icons/status_tray_win_unittest.cc',
        'browser/ui/views/sync/one_click_signin_bubble_view_unittest.cc',
        'browser/ui/views/tabs/fake_base_tab_strip_controller.cc',
        'browser/ui/views/tabs/fake_base_tab_strip_controller.h',
        'browser/ui/views/tabs/stacked_tab_strip_layout_unittest.cc',
        'browser/ui/views/tabs/tab_unittest.cc',
        'browser/ui/views/tabs/tab_strip_unittest.cc',
        'browser/ui/views/translate/translate_bubble_view_unittest.cc',
        'browser/ui/views/validation_message_bubble_delegate_unittest.cc',
        'browser/ui/website_settings/permission_bubble_manager_unittest.cc',
        'browser/ui/website_settings/website_settings_unittest.cc',
        'browser/ui/webui/fileicon_source_unittest.cc',
        'browser/ui/webui/history_ui_unittest.cc',
        'browser/ui/webui/ntp/ntp_user_data_logger_unittest.cc',
        'browser/ui/webui/ntp/suggestions_combiner_unittest.cc',
        'browser/ui/webui/options/chromeos/cros_language_options_handler_unittest.cc',
        'browser/ui/webui/options/language_options_handler_unittest.cc',
        'browser/ui/webui/options/pepper_flash_content_settings_utils_unittest.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_util_unittest.cc',
        'browser/ui/webui/print_preview/print_preview_ui_unittest.cc',
        'browser/ui/webui/signin/login_ui_service_unittest.cc',
        'browser/ui/webui/sync_internals_ui_unittest.cc',
        'browser/ui/webui/sync_setup_handler_unittest.cc',
        'browser/ui/webui/theme_source_unittest.cc',
        'browser/ui/webui/web_dialog_web_contents_delegate_unittest.cc',
        'browser/ui/window_sizer/window_sizer_ash_unittest.cc',
        'browser/ui/window_sizer/window_sizer_common_unittest.cc',
        'browser/ui/window_sizer/window_sizer_unittest.cc',
        'browser/ui/zoom/zoom_controller_unittest.cc',
        'browser/upload_list_unittest.cc',
        'browser/chrome_content_browser_client_unittest.cc',
        'browser/undo/bookmark_undo_service_test.cc',
        'browser/undo/undo_manager_test.cc',
        'browser/usb/usb_context_unittest.cc',
        'browser/value_store/leveldb_value_store_unittest.cc',
        'browser/value_store/testing_value_store_unittest.cc',
        'browser/value_store/value_store_change_unittest.cc',
        'browser/value_store/value_store_frontend_unittest.cc',
        'browser/value_store/value_store_unittest.cc',
        'browser/value_store/value_store_unittest.h',
        'browser/web_applications/web_app_mac_unittest.mm',
        'browser/web_applications/web_app_unittest.cc',
        'browser/web_resource/eula_accepted_notifier_unittest.cc',
        'browser/web_resource/promo_resource_service_mobile_ntp_unittest.cc',
        'browser/web_resource/promo_resource_service_unittest.cc',
        'browser/web_resource/resource_request_allowed_notifier_test_util.cc',
        'browser/web_resource/resource_request_allowed_notifier_test_util.h',
        'browser/web_resource/resource_request_allowed_notifier_unittest.cc',
        'browser/webdata/keyword_table_unittest.cc',
        'browser/webdata/web_apps_table_unittest.cc',
        'common/chrome_paths_unittest.cc',
        'common/chrome_content_client_unittest.cc',
        'common/cloud_print/cloud_print_helpers_unittest.cc',
        'common/content_settings_helper_unittest.cc',
        'common/content_settings_pattern_parser_unittest.cc',
        'common/content_settings_pattern_unittest.cc',
        'common/crash_keys_unittest.cc',
        'common/extensions/api/commands/commands_manifest_unittest.cc',
        'common/extensions/api/extension_action/browser_action_manifest_unittest.cc',
        'common/extensions/api/extension_action/page_action_manifest_unittest.cc',
        'common/extensions/api/file_browser_handlers/file_browser_handler_manifest_unittest.cc',
        'common/extensions/api/file_handlers/file_handlers_manifest_unittest.cc',
        'common/extensions/api/i18n/default_locale_manifest_unittest.cc',
        'common/extensions/api/identity/extension_manifests_auth_unittest.cc',
        'common/extensions/api/sockets/sockets_manifest_permission_unittest.cc',
        'common/extensions/api/storage/storage_schema_manifest_handler_unittest.cc',
        'common/extensions/command_unittest.cc',
        'common/extensions/extension_file_util_unittest.cc',
        'common/extensions/extension_icon_set_unittest.cc',
        'common/extensions/extension_l10n_util_unittest.cc',
        'common/extensions/extension_unittest.cc',
        'common/extensions/feature_switch_unittest.cc',
        'common/extensions/features/base_feature_provider_unittest.cc',
        'common/extensions/features/complex_feature_unittest.cc',
        'common/extensions/features/simple_feature_unittest.cc',
        'common/extensions/manifest_handlers/content_scripts_manifest_unittest.cc',
        'common/extensions/manifest_handlers/exclude_matches_manifest_unittest.cc',
        'common/extensions/manifest_handlers/externally_connectable_unittest.cc',
        'common/extensions/manifest_handlers/settings_overrides_handler_unittest.cc',
        'common/extensions/manifest_tests/extension_manifest_test.cc',
        'common/extensions/manifest_tests/extension_manifests_background_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_chromepermission_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_contentsecuritypolicy_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_default_extent_path_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_devtools_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_dummy_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_experimental_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_homepage_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_icons_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_initvalue_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_isolatedapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_kiosk_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_launch_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_manifest_version_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_offline_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_old_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_options_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_override_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_platformapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_portsinpermissions_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_requirements_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_sandboxed_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_storage_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_ui_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_update_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_validapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_web_accessible_resources_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_web_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_webview_accessible_resources_unittest.cc',
        'common/extensions/manifest_unittest.cc',
        'common/extensions/message_bundle_unittest.cc',
        'common/extensions/permissions/media_galleries_permission_unittest.cc',
        'common/extensions/permissions/permission_set_unittest.cc',
        'common/extensions/permissions/settings_override_permission_unittest.cc',
        'common/extensions/permissions/socket_permission_unittest.cc',
        'common/extensions/permissions/usb_device_permission_unittest.cc',
        'common/extensions/sync_type_unittest.cc',
        'common/extensions/update_manifest_unittest.cc',
        'common/extensions/value_counter_unittest.cc',
        'common/extensions/api/extension_api_unittest.cc',
        'common/favicon/favicon_url_parser_unittest.cc',
        'common/importer/firefox_importer_utils_unittest.cc',
        'common/instant_restricted_id_cache_unittest.cc',
        'common/mac/cfbundle_blocker_unittest.mm',
        'common/mac/mock_launchd.cc',
        'common/mac/mock_launchd.h',
        'common/mac/objc_method_swizzle_unittest.mm',
        'common/mac/objc_zombie_unittest.mm',
        'common/metrics/caching_permuted_entropy_provider_unittest.cc',
        'common/metrics/metrics_log_base_unittest.cc',
        'common/metrics/metrics_log_manager_unittest.cc',
        'common/metrics/variations/experiment_labels_unittest.cc',
        'common/metrics/variations/variations_util_unittest.cc',
        'common/multi_process_lock_unittest.cc',
        'common/net/url_fixer_upper_unittest.cc',
        'common/net/x509_certificate_model_unittest.cc',
        'common/partial_circular_buffer_unittest.cc',
        'common/pref_names_util_unittest.cc',
        'common/search_urls_unittest.cc',
        'common/service_process_util_unittest.cc',
        'common/switch_utils_unittest.cc',
        'common/thumbnail_score_unittest.cc',
        'common/worker_thread_ticker_unittest.cc',
        'renderer/chrome_content_renderer_client_unittest.cc',
        'renderer/content_settings_observer_unittest.cc',
        'renderer/extensions/activity_log_converter_strategy_unittest.cc',
        'renderer/extensions/chrome_v8_context_set_unittest.cc',
        'renderer/extensions/event_unittest.cc',
        'renderer/extensions/extension_localization_peer_unittest.cc',
        'renderer/extensions/json_schema_unittest.cc',
        'renderer/extensions/messaging_utils_unittest.cc',
        'renderer/extensions/module_system_unittest.cc',
        'renderer/extensions/renderer_permissions_policy_delegate_unittest.cc',
        'renderer/extensions/safe_builtins_unittest.cc',
        'renderer/media/chrome_webrtc_log_message_delegate_unittest.cc',
        'renderer/net/net_error_helper_core_unittest.cc',
        'renderer/net/predictor_queue_unittest.cc',
        'renderer/net/renderer_predictor_unittest.cc',
        'renderer/plugins/plugin_uma_unittest.cc',
        'renderer/prerender/prerender_dispatcher_unittest.cc',
        'renderer/safe_browsing/features_unittest.cc',
        'renderer/safe_browsing/murmurhash3_util_unittest.cc',
        'renderer/safe_browsing/phishing_term_feature_extractor_unittest.cc',
        'renderer/safe_browsing/phishing_url_feature_extractor_unittest.cc',
        'renderer/safe_browsing/scorer_unittest.cc',
        'renderer/searchbox/search_bouncer_unittest.cc',
        'renderer/searchbox/searchbox_extension_unittest.cc',
        'renderer/searchbox/searchbox_unittest.cc',
        'renderer/spellchecker/custom_dictionary_engine_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_hunspell_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_mac_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_test.cc',
        'renderer/spellchecker/spellcheck_provider_test.h',
        'renderer/spellchecker/spellcheck_unittest.cc',
        'renderer/spellchecker/spellcheck_worditerator_unittest.cc',
        'renderer/web_apps_unittest.cc',
        'service/cloud_print/cloud_print_service_helpers_unittest.cc',
        'service/cloud_print/cloud_print_token_store_unittest.cc',
        'service/cloud_print/cloud_print_url_fetcher_unittest.cc',
        'service/cloud_print/connector_settings_unittest.cc',
        'service/cloud_print/printer_job_handler_unittest.cc',
        'service/cloud_print/printer_job_queue_handler_unittest.cc',
        'service/service_process_prefs_unittest.cc',
        'service/service_process_unittest.cc',
        'test/base/browser_with_test_window_test.cc',
        'test/base/browser_with_test_window_test.h',
        'test/base/chrome_render_view_test.cc',
        'test/base/chrome_render_view_test.h',
        'test/base/menu_model_test.cc',
        'test/base/menu_model_test.h',
        'test/base/v8_unit_test.cc',
        'test/base/v8_unit_test.h',
        'test/data/resource.rc',
        'test/data/unit/framework_unittest.gtestjs',
        'test/logging/win/mof_data_parser_unittest.cc',
        'tools/convert_dict/convert_dict_unittest.cc',
        'tools/profile_reset/jtl_compiler_unittest.cc',
        'tools/profile_reset/jtl_parser_unittest.cc',
        'utility/cloud_print/pwg_encoder_unittest.cc',
        'utility/extensions/unpacker_unittest.cc',
        'utility/image_writer/image_writer_unittest.cc',
        'utility/importer/bookmark_html_reader_unittest.cc',
        'utility/importer/bookmarks_file_importer_unittest.cc',
        'utility/importer/firefox_importer_unittest.cc',
        'utility/importer/firefox_importer_unittest_messages_internal.h',
        'utility/importer/firefox_importer_unittest_utils.h',
        'utility/importer/firefox_importer_unittest_utils_mac.cc',
        'utility/importer/safari_importer_unittest.mm',

        # Duplicate these tests here because PathService has more items in
        # unit_tests than in base_unittests.
        '../base/path_service_unittest.cc',

        # TODO(joi): Move to //components/components_tests.gypi once
        # remaining dependencies back to //chrome are eliminated.
        '../components/autofill/content/browser/autofill_driver_impl_unittest.cc',
        '../components/autofill/content/browser/request_autocomplete_manager_unittest.cc',
        '../components/autofill/content/browser/wallet/full_wallet_unittest.cc',
        '../components/autofill/content/browser/wallet/instrument_unittest.cc',
        '../components/autofill/content/browser/wallet/wallet_address_unittest.cc',
        '../components/autofill/content/browser/wallet/wallet_client_unittest.cc',
        '../components/autofill/content/browser/wallet/wallet_items_unittest.cc',
        '../components/autofill/content/browser/wallet/wallet_service_url_unittest.cc',
        '../components/autofill/content/browser/wallet/wallet_signin_helper_unittest.cc',
        '../components/autofill/core/browser/address_field_unittest.cc',
        '../components/autofill/core/browser/address_unittest.cc',
        '../components/autofill/core/browser/android/auxiliary_profile_unittest_android.cc',
        '../components/autofill/core/browser/autocomplete_history_manager_unittest.cc',
        '../components/autofill/core/browser/autofill_country_unittest.cc',
        '../components/autofill/core/browser/autofill_data_model_unittest.cc',
        '../components/autofill/core/browser/autofill_download_unittest.cc',
        '../components/autofill/core/browser/autofill_download_url_unittest.cc',
        '../components/autofill/core/browser/autofill_external_delegate_unittest.cc',
        '../components/autofill/core/browser/autofill_field_unittest.cc',
        '../components/autofill/core/browser/autofill_ie_toolbar_import_win_unittest.cc',
        '../components/autofill/core/browser/autofill_manager_unittest.cc',
        '../components/autofill/core/browser/autofill_merge_unittest.cc',
        '../components/autofill/core/browser/autofill_metrics_unittest.cc',
        '../components/autofill/core/browser/autofill_profile_unittest.cc',
        '../components/autofill/core/browser/autofill_regexes_unittest.cc',
        '../components/autofill/core/browser/autofill_type_unittest.cc',
        '../components/autofill/core/browser/autofill_xml_parser_unittest.cc',
        '../components/autofill/core/browser/contact_info_unittest.cc',
        '../components/autofill/core/browser/credit_card_field_unittest.cc',
        '../components/autofill/core/browser/credit_card_unittest.cc',
        '../components/autofill/core/browser/form_field_unittest.cc',
        '../components/autofill/core/browser/form_structure_unittest.cc',
        '../components/autofill/core/browser/name_field_unittest.cc',
        '../components/autofill/core/browser/password_autofill_manager_unittest.cc',
        '../components/autofill/core/browser/password_generator_unittest.cc',
        '../components/autofill/core/browser/personal_data_manager_unittest.cc',
        '../components/autofill/core/browser/phone_field_unittest.cc',
        '../components/autofill/core/browser/phone_number_unittest.cc',
        '../components/autofill/core/browser/phone_number_i18n_unittest.cc',
        '../components/autofill/core/browser/validation_unittest.cc',

        # TODO(caitkp): Move to //components/components_tests.gypi once
        # remaining dependencies back to //chrome are eliminated.
        '../components/autofill/core/browser/webdata/autofill_table_unittest.cc',
        '../components/autofill/core/browser/webdata/autofill_profile_syncable_service_unittest.cc',

        # TODO(yael): Move to //components/components_tests.gypi once
        # nacl_defines is moved out of chrome.gyp into a common place.
        '../components/nacl/loader/nacl_ipc_adapter_unittest.cc',
        '../components/nacl/loader/nacl_validation_query_unittest.cc',

        '../components/webdata/common/web_database_migration_unittest.cc',
        '../components/webdata/common/web_data_service_test_util.cc',
        '../components/webdata/common/web_data_service_test_util.h',

        '../skia/ext/analysis_canvas_unittest.cc',
        '../skia/ext/bitmap_platform_device_mac_unittest.cc',
        '../skia/ext/convolver_unittest.cc',
        '../skia/ext/image_operations_unittest.cc',
        '../skia/ext/pixel_ref_utils_unittest.cc',
        '../skia/ext/platform_canvas_unittest.cc',
        '../skia/ext/recursive_gaussian_convolution_unittest.cc',
        '../skia/ext/refptr_unittest.cc',
        '../skia/ext/skia_utils_ios_unittest.mm',
        '../skia/ext/skia_utils_mac_unittest.mm',
        '../skia/ext/vector_canvas_unittest.cc',
        '../testing/gtest_mac_unittest.mm',
        '../third_party/zlib/google/zip_reader_unittest.cc',
        '../third_party/zlib/google/zip_unittest.cc',
        '../tools/json_schema_compiler/test/additional_properties_unittest.cc',
        '../tools/json_schema_compiler/test/any_unittest.cc',
        '../tools/json_schema_compiler/test/arrays_unittest.cc',
        '../tools/json_schema_compiler/test/callbacks_unittest.cc',
        '../tools/json_schema_compiler/test/choices_unittest.cc',
        '../tools/json_schema_compiler/test/crossref_unittest.cc',
        '../tools/json_schema_compiler/test/enums_unittest.cc',
        '../tools/json_schema_compiler/test/functions_as_parameters_unittest.cc',
        '../tools/json_schema_compiler/test/functions_on_types_unittest.cc',
        '../tools/json_schema_compiler/test/idl_schemas_unittest.cc',
        '../tools/json_schema_compiler/test/objects_unittest.cc',
        '../tools/json_schema_compiler/test/simple_api_unittest.cc',
        '../tools/json_schema_compiler/test/error_generation_unittest.cc',
        '../ui/webui/resources/js/cr.js',
        '../webkit/browser/quota/mock_storage_client.cc',
        '../webkit/browser/quota/mock_storage_client.h',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            'common/extensions/api/api.gyp:api',
            '../components/components.gyp:autofill_content_test_support',
            '../components/component_strings.gyp:component_strings',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth_mocks',
            '../gpu/gpu.gyp:gpu_unittest_utils',
            '../media/media.gyp:media_test_support',
            '../ppapi/ppapi_internal.gyp:ppapi_unittest_shared',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
            '../third_party/libjingle/libjingle.gyp:libjingle',
            '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
            '../tools/json_schema_compiler/test/json_schema_compiler_tests.gyp:json_schema_compiler_tests',
            '../ui/gl/gl.gyp:gl',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/webkit_resources.gyp:webkit_resources',
          ],
          # TODO(scr): Use this in browser_tests too.
          'includes': [
            'js_unittest_rules.gypi',
          ],
          'include_dirs': [
            '<(SHARED_INTERMEDIATE_DIR)/chrome',
          ],
        }, {  # OS=="ios"
          'dependencies': [
            '../third_party/ocmock/ocmock.gyp:ocmock',
          ],
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^common/translate/language_detection_util_unittest\\.cc$'],
            ['include', '^common/translate/translate_util_unittest\\.cc$'],
            ['include', '^common/zip_'],
          ],
          # Bundle all the necessary resources into the test bundle.
          'includes': ['chrome_ios_bundle_resources.gypi'],
          'xcode_settings': {'OTHER_LDFLAGS': ['-ObjC']},
        }],
        ['enable_background==0', {
          'sources/': [
            ['exclude', '^browser/background/'],
          ],
        }],
        ['enable_spellcheck==0', {
          'sources/': [
             ['exclude', '^browser/spellchecker/'],
             ['exclude', '^renderer/spellchecker/'],
          ],
          'dependencies!': [
             '../third_party/hunspell/hunspell.gyp:hunspell',
          ],
        }],
        ['enable_one_click_signin==0', {
          'sources!': [
            'browser/ui/cocoa/one_click_signin_bubble_controller_unittest.mm',
            'browser/ui/sync/one_click_signin_helper_unittest.cc',
            'browser/ui/sync/one_click_signin_sync_starter_unittest.cc',
            'browser/ui/views/sync/one_click_signin_bubble_view_unittest.cc',
          ]
        }],
        ['disable_nacl==1', {
          'sources!':[
            # TODO(yael): Move to //components/components_tests.gypi once
            # nacl_defines is moved out of chrome.gyp into a common place.
            '../components/nacl/loader/nacl_ipc_adapter_unittest.cc',
            '../components/nacl/loader/nacl_validation_query_unittest.cc',
          ],
        }],
        ['enable_extensions==0', {
          'sources/': [
            ['exclude', '^../extensions/'],
            ['exclude', '^browser/extensions/activity_log/'],
            ['exclude', '^browser/extensions/api/'],
            ['exclude', '^browser/extensions/error_console/'],
            ['exclude', '^browser/sync/glue/extensions_activity_monitor_unittest.cc'],
            ['exclude', '^common/extensions/api/'],
            ['exclude', '^common/extensions/manifest_handlers/'],
            ['exclude', '^common/extensions/manifest_tests/'],
            # This test depends on manifest_tests.
            ['exclude', '^common/extensions/permissions/settings_override_permission_unittest.cc'],
          ],
          'sources!': [
            'browser/extensions/extension_context_menu_model_unittest.cc',
            'browser/extensions/extension_protocols_unittest.cc',
            'browser/extensions/extension_ui_unittest.cc',
            'browser/extensions/pack_extension_unittest.cc',
            'browser/extensions/permissions_updater_unittest.cc',
            'browser/extensions/sandboxed_unpacker_unittest.cc',
            'common/extensions/sync_type_unittest.cc',
            'common/extensions/permissions/permission_set_unittest.cc',
            'renderer/extensions/activity_log_converter_strategy_unittest.cc',
            'renderer/extensions/chrome_v8_context_set_unittest.cc',
            'renderer/extensions/event_unittest.cc',
            'renderer/extensions/extension_localization_peer_unittest.cc',
            'renderer/extensions/json_schema_unittest.cc',
            'renderer/extensions/messaging_utils_unittest.cc',
            'renderer/extensions/module_system_unittest.cc',
            'renderer/extensions/renderer_permissions_policy_delegate_unittest.cc',
            'renderer/extensions/safe_builtins_unittest.cc',
            'utility/extensions/unpacker_unittest.cc',
          ],
        }],
        ['use_ash==1', {
          'sources': [
            'browser/ui/app_list/search/app_search_provider_unittest.cc',
            'browser/ui/app_list/search/history_unittest.cc',
            'browser/ui/app_list/search/history_data_store_unittest.cc',
            'browser/ui/app_list/search/mixer_unittest.cc',
            'browser/ui/app_list/search/term_break_iterator_unittest.cc',
            'browser/ui/app_list/search/tokenized_string_char_iterator_unittest.cc',
            'browser/ui/app_list/search/tokenized_string_match_unittest.cc',
            'browser/ui/app_list/search/tokenized_string_unittest.cc',
          ],
          'dependencies': [
            '../ash/ash.gyp:ash_resources',
            '../ash/ash.gyp:ash_test_support',
            '../ash/ash_strings.gyp:ash_strings',
          ],
          # We eventually want to compile both in Win Aura builds, see
          # http://crbug.com/155545.
          'conditions': [
            ['OS !="win"', {
              'sources!': [
                'browser/ui/window_sizer/window_sizer_unittest.cc',
              ],
            }],
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura_test_support',
          ],
          'sources/': [
            ['exclude', '^browser/ui/views/extensions/browser_action_drag_data_unittest.cc'],
          ],
        }],
        ['use_aura==1 and use_ash==0 and use_ozone==0 and OS=="linux"', {
          'dependencies': [
            'browser/ui/libgtk2ui/libgtk2ui.gyp:gtk2ui',
            '../build/linux/system.gyp:gio',
          ],
        }, {
          'sources/': [
            ['exclude', '^browser/ui/libgtk2ui/'],
          ],
        }],
        ['use_aura==1 or toolkit_views==1', {
          'dependencies': [
            '../ui/events/events.gyp:events_test_support',
            '../ui/wm/wm.gyp:wm_public',
          ],
        }],
        ['use_aura==1 and component=="shared_library"', {
          'sources!': [
            # TODO(erg): This file does not compile in shared library mode
            # because it is reaching into the internals of libgtk2ui, which
            # shouldn't be linked with the rest of chrome. This should either
            # be fixed by creating a separate unit test target, or by deleting
            # the test.
            'browser/ui/libgtk2ui/x11_input_method_context_impl_gtk2_unittest.cc'
          ],
        }],
        ['enable_task_manager==0', {
          'sources/': [
            ['exclude', '^browser/task_manager/'],
          ],
        }],
        ['chromeos==0', {
          'sources!': [
            'browser/ui/views/frame/immersive_mode_controller_ash_unittest.cc',
            'browser/ui/views/select_file_dialog_extension_unittest.cc',
          ],
        }],
        ['enable_mdns == 1', {
            'sources': [
              'utility/local_discovery/local_domain_resolver_unittest.cc',
              'utility/local_discovery/service_discovery_client_unittest.cc',
              'browser/local_discovery/privet_device_lister_unittest.cc',
              'browser/local_discovery/privet_notifications_unittest.cc',
              'browser/local_discovery/privet_local_printer_lister_unittest.cc',
            ]
        }],
        ['configuration_policy==0', {
          'sources!': [
            'browser/extensions/api/storage/policy_value_store_unittest.cc',
            'browser/extensions/policy_handlers_unittest.cc',
            'browser/net/proxy_policy_handler_unittest.cc',
            'browser/prefs/proxy_policy_unittest.cc',
            'browser/profiles/incognito_mode_policy_handler_unittest.cc',
            'browser/search_engines/default_search_policy_handler_unittest.cc',
            'browser/sessions/restore_on_startup_policy_handler_unittest.cc',
            'browser/sync/sync_policy_handler_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/policy/'],
          ],
        }],
        ['input_speech==0', {
          'sources/': [
            ['exclude', '^browser/speech/'],
          ],
        }],
        ['notifications==0', {
          'sources/': [
            ['exclude', '^browser/notifications/'],
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }],
        # TODO(sgurun): enable tests for safe_browsing==2.
        ['safe_browsing!=1', {
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['exclude', '^renderer/safe_browsing/'],
          ],
        }],
        ['enable_autofill_dialog!=1 or OS=="android"', {
          'sources!': [
            'browser/ui/autofill/account_chooser_model_unittest.cc',
            'browser/ui/autofill/autofill_credit_card_bubble_controller_unittest.cc',
            'browser/ui/autofill/autofill_dialog_controller_unittest.cc',
            'browser/ui/autofill/autofill_dialog_i18n_input_unittest.cc',
            'browser/ui/autofill/country_combobox_model_unittest.cc',
            'browser/ui/autofill/data_model_wrapper_unittest.cc',
            'browser/ui/autofill/mock_autofill_dialog_view_delegate.cc',
            'browser/ui/autofill/mock_autofill_dialog_view_delegate.h',
            'browser/ui/autofill/test_autofill_credit_card_bubble.cc',
            'browser/ui/autofill/test_autofill_credit_card_bubble.h',
          ],
        }],
        ['enable_automation!=1', {
          'sources/': [
            ['exclude', '^browser/automation/'],
          ],
        }],
        ['enable_plugins==0', {
          'sources/': [
            ['exclude', '^browser/plugins/'],
          ],
          'sources!': [
            'browser/renderer_host/plugin_info_message_filter_unittest.cc',
          ],
        }],
        ['enable_printing!=1', {
          'sources/': [
            ['exclude', '^browser/printing/'],
            ['exclude', '^browser/ui/webui/print_preview/'],
          ],
        }],
        ['enable_captive_portal_detection!=1', {
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
          ],
        }],
        ['enable_session_service!=1', {
          'sources!': [
            'browser/sessions/session_service_unittest.cc',
            'browser/ui/startup/session_crashed_infobar_delegate_unittest.cc',
          ],
        }],
        ['enable_webrtc==0', {
          'sources!': [
            'browser/media/webrtc_log_uploader_unittest.cc',
            'renderer/media/chrome_webrtc_log_message_delegate_unittest.cc',
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'browser/extensions/api/messaging/native_message_process_host_unittest.cc',
            'browser/extensions/api/messaging/native_messaging_host_manifest_unittest.cc',
            'browser/extensions/api/messaging/native_messaging_policy_handler_unittest.cc',
            'browser/password_manager/native_backend_gnome_x_unittest.cc',
            'browser/password_manager/native_backend_kwallet_x_unittest.cc',
            'browser/policy/cloud/user_policy_signin_service_unittest.cc',
            'browser/profiles/profile_list_desktop_unittest.cc',
            'browser/safe_browsing/download_protection_service_unittest.cc',
            'browser/shell_integration_linux_unittest.cc',
            'browser/signin/signin_manager_unittest.cc',
            'browser/signin/signin_names_io_thread_unittest.cc',
            'browser/ui/sync/one_click_signin_helper_unittest.cc',
            'browser/ui/sync/one_click_signin_sync_starter_unittest.cc',
            'browser/ui/views/frame/opaque_browser_frame_view_layout_unittest.cc',
          ],
          'sources': [
            'browser/extensions/updater/local_extension_cache_unittest.cc',
          ],
        }, { # else: chromeos == 0
          'sources/': [
            ['exclude', '^browser/chromeos/'],
            ['exclude', '^browser/ui/webui/chromeos/imageburner/'],
            ['exclude', '^browser/ui/webui/chromeos/login'],
            ['exclude', '^browser/ui/webui/options/chromeos/'],
            ['exclude', '^browser/ui/webui/options/chromeos/'],
          ],
          'sources!': [
            'browser/extensions/api/enterprise_platform_keys_private/enterprise_platform_keys_private_api_unittest.cc',
            'browser/notifications/login_state_notification_blocker_chromeos_unittest.cc',
            'browser/extensions/api/log_private/syslog_parser_unittest.cc',
          ],
        }],
        ['use_x11==1', {
          'dependencies': [
            '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'conditions': [
            ['toolkit_views==1', {
              'sources!': [
                'browser/ui/gtk/accelerators_gtk_unittest.cc',
                'browser/ui/gtk/bookmarks/bookmark_bar_gtk_unittest.cc',
                'browser/ui/gtk/bookmarks/bookmark_editor_gtk_unittest.cc',
                'browser/ui/gtk/gtk_chrome_shrinkable_hbox_unittest.cc',
                'browser/ui/gtk/gtk_theme_service_unittest.cc',
                'browser/ui/gtk/omnibox/omnibox_popup_view_gtk_unittest.cc',
                'browser/ui/gtk/omnibox/omnibox_view_gtk_unittest.cc',
                'browser/ui/gtk/reload_button_gtk_unittest.cc',
                'browser/ui/gtk/status_icons/status_tray_gtk_unittest.cc',
              ],
            }],
            ['chromeos==0', {
              'conditions': [
                ['use_gnome_keyring==1', {
                  # We use a few library functions directly, so link directly.
                  'dependencies': [
                    '../build/linux/system.gyp:gnome_keyring_direct',
                  ],
                }],
              ],
            }],
          ],
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gtk',
            '../dbus/dbus.gyp:dbus_test_support',
            '../sandbox/sandbox.gyp:*',
          ],
        }, { # else: toolkit_uses_gtk != 1
          'sources!': [
            'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
            '../ui/views/focus/accelerator_handler_gtk_unittest.cc',
          ],
        }],
        ['toolkit_uses_gtk == 1 or chromeos==1 or (OS=="linux" and use_aura==1)', {
          'dependencies': [
            '../build/linux/system.gyp:ssl',
          ],
        }],
        ['use_gnome_keyring == 0', {
          # Disable the GNOME Keyring tests if we are not using it.
          'sources!': [
            'browser/password_manager/native_backend_gnome_x_unittest.cc',
          ],
        }],
        ['OS=="linux" and use_aura==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../dbus/dbus.gyp:dbus_test_support',
            '../ui/aura/aura.gyp:aura_test_support',
          ],
        }],
        ['OS=="linux" and branding=="Chrome" and target_arch=="ia32"', {
          'configurations': {
            'Release': {
              'ldflags': [
                '-Wl,--strip-debug',
              ],
            },
          },
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        ['OS=="mac"', {
          # The test fetches resources which means Mac need the app bundle to
          # exist on disk so it can pull from it.
          'dependencies': [
            '../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
            '../third_party/ocmock/ocmock.gyp:ocmock',
            'chrome',
          ],
          'sources!': [
            'browser/ui/tabs/dock_info_unittest.cc',
            'browser/ui/tests/ui_gfx_image_unittest.cc',
            'browser/ui/gtk/reload_button_gtk_unittest.cc',
            'tools/convert_dict/convert_dict_unittest.cc',
            'renderer/spellchecker/spellcheck_provider_hunspell_unittest.cc',
          ],
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui and startup tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS!="mac" and OS!="ios"', {
          'dependencies': [
            '../third_party/hunspell/hunspell.gyp:hunspell',
            'chrome_resources.gyp:packed_extra_resources',
            'chrome_resources.gyp:packed_resources',
            'tools/convert_dict/convert_dict.gyp:convert_dict_lib',
          ],
        }],
        ['OS!="win" and OS!="mac"', {
          'sources!': [
            '../skia/ext/platform_canvas_unittest.cc',
          ],
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [
            'browser/media_galleries/fileapi/itunes_file_util_unittest.cc',
            'browser/media_galleries/fileapi/picasa_file_util_unittest.cc',
            'utility/media_galleries/itunes_library_parser_unittest.cc',
            'utility/media_galleries/picasa_album_table_reader_unittest.cc',
            'utility/media_galleries/picasa_albums_indexer_unittest.cc',
            'utility/media_galleries/pmp_column_reader_unittest.cc',
          ],
        }],
        ['OS=="mac"', {
          'sources': [
            'browser/media_galleries/fileapi/iphoto_file_util_unittest.cc',
            'utility/media_galleries/iphoto_library_parser_unittest.cc',
          ],
        }],
        ['enable_rlz==0', {
          'sources!': [
            'browser/rlz/rlz_unittest.cc',
          ],
        }],
        ['OS=="win" and component!="shared_library"', {
          # Unit_tests pdb files can get too big when incremental linking is
          # on, disabling for this target.
          'configurations': {
            'Debug': {
              'msvs_settings': {
                'VCLinkerTool': {
                  'LinkIncremental': '<(msvs_debug_link_nonincremental)',
                },
              },
            },
          },
        }],
        ['OS=="win"', {
          'dependencies': [
            'chrome_version_resources',
            'installer_util_strings',
            'unit_tests_exe_pdb_workaround',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'sources': [
            'browser/extensions/api/networking_private/networking_private_crypto_unittest.cc',
            # TODO:  It would be nice to have these pulled in
            # automatically from direct_dependent_settings in
            # their various targets (net.gyp:net_resources, etc.),
            # but that causes errors in other targets when
            # resulting .res files get referenced multiple times.
            '<(SHARED_INTERMEDIATE_DIR)/chrome_version/other_version.rc',
            '<(SHARED_INTERMEDIATE_DIR)/installer_util_strings/installer_util_strings.rc',
            '<(SHARED_INTERMEDIATE_DIR)/ui/ui_resources/ui_unscaled_resources.rc',
          ],
          'link_settings': {
            'libraries': [
              '-lcomsupp.lib',
              '-loleacc.lib',
              '-lrpcrt4.lib',
              '-lurlmon.lib',
              '-lwinmm.lib',
            ],
          },
        }, { # else: OS != "win"
          'sources!': [
            'app/chrome_dll.rc',
            'browser/search_engines/template_url_scraper_unittest.cc',
            'browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc',
            'browser/ui/views/extensions/browser_action_drag_data_unittest.cc',
            'test/data/resource.rc',
            '../skia/ext/vector_canvas_unittest.cc',
          ],
        }],
        ['OS!="android" and OS!="ios"', {
          'dependencies': [
            'tools/profile_reset/jtl_compiler.gyp:jtl_compiler_lib',
          ],
          'sources!': [
            'browser/metrics/variations/variations_request_scheduler_mobile_unittest.cc',
            'browser/net/spdyproxy/data_reduction_proxy_settings_unittest.cc',
            'browser/net/spdyproxy/data_reduction_proxy_settings_unittest.h',
            'browser/web_resource/promo_resource_service_mobile_ntp_unittest.cc',
          ],
        }],
        ['OS=="android"', {
          '!dependencies': [
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
          ],
          'sources!': [
            # Bookmark export/import are handled via the BookmarkColumns
            # ContentProvider.
            'browser/bookmarks/bookmark_html_writer_unittest.cc',

            # No service process (which also requires multiprocess lock).
            'common/multi_process_lock_unittest.cc',

            # Sync setup uses native ui.
            'browser/ui/webui/sync_setup_handler_unittest.cc',
            'browser/sync/sync_ui_util_unittest.cc',

            'browser/browser_commands_unittest.cc',
            'browser/download/download_shelf_unittest.cc',
            'browser/extensions/extension_message_bubble_controller_unittest.cc',
            'browser/policy/policy_path_parser_unittest.cc',
            'browser/profiles/off_the_record_profile_impl_unittest.cc',
            'browser/profiles/profile_list_desktop_unittest.cc',
            'browser/search/instant_service_unittest.cc',
            'browser/search/search_unittest.cc',
            'browser/signin/mutable_profile_oauth2_token_service_unittest.cc',
            'browser/sync/profile_sync_service_session_unittest.cc',
            'browser/sync/sessions2/sessions_sync_manager_unittest.cc',
            'browser/sync/sync_global_error_unittest.cc',
            'browser/tab_contents/render_view_context_menu_unittest.cc',
            'browser/ui/autofill/autofill_dialog_controller_unittest.cc',
            'browser/ui/browser_instant_controller_unittest.cc',
            'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate_unittest.cc',
            'browser/ui/bookmarks/bookmark_context_menu_controller_unittest.cc',
            'browser/ui/bookmarks/bookmark_prompt_controller_unittest.cc',
            'browser/ui/bookmarks/bookmark_unittest.cc',
            'browser/ui/browser_command_controller_unittest.cc',
            'browser/ui/browser_iterator_unittest.cc',
            'browser/ui/fullscreen/fullscreen_controller_state_unittest.cc',
            'browser/ui/fullscreen/fullscreen_controller_unittest.cc',
            'browser/ui/search/instant_page_unittest.cc',
            'browser/ui/search/instant_search_prerenderer_unittest.cc',
            'browser/ui/search/search_delegate_unittest.cc',
            'browser/ui/search/search_ipc_router_policy_unittest.cc',
            'browser/ui/search/search_ipc_router_unittest.cc',
            'browser/ui/search/search_model_unittest.cc',
            'browser/ui/search/search_tab_helper_unittest.cc',
            'browser/ui/tab_contents/tab_contents_iterator_unittest.cc',
            'browser/ui/toolbar/recent_tabs_sub_menu_model_unittest.cc',
            'browser/ui/toolbar/toolbar_model_unittest.cc',
            'browser/ui/toolbar/wrench_menu_model_unittest.cc',
            'browser/ui/webui/ntp/suggestions_combiner_unittest.cc',
            'browser/ui/webui/web_dialog_web_contents_delegate_unittest.cc',
            'browser/ui/window_sizer/window_sizer_common_unittest.cc',
            'browser/ui/window_sizer/window_sizer_unittest.cc',
            'test/base/browser_with_test_window_test.cc',
            'test/base/browser_with_test_window_test.h',
            'test/base/test_browser_window.h',

            'browser/sessions/persistent_tab_restore_service_unittest.cc',
            'browser/sessions/session_backend_unittest.cc',

            # Test files cannot be opened on Android.
            'browser/drive/fake_drive_service_unittest.cc',
            'browser/sync_file_system/drive_backend/api_util_unittest.cc',
            'browser/sync_file_system/drive_backend/drive_file_sync_service_sync_unittest.cc',

            # The autofill popup is implemented in mostly native code on
            # Android.
            'browser/ui/autofill/autofill_popup_controller_unittest.cc',

            # Android uses a different invaliator.
            'browser/invalidation/gcm_network_channel_delegate_impl_unittest.cc',
            'browser/invalidation/ticl_invalidation_service_unittest.cc',

            # The importer code is not used on Android.
            'common/importer/firefox_importer_utils_unittest.cc',

            # USB service is not supported on Android.
            'browser/usb/usb_context_unittest.cc',

            # Bookmark undo is not used on Android.
           'browser/undo/bookmark_undo_service_test.cc',
           'browser/undo/undo_manager_test.cc',

            # URL elider is not used on android.
           'browser/ui/tests/elide_url_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
            ['exclude', '^browser/diagnostics/'],
            ['exclude', '^browser/first_run/'],
            ['exclude', '^browser/lifetime/'],
            ['exclude', '^browser/media_galleries/'],
            ['exclude', '^browser/net/firefox_*'],
            ['exclude', '^browser/profile_resetter/'],
            ['exclude', '^browser/speech/'],
            ['exclude', '^browser/sync/glue/app_'],
            ['exclude', '^browser/sync/glue/extension_'],
            ['exclude', '^browser/themes/'],
            ['exclude', '^browser/ui/autofill/.*credit_card_bubble.*'],
            ['exclude', '^browser/ui/content_settings/'],
            ['exclude', '^browser/ui/omnibox/'],
            ['exclude', '^browser/ui/panels'],
            ['exclude', '^browser/ui/tabs/'],
            ['exclude', '^browser/ui/toolbar/'],
            ['exclude', '^browser/ui/webui/downloads_'],
            ['exclude', '^browser/ui/webui/flags_'],
            ['exclude', '^browser/ui/webui/help/'],
            ['exclude', '^browser/ui/webui/options/'],
            ['exclude', '^browser/ui/webui/options/'],
            ['exclude', '^browser/ui/webui/signin/'],
            ['exclude', '^browser/ui/webui/suggestions_internals'],
            ['exclude', '^browser/ui/webui/sync_promo'],
            ['exclude', '^tools/profile_reset/'],
            ['exclude', '^utility/importer/'],
          ],
          'conditions': [
            ['gtest_target_type == "shared_library"', {
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_native_code',
              ],
            }],
          ],
        }],  # OS == android
        ['OS!="android" and OS!="ios" and chromeos==0 and configuration_policy==1', {
          'sources': [
            'browser/download/download_dir_policy_handler_unittest.cc',
            'browser/net/disk_cache_dir_policy_handler_unittest.cc',
          ],
        }],
        ['enable_printing!=1', {
          'sources/': [
            # No need for service process.
            ['exclude', '^browser/service/'],
            ['exclude', '^common/service_'],
            ['exclude', '^service/'],
          ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/ui/webui/theme_source_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/themes/'],
          ],
        }],
        ['toolkit_views==1', {
          'dependencies': [
            '../components/components.gyp:web_modal_test_support',
            '../ui/views/views.gyp:views',
            '../ui/views/views.gyp:views_test_support',
          ],
          'sources!': [
            'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
          ],
        }, { # else: toolkit_views == 0
          'sources/': [
            ['exclude', '^browser/bookmarks/bookmark_node_data_unittest.cc'],
            ['exclude', '^browser/ui/views/'],
            ['exclude', '^../ui/views/'],
          ],
        }],
        ['use_nss==0 and use_openssl==0', {
          'sources!': [
            'common/net/x509_certificate_model_unittest.cc',
          ],
        }],
        ['use_openssl==1', {
          'sources!': [
            # networking_private_crypto.cc uses NSS functions.
            'browser/extensions/api/networking_private/networking_private_crypto_unittest.cc',
          ],
          'sources/': [
            # OpenSSL build does not support firefox importer. See
            # http://crbug.com/64926
            ['exclude', '^browser/importer/'],
          ],
        }],
        ['enable_managed_users!=1', {
          'sources/': [
            ['exclude', '^browser/managed_mode/'],
          ],
        }],
        ['safe_browsing!=1', {
          'sources/': [
            ['exclude', '^browser/extensions/blacklist_unittest.cc'],
          ],
        }],
        ['cld_version==0 or cld_version==1', {
          'defines': [
            'CLD_WINDOWS',
          ],
          'direct_dependent_settings': {
            'defines': [
              'CLD_WINDOWS',
            ],
          },
          'sources': [
            '../third_party/cld/encodings/compact_lang_det/compact_lang_det_unittest_small.cc',
          ],
          'dependencies': [
            '../third_party/cld/cld.gyp:cld',
          ],
        }],
        ['enable_app_list==1', {
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list_test_support',
          ],
          'sources': [
            'browser/ui/app_list/extension_app_model_builder_unittest.cc',
            'browser/ui/app_list/test/fast_show_pickler_unittest.cc',
          ],
        }],
      ],
    },
    {
      'target_name': 'chrome_app_unittests',
      'type': 'executable',
      'dependencies': [
        # unit tests should only depend on
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_browser_dependencies)',
        '<@(chromium_child_dependencies)',
        '../content/content.gyp:content_app_both',
        # 2) test-specific support libraries:
        '../base/base.gyp:run_all_unittests',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'app/delay_load_hook_win.cc',
        'app/delay_load_hook_win.h',
        'app/delay_load_hook_unittest_win.cc',
        'app/signature_validator_win.cc',
        'app/signature_validator_win.h',
        'app/signature_validator_win_unittest.cc',
        'common/crash_keys.cc',
        'common/crash_keys.h',
      ],
      'conditions': [
        ['OS=="mac" or OS=="ios"', {
          'include_dirs': [
            '<(DEPTH)/breakpad/src',
          ],
        }],
        ['OS=="mac"', {
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui and startup tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS=="win"', {
          'dependencies': [
            # breakpad is currently only tested on Windows.
            '../breakpad/breakpad.gyp:*',
            '../components/components.gyp:breakpad_component',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
          'msvs_settings': {
            'VCLinkerTool': {
              'AdditionalDependencies': [ 'wintrust.lib' ],
            },
          },
        }],
      ],
    },
  ],

  'conditions': [
    # Special target to wrap a gtest_target_type==shared_library
    # unit_tests into an android apk for execution.
    ['OS == "android" and gtest_target_type == "shared_library"', {
      'targets': [
        {
          'target_name': 'unit_tests_java',
          'type': 'none',
          'variables': {
            'java_in_dir': 'test/android/unit_tests_apk',
          },
          'dependencies': [
            'chrome_java',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'unit_tests_apk',
          'type': 'none',
          'dependencies': [
            'chrome_java',
            'unit_tests_java',
            'unit_tests',
          ],
          'variables': {
            'test_suite_name': 'unit_tests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)unit_tests<(SHARED_LIB_SUFFIX)',
            'android_manifest_path': 'test/android/unit_tests_apk/AndroidManifest.xml',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'unit_tests_run',
          'type': 'none',
          'dependencies': [
            'unit_tests',
          ],
          'includes': [
            '../build/isolate.gypi',
            'unit_tests.isolate',
          ],
          'sources': [
            'unit_tests.isolate',
          ],
        },
      ],
    }],
    ['OS=="win"', {
      'targets' : [
        {
          # This target is only depended upon on Windows.
          'target_name': 'unit_tests_exe_pdb_workaround',
          'type': 'static_library',
          'sources': [ 'empty_pdb_workaround.cc' ],
          'msvs_settings': {
            'VCCLCompilerTool': {
              # This *in the compile phase* must match the pdb name that's
              # output by the final link. See empty_pdb_workaround.cc for
              # more details.
              'DebugInformationFormat': '3',
              'ProgramDataBaseFileName': '<(PRODUCT_DIR)/unit_tests.exe.pdb',
            },
          },
        },
      ],
    }],
    ['enable_app_list==1', {
      'targets': [
        {
          # Unit tests for chrome app list, not run on any bots, this is for faster
          # compile/link/test cycles during development.
          'target_name': 'chrome_app_list_unittests',
          'type': '<(gtest_target_type)',
          'dependencies': [
            '../base/base.gyp:run_all_unittests',
            '../chrome/chrome.gyp:test_support_common',
            '../skia/skia.gyp:skia',
            '../testing/gtest.gyp:gtest',
            'browser_ui',
          ],
          'sources': [
            'browser/ui/app_list/app_list_positioner_unittest.cc',
            'browser/ui/app_list/app_list_service_mac_unittest.mm',
            'browser/ui/app_list/app_list_service_unittest.cc',
            'browser/ui/app_list/profile_loader_unittest.cc',
            'browser/ui/app_list/test/app_list_shower_unittest.cc',
            'browser/ui/app_list/test/fake_keep_alive_service.cc',
            'browser/ui/app_list/test/fake_keep_alive_service.h',
            'browser/ui/app_list/test/fake_profile.cc',
            'browser/ui/app_list/test/fake_profile.h',
            'browser/ui/app_list/test/fake_profile_store.cc',
            'browser/ui/app_list/test/fake_profile_store.h',
            'browser/ui/app_list/test/fast_show_pickler_unittest.cc',
            'browser/ui/views/app_list/linux/app_list_linux_unittest.cc',
            'browser/ui/views/app_list/win/app_list_win_unittest.cc',
          ],
        },
      ],
    }],
  ],  # 'conditions'
}
