// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_EXO_TOUCH_H_
#define COMPONENTS_EXO_TOUCH_H_

#include <vector>

#include "base/macros.h"
#include "components/exo/surface_observer.h"
#include "ui/events/event_handler.h"

namespace ui {
class TouchEvent;
}

namespace exo {
class TouchDelegate;

// This class implements a client touch device that represents one or more
// touch devices.
class Touch : public ui::EventHandler, public SurfaceObserver {
 public:
  explicit Touch(TouchDelegate* delegate);
  ~Touch() override;

  // Overridden from ui::EventHandler:
  void OnTouchEvent(ui::TouchEvent* event) override;

  // Overridden from SurfaceObserver:
  void OnSurfaceDestroying(Surface* surface) override;

 private:
  // Returns the effective target for |event|.
  Surface* GetEffectiveTargetForEvent(ui::Event* event) const;

  // The delegate instance that all events are dispatched to.
  TouchDelegate* delegate_;

  // The current focus surface for the touch device.
  Surface* focus_;

  // Vector of touch points in focus surface.
  std::vector<int> touch_points_;

  DISALLOW_COPY_AND_ASSIGN(Touch);
};

}  // namespace exo

#endif  // COMPONENTS_EXO_TOUCH_H_
