#!/bin/sh

if [ $# -ne 2 ];
 then
  echo "usage: $0 newname color"
  echo "example: $0 purple \"#ff00ff\""
 exit 1
fi

cp -r gray_src $1"_src"
mkdir $1"_cursors"
mkdir $1"_cursors_nonanim"

function colorize () {
 for f in `ls *.png`
 do
  #convert -fill $1 -colorize 40 -contrast -modulate 100,180,100 +contrast $f $f
  #convert -fill $1 -colorize 40 $f $f
  #convert -fill $1 -colorize 40 -modulate 100,180,100 $f $f

  composite -compose multiply $f $crystalpath/overlay.png temp1.png
  composite -compose xor $f $crystalpath/overlay.png temp2.png
  composite -compose xor temp1.png temp2.png $f
  convert +contrast -modulate 130,100,100 $f $f 
  
  rm temp1.png temp2.png
  
 done
}

crystalpath=`pwd`

convert gray_src/X_cursor_32.png -fill $2 -draw "rectangle 0 0 32 32" overlay.png

cd $1"_src"
colorize $2

sed "s/gray/$1/g" Makefile > Make2
mv Make2 Makefile

sed "s/Grayscale/$1/g" index.theme > index2
mv index2 index.theme

cd watch
colorize $2

cd ../left_ptr_watch
colorize $2

cd ../nonanim
sed "s/gray/$1/g" Makefile > Make2
mv Make2 Makefile


sed "s/gray/$1/gi" index.theme > index2
mv index2 index.theme

cd ..

make&&make install

cd ..
rm overlay.png


