#include <stddef.h>
#include <string>

#include "httpinput.h"
#include "input.h"
#include "state.pb.h"
#include "udpinput.h"

using namespace std;

// Extremely rudimentary URL parsing.
bool parse_url(const string &url, string *protocol, string *host, string *port, string *path)
{
	size_t split = url.find("://");
	if (split == string::npos) {
		return false;
	}
	*protocol = string(url.begin(), url.begin() + split);

	string rest = string(url.begin() + split + 3, url.end());
	split = rest.find_first_of(":/");
	if (split == string::npos) {
		// http://foo
		*host = rest;
		*port = *protocol;
		*path = "/";
		return true;
	}

	*host = string(rest.begin(), rest.begin() + split);
	char ch = rest[split];  // Colon or slash.
	rest = string(rest.begin() + split + 1, rest.end());

	if (ch == ':') {
		// Parse the port.
		split = rest.find_first_of('/');
		if (split == string::npos) {
			// http://foo:1234
			*port = rest;
			*path = "/";
			return true;
		} else {
			// http://foo:1234/bar
			*port = string(rest.begin(), rest.begin() + split);
			*path = string(rest.begin() + split, rest.end());
			return true;
		}
	}

	// http://foo/bar
	*port = *protocol;
	*path = rest;
	return true;
}

Input *create_input(const std::string &url)
{
	string protocol, host, port, path;
	if (!parse_url(url, &protocol, &host, &port, &path)) {
		return NULL;
	}
	if (protocol == "http") {
		return new HTTPInput(url);
	}
	if (protocol == "udp") {
		return new UDPInput(url);
	}
	return NULL;
}

Input *create_input(const InputProto &serialized)
{
	string protocol, host, port, path;
	if (!parse_url(serialized.url(), &protocol, &host, &port, &path)) {
		return NULL;
	}
	if (protocol == "http") {
		return new HTTPInput(serialized);
	}
	if (protocol == "udp") {
		return new UDPInput(serialized);
	}
	return NULL;
}

Input::~Input() {}

