/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

import java.io.Serializable;
import java.net.URL;
import org.adl.datamodels.SCODataManager;
import org.adl.samplerte.client.APIAdapterApplet;
import org.adl.samplerte.client.ServletWriter;
import org.adl.util.debug.DebugIndicator;

public class ServletProxy {
    private static boolean _Debug = DebugIndicator.ON;
    private URL servletURL;
    private String sessionid;

    public ServletProxy(URL url, String sessionid) {
        this.servletURL = url;
        this.sessionid = sessionid;
    }

    public String GetSCOData() {
        if (_Debug) {
            System.out.println("In ServletProxy::GetSCOData()");
        }
        try {
            String servletCommand = "cmigetcat";
            Serializable[] data = new Serializable[]{servletCommand};
            if (_Debug) {
                System.out.println("Before postObjects()");
                System.out.println("In ServletProxy::PutSCOData() PASSING sessionid" + this.sessionid);
            }
            String result = ServletWriter.postObjects(this.servletURL, data, this.sessionid);
            System.out.println("Within Servlet Proxy - result is (this was cmigetcat)" + result);
            if (_Debug) {
                System.out.println("Back In ServletProxy::GetSCOData()");
                System.out.println("Attempting to read servlet response now...");
            }
            if (_Debug) {
                System.out.println("Read servlet response successfully.");
                System.out.println("Closing input stream");
            }
            return result;
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Exception caught In ServletProxy::GetSCODataData()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            return "";
        }
    }

    public String PutSCOData(SCODataManager scoData) {
        try {
            if (_Debug) {
                System.out.println("In ServletProxy::PutSCOData()");
            }
            String servletCommand = "cmiputcat";
            if (APIAdapterApplet.arewefinishing) {
                System.out.println("**********************************");
                System.out.println("***LMSFinish                   ***");
                System.out.println("**********************************");
                servletCommand = "cmiputcatONFINISH";
            }
            Serializable[] data = new Serializable[]{servletCommand, scoData};
            System.out.println("In ServletProxy::PutSCOData() PASSING sessionid" + this.sessionid);
            String result = ServletWriter.postObjects(this.servletURL, data, this.sessionid);
            System.out.println("Within Servlet Proxy - result is (this was cmigetput)" + result);
            if (!result.startsWith("ERROR")) {
                result = "OK";
            }
            return result;
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Exception caught In ServletProxy::PutSCOData()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            return "FAILED";
        }
    }

    public String KeepAlive() {
        try {
            if (_Debug) {
                System.out.println("In ServletProxy::KeepAlive()");
            }
            String servletCommand = "keepalive";
            Serializable[] data = new Serializable[]{servletCommand};
            String result = ServletWriter.postObjects(this.servletURL, data, this.sessionid);
            System.out.println("Within Servlet Proxy - (this was keepalive)" + result);
            if (!result.startsWith("ERROR")) {
                result = "OK";
            }
            return result;
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Exception caught In ServletProxy::KeepAlive()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            return "FAILED";
        }
    }
}

