#ifndef QFITSMAINWINDOW_H
#define QFITSMAINWINDOW_H

#include <QWidget>
#include <QImage>
#include <QString>
#include <QLabel>
#include <QMenuBar>
#include <QCheckBox>
#include <QComboBox>
#include <QSpinBox>
#include <QToolButton>
#include <QProgressBar>
#include <QMainWindow>
#include <QSplitter>

#include "QFitsGlobal.h"
#include "QFitsPreferences.h"
#include "fits.h"
#include "QPgplot.h"

class RGBDialog;
class dpCombineDialog;
class QFitsToolBar;
class CubeDisplayDialog;
class PlotOptionsDialog;
class BlinkDialog ;
class qFitsViewPreferences;
class QFitsViewingTools;
class MainWindow;
class QFits2dFit;
class QFitsBaseBuffer;
class QFitsSingleBuffer;
class QFitsCubeSpectrum;
class QFitsMainView;
class QFitsHeaderView;
class About;
class moreColourmaps;
class ImageDisplay;

class QFitsMainWindow : public QMainWindow {
    Q_OBJECT
//----- Functions -----
public:
    QFitsMainWindow(QWidget *parent = NULL);
    ~QFitsMainWindow();

    void StartDpuser();

    int getCurrentBufferIndex();
    QFitsBaseBuffer* getCurrentBuffer();
    QFitsBaseBuffer* getBuffer(int i);
    QFitsSingleBuffer* getMarkedSingleBuffer();

    QString createCaption(int, bool);
    virtual void keyPressEvent(QKeyEvent *e);
    bool headerVisible();
#ifdef HAS_VTK
    void updateCubeSpectrumViewer();
#endif
    void updateViewingtools();
    void updateWedge();
    void updateTools(int, int, int, int, bool updateTotal = true);
    void updateTotalVisibleRect();
    void setMagnifierCenterPos(int, int);
    void updateMenuScaling(int);
    void applyAppearance();
    void setActualSB(QFitsSingleBuffer *sb) { actualSB = sb; }
    QFitsSingleBuffer* getActualSB() { return actualSB; }
    QFitsSingleBuffer* getActualMarkedSB();

protected:
    virtual void dragEnterEvent(QDragEnterEvent* event);
    virtual void dropEvent(QDropEvent* event);

    virtual void resizeEvent(QResizeEvent *r);
    #ifdef HAS_VTK
    void showCurrentView(int which , dpViewMode previousMode = ViewUndefined);
    #else
    void showCurrentView(int which);
    #endif
    void arrangeChildren();
private:
    void updateBufferList();

//----- Slots -----
public slots:
    void updateScaling();
    void copyImage();
    void pasteImage();
    void menuZoomTriggered(QAction *);
    void imredClicked(int);
    void imredTriggered(QAction *);
    void imfilterTriggered(QAction *);
    void imcubeTriggered(QAction *);
    void spectralTriggered(QAction *);
    void userMenuTriggered(QAction *);
    void scalingTriggered(QAction *);
    void viewTriggered(QAction *);
    void buffersTriggered(QAction *);
    void windowsTriggered(QAction *);
    void updateWindowsMenu();
    void helpTriggered(QAction *);
    void moreColormaps(void);
    void viewClicked(dpViewMode);
    void helpClicked(int);
    void buffersClicked(int);
    void showSpectrum(bool);
    void adaptFileMenu();
    void showRGBDialog();
    void showCombineDialog();
    void updateImageOptions();
    void updateCubeOptions();
    void updateLinemapInfo(int);
    void fillBufferMenu();
    void fillUserMenu();
    void fillViewMenu();
    void reloadImage();
    void dpuserInterrupt();
    void dpuserExecuteScript();
    void dpuserChangeDirectory();
    void updateOrientation();
    void updateToolbar();
    void longslitChangedValues(int, int, double, int);
    void longslitChangedCenter(int, int);
    void longslitChangedAngle(double);
    void ellipticalProfileChangedValues(int, int, double, double, int);
    void updateCubeMode(int);
    void blinkTimerTimeout();
    void DisplayFITSHeader();
    void LoadClicked();
    void ImportClicked();
    void userMenuClicked(int);
    void dpuserProgress(const int &, const QString &);
    void dpuserHelp(const QString &);
    void dpuserVar(const int &);
    void updatePgplot(const int &, const QImage &);
    void updatePgplot(const int &, const int &, const int &);
    void LoadFile(bool);

//----- Signals -----
signals:
    void currentBufferChanged(int);
    void longslitCenterChanged(int, int);
    void longslitAngleChanged(double);
    void setVisibleRect(int, int);
    void progressActive(bool);

//----- Members -----
public:
    QSplitter           *splitter, *hsplitter;
    QMenu               *imfilter, *imcube, *scaling, *map, *zoom, *options, *imred,
                        *spectral, *view, *buffer, *windows, *help;
    QMenu               *userMenu;
    QMap<int,int>       bufferMenuList;
    QFitsViewingTools   *viewingtools;
    QFits2dFit          *fitter2d;
    QFitsCubeSpectrum   *spectrum;
    MainWindow          *scriptEditor;
    RGBDialog           *rgbdialog;
    dpCombineDialog     *combinedialog;
    QFitsHeaderView     *headerView;
    QFitsPrefDialog     *preferences;
    About               *about;
    moreColourmaps      *morecolourmaps;
    ImageDisplay        *imagedisplay;
    CubeDisplayDialog   *cubeDisplayDialog;
    PlotOptionsDialog   *plotoptions;
    BlinkDialog         *blinkdialog;
    QStringList         blinklist;
    QFitsToolBar        *mytoolbar;
    QProgressBar        *progressbar;
    QTimer              *blinkTimer;
    QActionGroup        *mapActions,
                        *viewActions;
    int                 viewingTools_width,
                        blinkcount;
    bool                bufferChangedByKey,
                        overrideSet,
                        zoomCorr_spectrumVisible,
                        zoomCorr_wedgeVisible,
                        zoomCorr_ComboZoomTriggered;
    QFitsMainView       *main_view;
    QPgplotDialog       *qpgplot_windows[10];
    QActionGroup        *scalingMethods;

private:
    double              centralWavelength;
    QByteArray          windowState;
    QAction             *menu_displayFitsHeader;
    QFitsSingleBuffer   *actualSB;
};

#endif /* FITSVIEW_H */
