/**********************************************************************
 * Copyright (c) 2012, 2013 Ericsson
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Bernd Hufmann - Initial API and implementation
 **********************************************************************/
package org.eclipse.linuxtools.internal.lttng2.control.core.model;

/**
 * <p>
 * Interface for retrieval of event field information.
 * </p>
 *
 * @author Bernd Hufmann
 */
public interface IFieldInfo extends ITraceInfo {

    /**
     * @return the event field type
     */
    String getFieldType();

    /**
     * Sets field type string
     *
     * @param fieldType - sting of event field type
     */
    void setFieldType(String fieldType);
}
