
! Copyright (C) 2023 J. K. Dewhurst and S. Sharma.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine ggamt_5b(is,np,vx,vc,dxdg2r,dcdg2r)
use modmain
implicit none
! arguments
integer, intent(in) :: is,np
real(8), intent(inout) :: vx(np),vc(np)
real(8), intent(in) :: dxdg2r(np),dcdg2r(np)
! local variables
integer nr,nri
! automatic arrays
real(8) rfmt1(np),rfmt2(np)
nr=nrmt(is)
nri=nrmti(is)
!------------------!
!     exchange     !
!------------------!
! convert dxdg2r to spherical harmonics
call rfsht(nr,nri,dxdg2r,rfmt1)
! compute grad^2 dxdg2r
call grad2rfmt(nr,nri,rlmt(:,-1,is),rlmt(:,-2,is),wcrmt(:,:,is),rfmt1,rfmt2)
vx(1:np)=vx(1:np)+rfmt2(1:np)
!---------------------!
!     correlation     !
!---------------------!
! convert dcdg2r to spherical harmonics
call rfsht(nr,nri,dcdg2r,rfmt1)
! compute grad^2 dcdg2r
call grad2rfmt(nr,nri,rlmt(:,-1,is),rlmt(:,-2,is),wcrmt(:,:,is),rfmt1,rfmt2)
vc(1:np)=vc(1:np)+rfmt2(1:np)
end subroutine

