/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include <boost/version.hpp>
#include <boost/python.hpp>
#include "Python/esys/lsm/MeshBuildParamsPy.h"

namespace esys
{
  namespace lsm
  {
    /*! 
      constructor for MeshTagBuildPrmsPy
    
      \param tag
      \param mask
    */
    MeshTagBuildPrmsPy::MeshTagBuildPrmsPy(int tag, int mask) : MeshTagBuildPrms(tag, mask)
    {
    }
    
    /*!
      constructor for MeshGapBuildPrmsPy
    
      \param maxGap
    */
    MeshGapBuildPrmsPy::MeshGapBuildPrmsPy(double maxGap) : MeshGapBuildPrms(maxGap)
    {
    }

    using boost::python::arg;
    void exportMeshBuildPrms()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<MeshTagBuildPrmsPy>(
        "MeshTagBuildPrms",
        "Parameters for bonding particles to a mesh which uses\n"
        "particle-tags as the criterion for creating bonds.",
        boost::python::init<int, int>(
          (
            arg("tag"),
            arg("mask")
          ),
	  "Build parameters for particles with a specified tag\n"
          "@type tag: int\n"
          "@kwarg tag: particle tag, particles with this tag will be\n"
          " bonded to the specified mesh.\n"
          "@type mask: int\n"
          "@kwarg mask: mask applied (anded) to particle tag before"
          " being compared with C{tag}.\n"
        )
      );

      boost::python::class_<MeshGapBuildPrmsPy>(
        "MeshGapBuildPrms",
        "Parameters for bonding particles to a mesh which uses\n"
        "distance-to-mesh criterion for creating bonds.",
        boost::python::init<double>(
          (arg("maxDistance")),
	  "Build parameters for particles within a specified distance of a mesh wall\n"
          "@type maxDistance: float\n"
          "@kwarg maxDistance: Particles which are closer than C{maxDistance}"
          " to the mesh get bonded to the mesh.\n"
        )
      );
    }
  }
}
