/* $Id$ 
 *
 * Log: Log a character (intermediate opcode).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LOG_HPP_INCLUDED
#define __LOG_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"

namespace intermediate {

//! log a character
/** This opcode can be used to log a character during the simulation.
 *
 *  Read operands: level operand, target operand.
 *  Write operands: implicit logging channel.
 *
 *  Operation:
 *      Log a character c at a desired level lvl.
 *      If lvl is -1, then severity level will not be prepended.
 */
class Log : public OpCode {
public:
	//! c'tor
	/** @param level desired log level
	 *  @param character char to log
	 */
	Log(
		Operand *level, 
		Operand *character
		) : 	lvl(level), 
			c(character) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! log level
	Operand *lvl;

	//! character to log
	Operand *c;

protected:
	virtual ~Log() {
		util::MiscUtil::terminate(this->lvl);
		util::MiscUtil::terminate(this->c);
	}
};

}; /* namespace intermediate */

#endif /* __LOG_HPP_INCLUDED */
