/* $Id$ 
 *
 * Sub: substract values. (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __SUB_HPP_INCLUDED
#define __SUB_HPP_INCLUDED

#include "intermediate/operands/Register.hpp"

namespace intermediate {

//! substract the right operand from the left
/** This class will substract the right operand from the left operand
 *  and store the result into the dst register.
 *  In case that left - right is a smaller value, than dst can store,
 *  the result is undefined.
 *
 *  Read operands left, right.
 *  Write operands: dst
 *
 *  left operand: Minuend
 *  right operand: Subtrahend
 *  dst: destination operand, to which the result will get written (any
 *  virtual register).
 */
class Sub : public OpCode {
public:
	//! c'tor
	/** @param l minuend
	 *  @param r subtrahend
	 *  @param destination destination register.
	 */
	Sub(
		Operand *l,
		Operand *r,
		Register *destination
		) :	left(l), right(r), dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination
	Register *dst;

protected:
	virtual ~Sub() {
		util::MiscUtil::terminate(this->left);
		util::MiscUtil::terminate(this->right);
		util::MiscUtil::terminate(this->dst);
	}

};
	
}; /* namespace intermediate */

#endif /* __SUB_HPP_INCLUDED */
