/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.viewer.xml;

import org.bounce.viewer.xml.CommentTreeNode;
import org.bounce.viewer.xml.ElementEndTreeNode;
import org.bounce.viewer.xml.Line;
import org.bounce.viewer.xml.NodeTreeNode;
import org.bounce.viewer.xml.ScannerUtils;
import org.bounce.xml.DOMUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementTreeNode
extends NodeTreeNode {
    private static final long serialVersionUID = 2859132085591886595L;

    ElementTreeNode(Element element) {
        super(element);
        if (!DOMUtils.isMixed(element)) {
            boolean hasChildElements = false;
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    hasChildElements = true;
                    this.add(new ElementTreeNode((Element)node));
                    continue;
                }
                if (!(node instanceof Comment) || !ScannerUtils.showComments()) continue;
                hasChildElements = true;
                this.add(new CommentTreeNode((Comment)node));
            }
            if (hasChildElements) {
                this.add(new ElementEndTreeNode(element));
            }
        }
        this.format();
    }

    void format() {
        this.setCurrent(new Line());
        ScannerUtils.scanElement(this.getLines(), this.getCurrent(), (Element)this.getNode());
    }
}

