/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.LocalTaskExecutorThreadPool;
import org.springframework.scheduling.quartz.ResourceJobSchedulingDataProcessor;
import org.springframework.scheduling.quartz.SchedulerContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

public class SchedulerFactoryBean
implements FactoryBean,
ApplicationContextAware,
InitializingBean,
DisposableBean,
Lifecycle {
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    public static final int DEFAULT_THREAD_COUNT = 10;
    private static final ThreadLocal configTimeTaskExecutorHolder = new ThreadLocal();
    private static final ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private static final ThreadLocal configTimeNonTransactionalDataSourceHolder = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class schedulerFactoryClass = StdSchedulerFactory.class;
    private String schedulerName;
    private Resource configLocation;
    private Properties quartzProperties;
    private TaskExecutor taskExecutor;
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private PlatformTransactionManager transactionManager;
    private Map schedulerContextMap;
    private ApplicationContext applicationContext;
    private String applicationContextSchedulerContextKey;
    private JobFactory jobFactory;
    private boolean jobFactorySet = false;
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List jobDetails;
    private Map calendars;
    private List triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private boolean autoStartup = true;
    private int startupDelay = 0;
    private boolean waitForJobsToCompleteOnShutdown = false;
    private Scheduler scheduler;

    public static TaskExecutor getConfigTimeTaskExecutor() {
        return (TaskExecutor)configTimeTaskExecutorHolder.get();
    }

    public static DataSource getConfigTimeDataSource() {
        return (DataSource)configTimeDataSourceHolder.get();
    }

    public static DataSource getConfigTimeNonTransactionalDataSource() {
        return (DataSource)configTimeNonTransactionalDataSourceHolder.get();
    }

    public void setSchedulerFactoryClass(Class schedulerFactoryClass) {
        if (schedulerFactoryClass == null || !SchedulerFactory.class.isAssignableFrom(schedulerFactoryClass)) {
            throw new IllegalArgumentException("schedulerFactoryClass must implement [org.quartz.SchedulerFactory]");
        }
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setSchedulerContextAsMap(Map schedulerContextAsMap) {
        this.schedulerContextMap = schedulerContextAsMap;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContextSchedulerContextKey(String applicationContextSchedulerContextKey) {
        this.applicationContextSchedulerContextKey = applicationContextSchedulerContextKey;
    }

    public void setJobFactory(JobFactory jobFactory) {
        this.jobFactory = jobFactory;
        this.jobFactorySet = true;
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String[] jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>(Arrays.asList(jobDetails));
    }

    public void setCalendars(Map calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener[] schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener[] globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setJobListeners(JobListener[] jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    public void setTriggerListeners(TriggerListener[] triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setStartupDelay(int startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null && this.nonTransactionalDataSource != null) {
            this.dataSource = this.nonTransactionalDataSource;
        }
        SchedulerFactory schedulerFactory = (SchedulerFactory)BeanUtils.instantiateClass(this.schedulerFactoryClass);
        this.initSchedulerFactory(schedulerFactory);
        if (this.taskExecutor != null) {
            configTimeTaskExecutorHolder.set(this.taskExecutor);
        }
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.nonTransactionalDataSource != null) {
            configTimeNonTransactionalDataSourceHolder.set(this.nonTransactionalDataSource);
        }
        try {
            this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
            if (!this.jobFactorySet && !(this.scheduler instanceof RemoteScheduler)) {
                this.jobFactory = new AdaptableJobFactory();
            }
            if (this.jobFactory != null) {
                if (this.jobFactory instanceof SchedulerContextAware) {
                    ((SchedulerContextAware)this.jobFactory).setSchedulerContext(this.scheduler.getContext());
                }
                this.scheduler.setJobFactory(this.jobFactory);
            }
            Object var3_2 = null;
            if (this.taskExecutor != null) {
                configTimeTaskExecutorHolder.set(null);
            }
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.nonTransactionalDataSource != null) {
                configTimeNonTransactionalDataSourceHolder.set(null);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.taskExecutor != null) {
                configTimeTaskExecutorHolder.set(null);
            }
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.nonTransactionalDataSource != null) {
                configTimeNonTransactionalDataSourceHolder.set(null);
            }
            throw throwable;
        }
        this.populateSchedulerContext();
        this.registerListeners();
        this.registerJobsAndTriggers();
        if (this.autoStartup) {
            this.startScheduler(this.scheduler, this.startupDelay);
        }
    }

    private void initSchedulerFactory(SchedulerFactory schedulerFactory) throws SchedulerException, IOException {
        if (this.configLocation != null || this.quartzProperties != null || this.dataSource != null || this.schedulerName != null || this.taskExecutor != null) {
            if (!(schedulerFactory instanceof StdSchedulerFactory)) {
                throw new IllegalArgumentException("StdSchedulerFactory required for applying Quartz properties");
            }
            Properties mergedProps = new Properties();
            if (this.taskExecutor != null) {
                mergedProps.setProperty("org.quartz.threadPool.class", LocalTaskExecutorThreadPool.class.getName());
            } else {
                mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
                mergedProps.setProperty(PROP_THREAD_COUNT, Integer.toString(10));
            }
            if (this.configLocation != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loading Quartz config from [" + this.configLocation + "]");
                }
                PropertiesLoaderUtils.fillProperties(mergedProps, this.configLocation);
            }
            CollectionUtils.mergePropertiesIntoMap(this.quartzProperties, mergedProps);
            if (this.dataSource != null) {
                mergedProps.put("org.quartz.jobStore.class", LocalDataSourceJobStore.class.getName());
            }
            if (this.schedulerName != null) {
                mergedProps.put("org.quartz.scheduler.instanceName", this.schedulerName);
            }
            ((StdSchedulerFactory)schedulerFactory).initialize(mergedProps);
        }
    }

    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        return schedulerFactory.getScheduler();
    }

    private void populateSchedulerContext() throws SchedulerException {
        if (this.schedulerContextMap != null) {
            this.scheduler.getContext().putAll(this.schedulerContextMap);
        }
        if (this.applicationContextSchedulerContextKey != null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("SchedulerFactoryBean needs to be set up in an ApplicationContext to be able to handle an 'applicationContextSchedulerContextKey'");
            }
            this.scheduler.getContext().put((Object)this.applicationContextSchedulerContextKey, (Object)this.applicationContext);
        }
    }

    private void registerListeners() throws SchedulerException {
        int i;
        if (this.schedulerListeners != null) {
            for (i = 0; i < this.schedulerListeners.length; ++i) {
                this.scheduler.addSchedulerListener(this.schedulerListeners[i]);
            }
        }
        if (this.globalJobListeners != null) {
            for (i = 0; i < this.globalJobListeners.length; ++i) {
                this.scheduler.addGlobalJobListener(this.globalJobListeners[i]);
            }
        }
        if (this.jobListeners != null) {
            for (i = 0; i < this.jobListeners.length; ++i) {
                this.scheduler.addJobListener(this.jobListeners[i]);
            }
        }
        if (this.globalTriggerListeners != null) {
            for (i = 0; i < this.globalTriggerListeners.length; ++i) {
                this.scheduler.addGlobalTriggerListener(this.globalTriggerListeners[i]);
            }
        }
        if (this.triggerListeners != null) {
            for (i = 0; i < this.triggerListeners.length; ++i) {
                this.scheduler.addTriggerListener(this.triggerListeners[i]);
            }
        }
    }

    private void registerJobsAndTriggers() throws SchedulerException {
        TransactionStatus transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction(new DefaultTransactionDefinition());
        }
        try {
            Iterator<Object> it;
            if (this.jobSchedulingDataLocations != null) {
                ResourceJobSchedulingDataProcessor dataProcessor = new ResourceJobSchedulingDataProcessor();
                if (this.applicationContext != null) {
                    dataProcessor.setResourceLoader(this.applicationContext);
                }
                for (int i = 0; i < this.jobSchedulingDataLocations.length; ++i) {
                    dataProcessor.processFileAndScheduleJobs(this.jobSchedulingDataLocations[i], this.scheduler, this.overwriteExistingJobs);
                }
            }
            if (this.jobDetails != null) {
                it = this.jobDetails.iterator();
                while (it.hasNext()) {
                    JobDetail jobDetail = (JobDetail)it.next();
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList();
            }
            if (this.calendars != null) {
                it = this.calendars.keySet().iterator();
                while (it.hasNext()) {
                    String calendarName = (String)it.next();
                    Calendar calendar = (Calendar)this.calendars.get(calendarName);
                    this.scheduler.addCalendar(calendarName, calendar, true, true);
                }
            }
            if (this.triggers != null) {
                it = this.triggers.iterator();
                while (it.hasNext()) {
                    Trigger trigger = (Trigger)it.next();
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error("Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), (Throwable)((Exception)ex));
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || this.scheduler.getJobDetail(jobDetail.getName(), jobDetail.getGroup()) == null) {
            this.scheduler.addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.scheduler.getTrigger(trigger.getName(), trigger.getGroup()) != null;
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail;
            if (trigger instanceof JobDetailAwareTrigger && !this.jobDetails.contains(jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail()) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.scheduler.scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored");
                    }
                    if (this.overwriteExistingJobs) {
                        this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    }
                }
            } else {
                this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
            }
            return true;
        }
        return false;
    }

    protected void startScheduler(final Scheduler scheduler, final int startupDelay) throws SchedulerException {
        if (startupDelay <= 0) {
            this.logger.info("Starting Quartz Scheduler now");
            scheduler.start();
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Will start Quartz Scheduler [" + scheduler.getSchedulerName() + "] in " + startupDelay + " seconds");
            }
            Thread schedulerThread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(startupDelay * 1000);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (SchedulerFactoryBean.this.logger.isInfoEnabled()) {
                        SchedulerFactoryBean.this.logger.info("Starting Quartz Scheduler now, after delay of " + startupDelay + " seconds");
                    }
                    try {
                        scheduler.start();
                    }
                    catch (SchedulerException ex) {
                        throw new SchedulingException("Could not start Quartz Scheduler after delay", ex);
                    }
                }
            };
            schedulerThread.setName("Quartz Scheduler [" + scheduler.getSchedulerName() + "]");
            schedulerThread.start();
        }
    }

    public Object getObject() {
        return this.scheduler;
    }

    public Class getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : Scheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.scheduler.start();
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not start Quartz Scheduler", ex);
            }
        }
    }

    public void stop() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.scheduler.standby();
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not stop Quartz Scheduler", ex);
            }
        }
    }

    public boolean isRunning() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                return !this.scheduler.isInStandbyMode();
            }
            catch (SchedulerException ex) {
                return false;
            }
        }
        return false;
    }

    public void destroy() throws SchedulerException {
        this.logger.info("Shutting down Quartz Scheduler");
        this.scheduler.shutdown(this.waitForJobsToCompleteOnShutdown);
    }
}

