/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import visad.VisADException;

public class ReflectedUniverse {
    protected Hashtable variables = new Hashtable();
    protected ClassLoader loader;
    protected boolean debug;

    public ReflectedUniverse() {
        this((ClassLoader)null);
    }

    public ReflectedUniverse(URL[] urls) {
        this(urls == null ? null : new URLClassLoader(urls));
    }

    public ReflectedUniverse(ClassLoader loader) {
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
        this.debug = false;
    }

    public static boolean isInstance(Class c, Object o) {
        return o == null || c.isInstance(o) || c == Byte.TYPE && o instanceof Byte || c == Short.TYPE && o instanceof Short || c == Integer.TYPE && o instanceof Integer || c == Long.TYPE && o instanceof Long || c == Float.TYPE && o instanceof Float || c == Double.TYPE && o instanceof Double || c == Boolean.TYPE && o instanceof Boolean || c == Character.TYPE && o instanceof Character;
    }

    public Object exec(String command) throws VisADException {
        Object result;
        int leftParen;
        if ((command = command.trim()).startsWith("import ")) {
            Class<?> c;
            int dot = (command = command.substring(7).trim()).lastIndexOf(".");
            String varName = dot < 0 ? command : command.substring(dot + 1);
            try {
                c = Class.forName(command, true, this.loader);
            }
            catch (ClassNotFoundException exc) {
                if (this.debug) {
                    exc.printStackTrace();
                }
                throw new VisADException("No such class: " + command);
            }
            this.setVar(varName, c);
            return null;
        }
        int eqIndex = command.indexOf("=");
        String target = null;
        if (eqIndex >= 0) {
            target = command.substring(0, eqIndex).trim();
            command = command.substring(eqIndex + 1).trim();
        }
        if ((leftParen = command.indexOf("(")) < 0 || leftParen != command.lastIndexOf("(") || command.indexOf(")") != command.length() - 1) {
            throw new VisADException("invalid parentheses");
        }
        String arglist = command.substring(leftParen + 1);
        StringTokenizer st = new StringTokenizer(arglist, "(,)");
        int len = st.countTokens();
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            String arg = st.nextToken().trim();
            args[i] = this.getVar(arg);
        }
        if ((command = command.substring(0, leftParen)).startsWith("new ")) {
            String className = command.substring(4).trim();
            Object var = this.getVar(className);
            if (!(var instanceof Class)) {
                throw new VisADException("not a class: " + className);
            }
            Class cl = (Class)var;
            Constructor<?> constructor = null;
            Constructor<?>[] c = cl.getConstructors();
            for (int i = 0; i < c.length; ++i) {
                Class<?>[] params = c[i].getParameterTypes();
                if (params.length != args.length) continue;
                boolean match = true;
                for (int j = 0; j < params.length; ++j) {
                    if (ReflectedUniverse.isInstance(params[j], args[j])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                constructor = c[i];
                break;
            }
            if (constructor == null) {
                throw new VisADException("No such constructor");
            }
            try {
                result = constructor.newInstance(args);
            }
            catch (Exception exc) {
                if (this.debug) {
                    exc.printStackTrace();
                }
                throw new VisADException("Cannot instantiate object");
            }
        }
        int dot = command.indexOf(".");
        if (dot < 0) {
            throw new VisADException("syntax error");
        }
        String varName = command.substring(0, dot).trim();
        String methodName = command.substring(dot + 1).trim();
        Object var = this.getVar(varName);
        if (var == null) {
            throw new VisADException("No such variable: " + varName);
        }
        Class<?> varClass = var instanceof Class ? (Class<?>)var : var.getClass();
        Method method = null;
        Method[] m = varClass.getMethods();
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] params;
            if (!methodName.equals(m[i].getName()) || (params = m[i].getParameterTypes()).length != args.length) continue;
            boolean match = true;
            for (int j = 0; j < params.length; ++j) {
                if (ReflectedUniverse.isInstance(params[j], args[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method = m[i];
            break;
        }
        if (method == null) {
            throw new VisADException("No such method: " + methodName);
        }
        try {
            result = method.invoke(var, args);
        }
        catch (Exception exc) {
            if (this.debug) {
                exc.printStackTrace();
            }
            throw new VisADException("Cannot execute method: " + methodName);
        }
        if (target != null) {
            this.setVar(target, result);
        }
        return result;
    }

    public void setVar(String varName, Object obj) {
        if (obj == null) {
            this.variables.remove(varName);
        } else {
            this.variables.put(varName, obj);
        }
    }

    public void setVar(String varName, boolean b) {
        this.setVar(varName, new Boolean(b));
    }

    public void setVar(String varName, byte b) {
        this.setVar(varName, new Byte(b));
    }

    public void setVar(String varName, char c) {
        this.setVar(varName, new Character(c));
    }

    public void setVar(String varName, double d) {
        this.setVar(varName, new Double(d));
    }

    public void setVar(String varName, float f) {
        this.setVar(varName, new Float(f));
    }

    public void setVar(String varName, int i) {
        this.setVar(varName, new Integer(i));
    }

    public void setVar(String varName, long l) {
        this.setVar(varName, new Long(l));
    }

    public void setVar(String varName, short s) {
        this.setVar(varName, new Short(s));
    }

    public Object getVar(String varName) throws VisADException {
        int dot = varName.indexOf(".");
        if (dot >= 0) {
            Object fieldVal;
            Field field;
            Object var = this.variables.get(varName.substring(0, dot).trim());
            Class<?> varClass = var instanceof Class ? (Class<?>)var : var.getClass();
            String fieldName = varName.substring(dot + 1).trim();
            try {
                field = varClass.getField(fieldName);
            }
            catch (NoSuchFieldException exc) {
                if (this.debug) {
                    exc.printStackTrace();
                }
                throw new VisADException("No such field: " + varName);
            }
            try {
                fieldVal = field.get(var);
            }
            catch (Exception exc) {
                if (this.debug) {
                    exc.printStackTrace();
                }
                throw new VisADException("Cannot get field value: " + varName);
            }
            return fieldVal;
        }
        Object var = this.variables.get(varName);
        return var;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

