/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file router.h
 * \brief Route header
 */

#ifndef ROUTER_H
#define ROUTER_H

struct sRouter {
	const gchar *pnName;
	int ( *Detect )( struct sProfile *psProfile );
	int ( *Init )( struct sProfile *psProfile );
	int ( *Login )( struct sProfile *psProfile );
	int ( *Logout )( struct sProfile *psProfile );
	int ( *DetectFirmware )( struct sProfile *psProfile );
	int ( *GetPhoneSettings )( struct sProfile *psProfile );
	int ( *GetPorts )( struct sProfile *psProfile );
	int ( *GetCallList )( struct sProfile *psProfile, const gchar *pnFile );
	int ( *ClearCallList )( struct sProfile *psProfile );
	int ( *CallNumber )( struct sProfile *psProfile, const gchar *pnNumber, int nPort );
	int ( *Hangup )( struct sProfile *psProfile, int nPort );
	int ( *Reconnect )( struct sProfile *psProfile );
	gchar *( *GetIp )( struct sProfile *psProfile );
	void ( *GetSpeed )( struct sProfile *psProfile, gint *pnMaxUp, gint *pnMaxDown );
	int ( *ReadDiversity )( struct sProfile *psProfile );
	int ( *SetDiversity )( struct sProfile *psProfile, gint nIndex, gboolean bSet );
	const gchar *( *GetName )( struct sProfile *psProfile );
	const gchar *( *GetVersion )( struct sProfile *psProfile );
	int ( *LoadVoiceBox )( struct sProfile *psProfile );
	int ( *LoadVoiceFile )( struct sProfile *psProfile, const gchar *pnFile );
	int ( *DeleteVoiceFile )( struct sProfile *psProfile, const gchar *pnFile );
	int ( *LoadFaxBox )( struct sProfile *psProfile );
	int ( *LoadFaxFile )( struct sProfile *psProfile, const gchar *pnFile );
	int ( *DeleteFaxFile )( struct sProfile *psProfile, const gchar *pnFile );
};

extern struct sRouter sFritzBox;
extern struct sRouter sSpeedport;
extern struct sRouter sAliceBox;

void RouterLoginError( gboolean bThread, gint nSleep );
void routerLock( struct sProfile *psProfile, gboolean bLock );

#endif
