/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#include "all_pass.h"
#include <stdlib.h>
#include <string.h>

#define SAMPLE_RATE 44100


void all_pass_next_buffer(all_pass *this)
{
  this->next = 1;
}

sample *all_pass_get_buffer(all_pass *this)
{
  int i;
  
  sample *i_buf;

  if (this->next) {
    this->next = 0;
    i_buf = this->input->get_buffer(this->input);
    for(i = 0; i < TBASS_BUFF_SIZE;i++)
      {
	sample s;
	if(this->d_index >= this->delay_size)
	  this->d_index = 0;
      
	/*	this->buffer[i] =
	  (long)this->delay_buffer[this->d_index] *
	  (MAX_FEEDBACK * MAX_FEEDBACK - this->feedback * this->feedback) /
	  (MAX_FEEDBACK * MAX_FEEDBACK) +
	  (i_buf[i] * -this->feedback / MAX_FEEDBACK);
	*/
	/*I just changed this...I believe this is now what an all pass
          should actually d0 -toph */
	this->buffer[i] =
	  (long)this->delay_buffer[this->d_index] +
	  (i_buf[i] * -this->feedback / MAX_FEEDBACK);
	

	s = i_buf[i] + (long)this->delay_buffer[this->d_index] * 
	  this->feedback / MAX_FEEDBACK;
	this->delay_buffer[this->d_index] = s;
	this->d_index++;
      }
  }

  return this->buffer;
}

void all_pass_set_time(all_pass *this,double delay_time_milli)
{

  this->delay_time_milli = delay_time_milli;
  this->delay_size = delay_time_milli * SAMPLE_RATE / 1000;
  if(this->delay_size > this->biggest_size)
    {
      this->delay_buffer = realloc(this->delay_buffer,sizeof(sample) * 
				   this->delay_size);
      memset(this->delay_buffer + this->biggest_size,
	     0,sizeof(sample) * (this->delay_size - this->biggest_size));
      this->biggest_size = this->delay_size;
    }
}

void all_pass_set_feedback(all_pass *this,int feedback)
{
  this->feedback = feedback;
}



static sample_producer **get_children(all_pass *this)
{
  return &(this->input);
}

static char **get_header(all_pass *this)
{
  static char *header[] = {
    "int $n_i = ((all_pass *)$t)->d_index;",
    "int $n_size = ((all_pass *)$t)->delay_size;",
    "int $n_feedback = ((all_pass *)$t)->feedback;",
    "sample *$n_buf = ((all_pass *)$t)->delay_buffer;",
    NULL
  };
  return header;
}

static char **get_code(all_pass *this)
{
  static char *code[] = {
    "if ($n_i >= $n_size)",
    "  $n_i = 0;",
    /*"$o = (long)$n_buf[$n_i] *",
    "     (MAX_FEEDBACK * MAX_FEEDBACK - $n_feedback * $n_feedback) /",
    "     (MAX_FEEDBACK * MAX_FEEDBACK) +",
    "     ($i0 * -$n_feedback / MAX_FEEDBACK);",
    */
    
    "$o = (long)$n_buf[$n_i] +",
    "     ($i0 * -$n_feedback / MAX_FEEDBACK);",
    "$n_buf[$n_i] = $i0 + (long)$n_buf[$n_i] * $n_feedback / MAX_FEEDBACK;",
    "$n_i++;",
    NULL
  };
  return code;
}

static char **get_footer(all_pass *this)
{
  static char *footer[] = {
    "((all_pass *)$t)->d_index = $n_i;",
    NULL
  };
  return footer;
}

all_pass *all_pass_new(double delay_time_milli,int feedback,
		      sample_producer *input)
{
  all_pass *out = (all_pass *)malloc(sizeof(all_pass));
  
  out->get_buffer       = all_pass_get_buffer;
  out->next_buffer      = all_pass_next_buffer;
  out->get_children	= get_children;
  out->get_header	= get_header;
  out->get_code		= get_code;
  out->get_footer	= get_footer;
  out->next = 0;
  out->input            = input;
  out->unused		= NULL;
  out->feedback         = feedback;
  out->delay_time_milli = delay_time_milli;
  out->delay_size       = delay_time_milli * SAMPLE_RATE / 1000;
  out->delay_buffer     = (sample  *)malloc(sizeof(sample)*out->delay_size);
  memset(out->delay_buffer,0,sizeof(sample)*out->delay_size);
  out->buffer           = (sample *)malloc(sizeof(sample) * TBASS_BUFF_SIZE);
  memset(out->buffer,0,sizeof(sample) * TBASS_BUFF_SIZE);
  out->d_index          = 0;
  out->biggest_size = out->delay_size; 
  return out;
}

/*
  Local Variables:
  mode: font-lock
  End:
*/
