#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
# Copyright (c) 2005  Satomi I.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ե򻲾Ȥ롣
#
package FreePWING::RefSound;

require 5.005;
require Exporter;
use English;
use FileHandle;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(Exporter);

#
# :
#	new()
# ᥽åɤζʬ:
#	public 饹᥽åɡ
# :
#	֥Ȥ롣
# :
#	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	'format' => {},
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	add_sounds_in_file(file_name)
#           file_name
#		ɤ߹಻ե̾
# ᥽åɤζʬ:
#	public 󥹥󥹥᥽åɡ
# :
#	եɤ߹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_sounds_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # ե򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: $file_name";
	return 0;
    }

    #
    # ƹԤɤ߹ǥϥå˳Ǽ롣
    #
    my ($line, @fields);

    while (1) {
	$line = $handle->getline();
	last if (!defined($line));
	chomp($line);

	@fields = split(/\t/, $line);
	if (defined($self->{'sounds'}->{$fields[0]})) {
	    $self->{'error_message'} =
		"redefined sound name, $fields[0]: line $NR, $file_name";
	    $self->close();
	    return 0;
	}

	$self->{'sounds'}->{$fields[0]} = [ map(hex, splice(@fields, 1)) ];
    }

    #
    # եĤ롣
    #
    $handle->close();
    1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
#	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub sound_type {
    my $self = shift;
    my ($tag) = @ARG;

    if (defined($self->{'sounds'}->{$tag})) {
	$self->{'sounds'}->{$tag}[0];
    }
}

sub sound_format {
    my $self = shift;
    my ($tag) = @ARG;

    if (defined($self->{'sounds'}->{$tag})) {
	$self->{'sounds'}->{$tag}[1];
    }
}

sub error_message {
    my $self = shift;
    $self->{'error_message'};
}

1;
