/*  HomeBank -- Free, easy, personal accounting for everyone.
 *  Copyright (C) 1995-2021 Maxime DOYEN
 *
 *  This file is part of HomeBank.
 *
 *  HomeBank is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  HomeBank is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __HB_FILTER_GTK_H__
#define __HB_FILTER_GTK_H__

enum
{
	BUTTON_ALL,
	BUTTON_NONE,
	BUTTON_INVERT,
	MAX_BUTTON
};


struct ui_flt_hub_stuf
{
	GtkWidget	*treeview;
	GtkWidget   *BT_all;
	GtkWidget   *BT_none;
	GtkWidget   *BT_invert;
};


struct ui_flt_manage_data
{
	Filter		*filter;

	GtkWidget	*stack;

	GtkWidget	*CY_option[FLT_GRP_MAX];
	GtkWidget	*GR_page[FLT_GRP_MAX];

	GtkWidget	*PO_mindate, *PO_maxdate;
	GtkWidget	*CY_month, *NB_year;

	GtkWidget	*CY_type;
	GtkWidget	*CY_status;
	GtkWidget	*LB_force, *GR_force;

	GtkWidget	*CM_forceadd, *CM_forcechg, *CM_forceremind, *CM_forcevoid;

	GtkWidget	*CM_paymode[NUM_PAYMODE_MAX];

	GtkWidget	*ST_minamount, *ST_maxamount;

	GtkWidget	*CM_exact;
	GtkWidget	*ST_info, *ST_memo, *ST_tag;

	struct ui_flt_hub_stuf pnl_acc_data;
	struct ui_flt_hub_stuf pnl_pay_data;
	struct ui_flt_hub_stuf pnl_cat_data;

	GtkWidget	*LV_acc, *BT_acc[MAX_BUTTON];
	GtkWidget	*LV_pay, *BT_pay[MAX_BUTTON];
	GtkWidget	*LV_cat, *BT_cat[MAX_BUTTON];

	GtkWidget	*BT_expand, *BT_collapse;


	gboolean	show_account;


};


gint ui_flt_manage_dialog_new(GtkWindow *parentwindow, Filter *filter, gboolean show_account, gboolean txnmode);


#endif
